#ifndef CAN_CH1_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH1_CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

extern st_CanMsgOp CAN_CH1_CanMsgOp;

extern st_CanMsgTxOp CAN_CH1_CanMsgTxOp;

typedef enum
{
    CAN_CH1_ID_ID131_MCU1_Msg_Count,
    CAN_CH1_ID_ID3F1_IC1_Msg_Count,
    CAN_CH1_ID_ID139_VCM2_Msg_Count,
    CAN_CH1_ID_ID153_BMS2_Msg_Count,
    CAN_CH1_ID_ID152_BMS3_Msg_Count,
    CAN_CH1_ID_ID320_BMS5_Msg_Count,
    CAN_CH1_ID_ID24A_BMS6_Msg_Count,
    CAN_CH1_ID_ID211_VCM5_Msg_Count,
    CAN_CH1_ID_ID35A_VCM9_Msg_Count,
    CAN_CH1_ID_ID2E1_OBC2_Msg_Count,
    CAN_CH1_ID_ID389_TPMS_Msg_Count,
    CAN_CH1_ID_ID135_VCM3_Msg_Count,
    CAN_CH1_ID_ID366_CHM1_Msg_Count,
    CAN_CH1_ID_ID521_VCMTBOX1_Msg_Count,
    CAN_CH1_ID_ID341_BMS7_Msg_Count,
    CAN_CH1_ID_ID431_VCM_Msg_Count,
    CAN_CH1_ID_ID123_Msg_Count,
    CAN_CH1_ID_ID137_EGS_Fault_Msg_Count,
    CAN_CH1_ID_Send_190_Msg_Count,
    CAN_CH1_ID_Send_276_Msg_Count,
    CAN_CH1_ID_Send_350_Msg_Count,
    CAN_CH1_ID_Send_0f6_Msg_Count,
    CAN_CH1_ID_Send_128_Msg_Count,
    CAN_CH1_ID_5E0_EDR_Msg_Count,
    CAN_CH1_ID_ID_302_VCU01_Msg_Count,
    CAN_CH1_ID_ID442_VCU_HMI1_Msg_Count,
    CAN_CH1_ID_ID342_VCU_HMI2_Msg_Count,
    CAN_CH1_ID_ID214_BMS02_Msg_Count,
    CAN_CH1_ID_ID222_VCU06_Msg_Count,
    CAN_CH1_ID_ID254_REMOTE_ACTION_REQ_Msg_Count,
    CAN_CH1_ID_ID43C_REVEIL_MDS_Msg_Count,
    CAN_CH1_ID_ID334_BMS_05_Msg_Count,
    CAN_CH1_ID_ID306_MCU_01_Msg_Count,
    CAN_CH1_ID_ID304_BMS_01_Msg_Count,
    CAN_CH1_ID_BMS_07_Msg_Count,

    CAN_CH1_ID_TOTAL_MAX,
} CAN_CH1_CAN_MSG_ID_t;

typedef enum
{
    CAN_CH1_MSGID_276,
    CAN_CH1_MSGID_350,
    CAN_CH1_MSGID_190,
    CAN_CH1_MSGID_128,
    CAN_CH1_MSGID_0F6,
    CAN_CH1_MSGID_3F1,
    CAN_CH1_MSGID_036,
    CAN_CH1_MSGID_294,
    CAN_CH1_ID_SEND_TOTAL,
    
} CAN_CH1_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH1_CAN_MSG_CONST_ARRAY[CAN_CH1_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH1_CANSendAttr[CAN_CH1_ID_SEND_TOTAL] ;

#define  CAN_CH1_ID_ID131_MCU1_Msg              0x131ul
#define  CAN_CH1_ID_ID3F1_IC1_Msg               0x3F1ul
#define  CAN_CH1_ID_ID139_VCM2_Msg              0x139ul
#define  CAN_CH1_ID_ID153_BMS2_Msg              0x153ul
#define  CAN_CH1_ID_ID152_BMS3_Msg              0x152ul
#define  CAN_CH1_ID_ID320_BMS5_Msg              0x320ul
#define  CAN_CH1_ID_ID24A_BMS6_Msg              0x24Aul
#define  CAN_CH1_ID_ID211_VCM5_Msg              0x211ul
#define  CAN_CH1_ID_ID35A_VCM9_Msg              0x35Aul
#define  CAN_CH1_ID_ID2E1_OBC2_Msg              0x2E1ul
#define  CAN_CH1_ID_ID389_TPMS_Msg              0x389ul
#define  CAN_CH1_ID_ID135_VCM3_Msg              0x135ul
#define  CAN_CH1_ID_ID366_CHM1_Msg              0x366ul
#define  CAN_CH1_ID_ID521_VCMTBOX1_Msg          0x521ul
#define  CAN_CH1_ID_ID341_BMS7_Msg              0x341ul
#define  CAN_CH1_ID_ID431_VCM_Msg               0x431ul
#define  CAN_CH1_ID_ID123_Msg                   0x123ul
#define  CAN_CH1_ID_ID137_EGS_Fault_Msg         0x137ul
#define  CAN_CH1_ID_Send_190_Msg                0x190ul
#define  CAN_CH1_ID_Send_276_Msg                0x276ul
#define  CAN_CH1_ID_Send_350_Msg                0x350ul
#define  CAN_CH1_ID_Send_0f6_Msg                0x0F6ul
#define  CAN_CH1_ID_Send_128_Msg                0x128ul
#define  CAN_CH1_ID_5E0_EDR_Msg                 0x5E0ul
#define  CAN_CH1_ID_ID_302_VCU01_Msg            0x302ul
#define  CAN_CH1_ID_ID442_VCU_HMI1_Msg          0x442ul
#define  CAN_CH1_ID_ID342_VCU_HMI2_Msg          0x342ul
#define  CAN_CH1_ID_ID214_BMS02_Msg             0x214ul
#define  CAN_CH1_ID_ID222_VCU06_Msg             0x222ul
#define  CAN_CH1_ID_ID254_REMOTE_ACTION_REQ_Msg 0x254ul 
#define  CAN_CH1_ID_ID43C_REVEIL_MDS_Msg        0x43Cul
#define  CAN_CH1_ID_ID334_BMS_05_Msg            0x334ul
#define  CAN_CH1_ID_ID306_MCU_01_Msg            0x306ul
#define  CAN_CH1_ID_ID304_BMS_01_Msg            0x304ul
#define  CAN_CH1_ID_BMS_07_Msg                  0x364ul

extern uint8_t  Get_CAN_CH1_ID_131_Sig_MCU_FaultLevel(void);
extern uint8_t  Get_CAN_CH1_ID_131_Sig_MCU_Motorspd_Status(void);
extern uint16_t Get_CAN_CH1_ID_131_Sig_MCU_Motorspd(void);
extern uint16_t Get_CAN_CH1_ID_3F1_Sig_DISTANCE_TRAJET2(void);
extern uint16_t Get_CAN_CH1_ID_3F1_Sig_DISTANCE_TRAJET1(void);
extern uint8_t  Get_CAN_CH1_ID_3F1_Sig_REO_REGEN_LEVEL(void);
extern uint8_t  Get_CAN_CH1_ID_3F1_Sig_Charge_plug_unlock_req(void);
extern uint8_t  Get_CAN_CH1_ID_3F1_Sig_ABAV_Req(void);
extern uint8_t  Get_CAN_CH1_ID_3F1_Sig_IC_Mileage2restart(void);
extern uint8_t  Get_CAN_CH1_ID_3F1_Sig_IC_Mileage1restart(void);
extern uint8_t  Get_CAN_CH1_ID_139_Sig_VCM_PowerStatus(void);
extern uint8_t  Get_CAN_CH1_ID_139_Sig_VCM_FaultLevel(void);
extern uint8_t  Get_CAN_CH1_ID_139_Sig_VCM_BrakePedalStatus(void);
extern uint8_t  Get_CAN_CH1_ID_153_Sig_ChargingStop(void);
extern uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_Battery_changeSts(void);
extern uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_SWAP_Status(void);
extern uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_Thermal_runaway_alarm_Sts(void);
extern uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_StatusTempHigh_Fault(void);
extern uint16_t Get_CAN_CH1_ID_153_Sig_BMS_SOC(void);
extern uint8_t  Get_CAN_CH1_ID_153_Sig_BMS_SOCLow(void);
extern uint16_t Get_CAN_CH1_ID_152_Sig_BMS_BatteryCurrent(void);
extern uint16_t Get_CAN_CH1_ID_320_Sig_BMS_DCLinkVoltage(void);
extern uint8_t  Get_CAN_CH1_ID_24A_Sig_BMS_FaultLevel(void);
extern uint8_t  Get_CAN_CH1_ID_24A_Sig_BMS_WorkMode(void);
extern uint8_t  Get_CAN_CH1_ID_211_Sig_VCM_PluginRemind(void);
extern uint16_t Get_CAN_CH1_ID_211_Sig_VCM_EstimateMileage(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_STATE_REGEN_LEVEL(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_stDrvReqWrgOptInfo(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Driving_HillHoldRemind(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Driving_GearPosRemind(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Cranking_GearPosRemind(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_HighVolConnect(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Mileage2Average_EnergyConsum(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Mileage1Average_EnergyConsum(void);
extern uint16_t Get_CAN_CH1_ID_35A_Sig_VCM_Instant_EnergyConsum(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_STATE_ECO_LEVEL(void);
extern uint8_t  Get_CAN_CH1_ID_35A_Sig_VCM_Average_EnergyConsum(void);
extern uint8_t  Get_CAN_CH1_ID_2E1_Sig_OBC_FaultLevel(void);
extern uint8_t  Get_CAN_CH1_ID_2E1_Sig_OBC_CCStatus(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_RB_TirePressure(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_LB_TirePressure(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_RF_TirePressure(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_LF_TirePressure(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_TirePre_FaultVoice_St(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_TirePre_FaultLight_St(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_RB_TirePressure_Warning(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_LB_TirePressure_Warning(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_TirePosition(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_RF_TirePressure_Warning(void);
extern uint8_t  Get_CAN_CH1_ID_389_Sig_LF_TirePressure_Warning(void);
extern uint8_t  Get_CAN_CH1_ID_135_Sig_VCM_ShiftLeverPosition(void);
extern uint8_t  Get_CAN_CH1_ID_366_Sig_CHM_AC_SOCRemind(void);
extern uint8_t  Get_CAN_CH1_ID_521_Sig_Vehicle_Status(void);
extern uint8_t  Get_CAN_CH1_ID_341_Sig_BMS_CC2Status(void);
extern uint8_t  Get_CAN_CH1_ID_431_Sig_VCM_Wakeup_Signal(void);
extern uint8_t  Get_CAN_CH1_ID_123_Sig_VCM_ShiftLeverPosition(void);
extern uint8_t  Get_CAN_CH1_ID_137_Sig_Fault(void);
extern uint8_t  Get_CAN_CH1_ID_190_Sig_BSI_TEMP_SONDE_EVAPOH(void);
extern uint8_t  Get_CAN_CH1_ID_190_Sig_BSI_TEMP_SONDE_EVAPOL(void);
extern uint8_t  Get_CAN_CH1_ID_276_Sig_BSI_ANNEE_HORLOGE(void);
extern uint8_t  Get_CAN_CH1_ID_350_Sig_BSI_TYPAGE(void);
extern uint8_t  Get_CAN_CH1_ID_0F6_Sig_BSI_T_EXT(void);
extern uint8_t  Get_CAN_CH1_ID_128_Sig_BSI_OUCP(void);
extern uint8_t  Get_CAN_CH1_ID_5E0_Sig_EDR_Full(void);
extern uint8_t  Get_CAN_CH1_ID_5E0_Sig_EDR_Fault(void);
extern uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_State(void);
extern uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_Fault_Level(void);
extern uint8_t  Get_CAN_CH1_ID_302_Sig_VCU_Fault_Level(void);
extern uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_ModeRequest(void);
extern uint8_t  Get_CAN_CH1_ID_302_Sig_PWT_NetWork_Request(void);
extern uint16_t Get_CAN_CH1_ID_442_Sig_ChgPower_HMI(void);
extern uint8_t  Get_CAN_CH1_ID_442_Sig_ChargeConnection_State(void);
extern uint16_t Get_CAN_CH1_ID_442_Sig_VCM_Instant_EnergyConsum(void);
extern uint16_t Get_CAN_CH1_ID_442_Sig_DrvPower_HMI(void);
extern uint16_t Get_CAN_CH1_ID_342_Sig_VCM_EstimateMileage(void);
extern uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_Mileage2Average_EnergyConsum(void);
extern uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_Mileage1Average_EnergyConsum(void);
extern uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_Average_EnergyConsum(void);
extern uint8_t  Get_CAN_CH1_ID_342_Sig_Matching_state(void);
extern uint8_t  Get_CAN_CH1_ID_342_Sig_VCM_stDrvReqWrgOptInfo(void);
extern uint8_t  Get_CAN_CH1_ID_342_Sig_Remote_GeoFenceHMI(void);
extern uint8_t  Get_CAN_CH1_ID_342_Sig_Remote_GeoFenceSts(void);
extern uint16_t Get_CAN_CH1_ID_214_Sig_BMS_faultcode(void);
extern uint16_t Get_CAN_CH1_ID_214_Sig_BMS_SOE(void);
extern uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_PositiveQickChargeRelay(void);
extern uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_NegetiveQickChargeRelaySts(void);
extern uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_Safety_IR(void);
extern uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_TI_Alert(void);
extern uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_Crash_Fault(void);
extern uint8_t  Get_CAN_CH1_ID_214_Sig_BMS_Safety_Fault(void);
extern uint8_t  Get_CAN_CH1_ID_222_Sig_GeneMode_State_HMI(void);
extern uint8_t  Get_CAN_CH1_ID_222_Sig_DriveMode_State_HMI(void);
extern uint16_t Get_CAN_CH1_ID_222_Sig_VCU_VehicleSpeed_Lmt(void);
extern uint8_t  Get_CAN_CH1_ID_222_Sig_VCU_AccelPedal_State(void);
extern uint8_t  Get_CAN_CH1_ID_222_Sig_VCU_BrakePedal_State(void);
extern uint8_t  Get_CAN_CH1_ID_222_Sig_VCU_ShiftLeverPosition(void);
extern uint8_t  Get_CAN_CH1_ID_254_Sig_REMOTE_TURN_LIGHTS_REQ(void);
extern uint8_t  Get_CAN_CH1_ID_254_Sig_REMOTE_HORN_REQUEST(void);
extern uint8_t  Get_CAN_CH1_ID_254_Sig_REMOTE_LOCK_UNLOCK_REQ(void);
extern uint8_t  Get_CAN_CH1_ID_43C_Sig_CAUSE_1(void);
extern uint16_t Get_CAN_CH1_ID_334_Sig_BMS_PackVoltage(void);
extern uint16_t Get_CAN_CH1_ID_334_Sig_BMS_MainCurrent(void);
extern uint16_t Get_CAN_CH1_ID_334_Sig_BMS_SOH(void);
extern uint16_t Get_CAN_CH1_ID_334_Sig_BMS_USOC(void);
extern uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_ASC_Sts(void);
extern uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_Ready(void);
extern uint8_t  Get_CAN_CH1_ID_306_Sig_ActiveDischarge_Sts(void);
extern uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_Fault_Level(void);
extern uint8_t  Get_CAN_CH1_ID_306_Sig_MCU_Wakeup_State(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_CCEStop_Req(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_Rcd_BMS(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_DCCharge_Relay_State(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_DCCharge_Relay_cmd(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_PowerRelay_State(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_DCChg_State(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_EndofCharge_Req(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_Fault_Level(void);
extern uint8_t  Get_CAN_CH1_ID_304_Sig_BMS_Wakeup_State(void);
extern uint16_t Get_CAN_CH1_ID_364_Sig_BMS_Charger_OutputCurrent(void);
extern uint16_t Get_CAN_CH1_ID_364_Sig_BMS_ChargeCurrentRequest(void);
extern uint8_t  Co_Can_ConvertSubID_CAN_CH1(uint32_t MsgID);
extern void Test_send_cycle(uint16_t u16ID);
extern uint8_t  CAN_CH1_SendID_Convert(uint32_t MsgID);

#endif
