/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_ETND_LLDriver.h                                                                                 */
/* SW-VERSION   = 1.5.4                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2021,2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains ETND specific definitions of Eth Driver Component.                                              */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.1: 20/10/2021    : Initial Version
 */
/**********************************************************************************************************************/
#ifndef ETH_ETND_LLDRIVER_H
#define ETH_ETND_LLDRIVER_H

#include "Std_Types.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ETH_ETND_AR_RELEASE_MAJOR_VERSION    ETH_AR_RELEASE_MAJOR_VERSION
#define ETH_ETND_AR_RELEASE_MINOR_VERSION    ETH_AR_RELEASE_MINOR_VERSION
#define ETH_ETND_AR_RELEASE_REVISION_VERSION ETH_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ETH_ETND_SW_MAJOR_VERSION            ETH_SW_MAJOR_VERSION
#define ETH_ETND_SW_MINOR_VERSION            ETH_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                              MISRA C Rule Violations                                               **
***********************************************************************************************************************/


/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* TxRAM initialization */
#define ETH_ETND_INIT_TMS_CONFIG              0x00004000UL
#define ETH_ETND_INIT_DESC_NUM                16UL
#define ETH_ETND_INIT_DESC_LOOP_NUM           2UL
#define ETH_ETND_INIT_TFS0_CONFIG             0x00000100UL
#define ETH_ETND_MIDDLE_DESC_NUM              6UL
#define ETH_ETND_EOS_DESC_NUM                 1UL
#define ETH_ETND_TDIS_0_MASK                  0x00000001UL
#define ETH_ETND_SOFTWARE_RESET_ENABLE        0x00000001UL
#define ETH_ETND_GIS_SWRCF_MASK               0x00010000UL
#define ETH_ETND_MCC_TXE_MASK                 0x00000002UL
#define ETH_ETND_TRCR0_TRANSMIT_ENABLE        0x00000001UL

/* MHD Mode values in OCR register */
#define ETH_ETND_MHD_DISABLE_MODE             0x00000000UL
#define ETH_ETND_MHD_CONFIG_MODE              0x00000001UL
#define ETH_ETND_MHD_OPERATION_MODE           0x00000002UL

/* MHD Tx General Configuration */
#define ETH_ETND_MAX_TFS                      4UL
#define ETH_ETND_TFS_CONFIG                   0x00200020UL
#define ETH_ETND_TGC1_CONFIG                  0x0000FF05UL
#define ETH_ETND_TCR1_CONFIG                  0x00000000UL
#define ETH_ETND_TCR2_CONFIG                  0x00000000UL
#define ETH_ETND_TCR3_CONFIG                  0x00000000UL
#define ETH_ETND_TCR4_CONFIG                  0x00000000UL

/* MHD Rx General Configuration */
#define ETH_ETND_RGC_CONFIG                   0x88A80000UL
#define ETH_ETND_RDFCR_CONFIG                 0x04000800UL
#define ETH_ETND_RCFCR_CONFIG                 0x00800100UL

/* Descriptor Attribute Types */
#define ETH_TX_DESCR_TSUN_MASK                0x00000FF0UL

/* Interrupt related registers */
/* AXIBMI Error Interrupt */
#define ETH_ETND_EIE0_CONFIG                  0x00000003UL
/* MHD Error Interrupt */
#define ETH_ETND_TCIE_CONFIG                  0x00000400UL
#define ETH_ETND_TIE2_CONFIG                  0xFF010000UL
#define ETH_ETND_RIE_CONFIG                   0x00000010UL

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define ETH_START_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"

extern FUNC(Std_ReturnType, ETH_PRIVATE_CODE) Eth_MHD_ModeSetting(
  CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulMode);

#define ETH_STOP_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"

#endif /* !ETH_ETND_LLDRIVER_H_ */
/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
