/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_ETNE_LLDriver.h                                                                                 */
/* SW-VERSION   = 1.5.4                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2021,2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains ETNE specific definitions of Eth Driver Component.                                              */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.1: 20/10/2021    : Initial Version
 */
/**********************************************************************************************************************/
#ifndef ETH_ETNE_LLDRIVER_H
#define ETH_ETNE_LLDRIVER_H

#include "Std_Types.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ETH_ETNE_AR_RELEASE_MAJOR_VERSION    ETH_AR_RELEASE_MAJOR_VERSION
#define ETH_ETNE_AR_RELEASE_MINOR_VERSION    ETH_AR_RELEASE_MINOR_VERSION
#define ETH_ETNE_AR_RELEASE_REVISION_VERSION ETH_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ETH_ETNE_SW_MAJOR_VERSION            ETH_SW_MAJOR_VERSION
#define ETH_ETNE_SW_MINOR_VERSION            ETH_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                            HW specific parameters referred from the upper-level driver                             **
***********************************************************************************************************************/


/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Descriptor Attribute Types */
#define ETH_TX_DESCR_TSUN_OFFSET              128UL /* offset = 256 / maximum port */

/* GWCA Mode values in GWMC register */
#define ETH_ETNE_GWMC_RESET_MODE              0x00000000UL
#define ETH_ETNE_GWMC_DISABLE_MODE            0x00000001UL
#define ETH_ETNE_GWMC_CONFIG_MODE             0x00000002UL
#define ETH_ETNE_GWMC_OPERATION_MODE          0x00000003UL

/* ETHA Mode values in EAMC register */
#define ETH_ETNE_ETHA_RESET_MODE              0x00000000UL
#define ETH_ETNE_ETHA_DISABLE_MODE            0x00000001UL
#define ETH_ETNE_ETHA_CONFIG_MODE             0x00000002UL
#define ETH_ETNE_ETHA_OPERATION_MODE          0x00000003UL
#define ETH_ETNE_EAMS_OPS_MASK                0x00000003UL

/* Rx General Configuration */
#define ETH_ETNE_GWRGC_FCS_DISABLE            0x00000000UL

/* Ethernet Agent PCP remapping configuration */
#define ETH_ETNE_EAPRC_CONFIG                 0x76543210UL
#define ETH_ETNE_EATDQD_CONFIG                64UL

/* mFWD configuration */
#define ETH_ETNE_MAX_PN                       3UL
#define ETH_ETNE_MAX_MFN_QGN                  16UL
#define ETH_ETNE_MAX_QCI_GRP                  (ETH_ETNE_MAX_MFN_QGN / 8UL)
#define ETH_ETNE_MAX_QCI_VLAN                 (ETH_ETNE_MAX_MFN_QGN / 2UL)
#define ETH_ETNE_FWMFV_CONFIG                 0x0000FFFFUL
#define ETH_ETNE_FWSPBFE_CONFIG               0x3UL
#define ETH_ETNE_FWCEPC_CONFIG                0x00040000UL
#define ETH_ETNE_SOVPC4_CONFIG                1UL
#define ETH_ETNE_FWGGTS_CONFIG                ETH_GPTP_TIMER_DOMAIN
#define ETH_ETNE_FWRR_QTRR                    0x00000001UL
#define ETH_ETNE_FWRR_MTRR                    0x00000004UL
#define ETH_ETNE_FWQTLR_QTL                   0x80000000UL
#define ETH_ETNE_FWMTLR_MTL                   0x80000000UL

#define ETH_ETNE_QCI_TBL_TOTAL                0UL

/* Error interrupt configuration */
#define ETH_ETNE_EAEIE0_CONFIG                0x00130000UL
#define ETH_ETNE_FWEIE1_CONFIG                0x00000380UL

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/


/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define ETH_START_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"

extern FUNC(Std_ReturnType, ETH_PRIVATE_CODE) Eth_ETHA_ModeSetting(
  CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulMode);

#define ETH_STOP_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"

#endif /* !ETH_ETNE_LLDRIVER_H_ */
/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
