/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_PIN_Ram.c                                                                                       */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Global variable declarations                                                                                       */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3:  17/04/2022  : Merge QAC message from U2Ax, E2x and U2Bx
 * 1.4.2:  02/03/2022  : Fix QAC header and message
 * 1.4.1:  18/10/2021  : Add QAC message 9.5.0
 *         16/09/2021  : Correct preprocessor directives
 * 1.3.2:  30/08/2021  : Change from #include "Icu_MemMap.h" to #include "Icu_Mapping.h".
 * 1.3.1:  02/07/2021  : Format source code to 120 characters
 *         04/05/2021  : Updated memory section and memory class for Icu_ExtIntFunc
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro is    */
/*                       over 1024                                                                                    */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object '%1s' is referenced in only one translation unit - but not the one in which it    */
/*                       is defined.                                                                                  */
/* Rule                : CERTCCM DCL15, DCL19, MISRA C:2012 Rule-8.7                                                  */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in separated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/* Included for RAM variable declarations */
#include "Icu_LLDriver.h"                                                                                               /* PRQA S 0857 # JV-01 */
#include "Icu_PIN_Ram.h"
#include "Icu_PIN_LLDriver.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define ICU_PIN_RAM_C_AR_RELEASE_MAJOR_VERSION    ICU_AR_RELEASE_MAJOR_VERSION_VALUE
#define ICU_PIN_RAM_C_AR_RELEASE_MINOR_VERSION    ICU_AR_RELEASE_MINOR_VERSION_VALUE
#define ICU_PIN_RAM_C_AR_RELEASE_REVISION_VERSION ICU_AR_RELEASE_REVISION_VERSION_VALUE

/* File version information */
#define ICU_PIN_RAM_C_SW_MAJOR_VERSION            ICU_SW_MAJOR_VERSION_VALUE
#define ICU_PIN_RAM_C_SW_MINOR_VERSION            ICU_SW_MINOR_VERSION_VALUE

/***********************************************************************************************************************
**                                                   Version Check                                                    **
***********************************************************************************************************************/
#if (ICU_PIN_RAM_AR_RELEASE_MAJOR_VERSION != ICU_PIN_RAM_C_AR_RELEASE_MAJOR_VERSION)
  #error "Icu_PIN_Ram.c : Mismatch in Release Major Version"
#endif
#if (ICU_PIN_RAM_AR_RELEASE_MINOR_VERSION != ICU_PIN_RAM_C_AR_RELEASE_MINOR_VERSION)
  #error "Icu_PIN_Ram.c : Mismatch in Release Minor Version"
#endif
#if (ICU_PIN_RAM_AR_RELEASE_REVISION_VERSION != ICU_PIN_RAM_C_AR_RELEASE_REVISION_VERSION)
  #error "Icu_PIN_Ram.c : Mismatch in Release Revision Version"
#endif

#if (ICU_PIN_RAM_SW_MAJOR_VERSION != ICU_PIN_RAM_C_SW_MAJOR_VERSION)
  #error "Icu_PIN_Ram.c : Mismatch in Software Major Version"
#endif

#if (ICU_PIN_RAM_SW_MINOR_VERSION != ICU_PIN_RAM_C_SW_MINOR_VERSION)
  #error "Icu_PIN_Ram.c : Mismatch in Software Minor Version"
#endif

/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#if ((STD_ON == ICU_IRQ_EDGE_DETECT) || (STD_ON == ICU_INTP_EDGE_DETECT))
#define ICU_START_SEC_CONST_PTR
#include "Icu_Mapping.h"
VAR(Icu_HwFuncTableType, ICU_CONST) Icu_ExtIntFunc =                                                                    /* PRQA S 1531 # JV-01 */
{
  NULL_PTR,
  &Icu_HW_Pin_ChannelInit,
  NULL_PTR,
  #if (ICU_DE_INIT_API == STD_ON)
  &Icu_HW_Pin_ChannelDeInit,
  #else
  NULL_PTR,
  #endif
  NULL_PTR,
  NULL_PTR,
  #if (ICU_SET_MODE_API == STD_ON)
  &Icu_HW_Pin_SetMode,
  #else
  NULL_PTR,
  #endif
  &Icu_HW_Pin_SetActivation,
  NULL_PTR,
  NULL_PTR,
  NULL_PTR,
  #if (ICU_GET_INPUT_LEVEL_API == STD_ON)
  &Icu_HW_GetInputLevel,
  #else
  NULL_PTR,
  #endif
  #if (ICU_EDGE_DETECT_API == STD_ON)
  &Icu_HW_Pin_EnableEdgeDetection,
  &Icu_HW_Pin_DisableEdgeDetection
  #else
  NULL_PTR,
  NULL_PTR
  #endif
};
#define ICU_STOP_SEC_CONST_PTR
#include "Icu_Mapping.h"                                                                                                /* PRQA S 5087 # JV-01 */
#endif /* ((STD_ON == ICU_IRQ_EDGE_DETECT) || (STD_ON == ICU_INTP_EDGE_DETECT)) */
/***********************************************************************************************************************
**                                                Function Definitions                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
