/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_ATU_Irq.h                                                                                       */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020, 2021 Renesas Electronics Corporation. All rights reserved.                                               */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains ISRs prototypes for all Timers of ICU Driver                                                    */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.1:  15/09/2021  : Add ISR for TimerC 14.
 * 1.3.2:  30/08/2021  : Change from #include "Icu_MemMap.h" to #include "Icu_Mapping.h".
 *                       Update header file macro.
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_ATU_IRQ
            #define ICU_59_INST0_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_ATU_IRQ
            #define ICU_59_INST1_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_ATU_IRQ
            #define ICU_59_INST2_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_ATU_IRQ
            #define ICU_59_INST3_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_ATU_IRQ
            #define ICU_59_INST4_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_ATU_IRQ
            #define ICU_59_INST5_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_ATU_IRQ
            #define ICU_59_INST6_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_ATU_IRQ
            #define ICU_59_INST7_ATU_IRQ
            #define ICU_ATU_IRQ_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_ATU_IRQ
        #define ICU_ATU_IRQ
        #define ICU_ATU_IRQ_HEADER
    #endif
#endif

#ifdef ICU_ATU_IRQ_HEADER
#undef ICU_ATU_IRQ_HEADER                                                                                               /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for interrupt category definitions */
#include "Os.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ICU_ATU_IRQ_AR_RELEASE_MAJOR_VERSION    ICU_AR_RELEASE_MAJOR_VERSION
#define ICU_ATU_IRQ_AR_RELEASE_MINOR_VERSION    ICU_AR_RELEASE_MINOR_VERSION
#define ICU_ATU_IRQ_AR_RELEASE_REVISION_VERSION ICU_AR_RELEASE_REVISION_VERSION

/* File version information */
#define ICU_ATU_IRQ_SW_MAJOR_VERSION            ICU_SW_MAJOR_VERSION
#define ICU_ATU_IRQ_SW_MINOR_VERSION            ICU_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#define ICU_START_SEC_CODE_FAST
#include "Icu_Mapping.h"

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH04_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH04_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH05_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH05_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH06_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH06_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERA0_CH07_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERA0_CH07_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC0_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC0_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC0_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC0_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC0_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC0_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC0_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC0_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC1_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC1_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC1_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC1_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC1_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC1_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC1_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC1_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC2_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC2_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC2_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC2_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC2_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC2_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC2_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC2_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC3_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC3_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC3_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC3_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC3_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC3_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC3_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC3_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC4_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC4_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC4_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC4_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC4_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC4_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC4_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC4_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC5_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC5_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC5_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC5_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC5_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC5_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC5_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC5_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC6_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC6_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC6_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC6_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC6_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC6_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC6_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC6_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC7_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC7_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC7_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC7_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC7_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC7_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC7_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC7_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC8_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC8_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC8_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC8_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC8_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC8_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC8_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC8_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC9_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC9_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC9_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC9_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC9_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC9_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC9_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC9_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC10_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC10_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC10_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC10_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC10_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC10_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC10_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC10_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC11_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC11_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC11_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC11_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC11_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC11_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC11_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC11_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC12_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC12_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC12_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC12_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC12_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC12_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC12_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC12_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC13_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC13_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC13_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC13_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC13_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC13_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC13_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC13_CH03_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC14_CH00_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC14_CH00_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC14_CH01_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC14_CH01_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC14_CH02_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC14_CH02_ISR(void);
#endif

/* Defines the CAT2 interrupt mapping */
#if defined(Os_ATU_TIMERC14_CH03_CAT2_ISR) || (ICU_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, ICU_CODE_FAST) ATU_TIMERC14_CH03_ISR(void);
#endif

#define ICU_STOP_SEC_CODE_FAST
#include "Icu_Mapping.h"
#endif /* ICU_ATU_IRQ_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
