/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_ATU_Ram.h                                                                                       */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* API function implementations of PWM  Driver                                                                        */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.4.2: 08/03/2022 : Add message QAC 3684 for Pwm_GaaATUChannelProp[]                                               **
 * 1.4.1: 06/12/2021 : Remove define number of element in array Pwm_GaaATUChannelProp                                 **
 * 1.4.0: 20/11/2021 : Add condition macro PWM_ATU_UNIT_USED to support U2Bx                                          **
 * 1.3.2: 04/08/2021 : Device specific implementation moved from Pwm common file.                                     **
 * 1.3.1: 02/07/2021 : Add QAC message 9.5.0                                                                          **
 *                     Format source code to 120 characters                                                           **
 *                     Improve Violation tag (remove START/END)                                                       **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.1: 18/05/2020 : Added size of                                                                                  **
                        Pwm_GaaATUChannelProp[PWM_TOTAL_CHANNELS_CONFIG]                                              **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_ATU_RAM_H
            #define PWM_59_INST0_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_ATU_RAM_H
            #define PWM_59_INST1_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_ATU_RAM_H
            #define PWM_59_INST2_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_ATU_RAM_H
            #define PWM_59_INST3_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_ATU_RAM_H
            #define PWM_59_INST4_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_ATU_RAM_H
            #define PWM_59_INST5_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_ATU_RAM_H
            #define PWM_59_INST6_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_ATU_RAM_H
            #define PWM_59_INST7_ATU_RAM_H
            #define PWM_ATU_RAM_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_ATU_RAM_H
        #define PWM_ATU_RAM_H
        #define PWM_ATU_RAM_HEADER
    #endif
#endif


#ifdef PWM_ATU_RAM_HEADER
#undef PWM_ATU_RAM_HEADER                                                                                               /* PRQA S 0841 # JV-01 */
/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/

/* AUTOSAR release version information */
#define PWM_ATU_RAM_AR_RELEASE_MAJOR_VERSION    PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_ATU_RAM_AR_RELEASE_MINOR_VERSION    PWM_AR_RELEASE_MINOR_VERSION
#define PWM_ATU_RAM_AR_RELEASE_REVISION_VERSION PWM_AR_RELEASE_REVISION_VERSION

/* Software module version information */
#define PWM_ATU_RAM_SW_MAJOR_VERSION            PWM_SW_MAJOR_VERSION
#define PWM_ATU_RAM_SW_MINOR_VERSION            PWM_SW_MINOR_VERSION
#define PWM_ATU_RAM_SW_PATCH_VERSION            PWM_SW_PATCH_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3684)    : Array declared with unknown size.                                                            */
/* Rule                : CERTCCM ARR02, MISRA C:2012 Rule-8.11                                                        */
/* JV-01 Justification : Arrays used are verified in the file which are only declarations and size is configuration   */
/*                       dependent.                                                                                   */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#if (PWM_ATU_UNIT_USED == STD_ON)
#define PWM_START_SEC_VAR_NO_INIT_PTR
#include "Pwm_Mapping.h"

extern P2CONST(Pwm_ATUUnitConfigType, PWM_VAR_NO_INIT, PWM_CONFIG_CONST) volatile Pwm_GpATUUnitConfig;
#if (PWM_CLOCK_SETTING == STD_ON)
extern P2CONST(Pwm_ATUClockConfigType, PWM_VAR_NO_INIT, PWM_CONFIG_CONST) volatile Pwm_GpATUClockConfig;
#endif

#define PWM_STOP_SEC_VAR_NO_INIT_PTR
#include "Pwm_Mapping.h"

#define PWM_START_SEC_VAR_NO_INIT_8
#include "Pwm_Mapping.h"

extern volatile VAR(uint8, PWM_VAR_NO_INIT) Pwm_GaaFpsSupport_Flag[PWM_TOTAL_CHANNELS_CONFIG];

#define PWM_STOP_SEC_VAR_NO_INIT_8
#include "Pwm_Mapping.h"
/***********************************************************************************************************************
**                                                  Global Variables                                                  **
***********************************************************************************************************************/
#define PWM_START_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"

extern VAR(Pwm_HwFuncTableType, PWM_VAR_NO_INIT) Pwm_AtuFunc;

#define PWM_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"


/***********************************************************************************************************************
**                                           Global configuration constants                                           **
***********************************************************************************************************************/
#define PWM_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"

/* Array of structures for Timer channel properties */
extern CONST(Pwm_ATUChannelPropType, PWM_CONST) Pwm_GaaATUChannelProp[];                                                /* PRQA S 3684 # JV-01 */

#if (PWM_CLOCK_SETTING == STD_ON)
extern CONST(Pwm_ATUClockConfigType, PWM_CONFIG_DATA) Pwm_GaaATUClockConfig[];                                          /* PRQA S 3684 # JV-01 */

extern CONST(Pwm_ATUConfigType, PWM_CONFIG_DATA) Pwm_GaaATUConfiguration[];                                             /* PRQA S 3684 # JV-01 */
#endif

/* Structure for ATU channel configuration */
extern CONST(Pwm_ATUChannelConfigType, PWM_CONFIG_DATA) Pwm_GaaATUChannelConfig[];                                      /* PRQA S 3684 # JV-01 */

extern CONST(Pwm_ATUUnitConfigType, PWM_CONFIG_DATA) Pwm_GaaATUUnitConfig[];                                            /* PRQA S 3684 # JV-01 */
#define PWM_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"
#endif /*#if (PWM_ATU_UNIT_USED == STD_ON)*/
/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#endif /* PWM_ATU_RAM_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
