/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_TAU_PBTypes.h                                                                                   */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains macros and structure data types for post build                                                  */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.4.4: 13/07/2022 : Removed QAC message 0883                                                                       **
 * 1.4.1: 21/11/2021 : Update QAC message for U2Bx                                                                    **
 * 1.3.2: 04/08/2021 : Device specific implementation moved from Pwm common file.                                     **
 *                     Format source code unified within module.                                                      **
 * 1.3.1: 02/07/2021 : Format source code to 120 characters                                                           **
 *        19/05/2021 : Removed ucPwmTauType from Pwm_TAUChannelConfigType                                             **
 *        15/05/2021 : Fixed Coding Rule and tailor space                                                             **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.1: 19/05/2020 : Changed "uinteger uiPwmTAUType;"                                                               **
 *                                 to "uint8 ucPwmTAUType;"                                                           **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_TAU_PBTYPES_H
            #define PWM_59_INST0_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_TAU_PBTYPES_H
            #define PWM_59_INST1_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_TAU_PBTYPES_H
            #define PWM_59_INST2_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_TAU_PBTYPES_H
            #define PWM_59_INST3_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_TAU_PBTYPES_H
            #define PWM_59_INST4_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_TAU_PBTYPES_H
            #define PWM_59_INST5_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_TAU_PBTYPES_H
            #define PWM_59_INST6_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_TAU_PBTYPES_H
            #define PWM_59_INST7_TAU_PBTYPES_H
            #define PWM_TAU_PBTYPES_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_TAU_PBTYPES_H
        #define PWM_TAU_PBTYPES_H
        #define PWM_TAU_PBTYPES_HEADER
    #endif
#endif



#ifdef PWM_TAU_PBTYPES_HEADER
#undef PWM_TAU_PBTYPES_HEADER                                                                                           /* PRQA S 0841 # JV-01 */
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for data type uinteger declaration */
#include "rh850_Types.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define PWM_TAU_PBTYPES_AR_RELEASE_MAJOR_VERSION    PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_TAU_PBTYPES_AR_RELEASE_MINOR_VERSION    PWM_AR_RELEASE_MINOR_VERSION
#define PWM_TAU_PBTYPES_AR_RELEASE_REVISION_VERSION PWM_AR_RELEASE_REVISION_VERSION

/* File version information */
#define PWM_TAU_PBTYPES_SW_MAJOR_VERSION            PWM_SW_MAJOR_VERSION
#define PWM_TAU_PBTYPES_SW_MINOR_VERSION            PWM_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Shift value */
#define PWM_CKS_BITS_POSITION                      (uint16)0x000EU
/* Flags which use SelectChannelClk function */
#define PWM_STOPPED_CH                             (uint8)0x01U
#define PWM_NOTSTARTED_CH                          (uint8)0x00U
/***********************************************************************************************************************
**                                     Structure for TAU Unit configuration type                                      **
***********************************************************************************************************************/
/***********************************************************************************************************************
**                                    Data structure for PWM channel configuration                                    **
***********************************************************************************************************************/
typedef struct STag_Pwm_TAUChannelConfigType
{
  /* Offset with respect to base Timer control register of the master channel of corresponding channel */
  uint8 ucMasterOffset;
  /* Timer Unit Index in the Array Pwm_GaaTAUDUnitConfig / Pwm_GaaTAUJUnitConfig based on the channel belongs to
   * TAUD or TAUJ */
  uint8 ucTimerUnitIndex;
  /*
   * ucTimerMode = true means channel acts as master channel
   * ucTimerMode = false means channel acts as slave channel
   */
  uint8 ucTimerMode;
  #if (PWM_SYNC_START_SUPPORT == STD_ON)
  /*
   * blComplexDriverInit = true means channel will be used by complex driver
   * blComplexDriverInit = false means channel will be used by PWM driver
   */
  boolean blComplexDriverInit;
  #endif
} Pwm_TAUChannelConfigType;

#endif /* PWM_TAU_PBTYPES_HEADER */
/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
