/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi.h                                                                                               */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains macros, SPI type definitions, structure data types and API function prototypes of SPI Driver    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.0:  02/12/2022  : Update to increase sw version:
 *                      - Change value of macro SPI_SW_MINOR_VERSION to 5U
 *                      - Change value of macro SPI_SW_PATCH_VERSION to 0U
 * 1.4.4:  20/06/2022  : Added macro SPI_PORT_PIN_MASK
 *         17/06/2022  : Update SPI_SW_PATCH_VERSION to 4
 * 1.4.3:  09/05/2022  : Add new DET error code SPI_E_PARAM_VALUE
 *         20/05/2022  : Remove redundant macro
 * 1.4.2:  02/03/2022  : Merge QAC
 * 1.4.1:  06/12/2021  : Update SPI_SW_PATCH_VERSION to 1U for SW-VERSION up
 * 1.4.0:  15/10/2021  : Update SPI_SW_MINOR_VERSION to 4U and SPI_SW_PATCH_VERSION to 0U for SW-VERSION up
 * 1.3.2:  06/09/2021  : Update QAC contents
 *         30/08/2021  : Update header file macro to call file multiple times
 *                       Update to include Spi_Mapping.h instead of Spi_MemMap.h
 *         13/08/2021  : Changed SPI_SW_PATCH_VERSION to 2U for SW-VERSION up
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 *         07/05/2021  : Remove the declaration of Spi_MainFunction_Handling
 * 1.3.0:  02/12/2020  : Changed SPI_SW_MINOR_VERSION to 3U and SPI_SW_PATCH_VERSION to 1U for SW-VERSION up
 * 1.2.1:  14/10/2020  : Changed SPI_SW_PATCH_VERSION to 1U for SW-VERSION up
 * 1.2.0:  30/07/2020  : Release
 *         28/07/2020  : Add QAC 9.3.1 comment.
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  24/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (7:0791)    : Macro identifier does not differ from other macro identifier(s) (e.g. '%s') within the       */
/*                       specified number of significant characters.                                                  */
/* Rule                : CERTCCM DCL23, MISRA C:2012 Rule-5.4                                                         */
/* JV-01 Justification : This macro identifier is following AUTOSAR standard rule (Symbolic Name or Published         */
/*                       Macro's name), so this is accepted.                                                          */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

#ifdef SPI_INSTANCE_INDEX
    #if (SPI_INSTANCE_INDEX == 0)
        #ifndef SPI_59_INST0
            #define SPI_59_INST0
            #define SPI_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 1)
        #ifndef SPI_59_INST1
            #define SPI_59_INST1
            #define SPI_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 2)
        #ifndef SPI_59_INST2
            #define SPI_59_INST2
            #define SPI_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 3)
        #ifndef SPI_59_INST3
            #define SPI_59_INST3
            #define SPI_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 4)
        #ifndef SPI_59_INST4
            #define SPI_59_INST4
            #define SPI_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 5)
        #ifndef SPI_59_INST5
            #define SPI_59_INST5
            #define SPI_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 6)
        #ifndef SPI_59_INST6
            #define SPI_59_INST6
            #define SPI_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 7)
        #ifndef SPI_59_INST7
            #define SPI_59_INST7
            #define SPI_HEADER
        #endif
    #else
        #error "Miss instance index"
    #endif
#else
    #ifndef SPI_H
        #define SPI_H
        #define SPI_HEADER
    #endif
#endif

#ifdef SPI_HEADER
#undef SPI_HEADER                                                                                                       /* PRQA S 0841 # JV-01 */
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Include definition of multi instance */
#include "Spi_MultiInstance.h"
/* Include standard Autosar Type */
#include "Std_Types.h"
/* Include Spi pre-compile options */
#include SPI_CFG_HEADER
/* Include for Spi Type declaration */
#include "Spi_Types.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
#define SPI_INSTANCE_ID    SPI_INSTANCE_ID_VALUE

/* Vendor and module identification */
#define SPI_VENDOR_ID      SPI_VENDOR_ID_VALUE
#define SPI_MODULE_ID      SPI_MODULE_ID_VALUE

/* Different supported AUTOSAR release versions information */
#define SPI_AR_422_VERSION 422U
#define SPI_AR_431_VERSION 431U

/* AUTOSAR specification version information */
#if (SPI_AR_VERSION == SPI_AR_422_VERSION)
#define SPI_AR_RELEASE_MAJOR_VERSION    4U
#define SPI_AR_RELEASE_MINOR_VERSION    2U
#define SPI_AR_RELEASE_REVISION_VERSION 2U                                                                              /* PRQA S 0791 # JV-01 */
#elif (SPI_AR_VERSION == SPI_AR_431_VERSION)
#define SPI_AR_RELEASE_MAJOR_VERSION    4U
#define SPI_AR_RELEASE_MINOR_VERSION    3U
#define SPI_AR_RELEASE_REVISION_VERSION 1U                                                                              /* PRQA S 0791 # JV-01 */
#endif /* (SPI_AR_VERSION == SPI_AR_431_VERSION) */

/* File version information */
#define SPI_SW_MAJOR_VERSION          1U
#define SPI_SW_MINOR_VERSION          5U
#define SPI_SW_PATCH_VERSION          0U

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Port pin mask */
#define SPI_PORT_PIN_MASK                (uint32)0xFFFF0000UL
/***********************************************************************************************************************
**                                                    Service IDs                                                     **
***********************************************************************************************************************/
/* Service ID for Spi_Init() */
#define SPI_INIT_SID                  (uint8)0x00
/* Service ID for Spi_DeInit() */
#define SPI_DEINIT_SID                (uint8)0x01
/* Service ID for Spi_WriteIB() */
#define SPI_WRITEIB_SID               (uint8)0x02
/* Service ID for Spi_AsyncTransmit() */
#define SPI_ASYNCTRANSMIT_SID         (uint8)0x03
/* Service ID for Spi_ReadIB() */
#define SPI_READIB_SID                (uint8)0x04
/* Service ID for Spi_SetupEB() */
#define SPI_SETUPEB_SID               (uint8)0x05
/* Service ID for Spi_GetStatus() */
#define SPI_GETSTATUS_SID             (uint8)0x06
/* Service ID for Spi_GetJobResult() */
#define SPI_GETJOBRESULT_SID          (uint8)0x07
/* Service ID for Spi_GetSequenceResult() */
#define SPI_GETSEQUENCERESULT_SID     (uint8)0x08
/* Service ID for Spi_GetVersionInfo() */
#define SPI_GETVERSIONINFO_SID        (uint8)0x09
/* Service ID for Spi_SyncTransmit() */
#define SPI_SYNCTRANSMIT_SID          (uint8)0x0A
/* Service ID for Spi_GetHWUnitStatus() */
#define SPI_GETHWUNITSTATUS_SID       (uint8)0x0B
/* Service ID for Spi_Cancel() */
#define SPI_CANCEL_SID                (uint8)0x0C
/* Service ID for Spi_SetAsyncMode() */
#define SPI_SETASYNCMODE_SID          (uint8)0x0D
/* Service ID for Spi_ForceCancel() */
#define SPI_FORCECANCEL_SID           (uint8)0xA0

/***********************************************************************************************************************
**                                                  DET Error Codes                                                   **
***********************************************************************************************************************/
/* API services invoked with invalid channel ID */
#define SPI_E_PARAM_CHANNEL           (uint8)0x0A
/* API services invoked with invalid job ID */
#define SPI_E_PARAM_JOB               (uint8)0x0B
/* API services invoked with invalid sequence ID */
#define SPI_E_PARAM_SEQ               (uint8)0x0C
/* Spi_SetupEB API invoked with length greater than configured length */
#define SPI_E_PARAM_LENGTH            (uint8)0x0D
/* Spi_GetHWUnitStatus API invoked with invalid hardware unit ID */
#define SPI_E_PARAM_UNIT              (uint8)0x0E
/* Spi_SetAsyncMode API invoked with invalid asynchronous mode */
#define SPI_E_PARAM_VALUE             (uint8)0x0F
/* API services invoked before the initialization of SPI Driver */
#define SPI_E_UNINIT                  (uint8)0x1A
/* API services invoked in a wrong sequence */
#define SPI_E_SEQ_PENDING             (uint8)0x2A
/* Spi_SyncTransmit API invoked at wrong time */
#define SPI_E_SEQ_IN_PROCESS          (uint8)0x3A
/* Spi_init API service called while the Spi driver has already been initialized */
#define SPI_E_ALREADY_INITIALIZED     (uint8)0x4A
/* Spi_Init API invoked with pointer to invalid database */
#define SPI_E_INVALID_DATABASE        (uint8)0xEF
/* Spi_GetVersionInfo API invoked with invalid pointer */
#define SPI_E_PARAM_POINTER           (uint8)0x10

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define SPI_START_SEC_PUBLIC_CODE
#include "Spi_Mapping.h"

/* External declaration for Spi performs initialization SPI Driver API */
extern FUNC(void, SPI_PUBLIC_CODE) Spi_Init(P2CONST(Spi_ConfigType, AUTOMATIC, SPI_APPL_CONST) ConfigPtr);
/* External declaration for Spi performs de-initialization SPI Driver API */
extern FUNC(Std_ReturnType, SPI_PUBLIC_CODE) Spi_DeInit(void);

#if (SPI_CHANNEL_BUFFERS_ALLOWED == SPI_IB) || (SPI_CHANNEL_BUFFERS_ALLOWED == SPI_IBEB)
/* External declaration for Spi performs write IB API */
extern FUNC(Std_ReturnType, SPI_PUBLIC_CODE)
    Spi_WriteIB(Spi_ChannelType Channel, P2CONST(Spi_DataBufferType, AUTOMATIC, SPI_APPL_CONST) DataBufferPtr);
/* External declaration for Spi performs read IB API */
extern FUNC(Std_ReturnType, SPI_PUBLIC_CODE)
    Spi_ReadIB(Spi_ChannelType Channel, P2VAR(Spi_DataBufferType, AUTOMATIC, SPI_APPL_DATA) DataBufferPointer);         /* PRQA S 3432 # JV-01 */
#endif

#if (SPI_CHANNEL_BUFFERS_ALLOWED == SPI_EB) || (SPI_CHANNEL_BUFFERS_ALLOWED == SPI_IBEB)
/* External declaration for Spi performs setup EB API */
extern FUNC(Std_ReturnType, SPI_PUBLIC_CODE)
    Spi_SetupEB(Spi_ChannelType Channel, P2CONST(Spi_DataBufferType, AUTOMATIC, SPI_APPL_DATA) SrcDataBufferPtr,
                P2VAR(Spi_DataBufferType, AUTOMATIC, SPI_APPL_DATA) DesDataBufferPtr, Spi_NumberOfDataType Length);     /* PRQA S 3432 # JV-01 */
#endif

#if ((SPI_LEVEL_DELIVERED == SPI_LEVEL_1) || (SPI_LEVEL_DELIVERED == SPI_LEVEL_2))
/* External declaration for Spi transmitting data asynchronously API */
extern FUNC(Std_ReturnType, SPI_PUBLIC_CODE) Spi_AsyncTransmit(Spi_SequenceType Sequence);
#endif

#if ((SPI_LEVEL_DELIVERED == SPI_LEVEL_0) || (SPI_LEVEL_DELIVERED == SPI_LEVEL_2))
/* External declaration for Spi transmitting data synchronously API */
extern FUNC(Std_ReturnType, SPI_PUBLIC_CODE) Spi_SyncTransmit(Spi_SequenceType Sequence);
#endif

/* External declaration for Spi get status API */
extern FUNC(Spi_StatusType, SPI_PUBLIC_CODE) Spi_GetStatus(void);

/* External declaration for Spi get job result API */
extern FUNC(Spi_JobResultType, SPI_PUBLIC_CODE) Spi_GetJobResult(Spi_JobType Job);

/* External declaration for Spi get sequence result API */
extern FUNC(Spi_SeqResultType, SPI_PUBLIC_CODE) Spi_GetSequenceResult(Spi_SequenceType Sequence);

/* API to get the version information */
#if (SPI_VERSION_INFO_API == STD_ON)
/* External declaration for Spi get version info  API */
extern FUNC(void, SPI_PUBLIC_CODE) Spi_GetVersionInfo(
                                                    P2VAR(Std_VersionInfoType, AUTOMATIC, SPI_APPL_DATA) versioninfo);  /* PRQA S 3432 # JV-01 */
#endif /* END of SPI_VERSION_INFO_API */

#if (SPI_HW_STATUS_API == STD_ON)
/* External declaration for Spi get HW status  API */
extern FUNC(Spi_StatusType, SPI_PUBLIC_CODE) Spi_GetHWUnitStatus(Spi_HWUnitType HWUnit);
#endif

#if (SPI_CANCEL_API == STD_ON)
/* External declaration for Spi cancel API */
extern FUNC(void, SPI_PUBLIC_CODE) Spi_Cancel(Spi_SequenceType Sequence);
#endif

#if (SPI_LEVEL_DELIVERED == SPI_LEVEL_2)
/* External declaration for Spi setting the asynchronous mode API */
extern FUNC(Std_ReturnType, SPI_PUBLIC_CODE) Spi_SetAsyncMode(Spi_AsyncModeType Mode);
#endif

#if (SPI_FORCE_CANCEL_API == STD_ON)
/* External declaration for Spi force cancel API */
extern FUNC(void, SPI_PUBLIC_CODE) Spi_ForceCancel(const Spi_SequenceType LucSequence);
#endif

#define SPI_STOP_SEC_PUBLIC_CODE
#include "Spi_Mapping.h"

/***********************************************************************************************************************
**                                                    Global Data                                                     **
***********************************************************************************************************************/
#define SPI_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Spi_Mapping.h"

/* Structure for SPI Init configuration */
extern CONST(Spi_ConfigType, SPI_CONFIG_DATA) Spi_GaaConfiguration[1];

#define SPI_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Spi_Mapping.h"
#endif /* SPI_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
