/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_ETNC_Ram.h                                                                                      */
/* SW-VERSION   = 1.6.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains global variables and buffer management functions for                                            */
/* ETH Driver                                                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.0: 07/10/2021    : For support U2Bx, added the extern definition of the following global variables.
 *                        Eth_GaaDemEventAccess, Eth_GaaDemEventRxFramesLost, Eth_GaaDemEventCRC,
 *                        Eth_GaaDemEventUnderSizeFrame, Eth_GaaDemEventOverSizeFrame, Eth_GaaDemEventAlignment,
 *                        Eth_GaaDemEventSinglecollision, Eth_GaaDemEventMultiplecollision,
 *                        Eth_GaaDemEventLatecollision, Eth_GaaDemEventIntInconsistent,
 *                        Eth_GaaDemEventRegisterCorruption and Eth_GaaDemEventDmaError.
 * 1.4.2: 24/08/2021    : Modify the format to 120 characters
 * 1.4.1: 07/05/2021    : Remove vendor ID from the file name, API names
 *                        and parameters according to BSW00347 requirement
 *        09/06/2021    : Remove QA-C Warning 3432 according to QA-C 9.5.0
 *        06/07/2021    : Updated QA-C 9.5.0 comments.
 * 1.2.0: 13/07/2020    : Release
 *        29/07/2020    : Add QAC 9.3.1 comment.
 * 1.1.0: 19/06/2020    : Release
 * 1.0.1: 04/06/2020    : Reviewed the memory section.
 *                        Removed #if (ETH_59_AR_VERSION >= ETH_59_AR_431_VERSION) in Eth_59_GetTxBuffer
 * 1.0.0: 25/03/2020    : Initial Version
 */
/**********************************************************************************************************************/
#ifndef ETH_ETNC_RAM_H
#define ETH_ETNC_RAM_H
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
#include "Eth_Types.h"
#include "Eth_Filter.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ETH_ETNC_RAM_AR_RELEASE_MAJOR_VERSION    ETH_AR_RELEASE_MAJOR_VERSION
#define ETH_ETNC_RAM_AR_RELEASE_MINOR_VERSION    ETH_AR_RELEASE_MINOR_VERSION
#define ETH_ETNC_RAM_AR_RELEASE_REVISION_VERSION ETH_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ETH_ETNC_RAM_SW_MAJOR_VERSION            ETH_SW_MAJOR_VERSION
#define ETH_ETNC_RAM_SW_MINOR_VERSION            ETH_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Calculate the internal buffer byte size:
   Add paddings then extend to the device specific byte align */
#define ETH_INTERNAL_TX_BUFFER_BYTE                                                                 \
  (((uint32)ETH_CTRL_TX_BUF_LEN_BYTE_0 + ETH_TXRX_BUFFER_PRE_PADDING + ETH_TXRX_BUFFER_IN_PADDING + \
    (ETH_TX_BUFFER_ALIGNMENT - 1UL)) & ~(ETH_TX_BUFFER_ALIGNMENT - 1UL))

#define ETH_INTERNAL_RX_BUFFER_BYTE                                                                 \
  (((uint32)ETH_CTRL_RX_BUF_LEN_BYTE_0 + ETH_TXRX_BUFFER_PRE_PADDING + ETH_TXRX_BUFFER_IN_PADDING + \
    (ETH_RX_BUFFER_ALIGNMENT - 1UL)) & ~(ETH_RX_BUFFER_ALIGNMENT - 1UL))

/* Return value of Eth_GetTxBuffer when there is no free buffer.
   Since the maximum buffer number is 255(range of idx:0..254),
   0xFF is never used for any available buffer. */
#define ETH_INVALID_BUFFER_INDEX 0x000000FFUL

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/*                       REFERENCE - ISO:C90-6.3.1 Primary Expressions                                                */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is           */
/*                       accepted.                                                                                    */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
#define ETH_START_SEC_VAR_INIT_16
#include "Eth_MemMap.h"

extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventAccess[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventRxFramesLost[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventCRC[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventUnderSizeFrame[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventOverSizeFrame[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventAlignment[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventSinglecollision[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventMultiplecollision[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventLatecollision[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventIntInconsistent[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventRegisterCorruption[ETH_MAX_CTRLS_SUPPORTED];
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventDmaError[ETH_MAX_CTRLS_SUPPORTED];

#define ETH_STOP_SEC_VAR_INIT_16
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

/* Global variable to store  Controller State*/
extern volatile VAR(Eth_StateType, ETH_VAR_INIT) Eth_GenDriverState;

#define ETH_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

extern volatile VAR(Eth_ControllerStatusType, ETH_VAR_NO_INIT) Eth_GaaCtrlStat[ETH_MAX_CTRLS_SUPPORTED];

#define ETH_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_8
#include "Eth_MemMap.h"

/* Ring buffer which contains free tx buffer indexes */
extern volatile VAR(uint8, ETH_VAR_NO_INIT) Eth_GaaTxBufferRing[ETH_TX_BUF_TOTAL_0];

/* Whether each Tx buffer is provided to the user.
   Set as TRUE at Eth_ProvideTxBuffer, set as FALSE at Eth_Transmit. */
extern volatile VAR(boolean, ETH_VAR_NO_INIT) Eth_GaaTxBufferProvided[ETH_TX_BUF_TOTAL_0];

#define ETH_STOP_SEC_VAR_NO_INIT_8
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_32
#include "Eth_MemMap.h"

extern volatile VAR(Eth_MacAddressType, ETH_VAR_NO_INIT)
  Eth_GaaAddressFilters[ETH_MAX_CTRLS_SUPPORTED][ETH_MAX_FILTERS];

#define ETH_STOP_SEC_VAR_NO_INIT_32
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_NO_INIT_PTR
#include "Eth_MemMap.h"

/* Global variable to store pointer to Configuration */
extern P2CONST(Eth_CtrlConfigType, ETH_CONST, ETH_CONFIG_CONST) volatile Eth_GpCtrlConfigPtr;
extern P2CONST(Eth_EthConfigType, ETH_CONST, ETH_CONFIG_CONST) volatile Eth_GpEthConfigPtr;

#define ETH_STOP_SEC_VAR_NO_INIT_PTR
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_DESC_BUFFER
#include "Eth_MemMap.h"

extern volatile VAR(Eth_ETNCTxDescriptorType, ETH_VAR_NO_INIT) Eth_GaaTxDescriptor[ETH_TX_BUF_TOTAL_0];
extern volatile VAR(Eth_ETNCRxDescriptorType, ETH_VAR_NO_INIT) Eth_GaaRxDescriptor[ETH_RX_BUF_TOTAL_0];

#define ETH_STOP_SEC_VAR_DESC_BUFFER
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_TX_BUFFER
#include "Eth_MemMap.h"

extern volatile VAR(uint8, ETH_VAR_NO_INIT) Eth_GaaTxBuffer[ETH_TX_BUF_TOTAL_0][ETH_INTERNAL_TX_BUFFER_BYTE];

#define ETH_STOP_SEC_VAR_TX_BUFFER
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_RX_BUFFER
#include "Eth_MemMap.h"

extern volatile VAR(uint8, ETH_VAR_NO_INIT)
    Eth_GaaRxBuffer[ETH_MAX_CTRLS_SUPPORTED][ETH_RX_BUF_TOTAL_0][ETH_INTERNAL_RX_BUFFER_BYTE];

#define ETH_STOP_SEC_VAR_RX_BUFFER
#include "Eth_MemMap.h"

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define ETH_START_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"

extern FUNC(void, ETH_PRIVATE_CODE) Eth_InitializeBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx);
extern FUNC(void, ETH_PRIVATE_CODE) Eth_PreprocessBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx);
extern FUNC(BufReq_ReturnType, ETH_PRIVATE_CODE)
    Eth_GetTxBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx,
                    CONSTP2VAR(Eth_BufIdxType, AUTOMATIC, ETH_APPL_DATA) BufIdxPtr,                                     /* PRQA S 3432 # JV-01 */
                    CONSTP2VAR(uint8 *, AUTOMATIC, ETH_APPL_DATA) BufPtr,                                               /* PRQA S 3432 # JV-01 */
                    CONSTP2VAR(uint16, AUTOMATIC, ETH_APPL_DATA) LenBytePtr);                                           /* PRQA S 3432 # JV-01 */
extern FUNC(void, ETH_PRIVATE_CODE)
    Eth_ReleaseTxBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBufIdx);
extern FUNC(Std_ReturnType, ETH_PRIVATE_CODE)
    Eth_CheckProvideBuffer(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBufIdx);
extern FUNC(void, ETH_PRIVATE_CODE)
    Eth_PreprocessFrame(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBufIdx,
                        CONST(uint32, AUTOMATIC) LulFrameType,
                        CONSTP2CONST(uint8, AUTOMATIC, ETH_APPL_DATA) LpPhysAddrPtr);
extern FUNC(void, ETH_PRIVATE_CODE)
    Eth_RxIndication(CONST(uint32, AUTOMATIC) LulCtrlIdx, CONST(uint32, AUTOMATIC) LulBufferIdx,
                     CONST(uint32, AUTOMATIC) LulLenByte);

#define ETH_STOP_SEC_PRIVATE_CODE
#include "Eth_MemMap.h"

#endif /* ETH_ETNC_RAM_H  */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
