/*============================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                         */
/* Module       = EthIf_Cbk.c                                                 */
/* SW-VERSION   = 1.6.0                                                       */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) 2017-2021 Renesas Electronics Corporation. All rights reserved.        */
/*============================================================================*/
/* Purpose:                                                                   */
/* This application file contains execution sequences to demonstrate the usage*/
/* of ETH Driver APIs.                                                        */
/*                                                                            */
/*============================================================================*/
/*                                                                            */
/* Unless otherwise agreed upon in writing between your company and           */
/* Renesas Electronics Corporation the following shall apply!                 */
/*                                                                            */
/* Warranty Disclaimer                                                        */
/*                                                                            */
/* There is no warranty of any kind whatsoever granted by Renesas. Any        */
/* warranty is expressly disclaimed and excluded by Renesas, either expressed */
/* or implied, including but not limited to those for non-infringement of     */
/* intellectual property, merchantability and/or fitness for the particular   */
/* purpose.                                                                   */
/*                                                                            */
/* Renesas shall not have any obligation to maintain, service or provide bug  */
/* fixes for the supplied Product(s) and/or the Application.                  */
/*                                                                            */
/* Each User is solely responsible for determining the appropriateness of     */
/* using the Product(s) and assumes all risks associated with its exercise    */
/* of rights under this Agreement, including, but not limited to the risks    */
/* and costs of program errors, compliance with applicable laws, damage to    */
/* or loss of data, programs or equipment, and unavailability or              */
/* interruption of operations.                                                */
/*                                                                            */
/* Limitation of Liability                                                    */
/*                                                                            */
/* In no event shall Renesas be liable to the User for any incidental,        */
/* consequential, indirect, or punitive damage (including but not limited     */
/* to lost profits) regardless of whether such liability is based on breach   */
/* of contract, tort, strict liability, breach of warranties, failure of      */
/* essential purpose or otherwise and even if advised of the possibility of   */
/* such damages. Renesas shall not be liable for any services or products     */
/* provided by third party vendors, developers or consultants identified or   */
/* referred to the User by Renesas in connection with the Product(s) and/or   */
/* the Application.                                                           */
/*                                                                            */
/*============================================================================*/
/* Environment:                                                               */
/*              Devices:        X2x                                           */
/*============================================================================*/

/*******************************************************************************
**                      Revision History                                      **
*******************************************************************************/
/*
 * 1.5.0: 07/10/2021    : Remove the include file for Eth.h.
 * 1.3.1: 01/04/2021    : Remove vendor ID from the file name, API names
 *                        and parameters according to BSW00347 requirement
 * 1.2.0: 19/08/2020    : Release
 *        19/08/2020    : Added missing argument in EthIf_TxConfirmation().
 * 1.1.0: 19/06/2020    : Release
 * 1.0.2: 16/03/2020    : Updated Eth 2 channel.
 * 1.0.1: 17/05/2018    : Fix ARDAABO-712: LenByte of EthIf_RxIndication
 *                        should contain the payload length.
 * 1.0.0: 23/03/2017    : Initial Version.
 */
/******************************************************************************/

/*******************************************************************************
**                      Include Section                                       **
*******************************************************************************/

#include "EthIf_Cbk.h"
#include <stdio.h>
#include <string.h>
/*******************************************************************************
**                      Version Check                                         **
*******************************************************************************/
/* AUTOSAR release version information */
#define ETHIF_C_AR_RELEASE_MAJOR_VERSION   ETH_AR_RELEASE_MAJOR_VERSION_VALUE
#define ETHIF_C_AR_RELEASE_MINOR_VERSION   ETH_AR_RELEASE_MINOR_VERSION_VALUE
#define ETHIF_C_AR_RELEASE_REVISION_VERSION \
                                        ETH_AR_RELEASE_REVISION_VERSION_VALUE

/* File version information */
#define ETHIF_SW_MAJOR_VERSION    ETH_SW_MAJOR_VERSION
#define ETHIF_SW_MINOR_VERSION    ETH_SW_MINOR_VERSION

/*******************************************************************************
**                         Global Data                                        **
*******************************************************************************/

/*******************************************************************************
**                      Function Definitions                                  **
*******************************************************************************/

/*******************************************************************************
**                             EthIf_RxIndication                             **
*******************************************************************************/

void EthIf_RxIndication(uint8 CtrlIdx,
                        Eth_FrameType FrameType,
                        boolean IsBroadcast,
                        const uint8* PhysAddrPtr,
                        const Eth_DataType* DataPtr,
                        uint16 LenByte)
{

  #if (ETH_GLOBAL_TIME_SUPPORT == STD_ON)
  Eth_TimeStampQualType LenEthTimeQualPtr;
  Eth_TimeStampType LstIngressTime;
  
  Eth_GetIngressTimeStamp(CtrlIdx, (Eth_DataType*)DataPtr, &LenEthTimeQualPtr, &LstIngressTime);

  if (ETH_VALID == LenEthTimeQualPtr)
  {
    EthPassedCount[EthCheckCount] = ETH_PASSED;
  }
  EthCheckCount++;
  #endif

  #ifdef ETH_DEBUG_CONSOLE_MODE
  printf("Rx: Controller Index = %d, Received LenByte = %d, FrameType = 0x%04x IsBroadcast = %d \n",
    CtrlIdx, LenByte, FrameType, IsBroadcast);
  #endif

  /* LenByte contains the payload length */
  GusMsgLength[CtrlIdx] = LenByte;

  /* memcpy Received message */
  memcpy((uint8*)GaaRxEthFrame[CtrlIdx], (uint8*)DataPtr, GusMsgLength[CtrlIdx]);
  memcpy(&GaaRxSrcAddr[CtrlIdx], PhysAddrPtr, 6);
  GusRxFrameType[CtrlIdx] = FrameType;
  /* Store entire frame size (with header) to GusRxLenByte */
  GusRxLenByte[CtrlIdx] = LenByte + 14U;
  GusRxFrameCnt[CtrlIdx]++;
}

/*******************************************************************************
**                             EthIf_TxConfirmation                           **
*******************************************************************************/
void EthIf_TxConfirmation(uint8 CtrlIdx, Eth_BufIdxType BufIdx, Std_ReturnType Result)
{
  #ifdef ETH_DEBUG_CONSOLE_MODE
  printf("Tx: Controller Index = %d, Confirmed BufIdx = %d \n", CtrlIdx, BufIdx);
  #endif

  #if (ETH_GLOBAL_TIME_SUPPORT == STD_ON)
  TxTimeQual = ETH_INVALID;
  do
  {
    Eth_GetEgressTimeStamp(CtrlIdx, BufIdx, &TxTimeQual, &TxTimeStamp[CtrlIdx]);
  } while (ETH_INVALID == TxTimeQual);
  
  if (ETH_VALID == TxTimeQual)
  {
    EthPassedCount[EthCheckCount] = ETH_PASSED;
  }
  EthCheckCount++;
  #endif

  GucTxConfirmed[CtrlIdx] = 1U;
}

/*******************************************************************************
**                             EthIf_TxConfirmation                           **
*******************************************************************************/
void EthIf_CtrlModeIndication( uint8 CtrlIdx, Eth_ModeType CtrlMode)
{
  #ifdef ETH_DEBUG_CONSOLE_MODE
  printf("Controller Index = %d, Mode changed CtrlMode = %d \n", CtrlIdx, CtrlMode);
  #endif
}

/*******************************************************************************
                          End of the file
*******************************************************************************/
