/*============================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                         */
/* Module       = Lin_GeneralTypes.h                                          */
/* SW-VERSION   = 1.5.0                                                       */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) 2017,2018,2020 Renesas Electronics Corporation. All rights reserved.   */
/*============================================================================*/
/* Purpose:                                                                   */
/* C header file for LIN Driver type definitions.                             */
/*                                                                            */
/*============================================================================*/
/*                                                                            */
/* Unless otherwise agreed upon in writing between your company and           */
/* Renesas Electronics Corporation the following shall apply!                 */
/*                                                                            */
/* Warranty Disclaimer                                                        */
/*                                                                            */
/* There is no warranty of any kind whatsoever granted by Renesas. Any        */
/* warranty is expressly disclaimed and excluded by Renesas, either expressed */
/* or implied, including but not limited to those for non-infringement of     */
/* intellectual property, merchantability and/or fitness for the particular   */
/* purpose.                                                                   */
/*                                                                            */
/* Renesas shall not have any obligation to maintain, service or provide bug  */
/* fixes for the supplied Product(s) and/or the Application.                  */
/*                                                                            */
/* Each User is solely responsible for determining the appropriateness of     */
/* using the Product(s) and assumes all risks associated with its exercise    */
/* of rights under this Agreement, including, but not limited to the risks    */
/* and costs of program errors, compliance with applicable laws, damage to    */
/* or loss of data, programs or equipment, and unavailability or              */
/* interruption of operations.                                                */
/*                                                                            */
/* Limitation of Liability                                                    */
/*                                                                            */
/* In no event shall Renesas be liable to the User for any incidental,        */
/* consequential, indirect, or punitive damage (including but not limited     */
/* to lost profits) regardless of whether such liability is based on breach   */
/* of contract, tort, strict liability, breach of warranties, failure of      */
/* essential purpose or otherwise and even if advised of the possibility of   */
/* such damages. Renesas shall not be liable for any services or products     */
/* provided by third party vendors, developers or consultants identified or   */
/* referred to the User by Renesas in connection with the Product(s) and/or   */
/* the Application.                                                           */
/*                                                                            */
/*============================================================================*/
/* Environment:                                                               */
/*              Devices:        X2x                                           */
/*============================================================================*/

/*******************************************************************************
**                      Revision Control History                              **
*******************************************************************************/
/*
 *
 * 1.2.0:  26/08/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.2:  10/07/2018  : 1. As per RfC 76408, LIN_CH_SLEEP_PENDING is removed
 *                            from Lin_StatusType.
 * 1.0.1:  30/11/2017  : 1. [ARDAABO-193]
 *                            Removed Lin_ChannelConfigType structure
 *                         2. Removed LIN_CH_UNSELFTEST
 *                         3. Changed the type from macro to enum.
 *                            SWS_Lin_00229: Lin_FrameCsModelType
 *                            SWS_Lin_00230: Lin_FrameResponseType
 *                            SWS_Lin_00233: Lin_StatusType
 *                         4. Removed including Lin_Cfg.h
 *                         5. Removed Macro definition for Version check
 * 1.0.0:  31/03/2017  : Initial Version
 *
 */
/******************************************************************************/

#ifndef LIN_GENERALTYPES_H
#define LIN_GENERALTYPES_H

/*******************************************************************************
**                     Include Section                                        **
*******************************************************************************/
/* Included for Global type declarations */
#include "Std_Types.h"

/*******************************************************************************
**                      Global Data Types                                     **
*******************************************************************************/
/*The Lin identifier Type, (0 to 0x3F) together with its two parity bits */
typedef uint8 Lin_FramePidType;

/* Checksum model for the Lin Frame  */
typedef enum ETag_Lin_FrameCsModelType
{
  LIN_ENHANCED_CS = 0x00,
  LIN_CLASSIC_CS  = 0x01
} Lin_FrameCsModelType;

/* Lin Frame data length  */
typedef uint8 Lin_FrameDlType;

/* Lin Frame Type- Tx or Rx or anonymous */
typedef enum ETag_Lin_FrameResponseType
{
  LIN_MASTER_RESPONSE = 0x00,
  LIN_SLAVE_RESPONSE  = 0x01,
  LIN_SLAVE_TO_SLAVE  = 0x02
} Lin_FrameResponseType;

/* Lin PDU Type */
typedef struct STag_Lin_PduType
{
  Lin_FramePidType      Pid;
  Lin_FrameCsModelType  Cs;
  Lin_FrameResponseType Drc;
  Lin_FrameDlType       Dl;
  uint8 *SduPtr;
} Lin_PduType;

/* Lin channel status Type */
typedef enum ETag_Lin_StatusType
{
  LIN_NOT_OK           = 0x00,
  LIN_TX_OK            = 0x01,
  LIN_TX_BUSY          = 0x02,
  LIN_TX_HEADER_ERROR  = 0x03,
  LIN_TX_ERROR         = 0x04,
  LIN_RX_OK            = 0x05,
  LIN_RX_BUSY          = 0x06,
  LIN_RX_ERROR         = 0x07,
  LIN_RX_NO_RESPONSE   = 0x08,
  LIN_OPERATIONAL      = 0x09,
  LIN_CH_SLEEP         = 0x0A
} Lin_StatusType;

/*******************************************************************************
**                      Function Prototypes                                   **
*******************************************************************************/

#endif /* LIN_GENERALTYPES_H */

/*******************************************************************************
**                          End Of File                                       **
*******************************************************************************/
