/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_PIN_LLDriver.h                                                                                  */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020, 2021 Renesas Electronics Corporation. All rights reserved.                                               */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains Low level driver function prototypes of the ICU Driver                                          */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        U2A                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.1:  15/09/2021  : Add condition (STD_ON == ICU_IRQ_EDGE_DETECT) || (STD_ON == ICU_INTP_EDGE_DETECT) 
 *                          in Function Prototypes
 * 1.3.2:  30/08/2021  : Change from #include "Icu_MemMap.h" to #include "Icu_Mapping.h".
 *                       Update header file macro.
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_PIN_LLDRIVER_H
            #define ICU_59_INST0_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_PIN_LLDRIVER_H
            #define ICU_59_INST1_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_PIN_LLDRIVER_H
            #define ICU_59_INST2_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_PIN_LLDRIVER_H
            #define ICU_59_INST3_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_PIN_LLDRIVER_H
            #define ICU_59_INST4_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_PIN_LLDRIVER_H
            #define ICU_59_INST5_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_PIN_LLDRIVER_H
            #define ICU_59_INST6_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_PIN_LLDRIVER_H
            #define ICU_59_INST7_PIN_LLDRIVER_H
            #define ICU_PIN_LLDRIVER_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_PIN_LLDRIVER_H
        #define ICU_PIN_LLDRIVER_H
        #define ICU_PIN_LLDRIVER_HEADER
    #endif
#endif

#ifdef ICU_PIN_LLDRIVER_HEADER
#undef ICU_PIN_LLDRIVER_HEADER                                                                                          /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for Icu.h inclusion and macro definitions */
#include "Icu_PBTypes.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ICU_PIN_LLDRIVER_AR_RELEASE_MAJOR_VERSION     ICU_AR_RELEASE_MAJOR_VERSION
#define ICU_PIN_LLDRIVER_AR_RELEASE_MINOR_VERSION     ICU_AR_RELEASE_MINOR_VERSION
#define ICU_PIN_LLDRIVER_AR_RELEASE_REVISION_VERSION  ICU_AR_RELEASE_REVISION_VERSION
                                                                                         
/* Module Software version information */
#define ICU_PIN_LLDRIVER_SW_MAJOR_VERSION  ICU_SW_MAJOR_VERSION
#define ICU_PIN_LLDRIVER_SW_MINOR_VERSION  ICU_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define ICU_START_SEC_PRIVATE_CODE
#include "Icu_Mapping.h"

#if ((STD_ON == ICU_IRQ_EDGE_DETECT) || (STD_ON == ICU_INTP_EDGE_DETECT))
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Pin_ChannelInit(const Icu_ChannelType LucChannelIndex);

extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Pin_SetActivation
                                             (const Icu_ChannelType LddChannel, const Icu_ActivationType LenActiveEdge);

#if (ICU_DE_INIT_API == STD_ON)
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Pin_ChannelDeInit(const Icu_ChannelType LucChannelIndex);
#endif

#if (ICU_SET_MODE_API == STD_ON)
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Pin_SetMode
                                                    (const Icu_ChannelType LucChannelIndex, const Icu_ModeType LenMode);
#endif

#if (ICU_EDGE_DETECT_API == STD_ON)
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Pin_EnableEdgeDetection(const Icu_ChannelType LddChannel);

extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Pin_DisableEdgeDetection(const Icu_ChannelType LddChannel);
#endif
#endif /* End of ((STD_ON == ICU_IRQ_EDGE_DETECT) || (STD_ON == ICU_INTP_EDGE_DETECT)) */

#define ICU_STOP_SEC_PRIVATE_CODE
#include "Icu_Mapping.h"

#define ICU_START_SEC_CODE_FAST
#include "Icu_Mapping.h"

#if ((STD_ON == ICU_IRQ_EDGE_DETECT) || (STD_ON == ICU_INTP_EDGE_DETECT))
#if (ICU_EDGE_DETECT_API == STD_ON)
extern FUNC(void, ICU_CODE_FAST) Icu_HW_Pin_ExternalInterruptIsr(const Icu_ChannelType LddChannel);
#endif
#endif /* End of ((STD_ON == ICU_IRQ_EDGE_DETECT) || (STD_ON == ICU_INTP_EDGE_DETECT)) */

#define ICU_STOP_SEC_CODE_FAST
#include "Icu_Mapping.h"

#endif /* ICU_PIN_LLDRIVER_HEADER  */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
