/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_Ram.h                                                                                           */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains Global variable declarations of ICU Driver                                                      */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.4:  25/06/2022  : Change memory mapping of Icu_GaaHwDepFunc[]
 * 1.4.3:  17/04/2022  : Merge QAC message from U2Ax, E2x and U2Bx
 * 1.4.1:  18/10/2021  : Add QAC message 9.5.0
 *         15/09/2021  : Update Include Section.
 *                       Rename GpTimerChannelConfig to GpChannelUserRegConfig
 *                       Define Icu_GpChannelRamData, Icu_GpSignalMeasurementData 
 * 1.3.2:  30/08/2021  : Change from #include "Icu_MemMap.h" to #include "Icu_Mapping.h".
 *                       Update header file macro.
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_RAM_H
            #define ICU_59_INST0_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_RAM_H
            #define ICU_59_INST1_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_RAM_H
            #define ICU_59_INST2_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_RAM_H
            #define ICU_59_INST3_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_RAM_H
            #define ICU_59_INST4_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_RAM_H
            #define ICU_59_INST5_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_RAM_H
            #define ICU_59_INST6_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_RAM_H
            #define ICU_59_INST7_RAM_H
            #define ICU_RAM_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_RAM_H
        #define ICU_RAM_H
        #define ICU_RAM_HEADER
    #endif
#endif

#ifdef ICU_RAM_HEADER
#undef ICU_RAM_HEADER                                                                                                   /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Include type definition */
#include "Icu_PBTypes.h"
#if (ICU_TAU_UNIT_USED == STD_ON)
#include "Icu_TAU_Ram.h"
#endif
#if (ICU_ATU_TIMER_UNIT_USED == STD_ON)
#include "Icu_ATU_Ram.h"
#endif
#if ((ICU_IRQ_EDGE_DETECT == STD_ON) || (ICU_INTP_EDGE_DETECT == STD_ON))
#include "Icu_PIN_Ram.h"
#endif
/* Include the Timer configuration file */
/* Included for declaration of the Low Level Driver function */
/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ICU_RAM_AR_RELEASE_MAJOR_VERSION    ICU_AR_RELEASE_MAJOR_VERSION
#define ICU_RAM_AR_RELEASE_MINOR_VERSION    ICU_AR_RELEASE_MINOR_VERSION
#define ICU_RAM_AR_RELEASE_REVISION_VERSION ICU_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ICU_RAM_SW_MAJOR_VERSION            ICU_SW_MAJOR_VERSION
#define ICU_RAM_SW_MINOR_VERSION            ICU_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

#define ICU_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Icu_Mapping.h"

/* Holds the status of ICU Driver Component */
extern VAR(Icu_ModeType, ICU_VAR_NO_INIT) Icu_GenModuleMode;

#define ICU_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Icu_Mapping.h"

#define ICU_START_SEC_VAR_NO_INIT_PTR
#include "Icu_Mapping.h"

/* Global pointer variable for channel configuration */
extern P2CONST(Icu_ChannelConfigType, ICU_VAR_NO_INIT, ICU_CONFIG_DATA) volatile Icu_GpChannelConfig;
/* Global pointer variable for channel user register configuration */
extern P2CONST(Icu_ChannelUserRegConfigType, ICU_VAR_NO_INIT, ICU_CONFIG_DATA) volatile Icu_GpChannelUserRegConfig;

/* Global pointer to the address of Channel RAM data */
extern P2VAR(Icu_ChannelRamDataType, ICU_VAR_NO_INIT, ICU_CONFIG_DATA) volatile Icu_GpChannelRamData;                   /* PRQA S 3432 # JV-01 */

/* Global pointer to the address of Edge Count RAM data */
extern P2VAR(Icu_EdgeCountModeRamDatatype, ICU_VAR_NO_INIT, ICU_CONFIG_DATA) volatile Icu_GpEdgeCountData;              /* PRQA S 3432 # JV-01 */

/* Global pointer variable for Timestamp channel RAM data */
extern P2VAR(Icu_TimeStampChannelRamDataType, ICU_VAR_NO_INIT, ICU_CONFIG_DATA) volatile Icu_GpTimeStampData;           /* PRQA S 3432 # JV-01 */

/* Global pointer to the address of Signal Measure RAM data */
extern volatile P2VAR(Icu_SignalMeasurementModeRamDataType, ICU_VAR_NO_INIT, ICU_CONFIG_DATA)                           /* PRQA S 3432 # JV-01 */
                                                                                           Icu_GpSignalMeasurementData;

#define ICU_STOP_SEC_VAR_NO_INIT_PTR
#include "Icu_Mapping.h"

#define ICU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_Mapping.h"
/* Declaration for HWIP Functions */
extern P2CONST(Icu_HwFuncTableType, ICU_VAR_INIT, ICU_CONFIG_DATA) Icu_GaaHwDepFunc[6];

#define ICU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_Mapping.h"

#define ICU_START_SEC_VAR_NO_INIT_32
#include "Icu_Mapping.h"
#if (ICU_REPORT_WAKEUP_SOURCE == STD_ON)
/* Holds the wake up source information */
extern VAR(uint32, ICU_VAR_NO_INIT) Icu_GulWakeupSource;
#endif

#define ICU_STOP_SEC_VAR_NO_INIT_32
#include "Icu_Mapping.h"

/* Functionality related to R4.0 */
#define ICU_START_SEC_VAR_INIT_BOOLEAN
#include "Icu_Mapping.h"

#if (ICU_DEV_ERROR_DETECT == STD_ON)
/* Holds the status of Initialization */
extern VAR(volatile boolean, ICU_VAR_INIT) Icu_GblDriverStatus;
#endif /* End of #if (ICU_DEV_ERROR_DETECT == STD_ON) */

/* Functionality related to R4.0 */
#define ICU_STOP_SEC_VAR_INIT_BOOLEAN
#include "Icu_Mapping.h"

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#endif /* ICU_RAM_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
