/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_Cfg.h                                                                                           */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains pre-compile time parameters.                                                                    */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  EthU2x.dll version: 1.4.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Eth_Eth_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_ETH_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Eth.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Os\xml\Os_Eth.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  27 Apr 2025 - 14:14:08
 */


#ifndef ETH_CFG_H
#define ETH_CFG_H


/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/* Message (7:0791)    : Macro identifier does not differ from other macro identifier(s) (e.g. '%s') within the       */
/*                       specified number of significant characters.                                                  */
/* Rule                : CERTCCM DCL23, MISRA C:2012 Rule-5.4                                                         */
/* JV-01 Justification : This macro identifier is following AUTOSAR standard rule (Symbolic Name or Published         */
/*                       Macro's name), so this is accepted.                                                          */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3684)    : Array declared with unknown size.                                                            */
/* Rule                : CERTCCM ARR02, MISRA C:2012 Rule-8.11                                                        */
/* JV-01 Justification : Arrays used are verified in the file which are only declarations and size is configuration   */
/*                       dependent.                                                                                   */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
#define ETH_AR_VERSION                                                          ETH_AR_431_VERSION
/* AUTOSAR release version information */
#define ETH_CFG_AR_RELEASE_MAJOR_VERSION                                        4U
#define ETH_CFG_AR_RELEASE_MINOR_VERSION                                        3U
#define ETH_CFG_AR_RELEASE_REVISION_VERSION                                     1U
/* File version information */
#define ETH_CFG_SW_MAJOR_VERSION                                                1U
#define ETH_CFG_SW_MINOR_VERSION                                                6U

/***********************************************************************************************************************
**                      Common Published Information                                                                  **
***********************************************************************************************************************/
#define ETH_AR_RELEASE_MAJOR_VERSION_VALUE                                      4U
#define ETH_AR_RELEASE_MINOR_VERSION_VALUE                                      3U
#define ETH_AR_RELEASE_REVISION_VERSION_VALUE                                   1U
#define ETH_SW_MAJOR_VERSION_VALUE                                              1U
#define ETH_SW_MINOR_VERSION_VALUE                                              6U
#define ETH_SW_PATCH_VERSION_VALUE                                              0U
#define ETH_VENDOR_ID_VALUE                                                     59U
#define ETH_MODULE_ID_VALUE                                                     88U

/***********************************************************************************************************************
**                      Global Symbols                                                                                **
***********************************************************************************************************************/


/* Pre-compile option for Control Enable for Address Filtering */
#define ETH_UPDATE_PHYS_ADDR_FILTER                                             STD_ON
/* Pre-compile option for Version Info API */
#define ETH_VERSION_INFO_API                                                    STD_ON

#define ETH_AVB0_DATA_ISR                                                       STD_OFF
#define ETH_AVB0_ERR_ISR                                                        STD_ON
#define ETH_AVB0_MNG_ISR                                                        STD_ON
#define ETH_AVB0_MAC_ISR                                                        STD_ON
#define ETH_AVB1_DATA_ISR                                                       STD_OFF
#define ETH_AVB1_ERR_ISR                                                        STD_ON
#define ETH_AVB1_MNG_ISR                                                        STD_ON
#define ETH_AVB1_MAC_ISR                                                        STD_ON
#define ETH_AVB1_STA_ISR                                                        STD_ON
/* Pre-compile for Separation Filtering */
#define ETH_STREAM_FILTERING                                                    STD_ON
#define ETH_GET_COUNTER_VALUES_API                                              STD_ON
#define ETH_GET_TX_ERROR_COUNTER_VALUES_API                                     STD_ON
/* Pre-compile option for EthGetDropCountApi API */
#define ETH_GET_DROP_COUNT_API                                                  STD_OFF
/* Pre-compile option for EthGetEtherStatsApi API */
#define ETH_GET_ETHER_STATS_API                                                 STD_OFF
#define ETH_GET_RX_STATS_API                                                    STD_ON
#define ETH_GET_TX_STATS_API                                                    STD_ON
#define ETH_DEINIT_API                                                          STD_OFF

/* Pre-compile option for Development Error Detect */
#define ETH_DEV_ERROR_DETECT                                                    STD_OFF
/* Pre-compile option for enable or disable the critical section protection */
#define ETH_CRITICAL_SECTION_PROTECTION                                         STD_ON
/* Pre-compile option for enable or disable version check of inter-module dependencies */
#define ETH_VERSION_CHECK_EXT_MODULES                                           STD_ON
/* Enable/Disable Interrupt Consistency */
#define ETH_INTERRUPT_CONSISTENCY_CHECK                                         STD_OFF
/* Whether Eth uses Category 1 or Category 2 */
#define ETH_ISR_CATEGORY_2                                                      STD_OFF
/* Pre-compile option for MII Control Enable */
#define ETH_CTRL_ENABLE_MII                                                     STD_ON
/* Pre-compile option for Control Enable for receive Interrupt */
#define ETH_CTRL_ENABLE_RX_INTERRUPT                                            STD_OFF
/* Pre-compile option for Control Enable for transmit Interrupt */
#define ETH_CTRL_ENABLE_TX_INTERRUPT                                            STD_OFF
#define ETH_CTRL_ENABLE_RX_POLLING                                              STD_ON
#define ETH_CTRL_ENABLE_TX_POLLING                                              STD_ON

/* Pre-compile option for GlobalTime APIs */
#define ETH_GLOBAL_TIME_SUPPORT                                                 STD_ON
/* PreCompile Option to enable / disable the Priority in Transmission */
#define ETH_QOS_SUPPORT                                                         STD_ON
#define ETH_ETHSWITCH_MANAGEMENT_SUPPORT                                        STD_OFF
/* Enable / disable the checking whether registers are not stuck in Eth_Init */
#define ETH_REGISTER_CHECK_INITTIME                                             STD_OFF
/* Enable / disable the checking whether registers are not corrupted in Eth_MainFunction */
#define ETH_REGISTER_CHECK_RUNTIME                                              STD_OFF
/* Enable / disable bypass mode */
#define ETH_BYPASS_MODE                                                         STD_OFF
/* Using macro */
#define ETH_USING_MACRO                                                         ETH_MACRO_ETNB

/* Instance ID of the ETH Driver */
#define ETH_INSTANCE_ID_VALUE                                                   0U
/* Maximum Ethernet Controllers Supported */
#define ETH_MAX_CTRLS_SUPPORTED                                                 (uint8)0x02U
/* Total number of Ethernet controller config available */
#define ETH_TOTAL_CTRL_CONFIG                                                   (uint8)0x02U
/* Maximum Ethernet Timeout Count */
#define ETH_TIMEOUT_COUNT                                                       (uint32)63158
/* Ethernet EthRxBufTotal */
#define ETH_RX_BUF_TOTAL                                                        (uint16)0x0008U
/* The used Controller Index in Configset */
#define ETH_CTRLIDX_CONFIGSET_0                                                 (uint8)0x00U
#define ETH_CTRLIDX_CONFIGSET_1                                                 (uint8)0x01U

/* Peripheral clock value for the ETH Macro in Hz */
#define ETH_PERI_CLOCK_HZ                                                       (uint32)100000000UL
#define ETH_TX_DESC_MAX                                                         32UL
/* Ethernet RxBufLenByte */
#define ETH_CTRL_RX_BUF_LEN_BYTE_0                                              (uint16)0x0000U
#define ETH_CTRL_RX_BUF_LEN_BYTE_1                                              (uint16)0x0000U
/* Ethernet TxBufLenByte */
#define ETH_CTRL_TX_BUF_LEN_BYTE_0                                              (uint16)0x0000U
#define ETH_CTRL_TX_BUF_LEN_BYTE_1                                              (uint16)0x0000U
/* Ethernet TxBufTotal */
#define ETH_TX_BUF_TOTAL_0                                                      (uint16)0x0000U
#define ETH_TX_BUF_TOTAL_1                                                      (uint16)0x0000U
/* Ethernet EthRxBufTotal */
#define ETH_RX_BUF_TOTAL_0                                                      (uint16)0x0000U
#define ETH_RX_BUF_TOTAL_1                                                      (uint16)0x0000U

#define ETHAVB0                                                                 ETH_CTRLIDX_CONFIGSET_0
#define ETH_TX_QUEUE_CONFIG_0                                                   0x0000001EUL
#define ETH_RX_QUEUE_CONFIG_0                                                   0x0000000FUL
#define ETHAVB1                                                                 ETH_CTRLIDX_CONFIGSET_1
#define ETH_TX_QUEUE_CONFIG_1                                                   0x0000001EUL
#define ETH_RX_QUEUE_CONFIG_1                                                   0x0000000FUL

#define ETH_OS_COUNTER_ID                                                       OsCounter
#define ETH_OS_COUNTER_MAX_VALUE                                                1000U

/* Ethernet Configuration Set Handles */
#define Eth_Config                                                              (&Eth_GaaConfiguration[0])
#define EthConf_EthCtrlConfig_EthCtrlConfig                                     (uint8)0U
#define EthConf_EthCtrlConfig_EthCtrlConfig_001                                 (uint8)1U                               /* PRQA S 0791 # JV-01 */

/* Do not move the location of this include file */
#include "Eth_ETNB_LLDriver.h"

#define ETH_START_SEC_VAR_INIT_PTR
#include "Eth_MemMap.h"

extern P2VAR(uint8, AUTOMATIC, ETH_VAR_INIT_PTR) Eth_GaaMemPoolBufferTable[];                                           /* PRQA S 3432, 3684 # JV-01, JV-01 */
#define ETH_STOP_SEC_VAR_INIT_PTR
#include "Eth_MemMap.h"

#define ETH_START_SEC_VAR_INIT_16
#include "Eth_MemMap.h"

extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventAccess[];                                                               /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventRxFramesLost[];                                                         /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventCRC[];                                                                  /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventUnderSizeFrame[];                                                       /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventOverSizeFrame[];                                                        /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventAlignment[];                                                            /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventSinglecollision[];                                                      /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventMultiplecollision[];                                                    /* PRQA S 3684 # JV-01 */
extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventLatecollision[];                                                        /* PRQA S 3684 # JV-01 */
#if (ETH_GLOBAL_TIME_SUPPORT == STD_ON)

extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventTimerincFailed[];                                                       /* PRQA S 3684 # JV-01 */
#endif

#if (ETH_GLOBAL_TIME_SUPPORT == STD_ON)

extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventTimeroffsetFailed[];                                                    /* PRQA S 3684 # JV-01 */
#endif

#if (ETH_INTERRUPT_CONSISTENCY_CHECK == STD_ON)

extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventIntInconsistent[];                                                      /* PRQA S 3684 # JV-01 */
#endif

#if ((ETH_REGISTER_CHECK_INITTIME == STD_ON) || (ETH_REGISTER_CHECK_RUNTIME == STD_ON))

extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventRegisterCorruption[];                                                   /* PRQA S 3684 # JV-01 */
#endif

extern VAR(uint16, ETH_VAR_INIT) Eth_GaaDemEventDmaError[];                                                             /* PRQA S 3684 # JV-01 */
#define ETH_STOP_SEC_VAR_INIT_16
#include "Eth_MemMap.h"

#define ETH_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Eth_MemMap.h"

extern CONST(uint32, ETH_CONFIG_DATA) Eth_GaaRamSize[];                                                                 /* PRQA S 3684 # JV-01 */
#define ETH_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Eth_MemMap.h"

#define ETH_START_SEC_CONST_32
#include "Eth_MemMap.h"

extern CONSTP2VAR(volatile Eth_ETNBRegType, ETH_CONST, REGSPACE) Eth_GaaETNBRegs[];                                     /* PRQA S 3684 # JV-01 */
extern CONSTP2VAR(volatile Eth_ETNBEICRegType, ETH_CONST, REGSPACE) Eth_GaaETNBEICRegs[];                               /* PRQA S 3684 # JV-01 */
#define ETH_STOP_SEC_CONST_32
#include "Eth_MemMap.h"


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Function Prototypes                                                                           **
***********************************************************************************************************************/



#endif /* ETH_CFG_H */


/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

