/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_ATU_LLDriver.h                                                                                  */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* API function implementations of PWM Driver                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.4.1: 20/11/2021 : Add condition macro PWM_ATU_UNIT_USED to support U2Bx                                          **
 * 1.3.2: 04/08/2021 : Updated argument of Pwm_HW_ATU_InitUnit for Device specific implementation moved               **
 *                     from Pwm common file.                                                                          **
 *                     Format source code unified within module.                                                      **
 * 1.3.1: 02/07/2021 : Add QAC message 9.5.0                                                                          **
 *                     Format source code to 120 characters                                                           **
 *                     Improve Violation tag (remove START/END)                                                       **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/
#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_ATU_LLDRIVER_H
            #define PWM_59_INST0_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_ATU_LLDRIVER_H
            #define PWM_59_INST1_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_ATU_LLDRIVER_H
            #define PWM_59_INST2_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_ATU_LLDRIVER_H
            #define PWM_59_INST3_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_ATU_LLDRIVER_H
            #define PWM_59_INST4_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_ATU_LLDRIVER_H
            #define PWM_59_INST5_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_ATU_LLDRIVER_H
            #define PWM_59_INST6_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_ATU_LLDRIVER_H
            #define PWM_59_INST7_ATU_LLDRIVER_H
            #define PWM_ATU_LLDRIVER_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_ATU_LLDRIVER_H
        #define PWM_ATU_LLDRIVER_H
        #define PWM_ATU_LLDRIVER_HEADER
    #endif
#endif


#ifdef PWM_ATU_LLDRIVER_HEADER
#undef PWM_ATU_LLDRIVER_HEADER                                                                                          /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/

/* AUTOSAR release version information */
#define PWM_ATU_LLDRIVER_AR_RELEASE_MAJOR_VERSION    PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_ATU_LLDRIVER_AR_RELEASE_MINOR_VERSION    PWM_AR_RELEASE_MINOR_VERSION
#define PWM_ATU_LLDRIVER_AR_RELEASE_REVISION_VERSION PWM_AR_RELEASE_REVISION_VERSION

/*  Module software version information */
#define PWM_ATU_LLDRIVER_SW_MAJOR_VERSION            PWM_SW_MAJOR_VERSION
#define PWM_ATU_LLDRIVER_SW_MINOR_VERSION            PWM_SW_MINOR_VERSION
#define PWM_ATU_LLDRIVER_SW_PATCH_VERSION            PWM_SW_PATCH_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#if (PWM_ATU_UNIT_USED == STD_ON)
#define PWM_START_SEC_PRIVATE_CODE
#include "Pwm_Mapping.h"

extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_ATU_InitUnit(
  P2CONST (Pwm_ConfigType, AUTOMATIC, PWM_CONFIG_DATA) LddConfigPtr);
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_ATU_InitChannel(void);
#if (PWM_DE_INIT_API == STD_ON)
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_DeInitUnit(void);
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_DeInitChannel(void);
#endif
#if (PWM_SET_OUTPUT_TO_IDLE_API == STD_ON)
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_SetOutputToIdle(Pwm_ChannelType LddChannelId);
#endif
#if (PWM_SET_DUTY_CYCLE_API == STD_ON)
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_SetDutyCycle(Pwm_ChannelType LddChannelId, uint16 LusDutyCycle);
#endif
#if (PWM_SET_PERIOD_AND_DUTY_API == STD_ON)
extern FUNC(void, PWM_PRIVATE_CODE)
  Pwm_HW_SetPeriodAndDuty(Pwm_ChannelType LddChannelId, Pwm_PeriodType LddSetPeriod, uint16 LusSetDutyCycle);
#endif
#if (PWM_NOTIFICATION_SUPPORTED == STD_ON)
extern FUNC(void, PWM_PRIVATE_CODE)
  Pwm_HW_EnableNotification(Pwm_ChannelType LddChannelId, Pwm_EdgeNotificationType LenNotification);
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_DisableNotification(Pwm_ChannelType LddChannelId);
#endif
extern FUNC(void, PWM_CODE_FAST) Pwm_HW_Callback(Pwm_ChannelType LddChannelId);
#if (PWM_SELECT_CHANNEL_CLK_API == STD_ON)
extern FUNC(void, PWM_PRIVATE_CODE)
  Pwm_HW_SelectChannelClk(Pwm_ChannelType LddChannelId, Pwm_ClockSourceType LenClockSource);
#endif
#if (PWM_SYNC_START_SUPPORT == STD_ON)
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_SynchronousInit(void);
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_SynchronousStart(void);
extern FUNC(void, PWM_PRIVATE_CODE) Pwm_HW_SynchronousStop(void);
#endif

#define PWM_STOP_SEC_PRIVATE_CODE
#include "Pwm_Mapping.h"
#endif /*#if (PWM_ATU_UNIT_USED == STD_ON)*/

#endif /* PWM_LLDRIVER_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
