#ifndef CAN_CH0_TX_MATRIX_H__
#define CAN_CH0_TX_MATRIX_H__

#include "CAN_Message_Types.h"
/*****************************************************************************************************************************************************************************
ID  :  0x317
报文： ID_CMB_CFG_VOY
信号： |- STOP_VOY
       |- SERVICE_VOY
       |- MINC_VOY
       |- ABPI_VOY
       |- T_HUIL_VOY
       |- T_EAU_VOY
       |- GENE_DEF_VOY
       |- PORT_OUV_VOY
       |- REF_DEF_VOY
       |- SOUG_VOY
       |- NIVL_VOY
       |- PIED_FREIN_VOY
       |- FSE_SER_DEF_VOY
       |- FSE_SYST_DEF_VOY
       |- PLUS_START_VOY
       |- ASR_DEF_VOY
       |- ABS_DEF_VOY
       |- CBAT_DEF_VOY
       |- SEC_PASS_DEF_VOY
       --
*****************************************************************************************************************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {
    uint32_t  STOP_VOY               :  8;     //Bit      00 : STOP_VOY
    // uint32_t  SERVICE_VOY            :  1;     //Bit      01 : SERVICE_VOY
    // uint32_t                         :  2;
    // uint32_t  MINC_VOY               :  1;     //Bit      04 : MINC_VOY
    // uint32_t                         :  2;
    // uint32_t  ABPI_VOY               :  1;     //Bit      00 : ABPI_VOY

    // uint32_t                         :  3;
    uint32_t  T_HUIL_VOY             :  32;     // T_HUIL_VOY
    // uint32_t  T_EAU_VOY              :  1;     // T_EAU_VOY
    // uint32_t  GENE_DEF_VOY           :  1;     // GENE_DEF_VOY
    // uint32_t                         :  1;
    // uint32_t  PORT_OUV_VOY           :  1;     //PORT_OUV_VOY

    // uint32_t                         :  1;
    // uint32_t  REF_DEF_VOY            :  1;     //Bi   // REF_DEF_VOY
    // uint32_t                         :  3;
    // uint32_t  SOUG_VOY               :  1;     //Bit      05 : SOUG_VOY
    // uint32_t  FSE_INHIB_VOY          :  1;
    // uint32_t  NIVL_VOY               :  1;     //Bit   NIVL_VOY

    // uint32_t  PIED_FREIN_VOY         :  1;     //Bit      24 : PIED_FREIN_VOY
    // uint32_t  FSE_SER_DEF_VOY        :  1;     //Bit      05 : FSE_SER_DEF_VOY
    // uint32_t  FSE_SYST_DEF_VOY       :  1;     //Bit      05 : FSE_SYST_DEF_VOY
    // uint32_t  PLUS_START_VOY         :  1;     //Bit      05 : PLUS_START_VOY
    // uint32_t                         :  2;
    // uint32_t  ASR_DEF_VOY            :  1;     //Bit      05 : ASR_DEF_VOY
    // uint32_t  ABS_DEF_VOY            :  1;     //Bit      05 : ABS_DEF_VOY

    // uint32_t                         :  4;
    // uint32_t  CBAT_DEF_VOY           :  1;     //Bit      13 : GENE_DEF_VOY
    // uint32_t                         :  2;
    // uint32_t  SEC_PASS_DEF_VOY       :  1;     //Bit      06 : SEC_PASS_DEF_VOY

    uint32_t                         :  8;
    uint32_t                         :  8;
    uint32_t                         :  8;
  } Sig;
} CANMsg317Union;


/*****************************************************************************************************************************************************************************
ID  :  0x217
报文： ID_ETAT_COMBINE
信号： |-  IHM_INHIB
       |-  RAZM
       |-  NIV_LUM
       |-  UNIT_DIST_CMB
       |-  RAZ_ODO_PARTIEL
       |-  SIGNAL_DEF_AIRBAG
       |-  ENT_PUSH_ODO_FILTRE
       |-  DMD_CHECK_MAT
       |-  ENT_PUSH_ESP
       |-  ENT_PUSH_AAS
       |-  DMD_CHGMT_ETAT_SCP
       |-  DMD_RAZM_MATT
       |-  ENT_PUSH_DSGI
       |-  VITESSE_AFF_CMB
       |-  DEFAUT_AFFICHEUR
       |-  ENT_PUSH_DYN
       --
*****************************************************************************************************************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {
     
    uint8_t  IHM_INHIB              :  2;     //Bit 00 - 01 : IHM_INHIB
    uint8_t  RAZM                   :  1;     //Bit      02 : RAZM
    uint8_t                         :  1;
    uint8_t  NIV_LUM                :  4;     //Bit 04 - 07 : NIV_LUM

    uint8_t  UNIT_DIST_CMB          :  1;     //Bit      08 : UNIT_DIST_CMB
    uint8_t  RAZ_ODO_PARTIEL        :  1;     //Bit      09 : RAZ_ODO_PARTIEL
    uint8_t                         :  4;
    uint8_t  SIGNAL_DEF_AIRBAG      :  2;     //Bit 14 - 15 : SIGNAL_DEF_AIRBAG

    uint8_t                         :  2;
    uint8_t  ENT_PUSH_ODO_FILTRE    :  1;     //Bit      10 : ENT_PUSH_ODO_FILTRE
    uint8_t  DMD_CHECK_MAT          :  1;     //Bit      22 : DMD_CHECK_MAT
    uint8_t                         :  2;
    uint8_t  ENT_PUSH_ESP           :  1;     //Bit      22 : ENT_PUSH_ESP
    uint8_t  ENT_PUSH_AAS           :  1;     //Bit      23 : ENT_PUSH_AAS

    uint8_t                         :  8;

    uint8_t  DMD_CHGMT_ETAT_SCP     :  1;     //Bit      25 : DMD_CHGMT_ETAT_SCP
    uint8_t                         :  3;
    uint8_t  DMD_RAZM_MATT          :  1;     //Bit      28 : DMD_RAZM_MATT
    uint8_t                         :  2;
    uint8_t  ENT_PUSH_DSGI          :  1;     //Bit      29 : ENT_PUSH_DSGI

    uint8_t  VITESSE_AFF_CMB        :  8;     //Bit 40 - 47 : VITESSE_AFF_CMB

    uint8_t                         :  4;
    uint8_t  DEFAUT_AFFICHEUR       :  1;     //Bit      52 : DEFAUT_AFFICHEUR
    uint8_t  ENT_PUSH_DYN           :  1;     //Bit      52 : ENT_PUSH_DYN
    uint8_t                         :  2;

    uint8_t                         :  8;
  } Sig;
} CANMsg217Union;

/*****************************************************************************************************************************************************************************
ID  :  0x257
报文： ID_KM_SAUV_CMB
信号： |- KM_SAUV
       -- SECURE
*****************************************************************************************************************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {      
    uint32_t KM_SAUV_H      : 8;     //Bit 00 - 23 : KM_SAUV
    uint32_t KM_SAUV_M      : 8;     //Bit 24 - 47 : SECURE
    uint32_t KM_SAUV_L      : 8;     //Bit 24 - 47 : SECURE    
    uint32_t SECURE_H       : 8;     //Bit 24 - 47 : SECURE  
    uint32_t SECURE_M       : 8;     //Bit 24 - 47 : SECURE  
    uint32_t SECURE_L       : 8;     //Bit 24 - 47 : SECURE  
    uint32_t                : 8;
    uint32_t                : 8;
  } Sig;
} CANMsg257Union;
/*****************************************************************************************************************************************************************************
ID  :  0x43C
报文： ID_REVEIL_MDS
信号： |- CAUSE_1
       -- 8.21
*****************************************************************************************************************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {      
    uint32_t              : 8;

    uint32_t              : 4; 
    uint32_t              : 2; 
    uint32_t              : 1; 
    uint32_t   CAUSE_1    : 1; //Bit 15:CAUSE_1 

    uint32_t              : 8;
    uint32_t              : 8;
    uint32_t              : 8;
    uint32_t              : 8;
    uint32_t              : 8;
    uint32_t              : 8;
  } Sig;
} CANMsg43CUnion;

/*****************************************************************************************************************************************************************************
ID  :  0x254
报文： ID_REMOTE_ACTION_REQ
信号： |- REMOTE_LOCK_UNLOCK_REQ
       |- REMOTE_HORN_REQUEST
       |- REMOTE_TURN_LIGHTS_REQ
       -- 8.21
*****************************************************************************************************************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {      
    uint32_t                                 : 8;
    uint32_t                                 : 8;
    uint32_t                                 : 8;     
    uint32_t                                 : 8;       
    uint32_t                                 : 8;      
    uint32_t                                 : 8;      
    uint32_t                                 : 8;

    uint32_t  REMOTE_LOCK_UNLOCK_REQ         : 3;   //:Bit 56 - 58 : REMOTE_LOCK_UNLOCK_REQ
    uint32_t  REMOTE_HORN_REQUEST            : 2;   //:Bit 59 - 60 : REMOTE_HORN_REQUEST
    uint32_t  REMOTE_TURN_LIGHTS_REQ         : 2;   //Bit 61 - 62 : REMOTE_TURN_LIGHTS_REQ
    uint32_t                                 : 1;
  } Sig;
} CANMsg254Union;

/*****************************************************************************************************************************************************************************
ID  :  0x31C
报文： ID_ETAT_MATT
信号： |- 
       -- 
*****************************************************************************************************************************************************************************/
typedef union
{
  uint8_t Msg[8];
  struct
  {
    uint32_t     DEFAUT_AFFICHEUR        : 1;     //: DEFAUT_AFFICHEUR
    uint32_t     DMD_PHASE_DEM           : 1;     //: DMD_PHASE_DEM
    uint32_t     DMD_RAZ_TRAJET2_MATT    : 1;     //: DMD_RAZ_TRAJET2_MATT
    uint32_t     DMD_RAZ_TRAJET1_MATT    : 1;     //: DMD_RAZ_TRAJET1_MATT
    uint32_t     RAZM_MATT               : 1;     //: RAZM_MATT
    uint32_t     RAZ_ODO_PARTIEL_MATT    : 1;     //: RAZ_ODO_PARTIEL_MATT
    uint32_t     STOP_CHECK_MATT         : 1;     //: STOP_CHECK_MATT
    uint32_t     CHECK_MATT              : 1;     //: CHECK_MATT                            

    uint32_t     CHECK_MATT1             : 8;
    uint32_t     CHECK_MATT2             : 8;
    uint32_t     CHECK_MATT3             : 8;
    uint32_t     CHECK_MATT4             : 8;
    uint32_t     CH031C_Test_05          : 8;
    uint32_t     CH031C_Test_06          : 8;
    uint32_t     CH031C_Test_07          : 8;    
  } Sig;
} CANMsg31CUnion;


#endif
