/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Pwm_PBcfg.c                                                                                         */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains post-build time parameters.                                                                     */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  PwmU2x.dll version: 1.5.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Pwm_Pwm_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_PWM_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Pwm.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  27 Apr 2025 - 14:14:07
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
#include "Pwm.h"
#include "Pwm_Ram.h"
#include "Pwm_Cbk.h"


/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/**********************************************************************************************************************/
/* Message (2:0303)    : Cast between a pointer to volatile object and an integral type.                              */
/* Rule                : CERTCCM INT36,MISRA C:2012 Rule-11.4                                                         */
/*                       REFERENCE - ISO-6.3.4 Semantics                                                              */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0315)    : Implicit conversion from a pointer to object type to a pointer to void.                      */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/*                       REFERENCE - ISO-6.3.4 Semantics                                                              */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1504)    : The object 'name' is only referenced in the translation unit where it is defined.            */
/* Rule                : CERTCCM DCL15, DCL19 , MISRA C:2012 Rule-8.7                                                 */
/* JV-01 Justification : This is accepted, due to following coding rule, internal function can be defined in other C  */
/*                       source files                                                                                 */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object 'name' is referenced in only one translation unit - but not the one in which      */
/*                       it is defined.                                                                               */
/* Rule                : CERTCCM DCL15, CERTCCM DCL19, MISRA C:2012 Rule-8.7                                          */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in seperated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping ).      */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3408)    : '%s' has external linkage and is being defined without any previous declaration              */
/* Rule                : CERTCCM DCL07, MISRA C:2012 Rule-8.4                                                         */
/* JV-01 Justification : It is accepted, due to the declaration will be taken care by Os                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/*                       REFERENCE - ISO:C90-6.3.1 Primary Expressions                                                */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:0311)    : Dangerous pointer cast results in loss of const qualification.                               */
/* Rule                : CERTCCM EXP05, MISRA C:2012 Rule-11.8                                                        */
/* JV-01 Justification : This is to achieve throughput in the code.                                                   */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (3:0313)    : Casting to different function pointer type.                                                  */
/* Rule                : MISRA C:2012 Rule-11.1                                                                       */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define PWM_PBCFG_C_AR_RELEASE_MAJOR_VERSION                                    4U
#define PWM_PBCFG_C_AR_RELEASE_MINOR_VERSION                                    3U
#define PWM_PBCFG_C_AR_RELEASE_REVISION_VERSION                                 1U

/* File version information */
#define PWM_PBCFG_C_SW_MAJOR_VERSION                                            1U
#define PWM_PBCFG_C_SW_MINOR_VERSION                                            5U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/
#if (PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION != PWM_PBCFG_C_AR_RELEASE_MAJOR_VERSION)
  #error "Pwm_PBcfg.c : Mismatch in Release Major Version"
#endif

#if (PWM_PBTYPES_AR_RELEASE_MINOR_VERSION != PWM_PBCFG_C_AR_RELEASE_MINOR_VERSION)
  #error "Pwm_PBcfg.c : Mismatch in Release Minor Version"
#endif

#if (PWM_PBTYPES_AR_RELEASE_REVISION_VERSION != PWM_PBCFG_C_AR_RELEASE_REVISION_VERSION)
  #error "Pwm_PBcfg.c : Mismatch in Release Revision Version"
#endif

#if (PWM_PBTYPES_SW_MAJOR_VERSION != PWM_PBCFG_C_SW_MAJOR_VERSION)
  #error "Pwm_PBcfg.c : Mismatch in Software Major Version"
#endif

#if (PWM_PBTYPES_SW_MINOR_VERSION != PWM_PBCFG_C_SW_MINOR_VERSION)
  #error "Pwm_PBcfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/
#define PWM_START_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_MemMap.h"


/* Pointer to function table for all timer IP */
P2CONST(Pwm_HwFuncTableType, PWM_VAR_INIT, PWM_CONFIG_DATA) Pwm_GaaHwFunc[] =                                           /* PRQA S 1531 # JV-01 */
{
  /* ATU Function Table */
  NULL_PTR,
  /* TAUD Function Table */
  &Pwm_TaudFunc,
  /* TAUJ Function Table */
  NULL_PTR,
  /* DIAG Function Table */
  NULL_PTR
};

#define PWM_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define PWM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Structure for Hardware IP configuration */
CONST(Pwm_HWIP_ConfigType, PWM_CONFIG_DATA) Pwm_GaaHWIP_Used[] =                                                        /* PRQA S 1531 # JV-01 */
{
  /* Index: 0 - TAUD */
  {
    /* ucIndex */
    PWM_HWIP_TAUD
  }
};

/* Structure for TAUD channel properties */
CONST(Pwm_TAUDChannelPropType, PWM_CONFIG_DATA) Pwm_GaaTAUDChannelProp[] =                                              /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - PwmChannel */
  {
    /* ddDefaultPeriodOrDuty */
    0x8000U,

    /* usChannelMask */
    0x0003U,

    /* pCntlRegs */
    (P2VAR(volatile Pwm_TAUDChannelUserRegs, TYPEDEF, REGSPACE)) 0xFFBF6000UL,                                          /* PRQA S 0303 # JV-01 */

    /* pCMORReg */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE)) 0xFFBF6200UL,                                                           /* PRQA S 0303 # JV-01 */

    /* pEICReg */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE)) 0xFFF80320UL,                                                           /* PRQA S 0303 # JV-01 */

    /* usCMORRegSettingsMask */
    0x0801U
  },
  /* Index: 1 - PwmChannel_001 */
  {
    /* ddDefaultPeriodOrDuty */
    0x2000U,

    /* usChannelMask */
    0x0002U,

    /* pCntlRegs */
    (P2VAR(volatile Pwm_TAUDChannelUserRegs, TYPEDEF, REGSPACE)) 0xFFBF6004UL,                                          /* PRQA S 0303 # JV-01 */

    /* pCMORReg */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE)) 0xFFBF6204UL,                                                           /* PRQA S 0303 # JV-01 */

    /* pEICReg */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE)) 0xFFF80322UL,                                                           /* PRQA S 0303 # JV-01 */

    /* usCMORRegSettingsMask */
    0x0409U
  }
};

/* Structure for TAU channel configuration */
CONST(Pwm_TAUChannelConfigType, PWM_CONFIG_DATA) Pwm_GaaTAUChannelConfig[] =                                            /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - PwmChannel */
  {
    /* ucMasterOffset */
    0x00U,

    /* ucTimerUnitIndex */
    0x00U,

    /* ucTimerMode */
    PWM_MASTER_CHANNEL,

    /* blComplexDriverInit */
    PWM_FALSE
  },
  /* Index: 1 - PwmChannel_001 */
  {
    /* ucMasterOffset */
    0x01U,

    /* ucTimerUnitIndex */
    0x00U,

    /* ucTimerMode */
    PWM_SLAVE_CHANNEL,

    /* blComplexDriverInit */
    PWM_FALSE
  }
};

/* Structure for each TAUD unit configuration set */
CONST(Pwm_TAUDUnitConfigType, PWM_CONFIG_DATA) Pwm_GaaTAUDUnitConfig[] =                                                /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - TAUD2 */
  {
    /* pUserCntlRegs */
    (P2VAR(volatile Pwm_TAUDUnitUserRegs, TYPEDEF, REGSPACE)) 0xFFBF6040UL,                                             /* PRQA S 0303 # JV-01 */

    /* pOsCntlRegs */
    (P2VAR(volatile Pwm_TAUDUnitOsRegs, TYPEDEF, REGSPACE)) 0xFFBF6240UL,                                               /* PRQA S 0303 # JV-01 */

    /* usTAUChannelMask */
    0x0003U,

    /* usTOMMask */
    0x0002U,

    /* usTOCMask */
    0x0000U,

    /* usTOLMask */
    0x0000U,

    /* usTOMask */
    0x0002U,

    /* usTOEMask */
    0x0002U,

    /* usPrescaler */
    0x7533U,

    /* ucBaudRate */
    0x14U,

    /* blConfigurePrescaler */
    PWM_TRUE,

    /* usSyncInitMask */
    0x0000U
  }
};

/* Structure for channel Configuration set */
CONST(Pwm_ChannelConfigType, PWM_CONFIG_DATA) Pwm_GaaChannelConfig[] =                                                  /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - PwmChannel */
  {
    /* pChannelProp */
    &Pwm_GaaTAUDChannelProp[0],                                                                                         /* PRQA S 0315 # JV-01 */

    /* pPwmEdgeNotifPtr */
    &Pwm_Notification_PwmChannel,                                                                                       /* PRQA S 0313 # JV-01 */

    /* ucPolarity */
    PWM_POLARITY_HIGH,

    /* enClassType */
    PWM_VARIABLE_PERIOD,

    /* ucIdleLevel */
    (uint8)PWM_HIGH,

    /* blSyncStartReq */
    PWM_FALSE,

    /* pHWIPChannelConfig */
    &Pwm_GaaTAUChannelConfig[0],                                                                                        /* PRQA S 0315 # JV-01 */

    /* ucTimerUnitType */
    PWM_HWIP_TAUD
  },
  /* Index: 1 - PwmChannel_001 */
  {
    /* pChannelProp */
    &Pwm_GaaTAUDChannelProp[1],                                                                                         /* PRQA S 0315 # JV-01 */

    /* pPwmEdgeNotifPtr */
    &Pwm_Notification_PwmChannel_001,                                                                                   /* PRQA S 0313 # JV-01 */

    /* ucPolarity */
    PWM_POLARITY_HIGH,

    /* enClassType */
    PWM_VARIABLE_PERIOD,

    /* ucIdleLevel */
    (uint8)PWM_HIGH,

    /* blSyncStartReq */
    PWM_FALSE,

    /* pHWIPChannelConfig */
    &Pwm_GaaTAUChannelConfig[1],                                                                                        /* PRQA S 0315 # JV-01 */

    /* ucTimerUnitType */
    PWM_HWIP_TAUD
  }
};

#define PWM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define PWM_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Structure for Configuration */
CONST(Pwm_ConfigType, PWM_CONFIG_DATA) Pwm_GaaConfiguration[] =
{
  /* Index: 0 - PwmChannelConfigSet */
  {
    /* ulStartOfDbToc */
    0x0EDE4128UL,

    /* Index: 1 - aaTimerUnitConfig */
    {
      /* aaTimerUnitConfig[0] */
      NULL_PTR,

      /* aaTimerUnitConfig[1] */
      &Pwm_GaaTAUDUnitConfig[0],                                                                                        /* PRQA S 0315 # JV-01 */

      /* aaTimerUnitConfig[2] */
      NULL_PTR,

      /* aaTimerUnitConfig[3] */
      NULL_PTR
    },
    /* pChannelConfig */
    &Pwm_GaaChannelConfig[0],                                                                                           /* PRQA S 0315 # JV-01 */

    /* pHWIPConfig */
    NULL_PTR
  }
};

#define PWM_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */



/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

