#include "MC33984EHFK.h"
#include "Simulated_SPI_Master.h"

void MC33984EHFK_Delay(void)
{
  uint8_t i;

  for (i = 0; i < 80U; i++)
  {
    NOP();
  }
}

void MC33984EHFK_Init(void)
{
  MC33984EHFK_CS2_Output_High();
  Sim_SPI_Master_Start(SIM_SPI_MODE_1, SIM_SPI_MSB_FIRST);
  MC33984EHFK_CS1_Output_Low();
  /*2.输出控制*/
  Sim_SPI_Master_Byte_Write(MC33984_OCR); /*全开*/
  Sim_SPI_Master_Byte_Write(0x0F);
  /*3.过电流高/低选择*/
  Sim_SPI_Master_Byte_Write(MC33984_SOCHLR_0); /*大电流100A，小电流7.5A*/
  Sim_SPI_Master_Byte_Write(0x07);
  /*4.电流检测时间与开负载*/
  Sim_SPI_Master_Byte_Write(MC33984_CDTOLR_0); /*禁用此检测*/
  Sim_SPI_Master_Byte_Write(0x0c);
  /*5.直接输入控制*/
  Sim_SPI_Master_Byte_Write(MC33984_DICR_0); /*使用外部控制，电流监测比例:1=1/41000,快速输出斜率*/
  Sim_SPI_Master_Byte_Write(0x0c);
  /*6.输出切换延迟*/
  Sim_SPI_Master_Byte_Write(MC33984_OSDR); /*挑了个中间值，延时300ms*/
  Sim_SPI_Master_Byte_Write(0x03);
  /*7.看门狗*/
  Sim_SPI_Master_Byte_Write(MC33984_WDR); /*设置为最大2500ms*/
  Sim_SPI_Master_Byte_Write(0X02);
  /*9.欠压/过压*/
  Sim_SPI_Master_Byte_Write(MC33984_UOVR); /*全开*/
  Sim_SPI_Master_Byte_Write(0X00);
  MC33984EHFK_CS1_Output_High();
  MC33984EHFK_Delay();
}
uint8_t MC33984EHFK_Readstep = 0;
uint8_t MC33984_Record = 0;
uint8_t dasdsa = 0;
uint8_t HDir[100] = 0;
void MC33984EHFK_Read(void)
{
  if (MC33984EHFK_Readstep < 8)
  {
    MC33984EHFK_CS1_Output_Low();
    if (MC33984_Record < 80)
    {
      HDir[MC33984_Record]=MC33984EHFK_Readstep;
      MC33984_Record++;
      HDir[MC33984_Record] = Sim_SPI_Master_Byte_Read(MC33984_STATR_0 + MC33984EHFK_Readstep);
      MC33984_Record++;
      if (dasdsa == 0)
      {
    Sim_SPI_Master_Byte_Write(MC33984_OCR); /*全开*/
    Sim_SPI_Master_Byte_Write(0x0F);
    dasdsa = 1;
      }
      else
      {
        Sim_SPI_Master_Byte_Write(MC33984_OCR_FeedDog); /*全开*/
        Sim_SPI_Master_Byte_Write(0x0F);
        dasdsa = 0;
      }
    }
    else
    {
      MC33984_Record = 0;
    }
    MC33984EHFK_CS1_Output_High();
    MC33984EHFK_Readstep++;
  }
  else
  {
    MC33984EHFK_Readstep = 0;
  }
}
