/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_ATU_PBTypes.h                                                                                   */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* API function implementations of PWM Driver                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.4.3: 18/04/2022 : Removed un-used PWM_TOCRE_REG_RESET_VALUE and PWM_COMMON_PRESCALER_NOT_USED macro definitions  **
 * 1.4.1: 08/10/2021 : Updated SW VERSION to 1.4.0                                                                    **
 *        11/11/2021 : Replace ATU5 with ATU                                                                          **
 *        21/11/2021 : Change PWM_TIMER_IP_ATU to PWM_ATU_UNIT_USED to support U2Bx                                   **
 * 1.3.2  04/08/2021 : Device specific implementation moved from Pwm common file.                                     **
 *                     Format source code unified within module.                                                      **
 * 1.3.1: 02/07/2021 : Format source code to 120 characters                                                           **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_ATU_PBTYPES_H
            #define PWM_59_INST0_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_ATU_PBTYPES_H
            #define PWM_59_INST1_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_ATU_PBTYPES_H
            #define PWM_59_INST2_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_ATU_PBTYPES_H
            #define PWM_59_INST3_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_ATU_PBTYPES_H
            #define PWM_59_INST4_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_ATU_PBTYPES_H
            #define PWM_59_INST5_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_ATU_PBTYPES_H
            #define PWM_59_INST6_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_ATU_PBTYPES_H
            #define PWM_59_INST7_ATU_PBTYPES_H
            #define PWM_ATU_PBTYPES_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_ATU_PBTYPES_H
        #define PWM_ATU_PBTYPES_H
        #define PWM_ATU_PBTYPES_HEADER
    #endif
#endif


#ifdef PWM_ATU_PBTYPES_HEADER
#undef PWM_ATU_PBTYPES_HEADER                                                                                           /* PRQA S 0841 # JV-01 */
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for data type unsigned integer declaration */
#include "rh850_Types.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define PWM_ATU_PBTYPES_AR_RELEASE_MAJOR_VERSION    PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_ATU_PBTYPES_AR_RELEASE_MINOR_VERSION    PWM_AR_RELEASE_MINOR_VERSION
#define PWM_ATU_PBTYPES_AR_RELEASE_REVISION_VERSION PWM_AR_RELEASE_REVISION_VERSION
/* Software module version information */
#define PWM_ATU_PBTYPES_SW_MAJOR_VERSION            PWM_SW_MAJOR_VERSION
#define PWM_ATU_PBTYPES_SW_MINOR_VERSION            PWM_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Macro for reset value */
#define PWM_CH_PRESCALER_RESET_VALUE                0x00U
#define PWM_SUBBLOCK_PRESCALER_RESET_VALUE          0x00U
#define PWM_SUBBLOCK_CLOCK_SEL_RESET_VALUE          0x00U
#define PWM_SUBBLOCK_CLOCK_SEL_MASK                 (uint8)0xF8U
#define PWM_SUBBLOCK_STARTING_REG_RESET_VALUE       (uint8)0x00U
#define PWM_TCRE_REG_RESET_VALUE                    (uint8)0x00U
#define PWM_RLDCRE_REG_RESET_VALUE                  (uint8)0x00U
#define PWM_TSRE_REG_RESET_VALUE                    0x0FFFU
/* Macro for selecting Channel clock source */
#define PWM_CH_SB_PRESCL_SEL                        (uint8)0x80U
#define PWM_CH_COUNTER_INIT_VALUE                   0x00000100UL
#define PWM_CYLRE_REG_RESET_VALUE                   0xFFFFFF00UL
#define PWM_DTRE_REG_RESET_VALUE                    0xFFFFFF00UL
#define PWM_CRLDE_REG_RESET_VALUE                   0xFFFFFF00UL
#define PWM_DRLDE_REG_RESET_VALUE                   0xFFFFFF00UL
/* Macro for ATUENR register setting */
#define PWM_ENR_COMMON_PRESCALER_EN_MASK            (uint8)0x01U
#define PWM_ENR_TIMERE_EN_MASK                      (uint8)0x20U
/* Macro for Duty Cycle */
#define PWM_BYTE_SHIFT_VALUE                        (uint8)0x08U
#define PWM_DUTY_CYCLE_RESET_VALUE                  0x00000000UL
/* set values */
#define PWM_LOWER_NIBBLE_MASK                       (uint8)0x0FU
#define PWM_DUTY_MATCH_MASK                         (uint16)0x0F00U
#define PWM_CYCLE_MATCH_MASK                        (uint16)0x000FU
/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3630)    : The implementation of this struct/union type should be hidden.                               */
/* Rule                : MISRA C:2012 Dir-4.8                                                                         */
/* JV-01 Justification : This is accepted. Redundant of struct or union type has no affect to driver operation.       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
/***********************************************************************************************************************
**                                          Structure for subblock                                                    **
***********************************************************************************************************************/
typedef enum ETag_Pwm_SubblockType
{
  PWM_ATUE_SUBBLK0 = 0x01,
  PWM_ATUE_SUBBLK1 = 0x02,
  PWM_ATUE_SUBBLK2 = 0x04,
  PWM_ATUE_SUBBLK3 = 0x08,
  PWM_ATUE_SUBBLK4 = 0x10,
  PWM_ATUE_SUBBLK5 = 0x20,
  PWM_ATUE_SUBBLK6 = 0x40,
  PWM_ATUE_SUBBLK7 = 0x80,
  PWM_ATUE_SUBBLK8 = 0x100,
  PWM_ATUE_SUBBLK9 = 0x200
} Pwm_SubblockType;

/***********************************************************************************************************************
**                                          Structure for ATU channel Properties                                      **
***********************************************************************************************************************/
typedef struct STag_Pwm_ATUChannelProp
{
  /* Default Period Value */
  Pwm_PeriodType ddDefault_Period;
  /* Default Duty Value */
  Pwm_PeriodType ddDefault_Duty;
  /* Individual channel mask value */
  uint8 ucChannelSelMask;
  /* Mask value for cycle and duty match for individual channel */
  uint16 usChannelIntSelMask;
} Pwm_ATUChannelPropType;

/***********************************************************************************************************************
**                                          Structure for Channel Properties                                          **
***********************************************************************************************************************/
#if (PWM_CLOCK_SETTING == STD_ON)

/* Overall module ATU configuration data structure */
typedef struct STag_Pwm_ATUConfigType
{
  /* Pointer to PWM Driver ATU-V Timer Common Prescaler configuration */
  P2CONST(void, TYPEDEF, PWM_CONFIG_DATA) pClockConfig;
} Pwm_ATUConfigType;

typedef struct STag_Pwm_ATUClockConfigType
{
  /* pointer to Common Prescaler Register */
  P2VAR(volatile uint16, TYPEDEF, REGSPACE) pPSCRx_Address;
  /* Common Prescaler Divider setting */
  uint16 usAtuCommonPrescalerDivRatio;
} Pwm_ATUClockConfigType;

#endif

/***********************************************************************************************************************
**                                     Structure for Sub-block Control registers                                      **
***********************************************************************************************************************/

typedef struct STag_Pwm_ATUESubblockRegs                                                                                /* PRQA S 3630 # JV-01 */
{
  /* Sub-block channel Starting Registers Ex */
  volatile uint8 ucATUESSTREx;
  /* Reserved Byte */
  volatile uint8 ucReserved1[PWM_THREE];
  /* Pre-scaler Registers Ex Correspond to sub-blocks */
  volatile uint8 ucATUEPSCREx;
  /* Reserved Byte */
  volatile uint8 ucReserved2[PWM_THREE];
  /* Timer Control Register Ex (Pre-scaler Select, TCNTEx Clock Select) */
  volatile uint8 ucATUETCREx;
} Pwm_ATUESubblockRegs;
/* where (x = 0 to 8;x = 0 to 9 at U2B24, U2B20; x = 0 to 8 at U2B10; x = 0 to 4 at U2B6)) */

/***********************************************************************************************************************
**                                        Structure for Sub-block Con-fig Type                                        **
***********************************************************************************************************************/
/* Instances 0 - 6 */

typedef struct STag_Pwm_ATUUnitConfigType
{
  #if (PWM_ATU_UNIT_USED == STD_ON)
  /* pointer to base address of Master Enable Register */
  P2VAR(volatile uint8, TYPEDEF, PWM_CONFIG_DATA) pATUENR_Address;
  /* pointer to base address of TIMER-E sub block registers */
  P2VAR(Pwm_ATUESubblockRegs, TYPEDEF, REGSPACE) pATUE_SubblockRegs;                                                    /* PRQA S 3432 # JV-01 */
  /* pointer to base address of TIMER-E sub block Enable register */
  P2VAR(volatile uint16, TYPEDEF, REGSPACE) pTSTRE_Address;
  /*Mask value for Timer Enable Register */
  uint16 usTimerEnableMask;
  /* Mask value for Timer sub block EN/DS(start/stop) Register */
  uint16 usEnableSubblockMask;
  /* Variable for Channel or Sub block Pre-scalar Selection */
  uint8 ucSelPrescalerMask;
  /* Variable for Pre-scalar value Selection for sub block */
  uint8 ucSelSubblockPrescaler;
  /* Variable for clock Selection of sub block */
  Pwm_ClockSourceType enSelSubblockClock;
  /* Mask Value for Synchronous Channels */
  #if (PWM_SYNC_START_SUPPORT == STD_ON)
  uint8 ucSyncChannelMask;
  #endif
  /* Mask value of all async channels configured for the corresponding
     sub block expect channel with fixed period class*/
  uint8 ucSubblockChannelMask;
  #endif
} Pwm_ATUUnitConfigType;
/***********************************************************************************************************************
**                                      Structure for Channel Control registers                                       **
***********************************************************************************************************************/

typedef struct STag_Pwm_ATUEChCntrlRegs                                                                                 /* PRQA S 3630 # JV-01 */
{
  /* Reload Control Registers(Reload function on cycle match is DS/EN) */
  volatile uint8 ucATUERLDCREx;
  /* Reserved Byte */
  volatile uint8 ucReserved3;
  /* Output Shut-off Control Register Ex */
  volatile uint16 usATUEPOECREx;
  /* Output Shut-off Level Setting Register Ex */
  volatile uint8 ucATUESOLVLEx;
  /* Reserved Byte */
  volatile uint8 ucReserved4;
  /* Timer Status Registers Ex(Duty match flags, Overflow Flag, Cycle Match Flag) */
  volatile uint16 usATUETSREx;
  /* Timer Status Clear Register Ex */
  volatile uint16 usATUETSCREx;
  /* Timer Output Control Registers (Output Inversion Select) */
  volatile uint8 ucATUETOCREx;
  /* Reserved Byte */
  volatile uint8 ucReserved5;
  /* Timer Interrupt Enable Registers Ex (Duty match interrupt enable, Cycle Match Interrupt Enable) */
  volatile uint16 usATUETIEREx;
  /* Prescaler Channel Registers Exy */
  volatile uint8 aaPSCCRExy[4];
  /*Forced Compare Match Trigger Registers Ex */
  volatile uint8 ucATUEFCTRGEx;
} Pwm_ATUEChCntrlRegs;

typedef struct STag_Pwm_ATUEChDataRegs                                                                                  /* PRQA S 3630 # JV-01 */
{
  /* Timer Counters Exy  */
  volatile uint32 ulATUETCNTExy;
  /* Cycle-Setting Registers Exy */
  volatile uint32 ulATUECYLRExy;
  /* Duty Cycle Setting Registers */
  volatile uint32 ulATUEDTRExy;
  /* Cycle Reload Registers  Exy */
  volatile uint32 ulATUECRLDExy;
  /* Duty Cycle Reload Registers Exy */
  volatile uint32 ulATUEDRLDExy;
} Pwm_ATUEChDataRegs;
/***********************************************************************************************************************
**                                    Data structure for PWM channel configuration                                    **
***********************************************************************************************************************/
typedef struct STag_Pwm_ATUChannelConfigType
{
  #if (PWM_ATU_UNIT_USED == STD_ON)
  /* Pointer to the base address of PWM Channel Pre-scalar register */
  P2VAR(volatile uint8, TYPEDEF, REGSPACE) pPSCCRExy_Address;
  /* Pointer to Pwm_ATUEChCntrlRegs structure to generate the base address of PWM Channel control register */
  P2VAR(Pwm_ATUEChCntrlRegs, TYPEDEF, REGSPACE) pATUEChCntrlRegs;                                                       /* PRQA S 3432 # JV-01 */
  /* Pointer to Pwm_ATUEChDataReg structure to generate the base address of PWM Channel data register */
  P2VAR(Pwm_ATUEChDataRegs, TYPEDEF, REGSPACE) pATUEChDataRegs;                                                         /* PRQA S 3432 # JV-01 */
  /* pointer to base address of Interrupt Mask Register */
  P2VAR(volatile uint32, TYPEDEF, REGSPACE) pIMRx_Address;
  /* pointer to base address of Interrupt Control Register */
  P2VAR(volatile uint16, TYPEDEF, REGSPACE) pEICx_Address;
  /* Pre-scalar value for channel */
  uint8 ucChSelPrescalVal;
  /* Mask value of the IMR Interrupt register */
  uint32 ulImrMaskValue;
  /* Enum for sub-block identification */
  Pwm_SubblockType enSubblockNum;
  #endif /* (PWM_TIMER_IP_USED) */
} Pwm_ATUChannelConfigType;

#endif /* PWM_ATU_PBTYPES_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
