/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_MultiInstance.h                                                                                 */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file is used to add instance index to each global symbol for the multiple instance support.                   */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/* 1.3.2:  06/09/2021  : Update QAC contents
 *         05/09/2021  : Append multi-instance symbol for LTTypes version macros.
 *                       Correct syntax of multi-instance symbol for internal functions.
 *         04/09/2021  : Add pre-compile condition for defining multiple files base on instance index
 *                       Add macros to convert string symbols
 *                       Update definition rule of multi-instance functions, macros, type definitions and header files
 * 1.3.1:  02/07/2021  : Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  30/07/2020  : Release.
 *                       Add component prefix to multi-instance macro names.
 *         28/07/2020  : Add QAC 9.3.1 comment.
 * 1.1.0:  19/06/2020  : Release
 * 1.0.1:  06/05/2020  : Remove multi-instance symbol definition for pre-compile macros that are not ISRs,
 *                       APIs/Internal Function and Global ptr/var.
 * 1.0.0:  24/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/

#ifdef SPI_INSTANCE_INDEX
    #if (SPI_INSTANCE_INDEX == 0)
        #ifndef SPI_59_INST0_MULTIINSTANCE_H
            #define SPI_59_INST0_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 1)
        #ifndef SPI_59_INST1_MULTIINSTANCE_H
            #define SPI_59_INST1_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 2)
        #ifndef SPI_59_INST2_MULTIINSTANCE_H
            #define SPI_59_INST2_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 3)
        #ifndef SPI_59_INST3_MULTIINSTANCE_H
            #define SPI_59_INST3_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 4)
        #ifndef SPI_59_INST4_MULTIINSTANCE_H
            #define SPI_59_INST4_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 5)
        #ifndef SPI_59_INST5_MULTIINSTANCE_H
            #define SPI_59_INST5_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 6)
        #ifndef SPI_59_INST6_MULTIINSTANCE_H
            #define SPI_59_INST6_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 7)
        #ifndef SPI_59_INST7_MULTIINSTANCE_H
            #define SPI_59_INST7_MULTIINSTANCE_H
            #define SPI_MULTIINSTANCE_HEADER
        #endif
    #else
        #error "Miss instance index"
    #endif
#else
    #ifndef SPI_MULTIINSTANCE_H
        #define SPI_MULTIINSTANCE_H
        #define SPI_MULTIINSTANCE_HEADER
    #endif
#endif

#ifdef SPI_MULTIINSTANCE_HEADER
#undef SPI_MULTIINSTANCE_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

/* SPI_USE_MULTIINSTANCE is passed by -D option */
#ifdef SPI_INSTANCE_INDEX

/* Add index to all global symbols. SPI_INSTANCE_INDEX is passed by -D option */
#define SPI_MULTIINC(pre_symbol, suf_symbol)           SPI_MULTIINC_(pre_symbol, suf_symbol, SPI_INSTANCE_INDEX)
/* To evaluate SPI_INSTANCE_INDEX before concatenation, nest the macro */
#define SPI_MULTIINC_(pre_symbol, suf_symbol, index)   SPI_MULTIINC__(pre_symbol, suf_symbol, index)
#define SPI_MULTIINC__(pre_symbol, suf_symbol, index)  pre_symbol##index##suf_symbol.h

/* String conversion macro */
#define TO_STRING(str)                                   TO_STRING_(str)
#define TO_STRING_(str)                                  #str

/* Add index to all global symbols. INSTANCE_INDEX is passed by -D option */
#define SPI_MULTI(pre_symbol, suf_symbol)                SPI_MULTI_(pre_symbol, suf_symbol, SPI_INSTANCE_INDEX)
/* To evaluate INSTANCE_INDEX before concatenation, nest the macro */
#define SPI_MULTI_(pre_symbol, suf_symbol, index)        SPI_MULTI__(pre_symbol, suf_symbol, index)
#define SPI_MULTI__(pre_symbol, suf_symbol, index)       pre_symbol##index##suf_symbol

/* Multi instance-ize all APIs */
#define Spi_Init                    SPI_MULTI(Spi_59_Inst, _Init)
#define Spi_DeInit                  SPI_MULTI(Spi_59_Inst, _DeInit)
#define Spi_WriteIB                 SPI_MULTI(Spi_59_Inst, _WriteIB)
#define Spi_AsyncTransmit           SPI_MULTI(Spi_59_Inst, _AsyncTransmit)
#define Spi_ReadIB                  SPI_MULTI(Spi_59_Inst, _ReadIB)
#define Spi_SetupEB                 SPI_MULTI(Spi_59_Inst, _SetupEB)
#define Spi_GetStatus               SPI_MULTI(Spi_59_Inst, _GetStatus)
#define Spi_GetJobResult            SPI_MULTI(Spi_59_Inst, _GetJobResult)
#define Spi_GetSequenceResult       SPI_MULTI(Spi_59_Inst, _GetSequenceResult)
#define Spi_GetVersionInfo          SPI_MULTI(Spi_59_Inst, _GetVersionInfo)
#define Spi_SyncTransmit            SPI_MULTI(Spi_59_Inst, _SyncTransmit)
#define Spi_GetHWUnitStatus         SPI_MULTI(Spi_59_Inst, _GetHWUnitStatus)
#define Spi_Cancel                  SPI_MULTI(Spi_59_Inst, _Cancel)
#define Spi_SetAsyncMode            SPI_MULTI(Spi_59_Inst, _SetAsyncMode)
#define Spi_MainFunction_Handling   SPI_MULTI(Spi_59_Inst, _MainFunction_Handling)
#define Spi_ForceCancel             SPI_MULTI(Spi_59_Inst, _ForceCancel)
#define Spi_SetStatus               SPI_MULTI(Spi_59_Inst, _SetStatus)
#define Spi_MemCopy                 SPI_MULTI(Spi_59_Inst, _MemCopy)

/* Multi instance-ize all internal global functions */
#define Spi_TurnOffHWUnit           SPI_MULTI(Spi_59_Inst, _TurnOffHWUnit)
#define Spi_RemoveFromQueue         SPI_MULTI(Spi_59_Inst, _RemoveFromQueue)
#define Spi_ProcessSequence         SPI_MULTI(Spi_59_Inst, _ProcessSequence)
#define Spi_StartTransmission       SPI_MULTI(Spi_59_Inst, _StartTransmission)
#define Spi_CancelSequence          SPI_MULTI(Spi_59_Inst, _CancelSequence)
#define Spi_TransmitSyncSequence    SPI_MULTI(Spi_59_Inst, _TransmitSyncSequence)
#define Spi_CSIXTransmitISR         SPI_MULTI(Spi_59_Inst, _CSIXTransmitISR)
#define Spi_CSIXReceiveISR          SPI_MULTI(Spi_59_Inst, _CSIXReceiveISR)
#define Spi_DMAInit                 SPI_MULTI(Spi_59_Inst, _DMAInit)
#define Spi_DMADeInit               SPI_MULTI(Spi_59_Inst, _DMADeInit)
#define Spi_DMAStart                SPI_MULTI(Spi_59_Inst, _DMAStart)
#define Spi_DMAStop                 SPI_MULTI(Spi_59_Inst, _DMAStop)
#define Spi_DMAMaskHWUnitInterrupts SPI_MULTI(Spi_59_Inst, _DMAMaskHWUnitInterrupts)
#define Spi_DMAClearInterruptFlag   SPI_MULTI(Spi_59_Inst, _DMAClearInterruptFlag)
#define Spi_DMAGetInterruptFlag     SPI_MULTI(Spi_59_Inst, _DMAGetInterruptFlag)
#define Spi_HSPIComEndISR           SPI_MULTI(Spi_59_Inst, _HSPIComEndISR)
#define Spi_HSPIErrorISR            SPI_MULTI(Spi_59_Inst, _HSPIErrorISR)
#define Spi_MSPITransmitISR         SPI_MULTI(Spi_59_Inst, _MSPITransmitISR)
#define Spi_MSPIReceiveISR          SPI_MULTI(Spi_59_Inst, _MSPIReceiveISR)
#define Spi_MSPIFrameEndISR         SPI_MULTI(Spi_59_Inst, _MSPIFrameEndISR)
#define Spi_PushToQueue                         SPI_MULTI(Spi_59_Inst, _PushToQueue)
#define Spi_PopFromQueue                        SPI_MULTI(Spi_59_Inst, _PopFromQueue)
#define Spi_MaskSequenceInterrupts              SPI_MULTI(Spi_59_Inst, _MaskSequenceInterrupts)
#define Spi_InvokeNotifications                 SPI_MULTI(Spi_59_Inst, _InvokeNotifications)
#define Spi_ProcessJob                          SPI_MULTI(Spi_59_Inst, _ProcessJob)
#define Spi_CheckSeqFinish                      SPI_MULTI(Spi_59_Inst, _CheckSeqFinish)
#define Spi_HSPIInit                            SPI_MULTI(Spi_59_Inst, _HSPIInit)
#define Spi_HSPIDeInit                          SPI_MULTI(Spi_59_Inst, _HSPIDeInit)
#define Spi_HSPIInitializeForJob                SPI_MULTI(Spi_59_Inst, _HSPIInitializeForJob)
#define Spi_HSPIInitializeForCh                 SPI_MULTI(Spi_59_Inst, _HSPIInitializeForCh)
#define Spi_HSPIProcessJob                      SPI_MULTI(Spi_59_Inst, _HSPIProcessJob)
#define Spi_HSPITransmitSyncJob                 SPI_MULTI(Spi_59_Inst, _HSPITransmitSyncJob)
#define Spi_HSPIDisableAllInterrupts            SPI_MULTI(Spi_59_Inst, _HSPIDisableAllInterrupts)
#define Spi_HSPIMainFunction_Handling           SPI_MULTI(Spi_59_Inst, _HSPIMainFunction_Handling)
#define Spi_HSPIForceStop                       SPI_MULTI(Spi_59_Inst, _HSPIForceStop)
#define Spi_HSPIMaskHWUnitInterrupts            SPI_MULTI(Spi_59_Inst, _HSPIMaskHWUnitInterrupts)
#define Spi_HSPITurnOff                         SPI_MULTI(Spi_59_Inst, _HSPITurnOff)
#define Spi_CSIXInit                            SPI_MULTI(Spi_59_Inst, _CSIXInit)
#define Spi_CSIXDeInit                          SPI_MULTI(Spi_59_Inst, _CSIXDeInit)
#define Spi_CSIXInitializeForJob                SPI_MULTI(Spi_59_Inst, _CSIXInitializeForJob)
#define Spi_CSIXInitializeForCh                 SPI_MULTI(Spi_59_Inst, _CSIXInitializeForCh)
#define Spi_CSIXProcessJob                      SPI_MULTI(Spi_59_Inst, _CSIXProcessJob)
#define Spi_CSIXStartChannelDirectAccessMode    SPI_MULTI(Spi_59_Inst, _CSIXStartChannelDirectAccessMode)
#define Spi_CSIXTransmitSyncJob                 SPI_MULTI(Spi_59_Inst, _CSIXTransmitSyncJob)
#define Spi_LoadTxData                          SPI_MULTI(Spi_59_Inst, _LoadTxData)
#define Spi_StoreRxData                         SPI_MULTI(Spi_59_Inst, _StoreRxData)
#define Spi_CSIXDMACompleteISR                  SPI_MULTI(Spi_59_Inst, _CSIXDMACompleteISR)
#define Spi_CSIXDisableAllInterrupts            SPI_MULTI(Spi_59_Inst, _CSIXDisableAllInterrupts)
#define Spi_CSIXMainFunction_Handling           SPI_MULTI(Spi_59_Inst, _CSIXMainFunction_Handling)
#define Spi_CSIXForceStop                       SPI_MULTI(Spi_59_Inst, _CSIXForceStop)
#define Spi_CSIXMaskHWUnitInterrupts            SPI_MULTI(Spi_59_Inst, _CSIXMaskHWUnitInterrupts)
#define Spi_CSIXTurnOff                         SPI_MULTI(Spi_59_Inst, _CSIXTurnOff)
#define Spi_MSPIInit                            SPI_MULTI(Spi_59_Inst, _MSPIInit)
#define Spi_MSPIDeInit                          SPI_MULTI(Spi_59_Inst, _MSPIDeInit)
#define Spi_MSPIInitializeForJob                SPI_MULTI(Spi_59_Inst, _MSPIInitializeForJob)
#define Spi_MSPIInitializeForCh                 SPI_MULTI(Spi_59_Inst, _MSPIInitializeForCh)
#define Spi_MSPIProcessJob                      SPI_MULTI(Spi_59_Inst, _MSPIProcessJob)
#define Spi_MSPIStartChannelDirectMemoryMode    SPI_MULTI(Spi_59_Inst, _MSPIStartChannelDirectMemoryMode)
#define Spi_MSPIStartChannelFixedBufferMode     SPI_MULTI(Spi_59_Inst, _MSPIStartChannelFixedBufferMode)
#define Spi_MSPIStartChannelFixedFIFOMode       SPI_MULTI(Spi_59_Inst, _MSPIStartChannelFixedFIFOMode)
#define Spi_MSPITransmitSyncJob                 SPI_MULTI(Spi_59_Inst, _MSPITransmitSyncJob)
#define Spi_MSPIDMACompleteISR                  SPI_MULTI(Spi_59_Inst, _MSPIDMACompleteISR)
#define Spi_MSPIDisableAllInterrupts            SPI_MULTI(Spi_59_Inst, _MSPIDisableAllInterrupts)
#define Spi_MSPIMainFunction_Handling           SPI_MULTI(Spi_59_Inst, _MSPIMainFunction_Handling)
#define Spi_MSPIForceStop                       SPI_MULTI(Spi_59_Inst, _MSPIForceStop)
#define Spi_MSPIMaskHWUnitInterrupts            SPI_MULTI(Spi_59_Inst, _MSPIMaskHWUnitInterrupts)
#define Spi_MSPITurnOff                         SPI_MULTI(Spi_59_Inst, _MSPITurnOff)

/* Multi instance-ize all internal global pointers */
#define Spi_GpConfigPtr             SPI_MULTI(Spi_59_Inst, _GpConfigPtr)
#define Spi_GpFirstChannel          SPI_MULTI(Spi_59_Inst, _GpFirstChannel)
#define Spi_GpFirstJob              SPI_MULTI(Spi_59_Inst, _GpFirstJob)
#define Spi_GpFirstSeq              SPI_MULTI(Spi_59_Inst, _GpFirstSeq)
#define Spi_GpFirstHWUnit           SPI_MULTI(Spi_59_Inst, _GpFirstHWUnit)
#define Spi_GpFirstDMAUnit          SPI_MULTI(Spi_59_Inst, _GpFirstDMAUnit)
#define Spi_GpHwConfig              SPI_MULTI(Spi_59_Inst, _GpHwConfig)

/* Multi instance-ize all internal global variables */
#define Spi_GblInitialized          SPI_MULTI(Spi_59_Inst, _GblInitialized)
#define Spi_GenAsyncMode            SPI_MULTI(Spi_59_Inst, _GenAsyncMode)
#define Spi_GaaHWStatus             SPI_MULTI(Spi_59_Inst, _GaaHWStatus)
#define Spi_GaaQueue                SPI_MULTI(Spi_59_Inst, _GaaQueue)
#define Spi_GaaSeqStatus            SPI_MULTI(Spi_59_Inst, _GaaSeqStatus)
#define Spi_GaaJobStatus            SPI_MULTI(Spi_59_Inst, _GaaJobStatus)
#define Spi_GaaEBData               SPI_MULTI(Spi_59_Inst, _GaaEBData)
#define Spi_GulActiveHWUnits        SPI_MULTI(Spi_59_Inst, _GulActiveHWUnits)
#define Spi_GulAllQueueSts          SPI_MULTI(Spi_59_Inst, _GulAllQueueSts)
#define Spi_GaaActiveSequence       SPI_MULTI(Spi_59_Inst, _GaaActiveSequence)
#define Spi_GaaChannelBuffer        SPI_MULTI(Spi_59_Inst, _GaaChannelBuffer)
#define Spi_GulDmaRxData            SPI_MULTI(Spi_59_Inst, _GulDmaRxData)
#define Spi_GulCancelingHWUnits     SPI_MULTI(Spi_59_Inst, _GulCancelingHWUnits)
#define Spi_GaaHSPIChannelBuffer    SPI_MULTI(Spi_59_Inst, _GaaHSPIChannelBuffer)
#define Spi_GstCSIXFunc             SPI_MULTI(Spi_59_Inst, _GstCSIXFunc)
#define Spi_GstHSPIFunc             SPI_MULTI(Spi_59_Inst, _GstHSPIFunc)
#define Spi_GstMSPIFunc             SPI_MULTI(Spi_59_Inst, _GstMSPIFunc)



/* Multi instance-ize all generated global variables */
#define Spi_GaaCSIHRegs             SPI_MULTI(Spi_59_Inst, _GaaCSIHRegs)
#define Spi_GaaHSPIRegs             SPI_MULTI(Spi_59_Inst, _GaaHSPIRegs)
#define Spi_GaaMSPIRegs             SPI_MULTI(Spi_59_Inst, _GaaMSPIRegs)
#define Spi_GaaConfiguration        SPI_MULTI(Spi_59_Inst, _GaaConfiguration)

/* Multi instance-ize all symbolic constants */
#define SPI_CSIH0_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH0_TIC_ISR_API)
#define SPI_CSIH1_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH1_TIC_ISR_API)
#define SPI_CSIH2_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH2_TIC_ISR_API)
#define SPI_CSIH3_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH3_TIC_ISR_API)
#define SPI_CSIH4_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH4_TIC_ISR_API)
#define SPI_CSIH5_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH5_TIC_ISR_API)
#define SPI_CSIH6_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH6_TIC_ISR_API)
#define SPI_CSIH7_TIC_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH7_TIC_ISR_API)
#define SPI_CSIH0_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH0_TIR_ISR_API)
#define SPI_CSIH1_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH1_TIR_ISR_API)
#define SPI_CSIH2_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH2_TIR_ISR_API)
#define SPI_CSIH3_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH3_TIR_ISR_API)
#define SPI_CSIH4_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH4_TIR_ISR_API)
#define SPI_CSIH5_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH5_TIR_ISR_API)
#define SPI_CSIH6_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH6_TIR_ISR_API)
#define SPI_CSIH7_TIR_ISR_API       SPI_MULTI(SPI_59_INST, _CSIH7_TIR_ISR_API)
#define SPI_HSPI0_CEND_ISR_API      SPI_MULTI(SPI_59_INST, _HSPI0_CEND_ISR_API)
#define SPI_HSPI0_ERR_ISR_API       SPI_MULTI(SPI_59_INST, _HSPI0_ERR_ISR_API)
#define SPI_HSPI0_BERR_ISR_API      SPI_MULTI(SPI_59_INST, _HSPI0_BERR_ISR_API)
#define SPI_MSPI0_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI0_TX_ISR_API)
#define SPI_MSPI0_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI0_RX_ISR_API)
#define SPI_MSPI0_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI0_FE_ISR_API)
#define SPI_MSPI1_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI1_TX_ISR_API)
#define SPI_MSPI1_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI1_RX_ISR_API)
#define SPI_MSPI1_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI1_FE_ISR_API)
#define SPI_MSPI2_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI2_TX_ISR_API)
#define SPI_MSPI2_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI2_RX_ISR_API)
#define SPI_MSPI2_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI2_FE_ISR_API)
#define SPI_MSPI3_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI3_TX_ISR_API)
#define SPI_MSPI3_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI3_RX_ISR_API)
#define SPI_MSPI3_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI3_FE_ISR_API)
#define SPI_MSPI4_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI4_TX_ISR_API)
#define SPI_MSPI4_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI4_RX_ISR_API)
#define SPI_MSPI4_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI4_FE_ISR_API)
#define SPI_MSPI5_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI5_TX_ISR_API)
#define SPI_MSPI5_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI5_RX_ISR_API)
#define SPI_MSPI5_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI5_FE_ISR_API)
#define SPI_MSPI6_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI6_TX_ISR_API)
#define SPI_MSPI6_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI6_RX_ISR_API)
#define SPI_MSPI6_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI6_FE_ISR_API)
#define SPI_MSPI7_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI7_TX_ISR_API)
#define SPI_MSPI7_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI7_RX_ISR_API)
#define SPI_MSPI7_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI7_FE_ISR_API)
#define SPI_MSPI8_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI8_TX_ISR_API)
#define SPI_MSPI8_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI8_RX_ISR_API)
#define SPI_MSPI8_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI8_FE_ISR_API)
#define SPI_MSPI9_TX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI9_TX_ISR_API)
#define SPI_MSPI9_RX_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI9_RX_ISR_API)
#define SPI_MSPI9_FE_ISR_API        SPI_MULTI(SPI_59_INST, _MSPI9_FE_ISR_API)
#define SPI_DMA0_00_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_00_ISR_API)
#define SPI_DMA0_01_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_01_ISR_API)
#define SPI_DMA0_02_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_02_ISR_API)
#define SPI_DMA0_03_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_03_ISR_API)
#define SPI_DMA0_04_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_04_ISR_API)
#define SPI_DMA0_05_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_05_ISR_API)
#define SPI_DMA0_06_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_06_ISR_API)
#define SPI_DMA0_07_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_07_ISR_API)
#define SPI_DMA0_08_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_08_ISR_API)
#define SPI_DMA0_09_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_09_ISR_API)
#define SPI_DMA0_10_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_10_ISR_API)
#define SPI_DMA0_11_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_11_ISR_API)
#define SPI_DMA0_12_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_12_ISR_API)
#define SPI_DMA0_13_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_13_ISR_API)
#define SPI_DMA0_14_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_14_ISR_API)
#define SPI_DMA0_15_ISR_API         SPI_MULTI(SPI_59_INST, _DMA0_15_ISR_API)
#define SPI_DMA1_00_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_00_ISR_API)
#define SPI_DMA1_01_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_01_ISR_API)
#define SPI_DMA1_02_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_02_ISR_API)
#define SPI_DMA1_03_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_03_ISR_API)
#define SPI_DMA1_04_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_04_ISR_API)
#define SPI_DMA1_05_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_05_ISR_API)
#define SPI_DMA1_06_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_06_ISR_API)
#define SPI_DMA1_07_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_07_ISR_API)
#define SPI_DMA1_08_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_08_ISR_API)
#define SPI_DMA1_09_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_09_ISR_API)
#define SPI_DMA1_10_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_10_ISR_API)
#define SPI_DMA1_11_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_11_ISR_API)
#define SPI_DMA1_12_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_12_ISR_API)
#define SPI_DMA1_13_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_13_ISR_API)
#define SPI_DMA1_14_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_14_ISR_API)
#define SPI_DMA1_15_ISR_API         SPI_MULTI(SPI_59_INST, _DMA1_15_ISR_API)

/*Multi instance for macro ISR*/
#define SPI_ISR_CATEGORY_2               SPI_MULTI(SPI_59_INST, _ISR_CATEGORY_2)

/* Multi instance for typedef depending on configuration */
#define Spi_ConfigType              SPI_MULTI(Spi_59_Inst, _ConfigType)
#define STag_Spi_ConfigType         SPI_MULTI(STag_Spi_59_Inst, _ConfigType)

#define STag_Spi_BRSRegType                         SPI_MULTI(STag_Spi_59_Inst, _BRSRegType)
#define Spi_BRSRegType                              SPI_MULTI(Spi_59_Inst, _BRSRegType)
#define STag_Spi_CSIHRegType                        SPI_MULTI(STag_Spi_59_Inst, _CSIHRegType)
#define Spi_CSIHRegType                             SPI_MULTI(Spi_59_Inst, _CSIHRegType)
#define STag_Spi_CSIHRegisterSetType                SPI_MULTI(STag_Spi_59_Inst, _CSIHRegisterSetType)
#define Spi_CSIHRegisterSetType                     SPI_MULTI(Spi_59_Inst, _CSIHRegisterSetType)
#define STag_Spi_CSIXDeviceConfigType               SPI_MULTI(STag_Spi_59_Inst, _CSIXDeviceConfigType)
#define Spi_CSIXDeviceConfigType                    SPI_MULTI(Spi_59_Inst, _CSIXDeviceConfigType)
#define STag_Spi_CSIXEDLStatusType                  SPI_MULTI(STag_Spi_59_Inst, _CSIXEDLStatusType)
#define Spi_CSIXEDLStatusType                       SPI_MULTI(Spi_59_Inst, _CSIXEDLStatusType)

#define STag_Spi_HSPIRegType                        SPI_MULTI(STag_Spi_59_Inst, _HSPIRegType)
#define Spi_HSPIRegType                             SPI_MULTI(Spi_59_Inst, _HSPIRegType)
#define STag_Spi_HSPIRegisterSetType                SPI_MULTI(STag_Spi_59_Inst, _HSPIRegisterSetType)
#define Spi_HSPIRegisterSetType                     SPI_MULTI(Spi_59_Inst, _HSPIRegisterSetType)
#define STag_Spi_HSPIDeviceConfigType               SPI_MULTI(STag_Spi_59_Inst, _HSPIDeviceConfigType)
#define Spi_HSPIDeviceConfigType                    SPI_MULTI(Spi_59_Inst, _HSPIDeviceConfigType)

#define STag_Spi_MSPIChannelRegType                 SPI_MULTI(STag_Spi_59_Inst, _MSPIChannelRegType)
#define Spi_MSPIChannelRegType                      SPI_MULTI(Spi_59_Inst, _MSPIChannelRegType)
#define STag_Spi_MSPIRegType                        SPI_MULTI(STag_Spi_59_Inst, _MSPIRegType)
#define Spi_MSPIRegType                             SPI_MULTI(Spi_59_Inst, _MSPIRegType)
#define STag_Spi_MSPIIntfRegType                    SPI_MULTI(STag_Spi_59_Inst, _MSPIIntfRegType)
#define Spi_MSPIIntfRegType                         SPI_MULTI(Spi_59_Inst, _MSPIIntfRegType)
#define STag_Spi_MSPITrgGenRegType                  SPI_MULTI(STag_Spi_59_Inst, _MSPITrgGenRegType)
#define Spi_MSPITrgGenRegType                       SPI_MULTI(Spi_59_Inst, _MSPITrgGenRegType)
#define STag_Spi_MSPIRegisterSetType                SPI_MULTI(STag_Spi_59_Inst, _MSPIRegisterSetType)
#define Spi_MSPIRegisterSetType                     SPI_MULTI(Spi_59_Inst, _MSPIRegisterSetType)
#define STag_Spi_MSPIDeviceConfigType               SPI_MULTI(STag_Spi_59_Inst, _MSPIDeviceConfigType)
#define Spi_MSPIDeviceConfigType                    SPI_MULTI(Spi_59_Inst, _MSPIDeviceConfigType)

#define STag_Spi_SDMAChRegType                      SPI_MULTI(STag_Spi_59_Inst, _SDMAChRegType)
#define Spi_SDMAChRegType                           SPI_MULTI(Spi_59_Inst, _SDMAChRegType)
#define STag_Spi_DmaConfigType                      SPI_MULTI(STag_Spi_59_Inst, _DmaConfigType)
#define Spi_DmaConfigType                           SPI_MULTI(Spi_59_Inst, _DmaConfigType)

#define STag_Spi_EBDataType                         SPI_MULTI(STag_Spi_59_Inst, _EBDataType)
#define Spi_EBDataType                              SPI_MULTI(Spi_59_Inst, _EBDataType)
#define STag_Spi_HWStatusType                       SPI_MULTI(STag_Spi_59_Inst, _HWStatusType)
#define Spi_HWStatusType                            SPI_MULTI(Spi_59_Inst, _HWStatusType)

#define STag_Spi_ChannelConfigType                  SPI_MULTI(STag_Spi_59_Inst, _ChannelConfigType)
#define Spi_ChannelConfigType                       SPI_MULTI(Spi_59_Inst, _ChannelConfigType)
#define STag_Spi_JobConfigType                      SPI_MULTI(STag_Spi_59_Inst, _JobConfigType)
#define Spi_JobConfigType                           SPI_MULTI(Spi_59_Inst, _JobConfigType)
#define STag_Spi_SubSeqConfigType                   SPI_MULTI(STag_Spi_59_Inst, _SubSeqConfigType)
#define Spi_SubSeqConfigType                        SPI_MULTI(Spi_59_Inst, _SubSeqConfigType)
#define STag_Spi_SeqConfigType                      SPI_MULTI(STag_Spi_59_Inst, _SeqConfigType)
#define Spi_SeqConfigType                           SPI_MULTI(Spi_59_Inst, _SeqConfigType)
#define STag_Spi_HWUnitInfoType                     SPI_MULTI(STag_Spi_59_Inst, _HWUnitInfoType)
#define Spi_HWUnitInfoType                          SPI_MULTI(Spi_59_Inst, _HWUnitInfoType)
#define STag_Spi_HwFuncTableType                    SPI_MULTI(STag_Spi_59_Inst, _HwFuncTableType)
#define Spi_HwFuncTableType                         SPI_MULTI(Spi_59_Inst, _HwFuncTableType)
#define STag_Spi_HwConfigType                       SPI_MULTI(STag_Spi_59_Inst, _HwConfigType)
#define Spi_HwConfigType                            SPI_MULTI(Spi_59_Inst, _HwConfigType)

#define STag_Spi_SubSeqStatusType                   SPI_MULTI(STag_Spi_59_Inst, _SubSeqStatusType)
#define Spi_SubSeqStatusType                        SPI_MULTI(Spi_59_Inst, _SubSeqStatusType)
#define STag_Spi_SeqStatusType                      SPI_MULTI(STag_Spi_59_Inst, _SeqStatusType)
#define Spi_SeqStatusType                           SPI_MULTI(Spi_59_Inst, _SeqStatusType)
#define STag_Spi_JobStatusType                      SPI_MULTI(STag_Spi_59_Inst, _JobStatusType)
#define Spi_JobStatusType                           SPI_MULTI(Spi_59_Inst, _JobStatusType)
#define STag_Spi_QueueType                          SPI_MULTI(STag_Spi_59_Inst, _QueueType)
#define Spi_QueueType                               SPI_MULTI(Spi_59_Inst, _QueueType)

#define ETag_Spi_MemoryModeType                     SPI_MULTI(ETag_Spi_59_Inst, _MemoryModeType)
#define Spi_MemoryModeType                          SPI_MULTI(Spi_59_Inst, _MemoryModeType)

#define ETag_Spi_TransferStartType                  SPI_MULTI(ETag_Spi_59_Inst, _TransferStartType)
#define Spi_TransferStartType                       SPI_MULTI(Spi_59_Inst, _TransferStartType)
#define ETag_Spi_ChannelBufferType                  SPI_MULTI(ETag_Spi_59_Inst, _ChannelBufferType)
#define Spi_ChannelBufferType                       SPI_MULTI(Spi_59_Inst, _ChannelBufferType)

#define ETag_Spi_StatusType                         SPI_MULTI(ETag_Spi_59_Inst, _StatusType)
#define Spi_StatusType                              SPI_MULTI(Spi_59_Inst, _StatusType)
#define ETag_Spi_JobResultType                      SPI_MULTI(ETag_Spi_59_Inst, _JobResultType)
#define Spi_JobResultType                           SPI_MULTI(Spi_59_Inst, _JobResultType)
#define ETag_Spi_SeqResultType                      SPI_MULTI(ETag_Spi_59_Inst, _SeqResultType)
#define Spi_SeqResultType                           SPI_MULTI(Spi_59_Inst, _SeqResultType)
#define ETag_Spi_AsyncModeType                      SPI_MULTI(ETag_Spi_59_Inst, _AsyncModeType)
#define Spi_AsyncModeType                           SPI_MULTI(Spi_59_Inst, _AsyncModeType)

#define Spi_DataBufferType                          SPI_MULTI(Spi_59_Inst, _DataBufferType)
#define Spi_NumberOfDataType                        SPI_MULTI(Spi_59_Inst, _NumberOfDataType)
#define Spi_ChannelType                             SPI_MULTI(Spi_59_Inst, _ChannelType)
#define Spi_JobType                                 SPI_MULTI(Spi_59_Inst, _JobType)
#define Spi_SequenceType                            SPI_MULTI(Spi_59_Inst, _SequenceType)
#define Spi_HWUnitType                              SPI_MULTI(Spi_59_Inst, _HWUnitType)

/* Multi instance for DEM ERROR */
#define SPI_E_INT_INCONSISTENT          SPI_MULTI(SPI_59_INST, _E_INT_INCONSISTENT)
#define SPI_E_DATA_TX_TIMEOUT_FAILURE   SPI_MULTI(SPI_59_INST, _E_DATA_TX_TIMEOUT_FAILURE)
#define SPI_E_HARDWARE_ERROR            SPI_MULTI(SPI_59_INST, _E_HARDWARE_ERROR)
#define SPI_E_DMA_ERROR                 SPI_MULTI(SPI_59_INST, _E_DMA_ERROR)

/*Multi instance for version information */
/* Multi instance for version information for AR VERSION */
#define SPI_AR_VERSION                                   SPI_MULTI(SPI_59_INST, _AR_VERSION)
/* Multi instance for version information for CFG file */
#define SPI_CFG_AR_RELEASE_MAJOR_VERSION                 SPI_MULTI(SPI_59_INST, _CFG_AR_RELEASE_MAJOR_VERSION)
#define SPI_CFG_AR_RELEASE_MINOR_VERSION                 SPI_MULTI(SPI_59_INST, _CFG_AR_RELEASE_MINOR_VERSION)
#define SPI_CFG_AR_RELEASE_REVISION_VERSION              SPI_MULTI(SPI_59_INST, _CFG_AR_RELEASE_REVISION_VERSION)
#define SPI_CFG_SW_MAJOR_VERSION                         SPI_MULTI(SPI_59_INST, _CFG_SW_MAJOR_VERSION)
#define SPI_CFG_SW_MINOR_VERSION                         SPI_MULTI(SPI_59_INST, _CFG_SW_MINOR_VERSION)
/* Multi instance for version information for LCFG file */
#define SPI_LCFG_C_AR_RELEASE_MAJOR_VERSION             SPI_MULTI(SPI_59_INST, _AR_RELEASE_MAJOR_VERSION
#define SPI_LCFG_C_AR_RELEASE_MINOR_VERSION             SPI_MULTI(SPI_59_INST, _AR_RELEASE_MINOR_VERSION
#define SPI_LCFG_C_AR_RELEASE_REVISION_VERSION          SPI_MULTI(SPI_59_INST, _AR_RELEASE_REVISION_VERSION
#define SPI_LCFG_C_SW_MAJOR_VERSION                     SPI_MULTI(SPI_59_INST, _SW_MAJOR_VERSION
#define SPI_LCFG_C_SW_MINOR_VERSION                     SPI_MULTI(SPI_59_INST, _SW_MINOR_VERSION
/* Multi instance for version information for PBCFG file */
#define SPI_PBCFG_C_AR_RELEASE_MAJOR_VERSION             SPI_MULTI(SPI_59_INST, _PBCFG_C_AR_RELEASE_MAJOR_VERSION)
#define SPI_PBCFG_C_AR_RELEASE_MINOR_VERSION             SPI_MULTI(SPI_59_INST, _PBCFG_C_AR_RELEASE_MINOR_VERSION)
#define SPI_PBCFG_C_AR_RELEASE_REVISION_VERSION          SPI_MULTI(SPI_59_INST, _PBCFG_C_AR_RELEASE_REVISION_VERSION)
#define SPI_PBCFG_C_SW_MAJOR_VERSION                     SPI_MULTI(SPI_59_INST, _PBCFG_C_SW_MAJOR_VERSION)
#define SPI_PBCFG_C_SW_MINOR_VERSION                     SPI_MULTI(SPI_59_INST, _PBCFG_C_SW_MINOR_VERSION)

/*Multi instance for common published information */
#define SPI_AR_RELEASE_MAJOR_VERSION_VALUE               SPI_MULTI(SPI_59_INST, _AR_RELEASE_MAJOR_VERSION_VALUE)
#define SPI_AR_RELEASE_MINOR_VERSION_VALUE               SPI_MULTI(SPI_59_INST, _AR_RELEASE_MINOR_VERSION_VALUE)
#define SPI_AR_RELEASE_REVISION_VERSION_VALUE            SPI_MULTI(SPI_59_INST, _AR_RELEASE_REVISION_VERSION_VALUE)
#define SPI_SW_MAJOR_VERSION_VALUE                       SPI_MULTI(SPI_59_INST, _SW_MAJOR_VERSION_VALUE)
#define SPI_SW_MINOR_VERSION_VALUE                       SPI_MULTI(SPI_59_INST, _SW_MINOR_VERSION_VALUE)
#define SPI_SW_PATCH_VERSION_VALUE                       SPI_MULTI(SPI_59_INST, _SW_PATCH_VERSION_VALUE)
#define SPI_VENDOR_ID_VALUE                              SPI_MULTI(SPI_59_INST, _VENDOR_ID_VALUE)
#define SPI_MODULE_ID_VALUE                              SPI_MULTI(SPI_59_INST, _MODULE_ID_VALUE)

/* Multi instance for memory class/pointer class */
#define SPI_PUBLIC_CODE                                  SPI_MULTI(SPI_59_INST, _PUBLIC_CODE)
#define SPI_PUBLIC_CONST                                 SPI_MULTI(SPI_59_INST, _PUBLIC_CONST)
#define SPI_PRIVATE_CODE                                 SPI_MULTI(SPI_59_INST, _PRIVATE_CODE)
#define SPI_PRIVATE_DATA                                 SPI_MULTI(SPI_59_INST, _PRIVATE_DATA)
#define SPI_PRIVATE_CONST                                SPI_MULTI(SPI_59_INST, _PRIVATE_CONST)
#define SPI_APPL_CODE                                    SPI_MULTI(SPI_59_INST, _APPL_CODE)
#define SPI_APPL_CONST                                   SPI_MULTI(SPI_59_INST, _APPL_CONST)
#define SPI_APPL_DATA                                    SPI_MULTI(SPI_59_INST, _APPL_DATA)
#define SPI_FAST_DATA                                    SPI_MULTI(SPI_59_INST, _FAST_DATA)
#define SPI_CODE_FAST                                    SPI_MULTI(SPI_59_INST, _CODE_FAST)
#define SPI_FAST_CONST                                   SPI_MULTI(SPI_59_INST, _FAST_CONST)
#define SPI_CONFIG_CONST                                 SPI_MULTI(SPI_59_INST, _CONFIG_CONST)
#define SPI_CONFIG_DATA                                  SPI_MULTI(SPI_59_INST, _CONFIG_DATA)
#define SPI_INIT_DATA                                    SPI_MULTI(SPI_59_INST, _INIT_DATA)
#define SPI_NOINIT_DATA                                  SPI_MULTI(SPI_59_INST, _NOINIT_DATA)
#define SPI_CONST                                        SPI_MULTI(SPI_59_INST, _CONST)
#define SPI_VAR                                          SPI_MULTI(SPI_59_INST, _VAR)
#define SPI_VAR_NOINIT                                   SPI_MULTI(SPI_59_INST, _VAR_NOINIT)

/* Define header file name */
#define SPI_MEMMAP_HEADER                                TO_STRING(SPI_MULTIINC(Spi_59_Inst, _MemMap))
#define SCHM_SPI_HEADER                                  TO_STRING(SPI_MULTIINC(SchM_Spi_59_Inst, ))
#define SPI_CFG_HEADER                                   TO_STRING(SPI_MULTIINC(Spi_59_Inst, _Cfg))

#define SPI_59_INST0_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST0_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST0_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST0_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST0_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST1_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST1_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST1_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST1_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST1_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST2_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST2_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST2_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST2_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST2_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST3_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST3_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST3_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST3_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST3_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST4_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST4_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST4_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST4_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST4_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST5_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST5_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST5_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST5_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST5_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST6_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST6_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST6_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST6_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST6_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST7_PBTYPES_AR_RELEASE_MAJOR_VERSION    SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST7_PBTYPES_AR_RELEASE_MINOR_VERSION    SPI_PBTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST7_PBTYPES_AR_RELEASE_REVISION_VERSION SPI_PBTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST7_PBTYPES_SW_MAJOR_VERSION            SPI_PBTYPES_SW_MAJOR_VERSION
#define SPI_59_INST7_PBTYPES_SW_MINOR_VERSION            SPI_PBTYPES_SW_MINOR_VERSION

#define SPI_59_INST0_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST0_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST0_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST0_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST0_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#define SPI_59_INST1_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST1_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST1_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST1_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST1_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#define SPI_59_INST2_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST2_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST2_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST2_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST2_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#define SPI_59_INST3_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST3_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST3_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST3_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST3_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#define SPI_59_INST4_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST4_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST4_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST4_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST4_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#define SPI_59_INST5_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST5_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST5_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST5_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST5_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#define SPI_59_INST6_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST6_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST6_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST6_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST6_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#define SPI_59_INST7_LTTYPES_AR_RELEASE_MAJOR_VERSION    SPI_LTTYPES_AR_RELEASE_MAJOR_VERSION
#define SPI_59_INST7_LTTYPES_AR_RELEASE_MINOR_VERSION    SPI_LTTYPES_AR_RELEASE_MINOR_VERSION
#define SPI_59_INST7_LTTYPES_AR_RELEASE_REVISION_VERSION SPI_LTTYPES_AR_RELEASE_REVISION_VERSION
#define SPI_59_INST7_LTTYPES_SW_MAJOR_VERSION            SPI_LTTYPES_SW_MAJOR_VERSION
#define SPI_59_INST7_LTTYPES_SW_MINOR_VERSION            SPI_LTTYPES_SW_MINOR_VERSION

#else /* end of defined(SPI_USE_MULTIINSTANCE)*/
#define SPI_MEMMAP_HEADER "Spi_MemMap.h"
#define SCHM_SPI_HEADER   "SchM_Spi.h"
#define SPI_CFG_HEADER    "Spi_Cfg.h"
#endif
#endif /* end of SPI_MULTIINSTANCE_HEADER*/

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
