/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_HSPI_LLDriver.h                                                                                 */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains the type definitions for link time parameters                                                   */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/* 1.4.3:  10/05/2022  : Remove redundant macro
 * 1.4.2:  02/03/2022  : Merge QAC
 * 1.3.2:  06/09/2021  : Update QAC contents
 *         04/09/2021  : Add pre-compile condition for defining multiple files base on instance index
 *                       Replace the inclusion of Spi_MemMap.h with Spi_Mapping.h
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 *         07/05/2021  : Change extern const Spi_HSPIRegisterSetType Spi_GaaHSPIRegs[]
 *                       to extern CONST (Spi_HSPIRegisterSetType, SPI_CONFIG_DATA) Spi_GaaHSPIRegs[];
 * 1.2.0:  30/07/2020  : Release
 *         28/07/2020  : Add QAC 9.3.1 comment.
 * 1.1.0:  19/06/2020  : Release
 * 1.0.1:  21/05/2020  : Update QAC warning and MISRA-C Rule violation
 * 1.0.0:  24/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3472)    : All toplevel uses of this function-like macro look like they could be replaced by            */
/*                       equivalent function calls.                                                                   */
/* Rule                : MISRA C:2012 Dir-4.9                                                                         */
/* JV-01 Justification : This message indicates that a candidate macro may be suitable for replacement by a           */
/*                       function, based on an actual call-site and the arguments passed to it there                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3630)    : The implementation of this struct/union type should be hidden.                               */
/* Rule                : MISRA C:2012 Dir-4.8                                                                         */
/* JV-01 Justification : This is accepted. Redundant of struct or union type has no affect to driver operation.       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3684)    : Array declared with unknown size.                                                            */
/* Rule                : CERTCCM ARR02, MISRA C:2012 Rule-8.11                                                        */
/* JV-01 Justification : Arrays used are verified in the file which are only declarations and size is configuration   */
/*                       dependent.                                                                                   */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

#ifdef SPI_INSTANCE_INDEX
    #if (SPI_INSTANCE_INDEX == 0)
        #ifndef SPI_59_INST0_HSPI_LLDRIVER_H
            #define SPI_59_INST0_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 1)
        #ifndef SPI_59_INST1_HSPI_LLDRIVER_H
            #define SPI_59_INST1_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 2)
        #ifndef SPI_59_INST2_HSPI_LLDRIVER_H
            #define SPI_59_INST2_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 3)
        #ifndef SPI_59_INST3_HSPI_LLDRIVER_H
            #define SPI_59_INST3_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 4)
        #ifndef SPI_59_INST4_HSPI_LLDRIVER_H
            #define SPI_59_INST4_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 5)
        #ifndef SPI_59_INST5_HSPI_LLDRIVER_H
            #define SPI_59_INST5_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 6)
        #ifndef SPI_59_INST6_HSPI_LLDRIVER_H
            #define SPI_59_INST6_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #elif (SPI_INSTANCE_INDEX == 7)
        #ifndef SPI_59_INST7_HSPI_LLDRIVER_H
            #define SPI_59_INST7_HSPI_LLDRIVER_H
            #define SPI_HSPI_LLDRIVER_HEADER
        #endif
    #else
        #error "Miss instance index"
    #endif
#else
    #ifndef SPI_HSPI_LLDRIVER_H
        #define SPI_HSPI_LLDRIVER_H
        #define SPI_HSPI_LLDRIVER_HEADER
    #endif
#endif

#ifdef SPI_HSPI_LLDRIVER_HEADER
#undef SPI_HSPI_LLDRIVER_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR Release version information */
#define SPI_HSPI_LLDRIVER_AR_RELEASE_MAJOR_VERSION    SPI_AR_RELEASE_MAJOR_VERSION
#define SPI_HSPI_LLDRIVER_AR_RELEASE_MINOR_VERSION    SPI_AR_RELEASE_MINOR_VERSION
#define SPI_HSPI_LLDRIVER_AR_RELEASE_REVISION_VERSION SPI_AR_RELEASE_REVISION_VERSION

/* File version information */
#define SPI_HSPI_LLDRIVER_SW_MAJOR_VERSION            SPI_SW_MAJOR_VERSION
#define SPI_HSPI_LLDRIVER_SW_MINOR_VERSION            SPI_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* HSPInCKEN */
#define SPI_HSPI_CKEN                                 0x00000001UL

/* HSPInSRST */
#define SPI_HSPI_SRST                                 0x00000001UL

/* HSPInEN */
#define SPI_HSPI_EN                                   0x00000001UL

/* HSPInMD */
#define SPI_HSPI_FLEN(x)                              ((uint32)(x) << 16U)                                              /* PRQA S 3472 # JV-01 */

/* HSPInCTL */
#define SPI_HSPI_LSBEN_LSB                            0x00100000UL

/* HSPInSSCTL */
#define SPI_HSPI_SS0P_LOW                             0x00U
#define SPI_HSPI_SS0P_HIGH                            0x01U

/* HSPInIREN */
#define SPI_HSPI_BEE                                  0x00000020UL
#define SPI_HSPI_ROVFEE                               0x00000008UL
#define SPI_HSPI_TUDREE                               0x00000004UL
#define SPI_HSPI_CENDE                                0x00000001UL

/* HSPInIRST */
#define SPI_HSPI_BEF                                  0x00000020UL
#define SPI_HSPI_PEF                                  0x00000010UL
#define SPI_HSPI_ROVFEF                               0x00000008UL
#define SPI_HSPI_TUDREF                               0x00000004UL
#define SPI_HSPI_CENDF                                0x00000001UL

/* HSPInIRCL */
#define SPI_HSPI_BEC                                  0x00000020UL
#define SPI_HSPI_PEC                                  0x00000010UL
#define SPI_HSPI_ROVFEC                               0x00000008UL
#define SPI_HSPI_TUDREC                               0x00000004UL
#define SPI_HSPI_CSTAC                                0x00000002UL
#define SPI_HSPI_CENDC                                0x00000001UL

/* HSPInACTST */
#define SPI_HSPI_ACTF                                 0x00000001UL

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
/* IO mapping structure for HSPI registers */
typedef struct STag_Spi_HSPIRegType                                                                                     /* PRQA S 3630 # JV-01 */
{
  uint32 ulCKEN;        /* +00H CKEN        */
  uint32 ulSRST;        /* +04H SRST        */
  uint32 ulEN;          /* +08H EN          */
  uint32 ulMD;          /* +0CH MD          */
  uint32 ulCTL;         /* +10H CTL         */
  uint32 ulSSCTL;       /* +14H SSCTL       */
  uint32 ulSCKDLY;      /* +18H SCKDLY      */
  uint32 ulSSNDLY;      /* +1CH SSNDLY      */
  uint32 ulNFMDLY;      /* +20H NFMDLY      */
  uint32 ulSPLDLY;      /* +24H SPLDLY      */
  uint32 ulCDIV;        /* +28H CDIV        */
  uint32 ulTSAR;        /* +2CH TSAR        */
  uint32 ulRDAR;        /* +30H RDAR        */
  uint32 ulCFSET;       /* +34H CFSET       */
  uint32 ulIREN;        /* +38H IREN        */
  uint32 ulIRST;        /* +3CH IRST        */
  uint32 ulIRCL;        /* +40H IRCL        */
  uint32 ulACTST;       /* +44H ACTST       */
  uint32 ulCTFM;        /* +48H CTFM        */
  uint32 ulCRFM;        /* +4CH CRFM        */
  uint32 ulVPEN;        /* +50H VPEN        */
  uint32 aaReserved[6]; /* Reserved         */
  uint32 ulTESTMD;      /* +6CH TESTMD      */
} Spi_HSPIRegType;

/* Structure for the register information for each HSPI unit */
typedef struct STag_Spi_HSPIRegisterSetType
{
  /* Base address of HSPI registers */
  volatile P2VAR(Spi_HSPIRegType, TYPEDEF, REGSPACE) pRegs;                                                             /* PRQA S 3432 # JV-01 */
  /* EIC register address for HSPInCEND interrupt */
  volatile P2VAR(uint16, TYPEDEF, REGSPACE) pICCEND;                                                                    /* PRQA S 3432 # JV-01 */
  /* EIC register address for HSPInERR interrupt */
  volatile P2VAR(uint16, TYPEDEF, REGSPACE) pICERR;                                                                     /* PRQA S 3432 # JV-01 */
  /* EIC register address for HSPInBERR interrupt */
  volatile P2VAR(uint16, TYPEDEF, REGSPACE) pICBERR;                                                                    /* PRQA S 3432 # JV-01 */
} Spi_HSPIRegisterSetType;

/* Structure for HW-dependent device configuration */
typedef struct STag_Spi_HSPIDeviceConfigType
{
  /* Value of HSPInMD register except FLEN field */
  uint32 ulHSPIMD;
  /* Value of HSPInCTL register except LSBEN field */
  uint32 ulHSPICTL;
  /* Value of HSPInSSCTL register */
  uint8 ucHSPISSCTL;
  /* Value of HSPInSCKDLY register */
  uint8 ucHSPISCKDLY;
  /* Value of HSPInSSNDLY register */
  uint8 ucHSPISSNDLY;
  /* Value of HSPInNFMDLY register */
  uint8 ucHSPINFMDLY;
  /* Value of HSPInSPLDLY register */
  uint16 usHSPISPLDLY;
  /* Value of HSPInCDIV register */
  uint8 ucHSPICDIV;
} Spi_HSPIDeviceConfigType;

#define SPI_START_SEC_CONST_UNSPECIFIED
#include "Spi_Mapping.h"

extern CONST(Spi_HSPIRegisterSetType, SPI_CONFIG_DATA) Spi_GaaHSPIRegs[];                                               /* PRQA S 3684 # JV-01 */

/* HW-dependent function pointer table */
extern CONST(Spi_HwFuncTableType, SPI_CONST) Spi_GstHSPIFunc;

#define SPI_STOP_SEC_CONST_UNSPECIFIED
#include "Spi_Mapping.h"

#if (SPI_MAX_HSPI_CHANNEL_BUFFER_SIZE > 0U)
#define SPI_START_SEC_VAR_NO_INIT_64
#include "Spi_Mapping.h"
/* Channel buffer for HS-SPI. This buffer should be aligned to 8byte regardless access size */
extern volatile VAR(uint32, SPI_VAR_NO_INIT)
    Spi_GaaHSPIChannelBuffer[SPI_MAX_HSPI_CHANNEL_BUFFER_SIZE / sizeof(uint32)];
#define SPI_STOP_SEC_VAR_NO_INIT_64
#include "Spi_Mapping.h"
#endif

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define SPI_START_SEC_PRIVATE_CODE
#include "Spi_Mapping.h"

#if (SPI_HSPI_CONFIGURED == STD_ON)
#if ((SPI_LEVEL_DELIVERED == SPI_LEVEL_1) || (SPI_LEVEL_DELIVERED == SPI_LEVEL_2))
extern FUNC(void, SPI_PRIVATE_CODE) Spi_HSPIComEndISR(const uint32 LulHWUnitIndex);
extern FUNC(void, SPI_PRIVATE_CODE) Spi_HSPIErrorISR(const uint32 LulHWUnitIndex);
#endif
#endif /* (SPI_HSPI_CONFIGURED == STD_ON) */

#define SPI_STOP_SEC_PRIVATE_CODE
#include "Spi_Mapping.h"

#endif /* SPI_HSPI_LLDRIVER_H */
/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
