#ifndef CAN_CH1_TX_MATRIX_H__
#define CAN_CH1_TX_MATRIX_H__

#include "CAN_Message_Types.h"
/******************************************************************************
Identifier  :  0x276
Signals     :  ICU_STS
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {
        uint32_t  BSI_ANNEE_HORLOGE                     :  7;
        uint32_t                                        :  1; 
        
        uint32_t  BSI_MOIS_HORLOGE                      :  4; 
        uint32_t                                        :  4; 

        uint32_t  BSI_JOUR_HORLOGE                      :  6; 
        uint32_t                                        :  2; 

        uint32_t  BSI_HEURE_HORLOGE                     :  5; 
        uint32_t                                        :  3; 
        
        uint32_t  BSI_MINUTE_HORLOGE                    :  6; 
        uint32_t                                        :  2; 

        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;

    } Sig;
} CANMsg276UnionE;

/******************************************************************************
Identifier  :  0x350
Signals     :  ICU_STS

******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {
        uint32_t  BSI_TYPAGE                             :  2;//    Bit 00 - 01: TYPAGE
        uint32_t  BSI_DMD_AC                             :  2;//     Bit 02-03 ：DMD_AC 
        uint32_t  BSI_DMD_VISI                           :  1;//   DMD_VISI  
        uint32_t                                         :  3;  
    
        uint32_t                                         :  8;
        uint32_t                                         :  8;  
   
        uint32_t  BSI_VAL_CONS_TEMP_AVG                  :  5; //VAL_CONS_TEMP_AVG   
        uint32_t                                         :  3; 
                  
        uint32_t  BSI_VAL_CONS_TEMP_AVD                  :  5; //VAL_CONS_TEMP_AVD   
        uint32_t                                         :  3; 
                  
        uint32_t  BSI_PULS_AV                            :  4;//PULS_AV 空调开关信号  标致车厂群内报告bug 暂时未知350信号整体错误还是，空调开关信号错误
        uint32_t  BSI_ENTREE_AIR                         :  4;//ENTREE_AIR
                  
        uint32_t  BSI_DISTRIBUTION_AVD                   :  4;// DISTRIBUTION_AVD 
        uint32_t  BSI_DISTRIBUTION_AVG                   :  4;// DISTRIBUTION_AVG 

        uint32_t                                         :  8;

    } Sig;
} CANMsg350UnionE;

/******************************************************************************
Identifier  :  0x3F1
Signals     :  IC1

******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {
        uint32_t                                         :  1; 
        uint32_t        IC_Mileage1restart               :  1; 
        uint32_t        IC_Mileage2restart               :  1;//    
        uint32_t        ABAV_Req                         :  1; 
        uint32_t                                         :  2; 
        uint32_t        Charge_plug_unlock_req           :  2; 
       
        uint32_t        REO_REGEN_LEVEL                  :  3;
        uint32_t        REQ_ECO_LEVEL                    :  3;        
        uint32_t                                         :  2;  

        uint32_t                                         :  8;      
        uint32_t                                         :  8;      
        uint32_t      DISTANCE_TRAJET1_H_E               :  8;
        uint32_t      DISTANCE_TRAJET1_L_E               :  8;        
        uint32_t      DISTANCE_TRAJET2_H_E               :  8;        
        uint32_t      DISTANCE_TRAJET2_L_E               :  8;

    } Sig;
} CANMsg3F1UnionE;

/******************************************************************************
Identifier  :  0x190
Signals     :  ICU_STS
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {       
        uint32_t  BSI_TEMP_SONDE_EVAPOL                 :  8;
        uint32_t  BSI_TEMP_SONDE_EVAPOH                 :  8;
        uint32_t                                        :  8; 
        uint32_t                                        :  8; 
        uint32_t                                        :  8; 
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
    } Sig;
} CANMsg190UnionE;

/******************************************************************************
Identifier  :  0x0F6
Signals     :  ICU_STS
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
        struct
    {       
        uint32_t                                        :  8; 
        uint32_t                                        :  8; 
        
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        
        uint32_t                                        :  8; 
        uint32_t                                        :  8;
        uint32_t  BSI_T_EXT                             :  8;
        uint32_t                                        :  8;
    } Sig;
} CANMsg0F6UnionE;

/******************************************************************************
Identifier  :  0x128
Signals     :  ICU_STS
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
        struct
    {       
        uint32_t                                        :  8; 
        uint32_t                                        :  8; 
        
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        
        uint32_t                                        :  8; 
        
        uint32_t                                        :  4;
        uint32_t  BSI_OUCP                              :  1;
        uint32_t                                        :  1;
        uint32_t  BSI_OUCC                              :  1;
        uint32_t                                        :  1;

        uint32_t                                        :  8;
        
        uint32_t                                        :  8;
    } Sig;
} CANMsg128UnionE;
/******************************************************************************
Identifier  :  0x00e
Signals     :  ETAT_CONDA
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {       
        uint32_t                                        :  1; 
        uint32_t          HAB_ETAT_CONDA                :  3;
        uint32_t                                        :  4;
        
        uint32_t                                        :  8;        
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;        
    } Sig;
} CANMsg00EUnionE;
/******************************************************************************
Identifier  :  0x137
Signals     :  EGS
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {       
        uint32_t                                        :  3; 
        uint32_t      EGS_Fault                         :  1;
        uint32_t                                        :  4;
        
        uint32_t                                        :  8;
        uint32_t                                        :  8;        
        uint32_t                                        :  8; 
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;        
    } Sig;
} CANMsg137UnionE;
/******************************************************************************
Identifier  :  0x036
Signals     :  PHASE_VIE  //8.21
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {       
        
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;

        uint32_t               PHASE_VIE                :  3; /*bug32337,转发到高速CAN应与低速CAN字节位相同*/
        uint32_t                                        :  4;
        uint32_t                                        :  1;

        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;        
    } Sig;
} CANMsg036UnionE;
/******************************************************************************
Identifier  :  0x294
Signals     :  REMOTE_LOCK_UNLOCK_STAT  //8.21
Signals     :  HORN_STATUS
Signals     :  TURN_LIGHTS_STATUS
******************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {       
        
        uint32_t                                        :  1;
        uint32_t       REMOTE_LOCK_UNLOCK_STAT          :  3;
        uint32_t       HORN_STATUS                      :  1;
        uint32_t       TURN_LIGHTS_STATUS               :  1;
        uint32_t                                        :  2;

        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;
        uint32_t                                        :  8;


    } Sig;
} CANMsg294UnionE;

#endif
