/*******************************************************************************
* Warranty Disclaimer :
*
* Because the Product(s) is licensed free of charge, there is no warranty of
* any kind whatsoever and expressly disclaimed and excluded by Renesas, either
* expressed or implied, including but not limited to those for non-infringement
* of intellectual property, merchantability and/or fitness for the particular
* purpose. Renesas shall not have any obligation to maintain, service or provide
* bug fixes for the supplied Product(s) and/or the Application.
*
* Each User is solely responsible for determining the appropriateness of using
* the Product(s) and assumes all risks associated with its exercise of rights
* under this Agreement, including, but not limited to the risks and costs of
* program errors, compliance with applicable laws, damage to or loss of data,
* programs or equipment, and unavailability or interruption of operations.
*
* Limitation of Liability :
*
* In no event shall Renesas be liable to the User for any incidental,
* consequential, indirect, or punitive damage (including but not limited to
* lost profits) regardless of whether such liability is based on breach of 
* contract, tort, strict liability, breach of warranties, failure of essential
* purpose or otherwise and even if advised of the possibility of such damages.
* Renesas shall not be liable for any services or products provided by third
* party vendors, developers or consultants identified or referred to the User
* by Renesas in connection with the Product(s) and/or the Application.
*
* Copyright (C) 2019 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* File Name	    : main.c
* Version	    : 0.01
* Device(s) 	: RH850/U2A
* Description	: This is the main tutorial code.
********************************************************************************
* History : DD.MM.YYYY Version Description
* : 04.26.2019 0.01 First Release
*******************************************************************************/

/*******************************************************************************
header include
*******************************************************************************/
#include "device.h"
#include "App_Mcal.h"
#include "Mcu.h"

/*******************************************************************************
Macro definitions
*******************************************************************************/

/*******************************************************************************
Imported global variables and functions (from other files)
*******************************************************************************/
Std_VersionInfoType           VersionInfo;
volatile uint8                GucIntCount;
volatile Std_ReturnType       GenIsTestSuccess;


/*******************************************************************************
Exported global variables and functions (to be accessed by other files)
*******************************************************************************/
/* Functions */
void main_pe0(void);
void main_pe1(void);
unsigned long GetPEID(void);
void Reg_Init(void);
void Mcu_EcmNotification(uint16 EcmErrorNum);
/*******************************************************************************
* Outline      : Main processing
* Header       : 
* Function name: int main (void)
* Description  : Main function base
* Arguments    : none
* Return Value : none
*******************************************************************************/
int main()
{
    unsigned int PE_ID;
	uint32 LucIntCount;
  
	// Reg_Init();

    PE_ID = GetPEID() ;

	switch(PE_ID)
	{
	    case 0:
			main_pe0() ;
			break ;

	    case 1:
			main_pe1() ;
			break ;
	}

	return 0;
}

/*******************************************************************************
* Outline      : Get PEID routine
* Header       : -
* Function name: unsigned long GetPEID (void)
* Description  : PEID getting.
* Arguments    : none
* Return Value : PEID(unsigned long __t)
*******************************************************************************/
unsigned long GetPEID(){
    unsigned long	__t;

    __t= (__STSR( 0, 2)) & 0x00000007;

    return __t;
}

void Mcu_EcmNotification(uint16 EcmErrorNum){
}

void Reg_Init(){
  volatile uint16 *pIcrReg;
  uint32 LulCount;
  
  pIcrReg = (volatile uint16 *)(MCU_ICR_REG_ADDR);
  
  for (LulCount = 0; LulCount < MCU_ICR_REG_NUM; LulCount++)
  {
     *pIcrReg = (uint16)MCU_EIC_REG_VALUE;
     pIcrReg++;
  }

  /* ECM ERROR Clear */
  {
    /* Register Protection Disable */
    MCU_ECMKCPROT = MCU_ECM_ENABLE_WRITE_ACCESS_VALUE;
    
    for (LulCount = MCU_ZERO; LulCount<MCU_TEN; LulCount++)
    {
      *(volatile uint32 *)(MCU_ECM_ECMESSTCn_ADDRESS+(0x4*LulCount)) = 
                                                                     0xFFFFFFFF;
    }
    
    /* Register Protection Enable */
    MCU_ECMKCPROT = MCU_ECM_DISABLE_WRITE_ACCESS_VALUE;
  }
}

/*-----<End of main.c>--------------------------------------------------------*/
