/*============================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                         */
/* Module       = EthIf_Cbk.h                                                 */
/* SW-VERSION   = 1.6.0                                                       */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) 2017-2021 Renesas Electronics Corporation. All rights reserved.   */
/*============================================================================*/
/* Purpose:                                                                   */
/* This file is a stub for EthIf Component                                    */
/*                                                                            */
/*============================================================================*/
/*                                                                            */
/* Unless otherwise agreed upon in writing between your company and           */
/* Renesas Electronics Corporation the following shall apply!                 */
/*                                                                            */
/* Warranty Disclaimer                                                        */
/*                                                                            */
/* There is no warranty of any kind whatsoever granted by Renesas. Any        */
/* warranty is expressly disclaimed and excluded by Renesas, either expressed */
/* or implied, including but not limited to those for non-infringement of     */
/* intellectual property, merchantability and/or fitness for the particular   */
/* purpose.                                                                   */
/*                                                                            */
/* Renesas shall not have any obligation to maintain, service or provide bug  */
/* fixes for the supplied Product(s) and/or the Application.                  */
/*                                                                            */
/* Each User is solely responsible for determining the appropriateness of     */
/* using the Product(s) and assumes all risks associated with its exercise    */
/* of rights under this Agreement, including, but not limited to the risks    */
/* and costs of program errors, compliance with applicable laws, damage to    */
/* or loss of data, programs or equipment, and unavailability or              */
/* interruption of operations.                                                */
/*                                                                            */
/* Limitation of Liability                                                    */
/*                                                                            */
/* In no event shall Renesas be liable to the User for any incidental,        */
/* consequential, indirect, or punitive damage (including but not limited     */
/* to lost profits) regardless of whether such liability is based on breach   */
/* of contract, tort, strict liability, breach of warranties, failure of      */
/* essential purpose or otherwise and even if advised of the possibility of   */
/* such damages. Renesas shall not be liable for any services or products     */
/* provided by third party vendors, developers or consultants identified or   */
/* referred to the User by Renesas in connection with the Product(s) and/or   */
/* the Application.                                                           */
/*                                                                            */
/*============================================================================*/
/* Environment:                                                               */
/*              Devices:        X2x                                           */
/*============================================================================*/

/*******************************************************************************
**                      Revision History                                      **
*******************************************************************************/
/*
 * 1.5.0: 07/10/2021    : Add the include file for Eth.h.
 * 1.3.1: 01/04/2021    : Remove vendor ID from the file name, API names
 *                        and parameters according to BSW00347 requirement
 * 1.2.0: 19/08/2020    : Release
 *        19/08/2020    : Added missing argument in EthIf_TxConfirmation().
 * 1.1.0: 19/06/2020    : Release
 * 1.0.1: 16/03/2020    : Updated Eth 2 channel.
 * 1.0.0: 23/03/2017    : Initial Version.
 */

#ifndef ETHIF_CBK_H
#define ETHIF_CBK_H
/*******************************************************************************
**                      Include Section                                       **
*******************************************************************************/
/* Eth Driver Header File */
#include "EthIf_Types.h"
#include "Eth.h"

/*******************************************************************************
**                      Version Information                                   **
*******************************************************************************/

/*******************************************************************************
**                      Global Symbols                                        **
*******************************************************************************/
/* The instances are declared in the sample program */
extern volatile uint8 GaaRxEthFrame[2][1522];
extern volatile uint8 GaaRxSrcAddr[2][6];
extern volatile Eth_FrameType GusRxFrameType[2];
extern volatile uint16 GusRxLenByte[2];
extern volatile uint16 GusRxFrameCnt[2];
extern volatile uint8 GucTxConfirmed[2];
extern volatile uint16 GusMsgLength[2];

#if (ETH_GLOBAL_TIME_SUPPORT == STD_ON)
extern Eth_TimeStampQualType TxTimeQual;
extern Eth_TimeStampType TxTimeStamp[2];
#endif
extern volatile uint8 EthPassedCount[70];
extern volatile uint8 EthCheckCount;

#define ETH_PASSED                    1
/*******************************************************************************
**                      Global Data Types                                     **
*******************************************************************************/

/*******************************************************************************
**                      Function Prototypes                                   **
*******************************************************************************/

/* RxIndication event referring to a Ethernet Network */
extern void EthIf_RxIndication(uint8 CtrlIdx,
                               Eth_FrameType FrameType,
                               boolean IsBroadcast,
                               const uint8* PhysAddrPtr,
                               const Eth_DataType* DataPtr,
                               uint16 LenByte);

/* TxConfirmaton event referring to a Ethernet Network */
extern void EthIf_TxConfirmation(uint8 CtrlIdx, Eth_BufIdxType BufIdx, Std_ReturnType Result);

/*Called asynchronously when mode has been read out.
 Triggered by previous Eth_SetControllerMode call.
 Can directly be called within the trigger functions. */
extern void EthIf_CtrlModeIndication(uint8 CtrlIdx, Eth_ModeType CtrlMode);

#endif /* ETHIF_CBK_H */

/*******************************************************************************
**                      End of File                                           **
*******************************************************************************/
