// #include "RTE_GPIO.h"
#include "RTE_CAN.h"
#include "Rscan.h"
// #include "dr7f701401.dvf.h"
#include "RSCAN_Table.h"
#include "CAN_Lib.h"
// #include "UDS_ISO14229_Server.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "CAN_CH1_CAN_Communication_Matrix.h"
#include "CAN_CH2_CAN_Communication_Matrix.h"
// #include "UDS_DTC.h"
#include "Can.h"
static uint16_t Can_Init_Lock = 0U;

void Can_Lock_Clr(void)
{
    Can_Init_Lock = 0u;
}

/***Middle***/
void Can_Init1(void)
{
    /* filter 变量声明 */

    uint32_t i;
    // B_CANEN_OUT   = 1u;
    // B_CANSTB_OUT  = 1u;

    // B_CANEN2_OUT  = 1u;
    // B_CANSTB2_OUT = 1u;
    
    // C_CANSTB_OUT  = 0u;
    
    if ( Can_Init_Lock != 0x55AAu )
    {

        RSCAN0_Config_st_t loc_can = {0};

        loc_can.stRSCANCh0.u32RSCANChEn            = 1U;
        loc_can.stRSCANCh0.enRSCANChBps            = RSCAN_Baud_Rate_125K;
        loc_can.stRSCANCh0.u32RSCANChRuleSize      = CANFD0_CH0_RX_RULE_SIZE;
        loc_can.stRSCANCh0.pfnRSCANConfirmCallBack = Can0_Confirm;
        loc_can.stRSCANCh0.pfnRSCANReadMsgCallBack = Can0_Read_Msg;

        loc_can.stRSCANCh1.u32RSCANChEn            = 1U;
        loc_can.stRSCANCh1.enRSCANChBps            = RSCAN_Baud_Rate_125K;
        loc_can.stRSCANCh1.u32RSCANChRuleSize      = CANFD0_CH1_RX_RULE_SIZE;
        loc_can.stRSCANCh1.pfnRSCANConfirmCallBack = Can1_Confirm;
        loc_can.stRSCANCh1.pfnRSCANReadMsgCallBack = Can1_Read_Msg;

        loc_can.stRSCANCh2.u32RSCANChEn            = 1U;
        loc_can.stRSCANCh2.enRSCANChBps            = RSCAN_Baud_Rate_500K;
        loc_can.stRSCANCh2.u32RSCANChRuleSize      = CANFD0_CH2_RX_RULE_SIZE;
        loc_can.stRSCANCh2.pfnRSCANConfirmCallBack = Can2_Confirm;
        loc_can.stRSCANCh2.pfnRSCANReadMsgCallBack = Can2_Read_Msg;
        RSCAN0_CH_Init(CANFD_RX_RULE_TABLE_LIST, &loc_can);
        Can_Init_Lock = 0x55AAu;
    }

}


typedef struct
{
    uint8_t CH0_APP_Disable[CAN_CH0_ID_SEND_TOTAL];
    uint8_t CH1_APP_Disable[CAN_CH1_ID_SEND_TOTAL];   
}CANSendCtrl_st_t;

CANSendCtrl_st_t    g_stCANSendCtrl;


void CAN_CH0_Send_Disable_Set(uint16_t u16SendID,uint8_t u8Off)
{/* 0:enble   1:Disable */
    g_stCANSendCtrl.CH0_APP_Disable[u16SendID] = u8Off;
}

uint8_t CAN_CH0_Send_Disable_Get(uint16_t u16SendID,uint8_t u8Off)
{/* 0:enble   1:Disable */
    return g_stCANSendCtrl.CH0_APP_Disable[u16SendID];
}

void CAN_CH1_Send_Disable_Set(uint16_t u16SendID,uint8_t u8Off)
{/* 0:enble   1:Disable */
    g_stCANSendCtrl.CH1_APP_Disable[u16SendID] = u8Off;
}

uint8_t CAN_CH1_Send_Disable_Get(uint16_t u16SendID,uint8_t u8Off)
{/* 0:enble   1:Disable */
    return g_stCANSendCtrl.CH1_APP_Disable[u16SendID];
}

void RTE_CAN_Send_Init(void)
{
    uint8_t i;

    for (i = 0;i < CAN_CH0_ID_SEND_TOTAL;i++)
    {
        g_stCANSendCtrl.CH0_APP_Disable[i] = 0;
    }

    for (i = 0;i < CAN_CH1_ID_SEND_TOTAL;i++)
    {
        g_stCANSendCtrl.CH1_APP_Disable[i] = 0;
    }    

}

uint8_t Can0_Write0(_CAN_Msg *Msg)
{
    Can_PduType LddCanPduType1;
    uint8_t GaaByteArrayTx01[8] = {0};
    
    // CAN_Frame_st_t loc_can;
    uint8_t        i      = 0;
    // loc_can.u32CANID      = Msg->MsgID;
    // loc_can.u8CANFrameIDE = 0;
    // loc_can.u8CANLEN      = Msg->MsgDLC;
    for ( i = 0; i < 8; i++ )
    {
        GaaByteArrayTx01 [ i ] = Msg->Msg [ i ];
    }
    // if (CAN_CH0_SendID_Convert(loc_can.u32CANID) != CAN_CH0_ID_SEND_TOTAL)
    // {
    //     if (g_stCANSendCtrl.CH0_APP_Disable[CAN_CH0_SendID_Convert(loc_can.u32CANID)] == 0)
    //     {
    //         RSCAN0_CH0_Set_TXBUF_Data(Msg->MsgPro, &loc_can);
    //     }
    // }
    // else
    // {
    //     RSCAN0_CH0_Set_TXBUF_Data(Msg->MsgPro, &loc_can);
    // }    
    

    // LucHthId = CanConf_CanHardwareObject_CanHardwareObject2;
    LddCanPduType1.length =  Msg->MsgDLC;
    LddCanPduType1.swPduHandle = 0x00;
    LddCanPduType1.id = Msg->MsgID;
    LddCanPduType1.sdu = &GaaByteArrayTx01[0];
    // App_GenReturnValue = 
    Can_Write(2, &LddCanPduType1);

    return 0;
}
uint8_t Can_CH1_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t loc_can;
    uint8_t        i      = 0;
    loc_can.u32CANID      = Msg->MsgID;
    loc_can.u8CANFrameIDE = 0;
    loc_can.u8CANLEN      = Msg->MsgDLC;
    for ( i = 0; i < 8; i++ )
    {
        loc_can.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }

    RSCAN0_CH1_Set_TXBUF_Data(Msg->MsgPro, &loc_can);

    return 0;
}




uint8_t Can_CH2_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t loc_can;
    uint8_t        i      = 0;
    loc_can.u32CANID      = Msg->MsgID;
    loc_can.u8CANFrameIDE = 0;
    loc_can.u8CANLEN      = Msg->MsgDLC;
    // for ( i = 0; i < 8; i++ )
    // {
    //     loc_can.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    // }    
    // if (CAN_CH1_SendID_Convert(loc_can.u32CANID) != CAN_CH1_ID_SEND_TOTAL)
    // {
    //     if (g_stCANSendCtrl.CH1_APP_Disable[CAN_CH1_SendID_Convert(loc_can.u32CANID)] == 0)
    //     {
    //         RSCAN0_CH2_Set_TXBUF_Data(Msg->MsgPro, &loc_can);
    //     }
    // }    
    // else
    // {
    //     RSCAN0_CH2_Set_TXBUF_Data(Msg->MsgPro, &loc_can);
    // }
    
    return 0;
}
void Can_Sleep_Fun(void)
{
}

void Can_SleepController_Fun(void)
{
}

void Can_Wakeup_Fun(void)
{
}

void Can_Uds_Abort(void)
{
    
}

void Can0_Abort_All(void)
{
    RSCAN0_CH0_Abort(0);
    RSCAN0_CH0_Abort(1);
    RSCAN0_CH0_Abort(2);
    RSCAN0_CH0_Abort(3);
    RSCAN0_CH0_Abort(4);
    RSCAN0_CH0_Abort(5);
    RSCAN0_CH0_Abort(6);
    RSCAN0_CH0_Abort(7);
    RSCAN0_CH0_Abort(8);
    RSCAN0_CH0_Abort(9);
}
void Can1_Abort_All(void)
{
    RSCAN0_CH1_Abort(0);
    RSCAN0_CH1_Abort(1);
    RSCAN0_CH1_Abort(2);
    RSCAN0_CH1_Abort(3);
    RSCAN0_CH1_Abort(4);
    RSCAN0_CH1_Abort(5);
    RSCAN0_CH1_Abort(6);
    RSCAN0_CH1_Abort(7);
    RSCAN0_CH1_Abort(8);
    RSCAN0_CH1_Abort(9);
    RSCAN0_CH1_Abort(10);
    RSCAN0_CH1_Abort(11);
}


/*****Lower  CH0*******/
void Can0_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{
    Co_Can_Buff_Set(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(m_id), m_dlc, m_Msg);
    
     //if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
     {
         //DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg,0);
     }
    // else
    // {
    //     APP_CAN_Data_Indication(m_id, m_dlc, m_Msg);
    // }
}

void Can0_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    
}

/*****Lower  CH1*******/

void Can1_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{
    Co_Can_Buff_Set(&CAN_CH2_CanMsgOp, Co_Can_ConvertSubID_CAN_CH2(m_id), m_dlc, m_Msg);
    //  if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
     {
         //DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg,1);
     }
    // else
    // {
    //     APP_CAN_Data_Indication(m_id, m_dlc, m_Msg);
    // }
}

void Can1_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    
}

/*****Lower  CH2*******/

void Can2_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{    
    Co_Can_Buff_Set(&CAN_CH1_CanMsgOp, Co_Can_ConvertSubID_CAN_CH1(m_id), m_dlc, m_Msg);
    // ReceivedMsg(m_id, m_dlc);
    // if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
    // {
    //     DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg,2);
    // }
    // else
    // {
    //     //APP_CAN_Data_Indication(m_id, m_dlc, m_Msg);
    // }

}

void Can2_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    uint32_t MSG_ID;
    MSG_ID = 0ul;
    switch ( Identifier )
    {
        case 1:
            ///DoCAN_L_Data_Confirm(&CAN2_TPParameter, CAN2_TPParameter.Diag_ID_Tx, TransferStatus);
            break;
        default:
            break;
    }
}

void CAN_BUSOFF_Recover(void)
{
    RSCAN0_CH0_Busoff_Recover( );
    RSCAN0_CH1_Busoff_Recover();
    RSCAN0_CH2_Busoff_Recover();
}
void test_can(uint32_t u32ID)
{
    uint8_t i = 0;
    _CAN_Msg  Msg_t;
    Msg_t.MsgID = u32ID;
    Msg_t.MsgDLC = 8;
    
    for ( i = 0; i < 8; i++ )
    {
        Msg_t.Msg [ i ] = 0;
    }
    Can0_Write0(&Msg_t);

}

