/*******************************************************************************
* Warranty Disclaimer :
*
* Because the Product(s) is licensed free of charge, there is no warranty of
* any kind whatsoever and expressly disclaimed and excluded by Renesas, either
* expressed or implied, including but not limited to those for non-infringement
* of intellectual property, merchantability and/or fitness for the particular
* purpose. Renesas shall not have any obligation to maintain, service or provide
* bug fixes for the supplied Product(s) and/or the Application.
*
* Each User is solely responsible for determining the appropriateness of using
* the Product(s) and assumes all risks associated with its exercise of rights
* under this Agreement, including, but not limited to the risks and costs of
* program errors, compliance with applicable laws, damage to or loss of data,
* programs or equipment, and unavailability or interruption of operations.
*
* Limitation of Liability :
*
* In no event shall Renesas be liable to the User for any incidental,
* consequential, indirect, or punitive damage (including but not limited to
* lost profits) regardless of whether such liability is based on breach of 
* contract, tort, strict liability, breach of warranties, failure of essential
* purpose or otherwise and even if advised of the possibility of such damages.
* Renesas shall not be liable for any services or products provided by third
* party vendors, developers or consultants identified or referred to the User
* by Renesas in connection with the Product(s) and/or the Application.
*
* Copyright (C) 2019 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/*******************************************************************************
* File Name	    : main_pe0.c
* Version	    : 0.01
* Device(s) 	: RH850/U2A
* Description	: This is the main_pe0 tutorial code.
********************************************************************************
* History : DD.MM.YYYY Version Description
* : 04.26.2019 0.01 First Release
*******************************************************************************/

/*******************************************************************************
header include
*******************************************************************************/

#include "init.h"
#include "Sys_Scheduler.h"
#include "Wdg_WDTB_LLDriver.h"
/*******************************************************************************
* Outline      : PE0 Main processing
* Header       : 
* Function name: void main_pe0 (void)
* Description  : PE0 main routine
* Arguments    : none
* Return Value : none
*******************************************************************************/
void delay(void);
void delay(void)
{
  uint32_t u32cnt;
  for (u32cnt = 0; u32cnt < 300000; u32cnt++)
  {
    ;
  }
}
void main_pe0()
{
  // (*((volatile uint8*)0xFF9A5000UL)) = 0xAC;
    // (*((volatile uint8*)0xff980c00UL)) = 0X00U;
    Port_Init(Port_Config);
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_HIGH);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_LOW);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_HIGH);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_LOW);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_HIGH);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_LOW);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_HIGH);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_HIGH);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_LOW);
    delay();
    // Dio_WriteChannel(DioConf_DioChannel_P24_13,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P24_12,STD_LOW);
    Dio_WriteChannel(DioConf_DioChannel_P04_09,STD_HIGH);
    Sys_Startup_Init();
    
    while(1)
    {
        Sys_Scheduling_Service();
        // Wdg_WDTBn_TriggerFunc();
        // (*((volatile uint8*)0xFF9A5000UL)) = 0xAC;//WDTBA_WDTE
    }
}


void MCU_RESET_CALLOUT(void)
{
    ASM_NOP();
}

/* Notification for channel0 */
void Pwm_Notification_PwmChannel(void)
{
// #ifdef USE_FREERUN_TIMER
//   GulTimerChannel1CountA = GulTimerChannel0CountB;
//   GulTimerChannel1CountB = PWM_OSTM0CNT;
// #endif
//   GulEdgeIntCount[0]++;
}

/* Notification for channel1 */
void Pwm_Notification_PwmChannel_001(void)
{
// #ifdef USE_FREERUN_TIMER
//   GulTimerChannel1CountA = GulTimerChannel0CountB;
//   GulTimerChannel1CountB = PWM_OSTM0CNT;
// #endif
//   GulEdgeIntCount[1]++;
}

void Icu_EdgeDetect_Notification(void)
{
    ASM_NOP();
}
void Icu_TimeStamps_Notification(void)
{
  /* Set flag to true to inform that the 5 timestamps have been captured */
  // GblTimestampsCaptured = TRUE;
}

void Icu_EdgeCount_Overflow_Notification(void)
{


}
void IoHwAb_Adc_ErrNotification_000(uint8 Lucchannel)
{
  /* Call the notification function */
}
void IoHwAb_Adc_ErrNotificationSG(uint8 Lucchannel)
{
  /* Call the notification function */
}
void IoHwAb_Adc_Notification_Group0(void)
{
  /* Call the notification function */
}
void IoHwAb_Adc_Notification_Group1(void)
{
  /* Call the notification function */
}
void IoHwAb_Adc_Notification_Group2(void)
{
  /* Call the notification function */
}
void IoHwAb_Adc_Notification_Group3(void)
{
  /* Call the notification function */
}


void SpiJob0Notification (void)
{
  /* No Action Required */
}

void SpiSequence0EndNotification (void)
{
  /* No Action Required */
}


void Big_Delay(void)
{
  volatile uint16 LuiCnt1 = 0;
  volatile uint16 LuiCnt2 = 0;

  while (LuiCnt1 < 100)
  {
    LuiCnt1++;
    while (LuiCnt2 < 10000)
    {
      LuiCnt2++;
    }
    LuiCnt2 = 0;
  }
}


#ifdef MCU_Deepstop_to_Run
//可能是休眠唤醒？
DISABLE_INTERRUPT();
 	  /* Invoke Mcu_SetMode with Deepstop MODE */
Mcu_SetMode(McuConf_McuModeSettingConf_McuModeSettingConf_DeepStop); 

#endif

#ifdef SPI_MODULE_SAMPLE
  
//测试SPI时将其放入任务中
  Dio_FlipChannel(DioConf_DioChannel_UserChannel_02_03);

 App_GenReturnValue = Spi_SetupEB(SpiConf_SpiChannel_SpiChannel, &App_GaaTransmitData0[0],&App_GaaReceiveData0[0],8);

 App_GenReturnValue = Spi_AsyncTransmit(SpiConf_SpiSequence_SpiSequence);  

   do
  {
  /* Get result of the specified sequence */
 App_GenSeqResult0 = Spi_GetSequenceResult(SpiConf_SpiSequence_SpiSequence);
    
  }while (SPI_SEQ_PENDING == App_GenSeqResult0); 

// Big_Delay();
// Big_Delay();



App_GenReturnValue = Spi_SetupEB(SpiConf_SpiChannel_SpiChannel_001, &App_GaaTransmitData1[0],&App_GaaReceiveData1[0],8);

App_GenReturnValue = Spi_AsyncTransmit(SpiConf_SpiSequence_SpiSequence_001);
// Dio_FlipChannel(DioConf_DioChannel_UserChannel_02_06);
  do
  {
 /* Get result of the specified sequence */
    App_GenSeqResult1 = Spi_GetSequenceResult(SpiConf_SpiSequence_SpiSequence_001);
  }while (SPI_SEQ_PENDING == App_GenSeqResult1);
#endif

/*-----<End of main_pe0.c>----------------------------------------------------*/
