
#ifndef _CAN_MESSAGE_TYPES_H_
#define _CAN_MESSAGE_TYPES_H_

#include "TYW_stdint.h"

#define   CAN_MSG_CYCLE                     0x00
#define   CAN_MSG_EVENT                     0x01
#define   CAN_MSG_EVENT_CYCLE               0x02

typedef enum
{
    CAN_MSG_ID_TYPE_STD = 0,
    CAN_MSG_ID_TYPE_EXT,
} CAN_Msg_ID_Type_en_t;

typedef enum
{
    CAN_MSG_DIR_RX = 0,
    CAN_MSG_DIR_TX,
} CAN_Msg_Dir_en_t;

typedef struct
{
    volatile uint8_t   *pMsg;
    volatile uint8_t   *pStatus;
    volatile uint8_t   *pRecordCnt;  //��¼���յĴ�����ѭ���������� ��¼�Ѿ����͵Ĵ���
    volatile uint8_t   *pReqCnt;     //�ⲿ���յĴ�����ѭ���������� �����͵Ĵ���
    volatile uint16_t  *pTimer;
    uint8_t             Init[8];
    uint8_t             TimeOut[8];
    uint8_t             Mask[8];
} CAN_Msg_Data_st_t;

typedef struct
{
  uint8_t ChildID;   //��ID
  uint8_t Index;     //��ID�����У�������
}CAN_Child_Msg_Map_t;

typedef struct
{
    uint32_t                   MsgID;          
    uint8_t                    pro;
    CAN_Msg_ID_Type_en_t       IDType;
    const CAN_Msg_Data_st_t   *pMsgData;
    uint8_t                    DLCMax;
    uint8_t                    DLCMin;
    CAN_Msg_Dir_en_t           Dir;
    uint8_t                    Type;         //��������(����/�¼�)
    uint16_t                   Cycle;
    uint16_t                   Offset;
    uint8_t                    NumofChild;
    const CAN_Child_Msg_Map_t *Map;
    void                       ( *pDataRdyCallbBack ) ( uint8_t Num );
} CAN_Msg_Attr_st_t;


typedef union
{
    uint8_t Byte;

    struct
    {
        uint8_t   Lost    : 1;
        uint8_t   Updt    : 1;
        uint8_t           : 5;
        uint8_t   TxEn    : 1;
    } Bit;
} CAN_Msg_Stat_un_t;
    
#define   CAN_MSG_STAT_BIT_TX_EN            0x80
#define   CAN_MSG_STAT_BIT_UPDATE           0x02
#define   CAN_MSG_STAT_BIT_MSG_LOST         0x01
#define   CAN_MSG_LOST  CAN_MSG_STAT_BIT_MSG_LOST
#define   CAN_UPDATE    CAN_MSG_STAT_BIT_UPDATE
#define   CAN_TX_EN     CAN_MSG_STAT_BIT_TX_EN
#endif

