/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_TAUJ_LLDriver.h                                                                                 */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020, 2021 Renesas Electronics Corporation. All rights reserved.                                               */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains Low level driver function prototypes of the ICU Driver                                          */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        U2A                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.1:  15/09/2021  : Rename TimerChannelConfig to ChannelUserRegConfig
 * 1.3.2:  30/08/2021  : Change from #include "Icu_MemMap.h" to #include "Icu_Mapping.h".
 *                       Update header file macro.
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.3.0:  20/01/2021  : Changed CONSTP2CONST to P2CONST for argument ConfigPtr
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_TAUJ_LLDRIVER_H
            #define ICU_59_INST0_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_TAUJ_LLDRIVER_H
            #define ICU_59_INST1_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_TAUJ_LLDRIVER_H
            #define ICU_59_INST2_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_TAUJ_LLDRIVER_H
            #define ICU_59_INST3_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_TAUJ_LLDRIVER_H
            #define ICU_59_INST4_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_TAUJ_LLDRIVER_H
            #define ICU_59_INST5_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_TAUJ_LLDRIVER_H
            #define ICU_59_INST6_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_TAUJ_LLDRIVER_H
            #define ICU_59_INST7_TAUJ_LLDRIVER_H
            #define ICU_TAUJ_LLDRIVER_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_TAUJ_LLDRIVER_H
        #define ICU_TAUJ_LLDRIVER_H
        #define ICU_TAUJ_LLDRIVER_HEADER
    #endif
#endif

#ifdef ICU_TAUJ_LLDRIVER_HEADER
#undef ICU_TAUJ_LLDRIVER_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

#include "Icu_TAUJ_PBTypes.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ICU_TAUJ_LLDRIVER_AR_RELEASE_MAJOR_VERSION    ICU_AR_RELEASE_MAJOR_VERSION
#define ICU_TAUJ_LLDRIVER_AR_RELEASE_MINOR_VERSION    ICU_AR_RELEASE_MINOR_VERSION
#define ICU_TAUJ_LLDRIVER_AR_RELEASE_REVISION_VERSION ICU_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ICU_TAUJ_LLDRIVER_SW_MAJOR_VERSION            ICU_SW_MAJOR_VERSION
#define ICU_TAUJ_LLDRIVER_SW_MINOR_VERSION            ICU_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#if (STD_ON == ICU_TAUJ_UNIT_USED)
#define ICU_START_SEC_PRIVATE_CODE
#include "Icu_Mapping.h"

#if (ICU_TIMESTAMP_API == STD_ON)
FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_TimestampInit
                             (P2CONST(Icu_ChannelUserRegConfigType, AUTOMATIC, ICU_CONFIG_DATA) LpChannelUserRegConfig);
#endif

#if (ICU_SIGNAL_MEASUREMENT_API == STD_ON)
FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_SignalMeasurementInit
                             (P2CONST(Icu_ChannelUserRegConfigType, AUTOMATIC, ICU_CONFIG_DATA) LpChannelUserRegConfig);
#endif

extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_UnitInit(P2CONST(Icu_ConfigType, AUTOMATIC, ICU_APPL_CONST) ConfigPtr);
    

extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_ChannelInit(const Icu_ChannelType LucChannelIndex);
    
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_SetActivation
                                             (const Icu_ChannelType LddChannel, const Icu_ActivationType LenActiveEdge);

#if (ICU_DE_INIT_API == STD_ON)
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_UnitDeInit(void);


extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_ChannelDeInit(const Icu_ChannelType LucChannelIndex);
#endif

#if ((ICU_TIMESTAMP_API == STD_ON) || (ICU_SIGNAL_MEASUREMENT_API == STD_ON))
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_StartCountMeasurement(const Icu_ChannelType LddChannel);

extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_StopCountMeasurement(const Icu_ChannelType LddChannel);
#endif

#if (ICU_GET_TAU_COUNT_VALUE_API == STD_ON)
extern FUNC(Icu_CounterValueType, ICU_PRIVATE_CODE) Icu_HW_Tauj_GetTAUInCountValue(const Icu_ChannelType LddChannel);
#endif

#if (ICU_SET_MODE_API == STD_ON)
extern FUNC(void, ICU_PRIVATE_CODE) Icu_HW_Tauj_SetMode(const Icu_ChannelType LucChannel, const Icu_ModeType LenMode);
#endif

#define ICU_STOP_SEC_PRIVATE_CODE
#include "Icu_Mapping.h"

#define ICU_START_SEC_CODE_FAST
#include "Icu_Mapping.h"

#if (ICU_SIGNAL_MEASUREMENT_API == STD_ON)
FUNC(void, ICU_CODE_FAST) Icu_HW_Tauj_ServiceSignalMeasurement(const Icu_ChannelType LddChannel);
#endif

#if (ICU_TIMESTAMP_API == STD_ON)
FUNC(void, ICU_CODE_FAST) Icu_HW_Tauj_ServiceTimestamp
                                               (const Icu_ChannelType LddChannel, const uint32 LulCapturedTimestampVal);
#endif

extern FUNC(void, ICU_CODE_FAST) Icu_HW_Tauj_TimerIsr(const Icu_ChannelType LddChannel);
    
#define ICU_STOP_SEC_CODE_FAST
#include "Icu_Mapping.h"

#endif /* End of ICU_TAUJ_UNIT_USED == STD_ON*/
#endif /* ICU_TAUJ_LLDRIVER_HEADER  */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
