/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_PBCfg.c                                                                                         */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains post-build time parameters.                                                                     */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  IcuU2x.dll version: 1.5.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Icu_Icu_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_ICU_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Icu.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Ecum\xml\Ecum_Icu.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  24 Apr 2025 - 19:49:56
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
#include "Icu_PBTypes.h"                                                                                                /* PRQA S 0857 # JV-01 */
#include "Icu_TAUD_Ram.h"
#include "Icu_PIN_PBTypes.h"
#include "Icu_PIN_Ram.h"



/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/**********************************************************************************************************************/
/* Message (2:0303)    : [I] Cast between a pointer to volatile object and an integral type.                          */
/* Rule                : CERTCCM INT36, MISRA C:2012 Rule-11.4                                                        */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0306)    : [I] Cast between a pointer to object and an integral type.                                   */
/* Rule                : MISRA-C:2012 Rule-11.4, CERTCMM INT36                                                        */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0314)    : Casting to different object pointer type.                                                    */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : Pointer to a void is a generic pointer type which can be use cast to any other pointer type. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0315)    : Implicit conversion from a pointer to object type to a pointer to void.                      */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : Pointer to a void is a generic pointer type which can be use cast to any other pointer type. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (7:0326)    : [I] Cast between a pointer to void and an integral type.                                     */
/* Rule                : MISRA C:2012 Rule-11.6, CERTCCM EXP36, INT36                                                 */
/* JV-01 Justification : Using void due to specific requirment of input parameter. So, this can be skipped            */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro is    */
/*                       over 1024                                                                                    */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1504)    : The object 'name' is only referenced in the translation unit where it is defined.            */
/* Rule                : MISRA-C:2012 Rule-8.7, CERTCCM DCL15, DCL19                                                  */
/* JV-01 Justification : This is accepted, due to following coding rule, internal function can be defined in other    */
/*                       C source files                                                                               */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object 'name' is referenced in only one translation unit - but not the one in which      */
/*                       it is defined.                                                                               */
/* Rule                : CERTCCM DCL15, CERTCCM DCL19, MISRA C:2012 Rule-8.7                                          */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in seperated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1533)    : The object 'entity' is only referenced by function 'func'.                                   */
/* Rule                : MISRA C:2012 Rule-8.9                                                                        */
/* JV-01 Justification : This is accepted, due to the object is defined in seperated cource C file to followed        */
/*                       coding rule                                                                                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3408)    : '%s' has external linkage and is being defined without any previous declaration.             */
/* Rule                : CERTCCM DCL07, MISRA C:2012 Rule-8.4                                                         */
/* JV-01 Justification : It is accepted, due to the declaration will be taken care by Os                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3432)    : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : #include statements in a file should only be preceded by other preprocessor                  */
/*                       directives or comments.                                                                      */
/* Rule                : MISRA-C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping ).      */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ICU_PBCFG_C_AR_RELEASE_MAJOR_VERSION                                    4U
#define ICU_PBCFG_C_AR_RELEASE_MINOR_VERSION                                    3U
#define ICU_PBCFG_C_AR_RELEASE_REVISION_VERSION                                 1U

/* File version information */
#define ICU_PBCFG_C_SW_MAJOR_VERSION                                            1U
#define ICU_PBCFG_C_SW_MINOR_VERSION                                            5U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/

#if (ICU_PBTYPES_AR_RELEASE_MAJOR_VERSION != ICU_PBCFG_C_AR_RELEASE_MAJOR_VERSION)
#error "Icu_PBCfg.c : Mismatch in Release Major Version"
#endif

#if (ICU_PBTYPES_AR_RELEASE_MINOR_VERSION != ICU_PBCFG_C_AR_RELEASE_MINOR_VERSION)
#error "Icu_PBCfg.c : Mismatch in Release Minor Version"
#endif

#if (ICU_PBTYPES_AR_RELEASE_REVISION_VERSION != ICU_PBCFG_C_AR_RELEASE_REVISION_VERSION)
#error "Icu_PBCfg.c : Mismatch in Release Revision Version"
#endif

#if (ICU_PBTYPES_SW_MAJOR_VERSION != ICU_PBCFG_C_SW_MAJOR_VERSION)
#error "Icu_PBCfg.c : Mismatch in Software Major Version"
#endif

#if (ICU_PBTYPES_SW_MINOR_VERSION != ICU_PBCFG_C_SW_MINOR_VERSION)
#error "Icu_PBCfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/

#define ICU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"

/* RAM Allocation of Channel data */
volatile VAR(Icu_ChannelRamDataType, ICU_VAR_NO_INIT) Icu_GaaChannelRamData[3];                                         /* PRQA S 1504 # JV-01 */

/* RAM Allocation of Signal Measure Channel data */
volatile VAR(Icu_SignalMeasurementModeRamDataType, ICU_VAR_NO_INIT) Icu_GaaSignalMeasureRamData[1];                     /* PRQA S 1504 # JV-01 */

#define ICU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define ICU_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/* RAM Allocation of Timestamp channel data */
/* volatile VAR(Icu_TimeStampChannelRamDataType, ICU_VAR_NO_INIT) Icu_GaaTimestampRamData[]; */

/* RAM Allocation of Edge Counting Channel data */
/* volatile VAR(Icu_EdgeCountModeRamDatatype, ICU_VAR_NO_INIT) Icu_GaaEdgeCountRamData[]; */

#define ICU_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define ICU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

/* Function pointer table for all HW IP */
P2CONST(Icu_HwFuncTableType, ICU_VAR_INIT, ICU_CONFIG_DATA) Icu_GaaHwDepFunc[] =                                        /* PRQA S 1531, 3408 # JV-01, JV-01 */
{
  /* INTP */
  &Icu_ExtIntFunc,
  /* IRQ */
  NULL_PTR,
  /* TAUD */
  &Icu_TaudFunc,
  /* TAUJ */
  NULL_PTR,
  /* ATU5A */
  NULL_PTR,
  /* ATU5C */
  NULL_PTR
};
#define ICU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define ICU_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Structure for each Config Set */
CONST(Icu_ConfigType, ICU_CONFIG_DATA) Icu_GaaConfiguration[] =
{
  /* Index: 0 - IcuConfigSet */
  {
    /* ulStartOfDbToc */
    0x0EDE8128UL,

    /* pChannelConfig */
    (P2CONST(void, TYPEDEF, ICU_CONFIG_CONST)) &Icu_GaaChannelConfig[0],                                                /* PRQA S 0314 # JV-01 */

    /* pChannelUserRegConfig */
    (P2CONST(void, TYPEDEF, ICU_CONFIG_CONST)) &Icu_GaaChannelUserRegConfig[0],                                         /* PRQA S 0314 # JV-01 */

    /* pRamAddress */
    (P2VAR(volatile void, TYPEDEF, ICU_CONFIG_CONST)) &Icu_GaaChannelRamData[0],                                        /* PRQA S 0314 # JV-01 */

    /* pSignalMeasureAddress */
    (P2VAR(volatile void, TYPEDEF, ICU_CONFIG_CONST)) &Icu_GaaSignalMeasureRamData[0],                                  /* PRQA S 0314 # JV-01 */

    /* pTimeStampAddress */
    NULL_PTR,

    /* pEdgeCountRamAddress */
    NULL_PTR,

    /* pTAUUnitConfig */
    (P2CONST(void, TYPEDEF, ICU_CONFIG_CONST)) &Icu_GaaTAUUnitConfig[0]                                                 /* PRQA S 0314 # JV-01 */
  }
};

#define ICU_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define ICU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Configuration of each ICU Channel */
CONST(Icu_ChannelConfigType, ICU_CONFIG_DATA) Icu_GaaChannelConfig[] =                                                  /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - IcuChannel */
  {
    /* pIcuNotificationPointer */
    NULL_PTR,

    /* pCntlRegs */
    (P2VAR(void, TYPEDEF, REGSPACE))0xFFBF4000UL,                                                                       /* PRQA S 0326 # JV-01 */

    /* pPPRAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE))0xFFD9060CUL,                                                            /* PRQA S 0303 # JV-01 */

    /* pIntrCntlAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE))0xFFFC4014UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucEcuMChannelWakeupInfo */
    (uint8)ICU_NOWAKEUP,

    /* usChannelMaskValue */
    0x0003U,

    /* usPortMaskValue */
    0x0010U,

    /* ucIcuPortType */
    ICU_NORMAL_PORT,

    /* ucIcuMeasurementMode */
    (uint8)ICU_MODE_SIGNAL_MEASUREMENT,

    /* ucIcuDefaultStartEdge */
    (uint8)ICU_RISING_EDGE,

    /* ucIcuChannelType */
    (uint8)ICU_HW_TAUD,

    /* ucIcuWakeupCapability */
    (uint8)ICU_FALSE,

    /* ucIcuDisableEcumWakeupNotification */
    (uint8)ICU_TRUE,

    /* pHWIPChannelConfig */
    &Icu_GaaTAUChannelConfig[0]                                                                                         /* PRQA S 0315 # JV-01 */
  },
  /* Index: 1 - ExtraDutyCycleChannel */
  {
    /* pIcuNotificationPointer */
    NULL_PTR,

    /* pCntlRegs */
    (P2VAR(void, TYPEDEF, REGSPACE))0xFFBF4004UL,                                                                       /* PRQA S 0326 # JV-01 */

    /* pPPRAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE))0xFFD9060CUL,                                                            /* PRQA S 0303 # JV-01 */

    /* pIntrCntlAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE))0xFFF802F0UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucEcuMChannelWakeupInfo */
    (uint8)ICU_NOWAKEUP,

    /* usChannelMaskValue */
    0x0003U,

    /* usPortMaskValue */
    0x0020U,

    /* ucIcuPortType */
    ICU_NORMAL_PORT,

    /* ucIcuMeasurementMode */
    (uint8)ICU_MODE_SIGNAL_MEASUREMENT,

    /* ucIcuDefaultStartEdge */
    (uint8)ICU_RISING_EDGE,

    /* ucIcuChannelType */
    (uint8)ICU_HW_TAUD,

    /* ucIcuWakeupCapability */
    (uint8)ICU_FALSE,

    /* ucIcuDisableEcumWakeupNotification */
    (uint8)ICU_TRUE,

    /* pHWIPChannelConfig */
    &Icu_GaaTAUChannelConfig[1]                                                                                         /* PRQA S 0315 # JV-01 */
  },
  /* Index: 2 - IcuChannel_006 */
  {
    /* pIcuNotificationPointer */
    &Icu_EdgeDetect_Notification,

    /* pCntlRegs */
    (P2VAR(void, TYPEDEF, REGSPACE))0xFFED4700UL,                                                                       /* PRQA S 0326 # JV-01 */

    /* pPPRAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE))0xFFD9010CUL,                                                            /* PRQA S 0303 # JV-01 */

    /* pIntrCntlAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE))0xFFF80440UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucEcuMChannelWakeupInfo */
    (uint8)5,

    /* usChannelMaskValue */
    0x0002U,

    /* usPortMaskValue */
    0x0001U,

    /* ucIcuPortType */
    ICU_NORMAL_PORT,

    /* ucIcuMeasurementMode */
    (uint8)ICU_MODE_SIGNAL_EDGE_DETECT,

    /* ucIcuDefaultStartEdge */
    (uint8)ICU_RISING_EDGE,

    /* ucIcuChannelType */
    (uint8)ICU_HW_EXT_INTP,

    /* ucIcuWakeupCapability */
    (uint8)ICU_TRUE,

    /* ucIcuDisableEcumWakeupNotification */
    (uint8)ICU_TRUE,

    /* pHWIPChannelConfig */
    NULL_PTR
  }
};

/* Configuration for Hardware IP */
CONST(Icu_HWIPType, ICU_CONFIG_DATA) Icu_GaaHWIPConfig[] =                                                              /* PRQA S 1531, 1533 # JV-01, JV-01 */
{
  /* Index: 0 - INTP */
  {
    /* ucIndex */
    ICU_HW_EXT_INTP
  },
  /* Index: 1 - TAUD */
  {
    /* ucIndex */
    ICU_HW_TAUD
  }
};

/* Configuration for TAU Channel configuration */
CONST(Icu_TAUChannelConfigType, ICU_CONFIG_DATA) Icu_GaaTAUChannelConfig[] =                                            /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - IcuChannel */
  {
    /* pTAUJCNTAddress */
    NULL_PTR,

    /* pCNTAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE)) 0xFFBF4080UL                                                            /* PRQA S 0303 # JV-01 */
  },
  /* Index: 1 - ExtraDutyCycleChannel */
  {
    /* pTAUJCNTAddress */
    NULL_PTR,

    /* pCNTAddress */
    (P2VAR(volatile uint16, TYPEDEF, REGSPACE)) 0xFFBF4084UL                                                            /* PRQA S 0303 # JV-01 */
  }
};

/* Configuration of each ICU Channel */
CONST(Icu_ChannelUserRegConfigType, ICU_CONFIG_DATA) Icu_GaaChannelUserRegConfig[] =                                    /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - IcuChannel */
  {
    /* ucRamDataIndex */
    0x00U,

    /* ucChannelProperties */
    0x06U,

    /* pHWChannelUserRegConfig */
    &Icu_GaaTAUChannelUserRegConfig[0]                                                                                  /* PRQA S 0315 # JV-01 */
  },
  /* Index: 1 - ExtraDutyCycleChannel */
  {
    /* ucRamDataIndex */
    0x00U,

    /* ucChannelProperties */
    0x05U,

    /* pHWChannelUserRegConfig */
    &Icu_GaaTAUChannelUserRegConfig[1]                                                                                  /* PRQA S 0315 # JV-01 */
  },
  /* Index: 2 - IcuChannel_006 */
  {
    /* ucRamDataIndex */
    0x00U,

    /* ucChannelProperties */
    0x00U,

    /* pHWChannelUserRegConfig */
    &Icu_GaaPINChannelUserRegConfig[0]                                                                                  /* PRQA S 0315 # JV-01 */
  }
};

CONST(Icu_TAUChannelUserRegConfigType, ICU_CONFIG_DATA) Icu_GaaTAUChannelUserRegConfig[] =                              /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - IcuChannel */
  {
    /* pCMORReg */
    (P2VAR(uint16, TYPEDEF, REGSPACE)) 0xFFBF4200UL,                                                                    /* PRQA S 0306, 3432 # JV-01, JV-01 */

    /* usChannelModeOSRegSettings */
    0x0144U,

    /* ucChannelModeUserRegSettings */
    0x01U,

    /* ucTimerUnitIndex */
    0x00U
  },
  /* Index: 1 - ExtraDutyCycleChannel */
  {
    /* pCMORReg */
    (P2VAR(uint16, TYPEDEF, REGSPACE)) 0xFFBF4204UL,                                                                    /* PRQA S 0306, 3432 # JV-01, JV-01 */

    /* usChannelModeOSRegSettings */
    0x024CU,

    /* ucChannelModeUserRegSettings */
    0x03U,

    /* ucTimerUnitIndex */
    0x00U
  }
};

CONST(Icu_PINChannelUserRegConfigType, ICU_CONFIG_DATA) Icu_GaaPINChannelUserRegConfig[] =                              /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - IcuChannel_006 */
  {
    /* ddChannelModeUserRegSettings */
    0x01U
  }
};

/* Array of structures for Hardware Configuration */
CONST(Icu_TAUUnitConfigType, ICU_CONFIG_DATA) Icu_GaaTAUUnitConfig[] =                                                  /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - TAUD0 */
  {
    /* pTAUnitUserCntlRegs */
    (P2VAR(uint8, TYPEDEF, ICU_CONFIG_CONST)) 0xFFBF4040UL,                                                             /* PRQA S 0306, 3432 # JV-01, JV-01 */

    /* pTAUnitOsCntlRegs */
    (P2VAR(uint8, TYPEDEF, ICU_CONFIG_CONST)) 0xFFBF4240UL,                                                             /* PRQA S 0306, 3432 # JV-01, JV-01 */

    /* usPrescaler */
    0x4B96U,

    /* ucIcuUnitType */
    ICU_HW_TAUD,

    /* usTAUChannelMaskValue */
    0x0003U,

    /* ucBaudRate */
    0xFFU,

    /* ucConfigurePrescaler */
    (uint8)ICU_TRUE
  }
};

#define ICU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */



/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

