/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Spi_PBcfg.c                                                                                         */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains post-build time parameters.                                                                     */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  SpiU2x.dll version: 1.5.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Spi_Spi_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Mcu_Mcu_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_SPI_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Spi.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  24 Apr 2025 - 19:50:00
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
#include "Spi.h"                                                                                                        /* PRQA S 0857 # JV-01 */

#include "Spi_Ram.h"

#include "Spi_MSPI_LLDriver.h"
#include "Spi_sDMAC_LLDriver.h"


/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/**********************************************************************************************************************/
/* Message (4:5087)    : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA C:2012 Rule 20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0303)    : Cast between a pointer to volatile object and an integral type.                              */
/* Rule                : MISRA-C:2012 Rule 11.4, CERT-C:1.2.4 CERTCMM INT36                                           */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (5:0488)    : Performing Pointer arithmetic.                                                               */
/* Rule                : MISRA-C:2012 Rule 18.4, CERT-C:1.2.4 CERTCMM EXP08                                           */
/* JV-01 Justification : This addresses pointed by the pointers needs to be incremented after each cycle.             */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0306)    : [I] Cast between a pointer to object and an integral type.                                   */
/* Rule                : MISRA-C:2012 Rule 11.4, CERT-C:1.2.4 CERTCMM INT36                                           */
/* JV-01 Justification : Typecasting is done as per the register size, to access hardware registers.                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0315)    : Implicit conversion from a pointer to object type to a pointer to void.                      */
/* Rule                : No MISRA-C:2012 Rules applicable to message 0315                                             */
/* JV-01 Justification : Pointer to a void is a generic pointer type which can be use cast to any other pointer type. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro       */
/*                       is over 1024                                                                                 */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:0751)    : Casting to char pointer type.                                                                */
/* Rule                : CERT-C:1.2.4 CERTCCM EXP11, EXP39                                                            */
/* JV-01 Justification : Using void due to specific requirement of input parameter. So, this can be skipped.          */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
/* AUTOSAR specification version information */
#define SPI_PBCFG_C_AR_RELEASE_MAJOR_VERSION                                    4U
#define SPI_PBCFG_C_AR_RELEASE_MINOR_VERSION                                    3U
#define SPI_PBCFG_C_AR_RELEASE_REVISION_VERSION                                 1U
/* File version information */
#define SPI_PBCFG_C_SW_MAJOR_VERSION                                            1U
#define SPI_PBCFG_C_SW_MINOR_VERSION                                            5U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/
#if (SPI_PBTYPES_AR_RELEASE_MAJOR_VERSION != SPI_PBCFG_C_AR_RELEASE_MAJOR_VERSION)
  #error "Spi_PBcfg.c : Mismatch in Release Major Version"
#endif

#if (SPI_PBTYPES_AR_RELEASE_MINOR_VERSION != SPI_PBCFG_C_AR_RELEASE_MINOR_VERSION)
  #error "Spi_PBcfg.c : Mismatch in Release Minor Version"
#endif

#if (SPI_PBTYPES_AR_RELEASE_REVISION_VERSION != SPI_PBCFG_C_AR_RELEASE_REVISION_VERSION)
  #error "Spi_PBcfg.c : Mismatch in Release Revision Version"
#endif

#if (SPI_PBTYPES_SW_MAJOR_VERSION != SPI_PBCFG_C_SW_MAJOR_VERSION)
  #error "Spi_PBcfg.c : Mismatch in Software Major Version"
#endif

#if (SPI_PBTYPES_SW_MINOR_VERSION != SPI_PBCFG_C_SW_MINOR_VERSION)
  #error "Spi_PBcfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/
#define SPI_START_SEC_CONFIG_DATA_8
#include "Spi_MemMap.h"


/* This array map hardware unit MSPI to hardware unit info array */
STATIC CONST(uint8, SPI_CONFIG_DATA) Spi_GaaMSPIToHWUnit[] =
{
  /* Index: 0 */
  0x00U, 0x00U, 0x00U, 0x00U, 0x01U
};

#define SPI_STOP_SEC_CONFIG_DATA_8
#include "Spi_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define SPI_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Spi_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Array for hardware unit information */
STATIC CONST(Spi_HWUnitInfoType, SPI_CONFIG_DATA) Spi_GaaHWUnitInfo[] =
{
  /* Index: 0 - MSPI3 */
  {
    /* ucMacroIndex */
    SPI_MACRO_MSPI,

    /* ucPhyUnitIndex */
    0x03U
  },
  /* Index: 1 - MSPI4 */
  {
    /* ucMacroIndex */
    SPI_MACRO_MSPI,

    /* ucPhyUnitIndex */
    0x04U
  }
};

/* This array map DMA hardware unit to hardware unit info array */
STATIC CONST(uint8, SPI_CONFIG_DATA) Spi_GaaDMAToHWUnit[] =
{
  /* Index: 0 */
  0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x01U
};

/* This array contains list of JobIds that used in sequence */
STATIC CONST(Spi_JobType, SPI_CONFIG_DATA) Spi_GaaJobList_0_1[] =
{
  /* Index: 0 - SpiSequence */
  0x00U
};

/* This array contains list of JobIds that used in sequence */
STATIC CONST(Spi_JobType, SPI_CONFIG_DATA) Spi_GaaJobList_1_2[] =
{
  /* Index: 1 - SpiSequence_001 */
  0x01U
};

/* This array contains list of JobIds that used in sequence */
STATIC CONST(Spi_JobType, SPI_CONFIG_DATA) Spi_GaaJobList_0_0[] =
{
  /* Index: 0 - SpiSequence */
  0x00U
};

/* This array contains list of JobIds that used in sequence */
STATIC CONST(Spi_JobType, SPI_CONFIG_DATA) Spi_GaaJobList_1_0[] =
{
  /* Index: 1 - SpiSequence_001 */
  0x01U
};

/* This array contains list of ChannelIds that used in job */
STATIC CONST(Spi_ChannelType, SPI_CONFIG_DATA) Spi_GaaChannelList0[] =
{
  /* Index: 0 - SpiJob */
  0x00U
};

/* This array contains list of ChannelIds that used in job */
STATIC CONST(Spi_ChannelType, SPI_CONFIG_DATA) Spi_GaaChannelList1[] =
{
  /* Index: 1 - SpiJob_001 */
  0x01U
};

/* This array contains device configuration for MSPI */
STATIC CONST(Spi_MSPIDeviceConfigType, SPI_CONFIG_DATA) Spi_GaaMSPIDeviceConfig[] =
{
  /* Index: 0 - SpiJob */
  {
    /* ucPhyChannelIndex */
    0x00U,

    /* enMemoryMode */
    SPI_MEMORYMODE_DIRECT,

    /* ulMSPICTL1 */
    0x01000000UL,

    /* ucMSPICTL2 */
    0x00U,

    /* ulMSPICFG0 */
    0x30010003UL,

    /* ulMSPICFG1 */
    0x00030000UL,

    /* usMSPICFG3 */
    0x0105U,

    /* ulMSPICFG4 */
    0x00000000UL,

    /* usMSPISEUP */
    0x0009U,

    /* usMSPIHOLD */
    0x0001U,

    /* usMSPIIDLE */
    0x0001U,

    /* usMSPIINDA */
    0x0000U,

    /* usMSPIRASTAD */
    0x0000U
  },
  /* Index: 1 - SpiJob_001 */
  {
    /* ucPhyChannelIndex */
    0x00U,

    /* enMemoryMode */
    SPI_MEMORYMODE_DIRECT,

    /* ulMSPICTL1 */
    0x00000000UL,

    /* ucMSPICTL2 */
    0x00U,

    /* ulMSPICFG0 */
    0x30010003UL,

    /* ulMSPICFG1 */
    0x01070000UL,

    /* usMSPICFG3 */
    0x0105U,

    /* ulMSPICFG4 */
    0x00000000UL,

    /* usMSPISEUP */
    0x0009U,

    /* usMSPIHOLD */
    0x0001U,

    /* usMSPIIDLE */
    0x0001U,

    /* usMSPIINDA */
    0x0000U,

    /* usMSPIRASTAD */
    0x0000U
  }
};

/* HW-dependent configuration */
STATIC CONST(Spi_HwConfigType, SPI_CONFIG_DATA) Spi_GaaHwConfig[] =
{
  /* Index: 0 - MSPI */
  {
    /* pHwDepFunc */
    &Spi_GstMSPIFunc,

    /* pPhyToHWUnit */
    &Spi_GaaMSPIToHWUnit[0]
  }
};

/* This array contains configuration details for Channels */
STATIC CONST(Spi_ChannelConfigType, SPI_CONFIG_DATA) Spi_GaaChannelConfig[] =
{
  /* Index: 0 - SpiChannel */
  {
    /* ucDataWidth */
    0x08U,

    /* ucByteSize */
    0x01U,

    /* enTransferStart */
    SPI_TRANSFER_START_MSB,

    /* ulDefaultData */
    0x000000A5UL,

    /* enChannelBufferType */
    SPI_BUFFER_TYPE_EB,

    /* usNoOfBuffers */
    0x0080U,

    /* pTxBuffer */
    NULL_PTR,

    /* pRxBuffer */
    NULL_PTR,

    /* pEBData */
    &Spi_GaaEBData[0]
  },
  /* Index: 1 - SpiChannel_001 */
  {
    /* ucDataWidth */
    0x08U,

    /* ucByteSize */
    0x01U,

    /* enTransferStart */
    SPI_TRANSFER_START_MSB,

    /* ulDefaultData */
    0x000000A5UL,

    /* enChannelBufferType */
    SPI_BUFFER_TYPE_EB,

    /* usNoOfBuffers */
    0x2790U,

    /* pTxBuffer */
    NULL_PTR,

    /* pRxBuffer */
    NULL_PTR,

    /* pEBData */
    &Spi_GaaEBData[1]
  }
};

/* This array contains configuration details for Jobs */
STATIC CONST(Spi_JobConfigType, SPI_CONFIG_DATA) Spi_GaaJobConfig[] =
{
  /* Index: 0 - SpiJob */
  {
    /* ucNoOfChannels */
    0x01U,

    /* usCSInfo */
    0x0001U,

    /* pChannelList */
    &Spi_GaaChannelList0[0],

    /* pJobEndNotification */
    &SpiJob0Notification,

    /* ucJobPriority */
    0x03U,

    /* ucHWUnitIndex */
    0x00U,

    /* enCSType */
    SPI_PERIPHERAL_ENGINE_CS,

    /* blChannelPropertySame */
    SPI_TRUE,

    /* ucTxDmaIndex */
    0x01U,

    /* ucRxDmaIndex */
    0x00U,

    /* pHWDevConfig */
    &Spi_GaaMSPIDeviceConfig[0]                                                                                         /* PRQA S 0315 # JV-01 */
  },
  /* Index: 1 - SpiJob_001 */
  {
    /* ucNoOfChannels */
    0x01U,

    /* usCSInfo */
    0x0001U,

    /* pChannelList */
    &Spi_GaaChannelList1[0],

    /* pJobEndNotification */
    &SpiJob0Notification,

    /* ucJobPriority */
    0x03U,

    /* ucHWUnitIndex */
    0x01U,

    /* enCSType */
    SPI_PERIPHERAL_ENGINE_CS,

    /* blChannelPropertySame */
    SPI_TRUE,

    /* ucTxDmaIndex */
    SPI_INVALID_DMAUNIT,

    /* ucRxDmaIndex */
    SPI_INVALID_DMAUNIT,

    /* pHWDevConfig */
    &Spi_GaaMSPIDeviceConfig[1]                                                                                         /* PRQA S 0315 # JV-01 */
  }
};

/* This array contains configuration details for Sequences */
STATIC CONST(Spi_SeqConfigType, SPI_CONFIG_DATA) Spi_GaaSeqConfig[] =
{
  /* Index: 0 - SpiSequence */
  {
    /* ulUsingHWUnits */
    0x00000001UL,

    /* pSeqEndNotification */
    &SpiSequence0EndNotification,

    /* pSeqStartNotification */
    NULL_PTR,

    /* blInterruptible */
    SPI_TRUE,

    /* aaJobSharedSequences */
    { 0x00000000UL },

    /* Index: 5 - aaSubSeqs */
    {
      /* Index: 0 - 0 */
      {
        /* ucUsingPriorities */
        0x08U,

        /* usNoOfJobs */
        0x0001U,

        /* pJobList */
        &Spi_GaaJobList_0_0[0]
      },
      /* Index: 1 - MSPI3 */
      {
        /* ucUsingPriorities */
        0x08U,

        /* usNoOfJobs */
        0x0001U,

        /* pJobList */
        &Spi_GaaJobList_0_1[0]
      },
      /* Index: 2 - MSPI4 */
      {
        /* ucUsingPriorities */
        0x00U,

        /* usNoOfJobs */
        0x0000U,

        /* pJobList */
        NULL_PTR
      }
    }
  },
  /* Index: 1 - SpiSequence_001 */
  {
    /* ulUsingHWUnits */
    0x00000002UL,

    /* pSeqEndNotification */
    &SpiSequence0EndNotification,

    /* pSeqStartNotification */
    NULL_PTR,

    /* blInterruptible */
    SPI_TRUE,

    /* aaJobSharedSequences */
    { 0x00000000UL },

    /* Index: 5 - aaSubSeqs */
    {
      /* Index: 0 - 0 */
      {
        /* ucUsingPriorities */
        0x08U,

        /* usNoOfJobs */
        0x0001U,

        /* pJobList */
        &Spi_GaaJobList_1_0[0]
      },
      /* Index: 1 - MSPI3 */
      {
        /* ucUsingPriorities */
        0x00U,

        /* usNoOfJobs */
        0x0000U,

        /* pJobList */
        NULL_PTR
      },
      /* Index: 2 - MSPI4 */
      {
        /* ucUsingPriorities */
        0x08U,

        /* usNoOfJobs */
        0x0001U,

        /* pJobList */
        &Spi_GaaJobList_1_2[0]
      }
    }
  }
};

/* Pointer to the structure of DMA configuration array */
STATIC CONST(Spi_DmaConfigType, SPI_CONFIG_DATA) Spi_GaaDmaConfig[] =
{
  /* Index: 0 - SDMA0_06 */
  {
    /* pDmaRegs */
    (Spi_SDMAChRegType*)0xFFF92300UL,                                                                                   /* PRQA S 0306 # JV-01 */

    /* pICDma */
    (uint16*)0xFFF8006AUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pDMACSEL */
    (uint32*)0xFF090400UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* ucTriggerGroup */
    0x00U,

    /* ucTriggerNumber */
    0x82U,

    /* ucSPIHWUnit */
    0x00U,

    /* blRxSide */
    SPI_TRUE,

    /* ulRegAddress */
    0xFFCC00D0UL
  },
  /* Index: 1 - SDMA0_07 */
  {
    /* pDmaRegs */
    (Spi_SDMAChRegType*)0xFFF92380UL,                                                                                   /* PRQA S 0306 # JV-01 */

    /* pICDma */
    (uint16*)0xFFF8006CUL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* pDMACSEL */
    (uint32*)0xFF090400UL,                                                                                              /* PRQA S 0306 # JV-01 */

    /* ucTriggerGroup */
    0x00U,

    /* ucTriggerNumber */
    0x81U,

    /* ucSPIHWUnit */
    0x00U,

    /* blRxSide */
    SPI_FALSE,

    /* ulRegAddress */
    0xFFCC00C0UL
  }
};

#define SPI_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Spi_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define SPI_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Spi_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Structure for SPI Init configuration */
CONST(Spi_ConfigType, SPI_CONFIG_DATA) Spi_GaaConfiguration[] =
{
  /* Index: 0 - SpiDriver */
  {
    /* ulStartOfDbToc */
    0x0ED4C128UL,

    /* ucNoOfHWUnits */
    0x02U,

    /* ucNoOfChannels */
    0x02U,

    /* usNoOfJobs */
    0x0002U,

    /* ucNoOfSequences */
    0x02U,

    /* ucNoOfDMAChannels */
    0x02U,

    /* pHWUnitInfo */
    &Spi_GaaHWUnitInfo[0],                                                                                              /* PRQA S 0315 # JV-01 */

    /* pChannelConfig */
    &Spi_GaaChannelConfig[0],                                                                                           /* PRQA S 0315 # JV-01 */

    /* pJobConfig */
    &Spi_GaaJobConfig[0],                                                                                               /* PRQA S 0315 # JV-01 */

    /* pSequenceConfig */
    &Spi_GaaSeqConfig[0],                                                                                               /* PRQA S 0315 # JV-01 */

    /* pDMAUnitInfo */
    &Spi_GaaDmaConfig[0],                                                                                               /* PRQA S 0315 # JV-01 */

    /* ulTimeoutCount */
    0x04C4B400UL,

    /* pDMAToHWUnit */
    &Spi_GaaDMAToHWUnit[0],

    /* pHwConfig */
    &Spi_GaaHwConfig[0]                                                                                                 /* PRQA S 0315 # JV-01 */
  }
};

#define SPI_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Spi_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */



/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

