/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_ETNDE_Irq.h                                                                                     */
/* SW-VERSION   = 1.5.4                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of prototypes for Interrupt service routine for ethernet driver.                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.3: 14/04/2022    : Update QA-C comments.
 * 1.5.1: 11/01/2022    : Initial Version
 */
/**********************************************************************************************************************/
#ifndef ETH_ETNDE_IRQ_H
#define ETH_ETNDE_IRQ_H
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
#include "Eth_Types.h"
/* Included for version information macros */
#include "Os.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ETH_ETNDE_IRQ_AR_RELEASE_MAJOR_VERSION    ETH_AR_RELEASE_MAJOR_VERSION
#define ETH_ETNDE_IRQ_AR_RELEASE_MINOR_VERSION    ETH_AR_RELEASE_MINOR_VERSION
#define ETH_ETNDE_IRQ_AR_RELEASE_REVISION_VERSION ETH_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ETH_ETNDE_IRQ_SW_MAJOR_VERSION            ETH_SW_MAJOR_VERSION
#define ETH_ETNDE_IRQ_SW_MINOR_VERSION            ETH_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:1055)    : [C99] The keyword 'inline' has been used.                                                    */
/* Rule                : MISRA C:2012 Dir-1.1, Rule-1.2                                                               */
/* JV-01 Justification : In this case, inline functions are considered more optimized for ECODE than function-like    */
/*                       macros. Usage of inline functions is accepted.                                               */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
#define ETH_SGOPMS_DATA_LINKUP                   0x00020012UL
#define ETH_SGOPMS_STATE_MASK                    0x00030012UL
#define ETH_SGOPMS_DATA_COM                      0x00020000UL
#define ETH_SGOPMS_XMIT_MASK                     0x00030000UL
#define ETH_SGOPMS_SPEED_MASK                    0x0000000CUL

#define ETH_DATAISR0                             0x00000000UL
#define ETH_DATAISR1                             0x00000001UL
#define ETH_DATAISR2                             0x00000002UL
#define ETH_DATAISR3                             0x00000003UL

LOCAL_INLINE uint32 ETH_ETNDE_DIS_MASK(const uint32 idx, const uint32 handler, const uint32 base)                       /* PRQA S 1055 # JV-01 */
{
  #if (ETH_USING_MACRO == ETH_MACRO_ETND)
  (void)idx;
  (void)base;
  return 0x00000011UL << handler;
  #else
  return (0x00000011UL << handler) << (idx * base);
  #endif
}

#define ETH_ETND_EIS0_ECCFES_MASK               0x00000001UL
#define ETH_ETND_EIS0_AEIS_MASK                 0x00000002UL

#define ETH_ETND_TCIS_ERROR_MASK                 0x00000400UL
#define ETH_ETND_TIS2_ERROR_MASK                 0xFF010000UL
#define ETH_ETND_RIS_ERROR_MASK                  0x00000010UL
#define ETH_ETNE_EAEIE0_ERROR_MASK               0x00130000UL
#define ETH_ETNE_FWEIS1_ERROR_MASK               0x00000380UL

#define ETH_ETNDE_TSDIS_0_MASK                   0x00000001UL

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#define ETH_START_SEC_CODE_FAST
#include "Eth_MemMap.h"
#if ((ETH_TSN0_DATA0_ISR == STD_ON) || (ETH_RSW_DATA0_ISR == STD_ON))
#if defined(Os_ETH_TSN0_DATAISR0_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN0_DATAISR0(void);
#endif
#endif

#if ((ETH_TSN0_DATA1_ISR == STD_ON) || (ETH_RSW_DATA1_ISR == STD_ON))
#if defined(Os_ETH_TSN0_DATAISR1_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN0_DATAISR1(void);
#endif
#endif

#if ((ETH_TSN0_DATA2_ISR == STD_ON) || (ETH_RSW_DATA2_ISR == STD_ON))
#if defined(Os_ETH_TSN0_DATAISR2_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN0_DATAISR2(void);
#endif
#endif

#if ((ETH_TSN0_DATA3_ISR == STD_ON) || (ETH_RSW_DATA3_ISR == STD_ON))
#if defined(Os_ETH_TSN0_DATAISR3_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN0_DATAISR3(void);
#endif
#endif

#if (ETH_TSN0_GENERAL_ISR == STD_ON)
#if defined(Os_ETH_TSN1_GENERALISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN0_GENERALISR(void);
#endif
#endif

#if (ETH_TSN1_DATA0_ISR == STD_ON)
#if defined(Os_ETH_TSN1_DATAISR0_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN1_DATAISR0(void);
#endif
#endif

#if (ETH_TSN1_DATA1_ISR == STD_ON)
#if defined(Os_ETH_TSN1_DATAISR1_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN1_DATAISR1(void);
#endif
#endif

#if (ETH_TSN1_DATA2_ISR == STD_ON)
#if defined(Os_ETH_TSN1_DATAISR2_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN1_DATAISR2(void);
#endif
#endif

#if (ETH_TSN1_DATA3_ISR == STD_ON)
#if defined(Os_ETH_TSN1_DATAISR3_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN1_DATAISR3(void);
#endif
#endif

#if (ETH_TSN1_GENERAL_ISR == STD_ON)
#if defined(Os_ETH_TSN1_GENERALISR_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_TSN1_GENERALISR(void);
#endif
#endif

#if (ETH_RSW_GENERAL_ISR == STD_ON)
#if defined(Os_ETH_RSW_GENERALISR1_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_RSW_GENERALISR1(void);
#endif

#if defined(Os_ETH_RSW_GENERALISR2_CAT2) || (ETH_ISR_CATEGORY_2 == STD_ON)
#else
extern _INTERRUPT_ FUNC(void, ETH_CODE_FAST) ETH_RSW_GENERALISR2(void);
#endif
#endif

#define ETH_STOP_SEC_CODE_FAST
#include "Eth_MemMap.h"

#endif /* ETH_ETNB_IRQ_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
