/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Eth_Types.h                                                                                         */
/* SW-VERSION   = 1.6.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of Ethernet Component specific types used within the module.                                             */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.5.2: 28/01/2022    : Add the ETH_HEADER_SIZE, ETH_MACADDR_SIZE, ETH_SRC_DST_ADDRESS_SIZE,
 *                        ETH_ETHERTYPE_SIZE, ETH_VLAN_SIZE and ETH_FCS_LENGTH macros.
 * 1.5.0: 07/10/2021    : For support U2Bx, changed the definition location of the include file.
 *                        For support U2Bx, removed the extern definition of the following global variables.
 *                        Eth_GaaDemEventAccess, Eth_GaaDemEventRxFramesLost, Eth_GaaDemEventCRC,
 *                        Eth_GaaDemEventUnderSizeFrame, Eth_GaaDemEventOverSizeFrame, Eth_GaaDemEventAlignment,
 *                        Eth_GaaDemEventSinglecollision, Eth_GaaDemEventMultiplecollision,
 *                        Eth_GaaDemEventLatecollision, Eth_GaaDemEventIntInconsistent,
 *                        Eth_GaaDemEventRegisterCorruption and Eth_GaaDemEventDmaError.
 * 1.4.2: 24/08/2021    : Modify the format to 120 characters
 * 1.4.1: 24/06/2021    : Add ETH_AR_R19_11_VERSION for R19-11 support.
 *        07/05/2021    : Changes to support U2Bx devices.
 *                        Remove vendor ID from the file name, API names
 *                        and parameters according to BSW00347 requirement
 *        06/07/2021    : Updated QA-C 9.5.0 comments.
 * 1.3.0: 09/12/2020    : Update value for ETH_DEM_NOT_CONFIGURED to 0x0000
 * 1.2.0: 13/07/2020    : Release
 *        29/07/2020    : Add QAC 9.3.1 comment.
 * 1.1.0: 19/06/2020    : Release
 * 1.0.1: 04/06/2020    : To support Transmit/Receive interrupts for each controller.
 *                        Removed unnecessary code.
 *                        Updated static analysis result.
 * 1.0.0: 25/03/2020    : Initial Version
 */
/**********************************************************************************************************************/
#ifndef ETH_TYPES_H
#define ETH_TYPES_H

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0342)    : Using the glue operator '##'.                                                                */
/* Rule                : CERTCCM PRE05, MISRA C:2012 Rule-20.10                                                       */
/* JV-01 Justification : This can be accepted, due to the implementation is following AUTOSAR standard rule for       */
/*                       SchM module's name                                                                           */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:3630)    : The implementation of this struct/union type should be hidden.                               */
/* Rule                : MISRA C:2012 Dir-4.8                                                                         */
/* JV-01 Justification : This is accepted. Redudant of struct or union type has no affect to driver operation         */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/* MACRO Types */
#define ETH_MACRO_ETNC                        0U
#define ETH_MACRO_ETNB                        1U
#define ETH_MACRO_ETNE                        2U
#define ETH_MACRO_ETND                        3U
/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for Type definitions */
#include "Eth_GeneralTypes.h"


/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
#define ETH_AR_R19_11_VERSION                 450
#define ETH_AR_431_VERSION                    431
#define ETH_AR_422_VERSION                    422
/* AUTOSAR release version information */
#define ETH_TYPES_AR_RELEASE_MAJOR_VERSION    ETH_AR_RELEASE_MAJOR_VERSION
#define ETH_TYPES_AR_RELEASE_MINOR_VERSION    ETH_AR_RELEASE_MINOR_VERSION
#define ETH_TYPES_AR_RELEASE_REVISION_VERSION ETH_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ETH_TYPES_SW_MAJOR_VERSION            ETH_SW_MAJOR_VERSION
#define ETH_TYPES_SW_MINOR_VERSION            ETH_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                                 GLOBAL DATA TYPES                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
                        Section: MACROS
***********************************************************************************************************************/
/* Macros for boolean variables */
#define ETH_FALSE              (boolean)0
#define ETH_TRUE               (boolean)1

/* Byte length of Ethernet header */
#define ETH_HEADER_SIZE          14UL
/* Byte length of MAC address */
#define ETH_MACADDR_SIZE         6UL
#define ETH_SRC_DST_ADDRESS_SIZE 12UL
#define ETH_ETHERTYPE_SIZE       2UL
#define ETH_VLAN_SIZE            4UL
#define ETH_FCS_LENGTH           4UL

#define ETH_DEM_NOT_CONFIGURED 0x0000

/***********************************************************************************************************************
                        Section: Enumerators
***********************************************************************************************************************/

/***********************************************************************************************************************
**  Enum: Eth_MacLayerSpeedType                                                                                       **
**                                                                                                                    **
**  Mac speed                                                                                                         **
**                                                                                                                    **
**  Members:                                                                                                          **
**    ETH_MAC_LAYER_SPEED_10M    - 10MBps                                                                             **
**    ETH_MAC_LAYER_SPEED_100M   - 100MBps                                                                            **
**    ETH_MAC_LAYER_SPEED_1G     - 1GBps                                                                              **
**    ETH_MAC_LAYER_SPEED_2500M  - 2.5GBps                                                                            **
**    ETH_MAC_LAYER_SPEED_10G    - 10GBps                                                                             **
***********************************************************************************************************************/
typedef enum ETag_Eth_MacLayerSpeedType
{
  ETH_MAC_LAYER_SPEED_10M = 0,
  ETH_MAC_LAYER_SPEED_100M,
  ETH_MAC_LAYER_SPEED_1G,
  ETH_MAC_LAYER_SPEED_2500M,
  ETH_MAC_LAYER_SPEED_10G
} Eth_MacLayerSpeedType;

/***********************************************************************************************************************
**  Enum: Eth_DuplexModeType                                                                                          **
**                                                                                                                    **
**  Mac duplex mode                                                                                                   **
**                                                                                                                    **
**  Members:                                                                                                          **
**    ETH_HALF_DUPLEX  - half duplex                                                                                  **
**    ETH_FULL_DUPLEX  - full duplex                                                                                  **
***********************************************************************************************************************/
typedef enum ETag_Eth_DuplexModeType
{
  ETH_HALF_DUPLEX = 0,
  ETH_FULL_DUPLEX
} Eth_DuplexModeType;

/***********************************************************************************************************************
**  Type: Eth_MediaInterfaceType                                                                                      **
**                                                                                                                    **
**  Setting option                                                                                                    **
**                                                                                                                    **
**  Members:                                                                                                          **
**    ETH_MII   - select MII                                                                                          **
**    ETH_RMII  - select RMII                                                                                         **
**    ETH_SGMII - select SGMII                                                                                        **
***********************************************************************************************************************/
typedef enum ETag_Eth_MediaInterfaceType
{
  ETH_MII = 0,
  ETH_RMII,
  ETH_SGMII
} Eth_MediaInterfaceType;

/***********************************************************************************************************************
**  Type: Eth_OptionType                                                                                              **
**                                                                                                                    **
**  Setting option                                                                                                    **
**                                                                                                                    **
**  Members:                                                                                                          **
**    ETH_DISABLE  - setting is disabled                                                                              **
**    ETH_ENABLE   - setting is enabled                                                                               **
***********************************************************************************************************************/
typedef enum ETag_Eth_OptionType
{
  ETH_DISABLE = 0,
  ETH_ENABLE
} Eth_OptionType;

/***********************************************************************************************************************
                        Section: Structures
***********************************************************************************************************************/

/***********************************************************************************************************************
  Type: Eth_EthConfigType

  Structure for Ethernet Configuration
  Overall Module Configuration Data Structure

  Members:
    enEthSpeed              - Ethernet Speed configured
    enEthDuplex             - Ethernet Duplex Mode configured
    enInternalLoopBackMode  - Enable InternalLoopBack Mode
    enEthPHYInterface       - PHY Interface (MII/RMII/SGMII)
    enTxInterruptMode       - Tx interrupt enable.
    enRxInterruptMode       - Rx interrupt enable.
*/

typedef struct STag_Eth_EthConfigType                                                                                   /* PRQA S 3630 # JV-01 */
{
  Eth_MacLayerSpeedType enEthSpeed;
  Eth_DuplexModeType enEthDuplex;
  Eth_OptionType enInternalLoopBackMode;
  Eth_MediaInterfaceType enEthPHYInterface;
  Eth_OptionType enTxInterruptMode;
  Eth_OptionType enRxInterruptMode;
} Eth_EthConfigType;

typedef struct STag_Eth_CtrlConfigType                                                                                  /* PRQA S 3630 # JV-01 */
{
  uint8 aaEthMACAddr[6];
  P2CONST(Eth_EthConfigType, TYPEDEF, ETH_APPL_CONST) pEthConfig;
  P2CONST(void, TYPEDEF, ETH_APPL_CONST) pHwUnitConfig;
} Eth_CtrlConfigType;

typedef struct STag_Eth_ConfigType
{
  /* Database start value - ETH_DBTOC_VALUE */
  uint32 ulStartOfDbToc;
  P2CONST(Eth_CtrlConfigType, TYPEDEF, ETH_APPL_CONST) pCtrlConfig;
} Eth_ConfigType;

/* Do not move the location of this include file */
#include "Eth_Cfg.h"

/***********************************************************************************************************************
**                                      SchM Critical Section Protection Macros                                       **
***********************************************************************************************************************/
#if (ETH_CRITICAL_SECTION_PROTECTION == STD_ON)
#define ETH_ENTER_CRITICAL_SECTION(Exclusive_Area) SchM_Enter_Eth_##Exclusive_Area()                                    /* PRQA S 0342 # JV-01 */
#define ETH_EXIT_CRITICAL_SECTION(Exclusive_Area)  SchM_Exit_Eth_##Exclusive_Area()                                     /* PRQA S 0342 # JV-01 */
#else
#define ETH_ENTER_CRITICAL_SECTION(Exclusive_Area)
#define ETH_EXIT_CRITICAL_SECTION(Exclusive_Area)
#endif

/***********************************************************************************************************************
**                                                Dem interface Macros                                                **
***********************************************************************************************************************/
#if (ETH_AR_VERSION == ETH_AR_422_VERSION)
#define ETH_DEM_REPORT_ERROR Dem_ReportErrorStatus
#elif (ETH_AR_VERSION == ETH_AR_431_VERSION)
#define ETH_DEM_REPORT_ERROR (void)Dem_SetEventStatus
#endif

#endif /* ETH_TYPES_H */

/***********************************************************************************************************************
**                                                    End Of File                                                     **
***********************************************************************************************************************/
