/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_TAUJ_Irq.h                                                                                      */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains ISRs prototypes for TAUJ Timers of PWM Driver                                                   */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.3.3: 25/02/2022 : Remove redundant header.                                                                       **
 * 1.3.2: 02/08/2021 : Added the INSTANCE INDEX                                                                       **
 * 1.3.1: 02/07/2021 : Add QAC message 9.5.0                                                                          **
 *                     Format source code to 120 characters                                                           **
 *                     Improve Violation tag (remove START/END)                                                       **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.1: 16/07/2020 : Changed "TAUDn_CHmm_CAT2_ISR" to                                                               **
 *                               "PWM_ISR_CATEGORY_2 == STD_ON"                                                       **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_TAUJ_IRQ_H
            #define PWM_59_INST0_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_TAUJ_IRQ_H
            #define PWM_59_INST1_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_TAUJ_IRQ_H
            #define PWM_59_INST2_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_TAUJ_IRQ_H
            #define PWM_59_INST3_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_TAUJ_IRQ_H
            #define PWM_59_INST4_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_TAUJ_IRQ_H
            #define PWM_59_INST5_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_TAUJ_IRQ_H
            #define PWM_59_INST6_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_TAUJ_IRQ_H
            #define PWM_59_INST7_TAUJ_IRQ_H
            #define PWM_TAUJ_IRQ_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_TAUJ_IRQ_H
        #define PWM_TAUJ_IRQ_H
        #define PWM_TAUJ_IRQ_HEADER
    #endif
#endif

#ifdef PWM_TAUJ_IRQ_HEADER
#undef PWM_TAUJ_IRQ_HEADER                                                                                              /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for interrupt category definitions */
#include "Os.h"

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define PWM_TAUJ_IRQ_AR_RELEASE_MAJOR_VERSION    PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_TAUJ_IRQ_AR_RELEASE_MINOR_VERSION    PWM_AR_RELEASE_MINOR_VERSION
#define PWM_TAUJ_IRQ_AR_RELEASE_REVISION_VERSION PWM_AR_RELEASE_REVISION_VERSION

/* Module software version information */
#define PWM_TAUJ_IRQ_SW_MAJOR_VERSION            PWM_SW_MAJOR_VERSION
#define PWM_TAUJ_IRQ_SW_MINOR_VERSION            PWM_SW_MINOR_VERSION
#define PWM_TAUJ_IRQ_SW_PATCH_VERSION            PWM_SW_PATCH_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define PWM_START_SEC_CODE_FAST
#include "Pwm_Mapping.h"

#if (PWM_TAUJ0_CH00_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ0_CH00_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ0_CH00_ISR(void);
#endif
#endif /* End of PWM_TAUJ0_CH00_ISR_API == STD_ON */

#if (PWM_TAUJ0_CH01_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ0_CH01_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ0_CH01_ISR(void);
#endif
#endif /* End of PWM_TAUJ0_CH01_ISR_API == STD_ON */

#if (PWM_TAUJ0_CH02_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ0_CH02_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ0_CH02_ISR(void);
#endif
#endif /* End of PWM_TAUJ0_CH02_ISR_API == STD_ON */

#if (PWM_TAUJ0_CH03_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ0_CH03_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ0_CH03_ISR(void);
#endif
#endif /* End of PWM_TAUJ0_CH03_ISR_API == STD_ON */

#if (PWM_TAUJ1_CH00_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ1_CH00_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ1_CH00_ISR(void);
#endif
#endif /* End of PWM_TAUJ1_CH00_ISR_API == STD_ON */

#if (PWM_TAUJ1_CH01_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ1_CH01_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ1_CH01_ISR(void);
#endif
#endif /* End of PWM_TAUJ1_CH01_ISR_API == STD_ON */

#if (PWM_TAUJ1_CH02_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ1_CH02_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ1_CH02_ISR(void);
#endif
#endif /* End of PWM_TAUJ1_CH02_ISR_API == STD_ON */

#if (PWM_TAUJ1_CH03_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ1_CH03_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ1_CH03_ISR(void);
#endif
#endif /* End of PWM_TAUJ1_CH03_ISR_API == STD_ON */

#if (PWM_TAUJ2_CH00_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ2_CH00_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ2_CH00_ISR(void);
#endif
#endif /* End of PWM_TAUJ2_CH00_ISR_API == STD_ON */

#if (PWM_TAUJ2_CH01_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ2_CH01_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ2_CH01_ISR(void);
#endif
#endif /* End of PWM_TAUJ2_CH01_ISR_API == STD_ON */

#if (PWM_TAUJ2_CH02_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ2_CH02_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ2_CH02_ISR(void);
#endif
#endif /* End of PWM_TAUJ2_CH02_ISR_API == STD_ON */

#if (PWM_TAUJ2_CH03_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ2_CH03_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ2_CH03_ISR(void);
#endif
#endif /* End of PWM_TAUJ2_CH03_ISR_API == STD_ON */

#if (PWM_TAUJ3_CH00_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ3_CH00_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ3_CH00_ISR(void);
#endif
#endif /* End of PWM_TAUJ3_CH00_ISR_API == STD_ON */

#if (PWM_TAUJ3_CH01_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ3_CH01_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ3_CH01_ISR(void);
#endif
#endif /* End of PWM_TAUJ3_CH01_ISR_API == STD_ON */

#if (PWM_TAUJ3_CH02_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ3_CH02_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ3_CH02_ISR(void);
#endif
#endif /* End of PWM_TAUJ3_CH02_ISR_API == STD_ON */

#if (PWM_TAUJ3_CH03_ISR_API == STD_ON)
/* Defines the CAT2 interrupt mapping */
#if defined(Os_TAUJ3_CH03_CAT2_ISR) || (PWM_ISR_CATEGORY_2 == STD_ON)
/* Use ISR() macro from Os.h */
/* Defines the CAT1 interrupt mapping */
#else
extern _INTERRUPT_ FUNC(void, PWM_CODE_FAST) TAUJ3_CH03_ISR(void);
#endif
#endif /* End of PWM_TAUJ3_CH03_ISR_API == STD_ON */

#define PWM_STOP_SEC_CODE_FAST
#include "Pwm_Mapping.h"

#endif /* PWM_TAUJ_IRQ_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
