/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Adc_ADCK_LLDriver.h                                                                                 */
/* SW-VERSION   = 1.4.5                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2021,2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Private functions declarations.                                                                                    */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3: 11/05/2022 : Removed prototype declarations for functions changed to STATIC.
 * 1.4.1: 24/11/2021 : Initial Version
 */
/**********************************************************************************************************************/
#ifdef ADC_INSTANCE_INDEX
  #if (ADC_INSTANCE_INDEX == 0)
    #ifndef ADC_59_INST0_ADCK_LLDRIVER_H
      #define ADC_59_INST0_ADCK_LLDRIVER_H
      #define ADC_ADCK_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 1)
    #ifndef ADC_59_INST1_ADCK_LLDRIVER_H
      #define ADC_59_INST1_ADCK_LLDRIVER_H
      #define ADC_ADCK_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 2)
    #ifndef ADC_59_INST2_ADCK_LLDRIVER_H
      #define ADC_59_INST2_ADCK_LLDRIVER_H
      #define ADC_ADCK_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 3)
    #ifndef ADC_59_INST3_ADCK_LLDRIVER_H
      #define ADC_59_INST3_ADCK_LLDRIVER_H
      #define ADC_ADCK_LLDRIVER_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 4)
    #ifndef ADC_59_INST4_ADCK_LLDRIVER_H
      #define ADC_59_INST4_ADCK_LLDRIVER_H
      #define ADC_ADCK_LLDRIVER_HEADER
    #endif
  #else
    #error "Miss instance index"
  #endif
#else
  #ifndef ADC_ADCK_LLDRIVER_H
    #define ADC_ADCK_LLDRIVER_H
    #define ADC_ADCK_LLDRIVER_HEADER
  #endif
#endif

#ifdef ADC_ADCK_LLDRIVER_HEADER
#undef ADC_ADCK_LLDRIVER_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define ADC_ADCK_LLDRIVER_AR_RELEASE_MAJOR_VERSION    ADC_AR_RELEASE_MAJOR_VERSION
#define ADC_ADCK_LLDRIVER_AR_RELEASE_MINOR_VERSION    ADC_AR_RELEASE_MINOR_VERSION
#define ADC_ADCK_LLDRIVER_AR_RELEASE_REVISION_VERSION ADC_AR_RELEASE_REVISION_VERSION

/* Module Software version information */
#define ADC_ADCK_LLDRIVER_SW_MAJOR_VERSION            ADC_SW_MAJOR_VERSION
#define ADC_ADCK_LLDRIVER_SW_MINOR_VERSION            ADC_SW_MINOR_VERSION

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/
#define ADC_START_SEC_PRIVATE_CODE
#include "Adc_Mapping.h"

extern FUNC(void, ADC_PRIVATE_CODE) Adc_AdcInit(const uint8 LucHwUnitIndex);
#if (ADC_DEINIT_API == STD_ON)
extern FUNC(void, ADC_PRIVATE_CODE) Adc_AdcDeInit(const uint8 LucHwUnitIndex);
#endif /* (ADC_DEINIT_API == STD_ON) */

#if (ADC_TRACK_AND_HOLD == STD_ON)
extern FUNC(void, ADC_PRIVATE_CODE) Adc_TrackHoldEnable(const Adc_GroupType LddGroup);
extern FUNC(void, ADC_PRIVATE_CODE) Adc_TrackHoldDisable(const Adc_GroupType LddGroup);
#endif /* (ADC_TRACK_AND_HOLD == STD_ON) */

#if (ADC_ENABLE_PARITY_ERR_INT == STD_ON)
extern FUNC(void, ADC_PRIVATE_CODE) Adc_EcmErrorInterrupt(const boolean LblEnableInterrupt);
#endif /* (ADC_ENABLE_PARITY_ERR_INT == STD_ON) */

#define ADC_STOP_SEC_PRIVATE_CODE
#include "Adc_Mapping.h"

#endif /* ADC_ADCK_LLDRIVER_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
