/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Lin_PBcfg.c                                                                                         */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains post-build time parameters.                                                                     */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  LinU2x.dll version: 1.5.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Lin_Lin_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Mcu_Mcu_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_LIN_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Lin.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\EcuM\xml\EcuM_Lin.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  27 Apr 2025 - 14:14:01
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
/* LIN post-build configuration header */
#include "Lin.h"
#include "Lin_Ram.h"


/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/**********************************************************************************************************************/
/* Message(2:0315)     : Implicit conversion from a pointer to object type to a pointer to void.                      */
/* Rule                : No MISRA-C:2012 Rules applicable to message 0315                                             */
/*                       REFERENCE - ISO:C90-6.3.4 Cast Operators - Semantics                                         */
/* JV-01 Justification : An expression of type 'pointer-to-object' is being implicitly converted to type              */
/*                       'pointer-to-void'. 'Void pointers' should be used with care                                  */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message(2:0306)     : Cast between a pointer to object and an integral type.                                       */
/* Rule                : MISRA-C:2012 Rule 11.4, 11.6, CERT-C:1.2.4 CERTCCM INT36                                     */
/* JV-01 Justification : Void pointer is used in order to typecast to different channel structures later.             */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message(2:3432)     : Simple macro argument expression is not parenthesized.                                       */
/* Rule                : MISRA-C:2012 Rule-20.7                                                                       */
/* JV-01 Justification : Compiler keyword (macro) is defined and used followed AUTOSAR standard rule. It is accepted. */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message(1:1504)     : The object 'name' is only referenced in the translation unit where it is defined.            */
/* Rule                : MISRA C:2012 Rule-8.7, CERT-C:1.2.4 CERTCCM DCL15                                            */
/* JV-01 Justification : This is accepted since there is no problem with the software behavior.                       */
/*                       It is retained for future usage.                                                             */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message(4:5087)     : Use of #include directive after code fragment.                                               */
/* Rule                : MISRA-C:2012 Rule-20.1                                                                       */
/* JV-01 Justification : This is accepted, due to implementation for include memmap is following AUTOSAR rule.        */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/



/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define LIN_PBCFG_C_AR_RELEASE_MAJOR_VERSION                                    4U
#define LIN_PBCFG_C_AR_RELEASE_MINOR_VERSION                                    3U
#define LIN_PBCFG_C_AR_RELEASE_REVISION_VERSION                                 1U

/* File version information */
#define LIN_PBCFG_C_SW_MAJOR_VERSION                                            1U
#define LIN_PBCFG_C_SW_MINOR_VERSION                                            5U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/
/* Specification Major Version Check */
#if (LIN_PBTYPES_AR_RELEASE_MAJOR_VERSION != \
LIN_PBCFG_C_AR_RELEASE_MAJOR_VERSION)
#error "Lin_PBcfg.c : Mismatch in Release Major Version"
#endif

#if (LIN_PBTYPES_AR_RELEASE_MINOR_VERSION != \
LIN_PBCFG_C_AR_RELEASE_MINOR_VERSION)
#error "Lin_PBcfg.c : Mismatch in Release Minor Version"
#endif

#if (LIN_PBTYPES_AR_RELEASE_REVISION_VERSION != \
LIN_PBCFG_C_AR_RELEASE_REVISION_VERSION)
#error "Lin_PBcfg.c : Mismatch in Release Revision Version"
#endif

#if (LIN_PBTYPES_SW_MAJOR_VERSION != LIN_PBCFG_C_SW_MAJOR_VERSION)
#error "Lin_PBcfg.c : Mismatch in Software Major Version"
#endif

#if (LIN_PBTYPES_SW_MINOR_VERSION != LIN_PBCFG_C_SW_MINOR_VERSION)
#error "Lin_PBcfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/
#define LIN_START_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Lin_MemMap.h"

/* RAM allocation for all active Channels */
volatile VAR(Lin_RamData, LIN_VAR_NO_INIT) Lin_GaaChannelRamData[LIN_NO_OF_CHANNELS];                                   /* PRQA S 1504 # JV-01 */


#define LIN_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define LIN_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* This structure contains module specific parameters */
CONST(Lin_ConfigType, LIN_CONFIG_DATA) Lin_GaaConfiguration[] =
{
  /* Index: 0 - LinGlobalConfig */
  {
    /* ulStartOfDbToc */
    0x0ED48128UL,

    /* pFirstChannel */
    &Lin_GaaChannelConfig[0],                                                                                           /* PRQA S 0315 # JV-01 */

    /* pRLIN3Properties */
    &Lin_GaaRLIN3Properties[0],                                                                                         /* PRQA S 0315 # JV-01 */

    /* pFrameVariables */
    &Lin_GaaChannelRamData[0]                                                                                           /* PRQA S 0315 # JV-01 */
  }
};

#define LIN_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


#define LIN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* This array contains channel specific information for all active channels */
CONST(Lin_ChannelInfo, LIN_CONFIG_DATA) Lin_GaaChannelConfig[] =                                                        /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - LinChannel */
  {
    /* ucWakeupSourceId */
    EcuMConf_EcuMWakeupSource_EcuMWakeupSource,

    /* ucModReg */
    0x00U,

    /* ucPropertiesIndex */
    0x00U,

    /* blWakeupSupport */
    LIN_TRUE,

    /* ucRLINBreakfieldwidth */
    0x00U,

    /* ucRLINInterbytespace */
    0x00U
  }
};

/* This array contains RLIN3 channel specific information for all active channels */
CONST(Lin3_ChannelConfigType, LIN_CONFIG_DATA) Lin_GaaRLIN3Properties[] =                                               /* PRQA S 1504 # JV-01 */
{
  /* Index: 0 - LinChannel */
  {
    /* pLn3ChanlBaseAddress */
    (P2VAR(RLin3_UartRegs, TYPEDEF, REGSPACE)) 0xFFD28001UL,                                                            /* PRQA S 0306, 3432 # JV-01, JV-01 */

    /* ucBaudRate */
    0x81U,

    /* ucPrescalerClk_Select */
    0x02U,

    /* ucBitSamples */
    0x00U,

    /* blLinSpec_Select */
    LIN_FALSE,

    /* pLin3IntTxEicReg */
    (P2VAR(uint16, TYPEDEF, REGSPACE)) 0xFFF80342UL,                                                                    /* PRQA S 0306, 3432 # JV-01, JV-01 */

    /* pLin3IntRxEicReg */
    (P2VAR(uint16, TYPEDEF, REGSPACE)) 0xFFF80344UL,                                                                    /* PRQA S 0306, 3432 # JV-01, JV-01 */

    /* pLin3IntStEicReg */
    (P2VAR(uint16, TYPEDEF, REGSPACE)) 0xFFF80346UL                                                                     /* PRQA S 0306, 3432 # JV-01, JV-01 */
  }
};

#define LIN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Lin_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */





/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

