#ifndef _RTE_CAN_H_
#define _RTE_CAN_H_

#include "TYW_stdint.h"

typedef enum
{
    CAN_OK,
    CAN_NOT_OK,
    CAN_BUSY1,
} Can_ReturnType1;

typedef enum
{
    CAN_N_TX   = 0u,
    CAN_Y_TX   = 1u,
    CAN_N_F_TX = 0x81u,
} Can_SendType;

typedef enum
{
    CAN_N_RX   = 0u,
    CAN_Y_RX   = 1u,
    CAN_N_F_RX = 0x81u,
} Can_ReceiveType;

typedef struct
{
    uint32_t MsgID;
    uint8_t  MsgStd;
    uint8_t  MsgRTR;
    uint8_t  MsgDLC;
    uint8_t  MsgPro;
    uint8_t  Msg [ 8 ];
} _CAN_Msg;

void    Can_Lock_Clr(void);
void    CAN_BUSOFF_Recover(void);
void    Can_Init1(void);
uint8_t Can0_Write0(_CAN_Msg *Msg);
uint8_t Can_CH1_Write(_CAN_Msg *Msg);
uint8_t Can_CH2_Write(_CAN_Msg *Msg);
void    Can_Sleep_Fun(void);
void    Can_SleepController_Fun(void);
void    Can_Wakeup_Fun(void);

void    Can0_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg []);
void    Can0_Confirm(uint32_t Identifier, uint8_t TransferStatus);

void    Can1_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg []);
void    Can1_Confirm(uint32_t Identifier, uint8_t TransferStatus);

void    Can2_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg []);
void    Can2_Confirm(uint32_t Identifier, uint8_t TransferStatus);

void    Can0_Abort_All(void);
void    Can1_Abort_All(void);
void    Can_Uds_Abort(void);

void test_can(uint32_t u32ID);
extern uint8_t CAN_CH0_Send_Disable_Get(uint16_t u16SendID,uint8_t u8Off);
extern void CAN_CH0_Send_Disable_Set(uint16_t u16SendID,uint8_t u8Off);
extern uint8_t CAN_CH1_Send_Disable_Get(uint16_t u16SendID,uint8_t u8Off);
extern void CAN_CH1_Send_Disable_Set(uint16_t u16SendID,uint8_t u8Off);
extern void RTE_CAN_Send_Init(void);
#endif
