/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Adc_ADCJ_PBTypes.h                                                                                  */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains the type definitions of Post-build Time Parameters                                              */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.4: 21/06/2022 : Added macros ADC_NUM_OF_TRIGG_SELECT, ADC_NUM_OF_PIC_CONTROL, and ADC_NUM_OF_PIC_SELECT.
 *                     Unified struct Adc_HwTriggSpecRegisters to Adc_SgTriggRegType.
 *                     Renamed the member aaADCKnSGTSELx in the struct Adc_SgTriggRegType to aaADCXnSGTSELx.
 *        15/06/2022 : Added macro ADC_ADCX_THSTPCR_THSTP.
 *                     Removed macros ADC_ENABLE_ASMPMSK and ADC_DISABLE_ASMPMSK.
 *                     Renamed macro ADC_SET_SMPST to ADC_ADCX_THSMPSTCR_SMPST.
 *                     Renamed macro ADC_SET_HLDST to ADC_ADCX_THAHLDSTCR_HLDST.
 *                     Changed values of ADC_TH_DISABLED to 0xFF and ADC_TH_GROUPA to 0x00.
 * 1.4.3: 18/05/2022 : Fixed the typos in comments
 * 1.4.1: 24/11/2021 : Added instance 4 to the suppression of duplicate inclusion.
 * 1.3.2: 09/09/2021 : Changed the names of macros for parity error bit of ECM CFG registers.
 *                     Added the macro ADC_ADCX_SGTSEL_INIT.
 *                     changed the name of SG trigger control register.
 *        06/09/2021 : Update header file macro to call file multiple times.
 *        03/09/2021 : Added macro for accessing PWM-Diag Data and Information.
 *        25/08/2021 : Added new macros for handling PWM-Diag registers.
 *                     Fixed typo of macro ADC_ADCX_ODCR_INIT_VALUE.
 * 1.3.1: 13/07/2021 : Added macros for Wiring Break Detection Control Register.
 *        07/07/2021 : Added QAC message 9.5.0
 *                     Changed comment format to 120 columns
 *                     Changed violation tag from START/END
 *        24/06/2021 : Removed the macro that not using.
 *        16/06/2021 : Updated by nesting ADC register structures.
 *                     Move scan group definition to "Adc_ADCJ_PBTypes.h".
 *        07/04/2021 : Changed to comply with coding rules.
 * 1.2.0: 04/08/2020 : Release
 *                     Add macro ADC_ECM_PARITY_MASK.
 *                     Add macro ADC1_ERR_EIC_OFFSET, ADC2_ERR_EIC_OFFSET.
 * 1.1.0: 19/06/2020 : Release
 * 1.0.1: 18/06/2020 : Move macro ADC_INVALID_CHANNELID from Adc_ADCJ_PBTypes.h,
 *                     Adc_ADCH_PBTypes.h to Adc_PBTypes.h and change the value
 *                     to 0xFF
 * 1.0.0: 09/01/2020 : Initial Version
 */
/**********************************************************************************************************************/
#ifdef ADC_INSTANCE_INDEX
  #if (ADC_INSTANCE_INDEX == 0)
    #ifndef ADC_59_INST0_ADCJ_PBTYPES_H
      #define ADC_59_INST0_ADCJ_PBTYPES_H
      #define ADC_ADCJ_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 1)
    #ifndef ADC_59_INST1_ADCJ_PBTYPES_H
      #define ADC_59_INST1_ADCJ_PBTYPES_H
      #define ADC_ADCJ_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 2)
    #ifndef ADC_59_INST2_ADCJ_PBTYPES_H
      #define ADC_59_INST2_ADCJ_PBTYPES_H
      #define ADC_ADCJ_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 3)
    #ifndef ADC_59_INST3_ADCJ_PBTYPES_H
      #define ADC_59_INST3_ADCJ_PBTYPES_H
      #define ADC_ADCJ_PBTYPES_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 34)
    #ifndef ADC_59_INST4_ADCJ_PBTYPES_H
      #define ADC_59_INST4_ADCJ_PBTYPES_H
      #define ADC_ADCJ_PBTYPES_HEADER
    #endif
  #else
    #error "Miss instance index"
  #endif
#else
  #ifndef ADC_ADCJ_PBTYPES_H
    #define ADC_ADCJ_PBTYPES_H
    #define ADC_ADCJ_PBTYPES_HEADER
  #endif
#endif

#ifdef ADC_ADCJ_PBTYPES_HEADER
#undef ADC_ADCJ_PBTYPES_HEADER                                                                                          /* PRQA S 0841 # JV-01 */


/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:3630)    : The implementation of this struct/union type should be hidden.                               */
/* Rule                : MISRA C:2012 Dir-4.8                                                                         */
/* JV-01 Justification : This is accepted. Redundant of struct or union type has no affect to driver operation        */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* Macros for Limit Check Registers */
#define ADC_NUM_OF_LIMIT_REG          2U
#define ADC_ADCX_VCLMSCR2_ALL_MASK    (uint32)0xFFFFFFFFUL
#define ADC_ADCX_VCULLMTBR_INIT_VALUE (uint32)0x7FFF0000UL

/* Macro for Parity Error Register */
#define ADC_ADCX_PER_PECAP            (uint8)0x7FU

/* Macros for ID Error Register */
#define ADC_ADCX_IDER_IDECAP          (uint8)0x7FU
#define ADC_ADCX_IDER_IDE             (uint8)(1U << 7U)

/* Macro for Trigger Overlap Check Error Status Register */
#define ADC_ADCX_TOCER_TOCESG_LSB     (uint8)(1U << 1U)

/* Macros for Error Clear Register */
#define ADC_ADCX_ECR_IDEC             (Adc_ErrClearRegType)(1UL << 0U)
#define ADC_ADCX_ECR_TOCESGC_LSB      (Adc_ErrClearRegType)(1UL << 9U)
#define ADC_ADCX_ECR_CLEAR_ALL        (Adc_ErrClearRegType)0x3E05U

/* Macro for Wiring Break Detection Control Register */
#define ADC_ADCX_ODCR_INIT_VALUE      (Adc_WireBreakRegType)0x0000U

/* Macro for Scan Group Start Trigger Control Register */
#define ADC_ADCX_SGTSEL_INIT          (uint32)0x00000000UL

/* Macro for ECM Register */
#define ADC_ECM_CFG_ADC_PARITY_ERR    (uint32)(1UL << 8U)

#if (ADC_TRACK_AND_HOLD == STD_ON)
/* Macro to stop all T&H */
#define ADC_ADCX_THSTPCR_THSTP        (uint8)0x01U
/* Macro to set the bit SMPST */
#define ADC_ADCX_THSMPSTCR_SMPST      (uint8)0x01U
/* Macro to set the bit HLDST */
#define ADC_ADCX_THAHLDSTCR_HLDST     (uint8)0x01U
/* Macro to indicate Track and Hold Group */
#define ADC_TH_DISABLED               (uint8)0xFFU
#define ADC_TH_GROUPA                 (uint8)0x00U

/* Macros for T&H Group A Control Register */
#define ADC_ADCX_THACR_HLDTE          (uint8)(1U << 4U)
#define ADC_ADCX_THACR_HLDCTE         (uint8)(1U << 5U)
#endif /* (ADC_TRACK_AND_HOLD == STD_ON) */

#if (ADC_ENABLE_PWM_DIAG == STD_ON)
/* Macros for handling PWM-Diag */
#define ADC_ADCX_PWDCR_DISABLE        (uint8)0U
#define ADC_ADCX_PWDCR_PWE            (uint8)1U
#define ADC_ADCX_PWDSGCR_DISABLE      (uint8)0U
#define ADC_ADCX_PWDSGCR_TRGMD        (uint8)1U
#define ADC_ADCX_PWVCLMINTER_DISABLE  (uint8)0U
/* Macros to indicate PWM-Diag channel */
#define ADC_ADCX_PER_PECAP_PWD        (uint8)0x70U
#define ADC_ADCX_IDER_IDECAP_PWD      (uint8)0x70U
/* Macro for accessing PWM-Diag Data and Information */
#define ADC_PWM_DIAG_NUM_DATA         2UL
#endif /* (ADC_ENABLE_PWM_DIAG == STD_ON) */

/* Number of wait time registers */
#define ADC_NUM_OF_WAITTIME           (uint8)8U

/* Number of limit check registers */
#define ADC_NUM_OF_LIMIT_TABLE        8UL

/* Macro for EIC error register offset value */
#define ADC1_ERR_EIC_OFFSET           (uint8)0x06U
#define ADC2_ERR_EIC_OFFSET           (uint8)0x0CU

/* Number of scan group */
#define ADC_NUM_SCANGROUP             (uint8)0x05U

/* Number of virtual channel registers */
#define ADC_NUM_OF_VCR                64U

/* Number of PIC register groups */
#define ADC_NUM_OF_TRIGG_SELECT          1UL
#define ADC_NUM_OF_PIC_CONTROL           4UL
#define ADC_NUM_OF_PIC_SELECT            3UL

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
typedef uint16 Adc_WireBreakRegType;
typedef uint16 Adc_ErrClearRegType;

/***********************************************************************************************************************
** Structure for HW Unit Registers, which are used to read or write                                                   **
** the status or configured values for proper working of the ADC driver                                               **
***********************************************************************************************************************/
/* Structure for registers of Scan Group */
typedef struct STag_Adc_SGRegType
{
  volatile uint8  ucADCXnSGSTCRx;                                   /* 00H */
  volatile uint8  aaReserved0[3];
  volatile uint8  ucADCXnSGSTPCRx;                                  /* 04H */
  volatile uint8  aaReserved1[3];
  volatile uint8  ucADCXnADTSTCRx;                                  /* 08H */
  volatile uint8  aaReserved2[3];
  volatile uint8  ucADCXnADTENDCRx;                                 /* 0CH */
  volatile uint8  aaReserved3[3];
  volatile uint8  ucADCXnSGCRx;                                     /* 10H */
  volatile uint8  aaReserved4[3];
  volatile uint16 usADCXnSGVCPRx;                                   /* 14H */
  volatile uint8  aaReserved5[2];
  volatile uint8  ucADCXnSGMCYCRx;                                  /* 18H */
  volatile uint8  aaReserved6[7];
  volatile uint8  ucADCXnSGSRx;                                     /* 20H */
  volatile uint8  aaReserved7[3];
  volatile uint32 ulADCXnADTIPRx;                                   /* 24H */
  volatile uint32 ulADCXnADTPRRx;                                   /* 28H */
  volatile uint8  aaReserved8[20];
} Adc_SGRegType;                                                    /* size 40H */

/* Structure for registers of Wait Time */
typedef struct STag_Adc_WaitTimeRegType
{
  volatile uint16 usWAITTRy;                                        /* 00H */
  volatile uint8  aaReserved0[2];
} Adc_WaitTimeRegType;                                              /* size 04H */

/* Structure for ADCJ registers */
typedef struct STag_Adc_ConfigRegisters                                                                                 /* PRQA S 3630 # JV-01 */
{
  volatile uint32 aaADCXnVCR[ADC_NUM_OF_VCR];                       /* 000H */
  volatile uint8  aaReserved0[128];
  volatile uint32 ulADCXnPWDVCR;                                    /* 180H */
  volatile uint8  aaReserved1[28];
  volatile uint16 aaADCXnDR[ADC_NUM_OF_VCR];                        /* 1A0H */
  volatile uint8  aaReserved2[64];
  volatile uint16 usADCXnPWDDR;                                     /* 260H */
  volatile uint8  aaReserved3[30];
  volatile uint32 aaADCXnDIR[ADC_NUM_OF_VCR];                       /* 280H */
  volatile uint8  aaReserved4[128];
  volatile uint32 ulADCXnPWDDIR;                                    /* 400H */
  volatile uint8  aaReserved5[60];
  volatile Adc_SGRegType aaADCXnSG[ADC_NUM_SCANGROUP];              /* 440H */
  volatile uint8  ucADCXnPWDCR;                                     /* 580H */
  volatile uint8  aaReserved6[3];
  volatile uint8  ucADCXnPWDSGCR;                                   /* 584H */
  volatile uint8  aaReserved7[123];
  volatile uint16 usADCXnSGSTR;                                     /* 600H */
  volatile uint8  aaReserved8[14];
  volatile uint8  ucADCXnADSYNSTCR;                                 /* 610H */
  volatile uint8  aaReserved9[3];
  volatile uint8  ucADCXnADTSYNSTCR;                                /* 614H */
  volatile uint8  aaReserved10[43];
  volatile uint8  ucADCXnADHALTR;                                   /* 640H */
  volatile uint8  aaReserved11[3];
  volatile uint8  ucADCXnADCR1;                                     /* 644H */
  volatile uint8  aaReserved12[3];
  volatile uint8  ucADCXnADCR2;                                     /* 648H */
  volatile uint8  aaReserved13[3];
  volatile uint32 ulADCXnSMPCR;                                     /* 64CH */
  volatile uint8  ucADCXnMPXCURCR;                                  /* 650H */
  volatile uint8  aaReserved14[3];
  volatile uint8  ucADCXnMPXINTER;                                  /* 654H */
  volatile uint8  aaReserved15[3];
  volatile uint32 ulADCXnMPXCURR1;                                  /* 658H */
  volatile uint8  ucADCXnMPXCURR2;                                  /* 65CH */
  volatile uint8  aaReserved16[3];
  volatile uint8  ucADCXnMPXCMDR;                                   /* 660H */
  volatile uint8  aaReserved17[15];
  volatile uint16 usADCXnGTMENTSGER;                                /* 670H */
  volatile uint8  aaReserved18[2];
  volatile uint8  ucADCXnADENDP0;                                   /* 674H */
  volatile uint8  aaReserved19[3];
  volatile uint8  ucADCXnADENDP1;                                   /* 678H */
  volatile uint8  aaReserved20[3];
  volatile uint8  ucADCXnADENDP2;                                   /* 67CH */
  volatile uint8  aaReserved21[3];
  volatile uint8  ucADCXnADENDP3;                                   /* 680H */
  volatile uint8  aaReserved22[3];
  volatile uint8  ucADCXnADENDP4;                                   /* 684H */
  volatile uint8  aaReserved23[11];
  volatile uint8  ucADCXnTHSMPSTCR;                                 /* 690H */
  volatile uint8  aaReserved24[3];
  volatile uint8  ucADCXnTHSTPCR;                                   /* 694H */
  volatile uint8  aaReserved25[3];
  volatile uint8  ucADCXnTHCR;                                      /* 698H */
  volatile uint8  aaReserved26[7];
  volatile uint8  ucADCXnTHAHLDSTCR;                                /* 6A0H */
  volatile uint8  aaReserved27[19];
  volatile uint8  ucADCXnTHER;                                      /* 6B4H */
  volatile uint8  aaReserved28[11];
  volatile uint8  ucADCXnTHACR;                                     /* 6C0H */
  volatile uint8  aaReserved29[63];
  volatile Adc_WaitTimeRegType aaADCXnWAITTRy[ADC_NUM_OF_WAITTIME]; /* 700H */
  volatile uint8  aaReserved30[32];
  volatile uint8  ucADCXnVMONVDCR1;                                 /* 740H */
  volatile uint8  aaReserved31[3];
  volatile uint8  ucADCXnVMONVDCR2;                                 /* 744H */
  volatile uint8  aaReserved32[27];
  volatile uint8  ucADCXnTDCR;                                      /* 760H */
  volatile uint8  aaReserved33[3];
  volatile Adc_WireBreakRegType ddADCXnODCR;                        /* 764H */
  volatile uint8  aaReserved34[10];
  volatile uint8  ucADCXnSFTCR;                                     /* 770H */
  volatile uint8  aaReserved35[3];
  volatile uint8  ucADCXnTOCCR;                                     /* 774H */
  volatile uint8  aaReserved36[27];
  volatile uint8  ucADCXnTOCER;                                     /* 790H */
  volatile uint8  aaReserved37[11];
  volatile uint8  ucADCXnOWER;                                      /* 79CH */
  volatile uint8  aaReserved38[3];
  volatile uint8  ucADCXnPER;                                       /* 7A0H */
  volatile uint8  aaReserved39[3];
  volatile uint8  ucADCXnIDER;                                      /* 7A4H */
  volatile uint8  aaReserved40[3];
  volatile Adc_ErrClearRegType ddADCXnECR;                          /* 7A8H */
  volatile uint8  aaReserved41[86];
  volatile uint32 aaADCXnVCULLMTBRy[ADC_NUM_OF_LIMIT_TABLE];        /* 800H */
  volatile uint8  aaReserved42[32];
  volatile uint32 aaADCXnVCLMINTER[ADC_NUM_OF_LIMIT_REG];           /* 840H */
  volatile uint8  aaReserved43[4];
  volatile uint8  ucADCXnPWVCLMINTER;                               /* 84CH */
  volatile uint8  aaReserved44[19];
  volatile uint32 aaADCXnVCLMSR[ADC_NUM_OF_LIMIT_REG];              /* 860H */
  volatile uint8  aaReserved45[4];
  volatile uint32 ulADCXnPWVCLMSR;                                  /* 86CH */
  volatile uint8  aaReserved46[16];
  volatile uint16 usADCXnSGULCR0;                                   /* 880H */
  volatile uint8  aaReserved47[2];
  volatile uint16 usADCXnSGULCR1;                                   /* 884H */
  volatile uint8  aaReserved48[2];
  volatile uint16 usADCXnSGULCR2;                                   /* 888H */
  volatile uint8  aaReserved49[2];
  volatile uint16 usADCXnSGULCR3;                                   /* 88CH */
  volatile uint8  aaReserved50[2];
  volatile uint16 usADCXnSGULCR4;                                   /* 890H */
  volatile uint8  aaReserved51[14];
  volatile uint32 aaADCXnVCLMSCR[ADC_NUM_OF_LIMIT_REG];             /* 8A0H */
  volatile uint8  aaReserved52[4];
  volatile uint8  ucADCXnPWVCLMSCR;                                 /* 8ACH */
  volatile uint8  aaReserved53[7];
  volatile uint8  ucADCXnSGULCCR;                                   /* 8B4H */
  volatile uint8  aaReserved54[3];
  volatile uint8  ucADCXnVCLMASCR;                                  /* 8B8H */
  volatile uint8  aaReserved55[3];
} Adc_ConfigRegisters;                                              /* size 8BCH */

/***********************************************************************************************************************
** Structure for Scan Group Start Trigger Control Registers                                                           **
***********************************************************************************************************************/
#if (ADC_ENABLE_ADC_TSEL == STD_ON)
typedef struct STag_Adc_SgTriggRegType                                                                                  /* PRQA S 3630 # JV-01 */
{
  /* Scan Group x Start Trigger Control Register */
  volatile uint32 aaADCXnSGTSELx[ADC_NUM_SCANGROUP];
} Adc_SgTriggRegType;
#endif /* (ADC_ENABLE_ADC_TSEL == STD_ON) */

/***********************************************************************************************************************
** Structure for wait time configuration                                                                              **
***********************************************************************************************************************/
typedef struct STag_Adc_WaitTimeConfigType
{
  /* Store value of ADCJnWAITTRy */
  uint16 usWAITTRy[ADC_NUM_OF_WAITTIME];
} Adc_WaitTimeConfigType;

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#endif /* ADC_ADCJ_PBTYPES_H */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
