/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_Types.h                                                                                         */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* API function implementations of PWM  Driver                                                                        */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.4.2: 26/02/2022 : Updated SW VERSION to 1.4.2 and add macro PWM_TOTAL_HWFUNC_SUPPORTED                           **
 * 1.3.2: 04/08/2021 : Device specific implementation move to device specific file.                                   **
 *                     Format source code unified within module.                                                      **
 * 1.3.1: 02/07/2021 : Add QAC message 9.5.0                                                                          **
 *                     Format source code to 120 characters                                                           **
 *                     Improve Violation tag (remove START/END)                                                       **
 *        15/05/2021  : Fixed Coding Rule and tailor space                                                            **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.1: 27/05/2020 : Modify "aaTimerUnitConfig[PWM_TOTAL_HW_IP_CONFIG]"                                             **
 *                     to "aaTimerUnitConfig[PWM_TOTAL_HW_IP_SUPPORTED]"                                              **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_TYPES_H
            #define PWM_59_INST0_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_TYPES_H
            #define PWM_59_INST1_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_TYPES_H
            #define PWM_59_INST2_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_TYPES_H
            #define PWM_59_INST3_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_TYPES_H
            #define PWM_59_INST4_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_TYPES_H
            #define PWM_59_INST5_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_TYPES_H
            #define PWM_59_INST6_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_TYPES_H
            #define PWM_59_INST7_TYPES_H
            #define PWM_TYPES_HEADER
        #endif
    #else
        #error "Miss instance index"
    #endif
#else
    #ifndef PWM_TYPES_H
        #define PWM_TYPES_H
        #define PWM_TYPES_HEADER
    #endif
#endif

#ifdef PWM_TYPES_HEADER
#undef PWM_TYPES_HEADER                                                                                                 /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/
/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define PWM_TYPES_AR_RELEASE_MAJOR_VERSION    PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_TYPES_AR_RELEASE_MINOR_VERSION    PWM_AR_RELEASE_MINOR_VERSION
#define PWM_TYPES_AR_RELEASE_REVISION_VERSION PWM_AR_RELEASE_REVISION_VERSION
/* Software module version information */
#define PWM_TYPES_SW_MAJOR_VERSION            PWM_SW_MAJOR_VERSION
#define PWM_TYPES_SW_MINOR_VERSION            PWM_SW_MINOR_VERSION
/**********************************************************************************************************************/

#define PWM_TOTAL_HWFUNC_SUPPORTED            4

/* Type definition for Pwm_ChannelType */
typedef uint8 Pwm_ChannelType;
/* Type definition for Pwm_PeriodType */
typedef uint32 Pwm_PeriodType;
/* Type definition for Pwm_OutputStateType */
typedef enum ETag_Pwm_OutputStateType
{
  PWM_LOW = 0,
  PWM_HIGH
} Pwm_OutputStateType;
/* Type definition for Pwm_EdgeNotificationType */
typedef enum ETag_Pwm_EdgeNotificationType
{
  PWM_RISING_EDGE = 0,
  PWM_FALLING_EDGE,
  PWM_BOTH_EDGES
} Pwm_EdgeNotificationType;
/* Type definition for Pwm_ChannelClassType */
typedef enum ETag_Pwm_ChannelClassType
{
  PWM_VARIABLE_PERIOD = 0,
  PWM_FIXED_PERIOD,
  PWM_FIXED_PERIOD_SHIFTED
} Pwm_ChannelClassType;

/* Type definition for Pwm_ClockSourceType */
#if ((PWM_TAUD_UNIT_USED == STD_ON) || (PWM_TAUJ_UNIT_USED == STD_ON))
typedef enum ETag_Pwm_ClockSourceType
{
  CLKBUSLINE0 = 0,
  CLKBUSLINE1,
  CLKBUSLINE2,
  CLKBUSLINE3,
  PWM_INVALID_CLOCK_SOURCE
} Pwm_ClockSourceType;
#elif (PWM_ATU_UNIT_USED == STD_ON)
typedef enum ETag_Pwm_ClockSourceType
{
  CLKBUSLINE0 = 0x00,
  CLKBUSLINE1 = 0x01,
  CLKBUSLINE2 = 0x02,
  CLKBUSLINE3 = 0x03,
  INVALID_CLOCK_SOURCE = 0x0F
} Pwm_ClockSourceType;
#endif

/* Structure for Pwm_Init configuration */
/* Overall module configuration data structure */
typedef struct STag_Pwm_ConfigType
{
  /* Database start value */
  uint32 ulStartOfDbToc;
  /* Pointer to PWM Driver Sub-block Unit configuration */
  P2CONST(void, TYPEDEF, PWM_CONFIG_CONST) aaTimerUnitConfig[PWM_TOTAL_HWFUNC_SUPPORTED];
  /* Pointer to PWM Driver channel configuration */
  P2CONST(void, TYPEDEF, PWM_CONFIG_DATA) pChannelConfig;
  /* Pointer to PWM Driver HWIP configuration */
  P2CONST(void, TYPEDEF, PWM_CONFIG_DATA) pHWIPConfig;
} Pwm_ConfigType;

/***********************************************************************************************************************
**                                     Structure for PWM HW-IP config information                                     **
***********************************************************************************************************************/
/* Data Structure for PWM required for Initializing the PWM timer unit */
typedef struct STag_Pwm_HWIP_ConfigType
{
  /* Pointer to PWM driver Timer Unit configuration */
  VAR(uint8, PWM_VAR_NO_INIT) ucIndex;
} Pwm_HWIP_ConfigType;

#endif /* PWM_TYPES_H */

/***********************************************************************************************************************
**                                                    End Of File                                                     **
***********************************************************************************************************************/
