/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Dio_Lcfg.c                                                                                          */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains link time parameters                                                                            */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  DioU2x.dll version: 1.5.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Dio_Dio_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_DIO_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  27 Apr 2025 - 14:14:12
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
#include "Dio.h"                                                                                                        /* PRQA S 0857 # JV-01 */

#include "Dio_LTTypes.h"


/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/**********************************************************************************************************************/
/* Message (5:0303)    : Cast between a pointer to volatile object and an integral type.                              */
/* Rule                : MISRA C:2012 Rule 11.4, CERT-C:1.2.4 CERTCCM INT36                                           */
/* JV-01 Justification : This macro is used to write or read values from hardware addresses.                          */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (2:0857)    : Number of macro definitions exceeds 1024 - program does not conform strictly to ISO:C90.     */
/* Rule                : MISRA C:2012 Dir-1.1                                                                         */
/* JV-01 Justification : The number of macro depend on module code size. There is no issue when number of macro       */
/*                       is over 1024                                                                                 */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1531)    : The object 'name' is referenced in only one translation unit - but not the one in which      */
/*                       it is defined.                                                                               */
/* Rule                : MISRA C:2012 Rule-8.7, CERT-C:1.2.4 CERTCCM DCL15, CERTCCM DCL19                             */
/* JV-01 Justification : Followed coding rules, the objects (global variable/const) is define in seperated source     */
/*                       file, so this could be accepted                                                              */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (1:1533)    : The object 'name' is only referenced by function 'func'.                                     */
/* Rule                : MISRA C:2012 Rule-8.9                                                                        */
/* JV-01 Justification : This is accepted, due to the object is defined in seperated cource C file to                 */
/*                       followed coding rule                                                                         */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : #include directives should only be preceded by preprocessor directives or comments           */
/* Rule                : MISRA C:2012 Rule 20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define DIO_LCFG_C_AR_RELEASE_MAJOR_VERSION                                     4U
#define DIO_LCFG_C_AR_RELEASE_MINOR_VERSION                                     3U
#define DIO_LCFG_C_AR_RELEASE_REVISION_VERSION                                  1U
/* File version information */
#define DIO_LCFG_C_SW_MAJOR_VERSION                                             1U
#define DIO_LCFG_C_SW_MINOR_VERSION                                             5U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/
#if (DIO_LTTYPES_AR_RELEASE_MAJOR_VERSION != DIO_LCFG_C_AR_RELEASE_MAJOR_VERSION)
    #error "Dio_Lcfg.c : Mismatch in Release Major Version"
#endif

#if (DIO_LTTYPES_AR_RELEASE_MINOR_VERSION != DIO_LCFG_C_AR_RELEASE_MINOR_VERSION)
    #error "Dio_Lcfg.c : Mismatch in Release Minor Version"
#endif

#if (DIO_LTTYPES_AR_RELEASE_REVISION_VERSION != DIO_LCFG_C_AR_RELEASE_REVISION_VERSION)
    #error "Dio_Lcfg.c : Mismatch in Release Revision Version"
#endif

#if (DIO_LTTYPES_SW_MAJOR_VERSION != DIO_LCFG_C_SW_MAJOR_VERSION)
    #error "Dio_Lcfg.c : Mismatch in Software Major Version"
#endif

#if (DIO_LTTYPES_SW_MINOR_VERSION != DIO_LCFG_C_SW_MINOR_VERSION)
    #error "Dio_Lcfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/
#define DIO_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Dio_MemMap.h"


/* Structure of DIO Port Group Configuration */
CONST(Dio_PortGroupType, DIO_CONFIG_DATA) Dio_GaaPortGroup[] =                                                          /* PRQA S 1531 # JV-01 */
{
  /* Index: 0 - Port02 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90084UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFF0000UL,

    /* ulPortGroupNum */
    2UL
  },
  /* Index: 1 - Port03 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD900C4UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFFFE03UL,

    /* ulPortGroupNum */
    3UL
  },
  /* Index: 2 - Port04 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90104UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFF000CUL,

    /* ulPortGroupNum */
    4UL
  },
  /* Index: 3 - Port05 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90144UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFFFFA3UL,

    /* ulPortGroupNum */
    5UL
  },
  /* Index: 4 - Port06 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90184UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFF0002UL,

    /* ulPortGroupNum */
    6UL
  },
  /* Index: 5 - Port10 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90284UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFF8000UL,

    /* ulPortGroupNum */
    10UL
  },
  /* Index: 6 - Port17 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90444UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFFFF80UL,

    /* ulPortGroupNum */
    17UL
  },
  /* Index: 7 - Port20 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90504UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFF8800UL,

    /* ulPortGroupNum */
    20UL
  },
  /* Index: 8 - Port21 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90544UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFFFF00UL,

    /* ulPortGroupNum */
    21UL
  },
  /* Index: 9 - Port22 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90584UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFFFFE0UL,

    /* ulPortGroupNum */
    22UL
  },
  /* Index: 10 - Port24 */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFD90604UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x02U,

    /* ulModeMask */
    0xFFFFC00FUL,

    /* ulPortGroupNum */
    24UL
  },
  /* Index: 11 - UserPort_JTAG */
  {
    /* pPortAddress */
    (P2VAR(volatile uint32, TYPEDEF, REGSPACE))0xFFDA0004UL,                                                            /* PRQA S 0303 # JV-01 */

    /* ucPortType */
    0x01U,

    /* ulModeMask */
    0xFFFFFFD0UL,

    /* ulPortGroupNum */
    25UL
  }
};

/* Data Structure of DIO Port Channel Configuration */
CONST(Dio_PortChannelType, DIO_CONFIG_DATA) Dio_GaaPortChannel[] =                                                      /* PRQA S 1531 # JV-01 */
{
  /* Index: 0 - P02_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 1 - P02_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 2 - P02_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 3 - P02_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 4 - P02_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 5 - P02_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 6 - P02_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 7 - P02_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 8 - P02_08 */
  {
    /* usMask */
    0x0100U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 9 - P02_09 */
  {
    /* usMask */
    0x0200U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 10 - P02_10 */
  {
    /* usMask */
    0x0400U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 11 - P02_11 */
  {
    /* usMask */
    0x0800U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 12 - P02_12 */
  {
    /* usMask */
    0x1000U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 13 - P02_13 */
  {
    /* usMask */
    0x2000U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 14 - P02_14 */
  {
    /* usMask */
    0x4000U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 15 - P02_15 */
  {
    /* usMask */
    0x8000U,

    /* ucPortIndex */
    0x00U
  },
  /* Index: 16 - P03_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x01U
  },
  /* Index: 17 - P03_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x01U
  },
  /* Index: 18 - P03_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x01U
  },
  /* Index: 19 - P03_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x01U
  },
  /* Index: 20 - P03_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x01U
  },
  /* Index: 21 - P03_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x01U
  },
  /* Index: 22 - P03_08 */
  {
    /* usMask */
    0x0100U,

    /* ucPortIndex */
    0x01U
  },
  /* Index: 23 - P04_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 24 - P04_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 25 - P04_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 26 - P04_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 27 - P04_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 28 - P04_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 29 - P04_08 */
  {
    /* usMask */
    0x0100U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 30 - P04_09 */
  {
    /* usMask */
    0x0200U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 31 - P04_10 */
  {
    /* usMask */
    0x0400U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 32 - P04_11 */
  {
    /* usMask */
    0x0800U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 33 - P04_12 */
  {
    /* usMask */
    0x1000U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 34 - P04_13 */
  {
    /* usMask */
    0x2000U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 35 - P04_14 */
  {
    /* usMask */
    0x4000U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 36 - P04_15 */
  {
    /* usMask */
    0x8000U,

    /* ucPortIndex */
    0x02U
  },
  /* Index: 37 - P05_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x03U
  },
  /* Index: 38 - P05_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x03U
  },
  /* Index: 39 - P05_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x03U
  },
  /* Index: 40 - P05_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x03U
  },
  /* Index: 41 - P06_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 42 - P06_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 43 - P06_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 44 - P06_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 45 - P06_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 46 - P06_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 47 - P06_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 48 - P06_08 */
  {
    /* usMask */
    0x0100U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 49 - P06_09 */
  {
    /* usMask */
    0x0200U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 50 - P06_10 */
  {
    /* usMask */
    0x0400U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 51 - P06_11 */
  {
    /* usMask */
    0x0800U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 52 - P06_12 */
  {
    /* usMask */
    0x1000U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 53 - P06_13 */
  {
    /* usMask */
    0x2000U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 54 - P06_14 */
  {
    /* usMask */
    0x4000U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 55 - P06_15 */
  {
    /* usMask */
    0x8000U,

    /* ucPortIndex */
    0x04U
  },
  /* Index: 56 - P10_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 57 - P10_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 58 - P10_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 59 - P10_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 60 - P10_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 61 - P10_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 62 - P10_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 63 - P10_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 64 - P10_08 */
  {
    /* usMask */
    0x0100U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 65 - P10_09 */
  {
    /* usMask */
    0x0200U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 66 - P10_10 */
  {
    /* usMask */
    0x0400U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 67 - P10_11 */
  {
    /* usMask */
    0x0800U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 68 - P10_12 */
  {
    /* usMask */
    0x1000U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 69 - P10_13 */
  {
    /* usMask */
    0x2000U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 70 - P10_14 */
  {
    /* usMask */
    0x4000U,

    /* ucPortIndex */
    0x05U
  },
  /* Index: 71 - P17_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x06U
  },
  /* Index: 72 - P17_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x06U
  },
  /* Index: 73 - P17_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x06U
  },
  /* Index: 74 - P17_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x06U
  },
  /* Index: 75 - P17_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x06U
  },
  /* Index: 76 - P17_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x06U
  },
  /* Index: 77 - P17_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x06U
  },
  /* Index: 78 - P20_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 79 - P20_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 80 - P20_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 81 - P20_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 82 - P20_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 83 - P20_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 84 - P20_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 85 - P20_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 86 - P20_08 */
  {
    /* usMask */
    0x0100U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 87 - P20_09 */
  {
    /* usMask */
    0x0200U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 88 - P20_10 */
  {
    /* usMask */
    0x0400U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 89 - P20_12 */
  {
    /* usMask */
    0x1000U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 90 - P20_13 */
  {
    /* usMask */
    0x2000U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 91 - P20_14 */
  {
    /* usMask */
    0x4000U,

    /* ucPortIndex */
    0x07U
  },
  /* Index: 92 - P21_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 93 - P21_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 94 - P21_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 95 - P21_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 96 - P21_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 97 - P21_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 98 - P21_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 99 - P21_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x08U
  },
  /* Index: 100 - P22_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x09U
  },
  /* Index: 101 - P22_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x09U
  },
  /* Index: 102 - P22_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x09U
  },
  /* Index: 103 - P22_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x09U
  },
  /* Index: 104 - P22_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x09U
  },
  /* Index: 105 - P24_04 */
  {
    /* usMask */
    0x0010U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 106 - P24_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 107 - P24_06 */
  {
    /* usMask */
    0x0040U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 108 - P24_07 */
  {
    /* usMask */
    0x0080U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 109 - P24_08 */
  {
    /* usMask */
    0x0100U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 110 - P24_09 */
  {
    /* usMask */
    0x0200U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 111 - P24_10 */
  {
    /* usMask */
    0x0400U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 112 - P24_11 */
  {
    /* usMask */
    0x0800U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 113 - P24_12 */
  {
    /* usMask */
    0x1000U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 114 - P24_13 */
  {
    /* usMask */
    0x2000U,

    /* ucPortIndex */
    0x0AU
  },
  /* Index: 115 - UserChannel_JTAG_00 */
  {
    /* usMask */
    0x0001U,

    /* ucPortIndex */
    0x0BU
  },
  /* Index: 116 - UserChannel_JTAG_01 */
  {
    /* usMask */
    0x0002U,

    /* ucPortIndex */
    0x0BU
  },
  /* Index: 117 - UserChannel_JTAG_02 */
  {
    /* usMask */
    0x0004U,

    /* ucPortIndex */
    0x0BU
  },
  /* Index: 118 - UserChannel_JTAG_03 */
  {
    /* usMask */
    0x0008U,

    /* ucPortIndex */
    0x0BU
  },
  /* Index: 119 - UserChannel_JTAG_05 */
  {
    /* usMask */
    0x0020U,

    /* ucPortIndex */
    0x0BU
  }
};

/* Data Structure of DIO Port Channel Group Configuration */
CONST(Dio_ChannelGroupType, DIO_CONFIG_DATA) Dio_GaaChannelGroupData[] =
{
  /* Index: 0 - UserChannelGroup_JTAG */
  {
    /* usMask */
    0x000CU,

    /* ucOffset */
    0x02U,

    /* ucPortIndex */
    0x0BU
  }
};

/* Structure of DIO PWE Data */
CONST(uint32, DIO_CONFIG_DATA) DIO_GaaPweData[] =                                                                       /* PRQA S 1533 # JV-01 */
{
  /* Index:0 */
  0x00000000UL,
  /* Index:1 */
  0x00000000UL,
  /* Index:2 */
  0x00000008UL,
  /* Index:3 */
  0x00000000UL,
  /* Index:4 */
  0x00000000UL,
  /* Index:5 */
  0x00000000UL,
  /* Index:6 */
  0x00000080UL,
  /* Index:7 */
  0x00000000UL,
  /* Index:8 */
  0x00000000UL,
  /* Index:9 */
  0x00000000UL,
  /* Index:10 */
  0x00000000UL,
  /* Index:11 */
  0x00000000UL,
  /* Index:12 */
  0x00000000UL,
  /* Index:13 */
  0x00000000UL,
  /* Index:14 */
  0x00000000UL,
  /* Index:15 */
  0x00000000UL,
  /* Index:16 */
  0x00000000UL,
  /* Index:17 */
  0x00000000UL,
  /* Index:18 */
  0x00000000UL,
  /* Index:19 */
  0x00000000UL,
  /* Index:20 */
  0x00000000UL,
  /* Index:21 */
  0x00000000UL,
  /* Index:22 */
  0x00000000UL,
  /* Index:23 */
  0x00000000UL,
  /* Index:24 */
  0x00000000UL,
  /* Index:25 */
  0x00000000UL,
  /* Index:26 */
  0x00000000UL,
  /* Index:27 */
  0x00000000UL,
  /* Index:28 */
  0x00000000UL,
  /* Index:29 */
  0x00000000UL,
  /* Index:30 */
  0x00000000UL,
  /* Index:31 */
  0x00000000UL
};

#define DIO_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Dio_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */



/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

