/*============================================================================*/
/* Project      = AUTOSAR Renesas U2A8 MCAL Components                        */
/* Module       = App_Mcu_Device_Sample.h                                     */
/* SW-VERSION   = 1.1.0                                                       */
/* Date         = 19/06/2020                                                  */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) Zhan Yi. All rights reserved.             */
/*============================================================================*/
/* Purpose:                                                                   */
/* Header file information for application.                                   */
/*                                                                            */

/*******************************************************************************
**                      Revision Control History                              **
*******************************************************************************/
/*
 * 1.1.0:  19/06/2020  : Beta Release
 * 1.0.0:  28/12/2019  : Initial Versionn
 */
/******************************************************************************/
#ifndef APP_MCAL_H
#define APP_MCAL_H

/*******************************************************************************
**                      Include Section                                       **
*******************************************************************************/
#include "Mcu.h"
#include "Mcu_PBTypes.h"
#include "Mcu_Irq.h"
#include "Mcu_Cfg.h"

#include "Gpt.h"

/*******************************************************************************
**                      Version Information                                  **
*******************************************************************************/
/*
 * AUTOSAR specification version information
 */

/*
 * File version information
 */

/*******************************************************************************
**                      Global Symbols                                        **
*******************************************************************************/

#define Mcu_ModuleConfiguration \
                    Mcu_Config

#define MCU_LRAM_SETTING_0 \
                    McuRamSectorSettingConf_McuRamSectorSettingConf
                    
#define MCU_LRAM_SETTING_1 \
                    McuRamSectorSettingConf_McuRamSectorSettingConf_001
                    
#define MCU_LRAM_SETTING_2 \
                    McuRamSectorSettingConf_McuRamSectorSettingConf_002
                    
#define MCU_LRAM_SETTING_3 \
                    McuRamSectorSettingConf_McuRamSectorSettingConf_003
                    
#define MCU_LRAM_SELF_SETTING \
                    McuRamSectorSettingConf_McuRamSectorSettingConf_004
  
#define MCU_CRAM_SETTING \
                    McuRamSectorSettingConf_McuRamSectorSettingConf_005

#define Mcu_McuClockSettingConfig \
                  McuConf_McuClockSettingConfig_McuClockSettingConfig
                  
#define MCU_MODE_SETTING_0 \
                  McuConf_McuModeSettingConf_McuModeSettingConf
#define MCU_MODE_SETTING_DP \
                  McuConf_McuModeSettingConf_McuModeSettingConf_001
                  
#define MCU_INTC1_SELF_BASE                0xFFFC0000UL

#define MCU_ICR_REG_NUM                   2
#define MCU_ICR_REG_ADDR                  (MCU_INTC1_SELF_BASE + (8*2))

#define MCU_ICR_VECTOR_TABLEREF_VALUE     0x0040
#define MCU_ICR_MASK_VALUE                0x0080
#define MCU_ICR_PRIORITY                  0x0007

#define MCU_EIC_REG_VALUE (MCU_ICR_VECTOR_TABLEREF_VALUE | MCU_ICR_MASK_VALUE | MCU_ICR_PRIORITY)

/* PCR01_7 Register Address (0xFF610000 + 0x2000 + 1 * 0x40 + 7 * 4 ) */
#define MCU_PCR_REG_ADDR                  (0xFF61205C)

#define MCU_PCR_PINV_BIT_POSITION        30
#define MCU_PCR_PODC_BIT_POSITION        28
#define MCU_PCR_PODCE_BIT_POSITION       27
#define MCU_PCR_PUCC_BIT_POSITION        25
#define MCU_PCR_PDSC_BIT_POSITION        24
#define MCU_PCR_PISA_BIT_POSITION        21
#define MCU_PCR_PIS_BIT_POSITION         20
#define MCU_PCR_PU_BIT_POSITION          19
#define MCU_PCR_PD_BIT_POSITION          18
#define MCU_PCR_PBDC_BIT_POSITION        17
#define MCU_PCR_PIBC_BIT_POSITION        16
#define MCU_PCR_PSFSOE_BIT_POSITION      15
#define MCU_PCR_PSFSD_BIT_POSITION       14
#define MCU_PCR_PSFSC_BIT_POSITION       13
#define MCU_PCR_P_BIT_POSITION           12
#define MCU_PCR_PPR_BIT_POSITION          8
#define MCU_PCR_PMC_BIT_POSITION          6
#define MCU_PCR_PIPC_BIT_POSITION         5
#define MCU_PCR_PM_BIT_POSITION           4
#define MCU_PCR_PFCEAE_BIT_POSITION       3
#define MCU_PCR_PFCAE_BIT_POSITION        2
#define MCU_PCR_PFCE_BIT_POSITION         1
#define MCU_PCR_PFC_BIT_POSITION          0

#define MCU_PCR_ALT6_OUT_PMC              1
#define MCU_PCR_ALT6_OUT_PIPC             0
#define MCU_PCR_ALT6_OUT_PM               0
#define MCU_PCR_ALT6_OUT_PFCEAE           0
#define MCU_PCR_ALT6_OUT_PFCAE            1
#define MCU_PCR_ALT6_OUT_PFCE             0
#define MCU_PCR_ALT6_OUT_PFC              1

#define MCU_PCR_ALTERNATE_VALUE_MASK \
          ( (1 << MCU_PCR_PMC_BIT_POSITION) | \
            (1 << MCU_PCR_PIPC_BIT_POSITION) | \
            (1 << MCU_PCR_PM_BIT_POSITION) | \
            (1 << MCU_PCR_PFCEAE_BIT_POSITION) | \
            (1 << MCU_PCR_PFCAE_BIT_POSITION) | \
            (1 << MCU_PCR_PFCE_BIT_POSITION) | \
            (1 << MCU_PCR_PFC_BIT_POSITION) )

#define MCU_PCR_ALTERNATE_VALUE_6_OUT \
          ( (MCU_PCR_ALT6_OUT_PMC    << MCU_PCR_PMC_BIT_POSITION) | \
            (MCU_PCR_ALT6_OUT_PIPC   << MCU_PCR_PIPC_BIT_POSITION) | \
            (MCU_PCR_ALT6_OUT_PM     << MCU_PCR_PM_BIT_POSITION) | \
            (MCU_PCR_ALT6_OUT_PFCEAE << MCU_PCR_PFCEAE_BIT_POSITION) | \
            (MCU_PCR_ALT6_OUT_PFCAE  << MCU_PCR_PFCAE_BIT_POSITION) | \
            (MCU_PCR_ALT6_OUT_PFCE   << MCU_PCR_PFCE_BIT_POSITION) | \
            (MCU_PCR_ALT6_OUT_PFC    << MCU_PCR_PFC_BIT_POSITION) )


#define MCU_PKCPROT                  *((volatile uint32 *)0xFF612F40ul)
#define MCU_PWE                      *((volatile uint32 *)0xFF612F44ul)

#define MCU_PORT_DISABLE_WRITE_ACCESS_VALUE 0xA5A5A500UL
#define MCU_PORT_ENABLE_WRITE_ACCESS_VALUE  0xA5A5A501UL
#define MCU_PWE_ENABLE_WRITE_ACCESS_VALUE   0x003B7FFFUL


#define MCU_ECMKCPROT                *((volatile uint32 *)0xFFD384B4ul)
#define MCU_ECM_DISABLE_WRITE_ACCESS_VALUE 0xA5A5A500UL
#define MCU_ECM_ENABLE_WRITE_ACCESS_VALUE  0xA5A5A501UL

#define MCU_ECMPE0                   *((volatile uint32 *)0xFFD384B8ul)
#define MCU_ECMPE0_ADDRESS                                0xFFD384B8ul

#define MCU_ECM_ECMESSTCn_ADDRESS                         0xFFD38478ul

#define MCU_ECMPEM                   *((volatile uint32 *)0xFFD38740ul)


/***********************************************************************************************************************
Macro definitions (Register bit)
***********************************************************************************************************************/
/*
    TAUJTTINm Input Signal Selection Register (SELB_TAUJ3I)
*/
/* Selection of  channel3 input signal (SELB_TAUJ3I1,SELB_TAUJ3I3) */
#define _TAUJ3_CHANNEL3_INPUT_TAUJ3I3                   (0x00U) /* Port TAUJ3I3 */
#define _TAUJ3_CHANNEL3_INPUT_RTCA0OUT                  (0x02U) /* Timer Input-RTCA0OUT */
#define _TAUJ3_CHANNEL3_INPUT_TAUJ0OUT0                 (0x0AU) /* Timer Input-TAUJ0 TAUJTTOUT0*/
#define _TAUJ3_CHANNEL3_INPUT_CLEAR                     (0xF5U) /* Channel3 input clear */
/* Selection of  channel2 input signal (SELB_TAUJ3I0,SELB_TAUJ3I2) */
#define _TAUJ3_CHANNEL2_INPUT_TAUJ3I2                   (0x00U) /* Port TAUJ3I2 */
#define _TAUJ3_CHANNEL2_INPUT_RTCA0OUT                  (0x01U) /* Timer Input-RTCA0OUT */
#define _TAUJ3_CHANNEL2_INPUT_TAUJ0OUT0                 (0x05U) /* Timer Input-TAUJ0 TAUJTTOUT0*/
#define _TAUJ3_CHANNEL2_INPUT_CLEAR                     (0xFAU) /* Channel2 input clear */
/*
    TAUJTTINm Input Signal Selection Register (SELB_TAUJ2I)
*/
/* Selection of  channel3 input signal (SELB_TAUJ2I1) */
#define _TAUJ2_CHANNEL3_INPUT_TAUJ2I3                   (0xFDU) /* Port TAUJ2I3 */
#define _TAUJ2_CHANNEL3_INPUT_TAUJ1OUT0                 (0x02U) /* TAUJ1 TAUJTTOUT0*/
/* Selection of  channel2 input signal (SELB_TAUJ2I0) */
#define _TAUJ2_CHANNEL2_INPUT_TAUJ2I2                   (0xFEU) /* Port TAUJ2I2 */
#define _TAUJ2_CHANNEL2_INPUT_TAUJ1OUT0                 (0x01U) /* TAUJ1 TAUJTTOUT0*/

/*
    TAUJm Prescaler Clock Select Register (TAUJmTPS)
*/
/* Operating mode selection (TAUJmPRS3[3-0]) */
#define _TAUJ_CK3_PRE_PCLK_0                            (0x0000U) /* CK3_PRE - PCLK/2^0 */
#define _TAUJ_CK3_PRE_PCLK_1                            (0x1000U) /* CK3_PRE - PCLK/2^1 */
#define _TAUJ_CK3_PRE_PCLK_2                            (0x2000U) /* CK3_PRE - PCLK/2^2 */
#define _TAUJ_CK3_PRE_PCLK_3                            (0x3000U) /* CK3_PRE - PCLK/2^3 */
#define _TAUJ_CK3_PRE_PCLK_4                            (0x4000U) /* CK3_PRE - PCLK/2^4 */
#define _TAUJ_CK3_PRE_PCLK_5                            (0x5000U) /* CK3_PRE - PCLK/2^5 */
#define _TAUJ_CK3_PRE_PCLK_6                            (0x6000U) /* CK3_PRE - PCLK/2^6 */
#define _TAUJ_CK3_PRE_PCLK_7                            (0x7000U) /* CK3_PRE - PCLK/2^7 */
#define _TAUJ_CK3_PRE_PCLK_8                            (0x8000U) /* CK3_PRE - PCLK/2^8 */
#define _TAUJ_CK3_PRE_PCLK_9                            (0x9000U) /* CK3_PRE - PCLK/2^9 */
#define _TAUJ_CK3_PRE_PCLK_10                           (0xA000U) /* CK3_PRE - PCLK/2^10 */
#define _TAUJ_CK3_PRE_PCLK_11                           (0xB000U) /* CK3_PRE - PCLK/2^11 */
#define _TAUJ_CK3_PRE_PCLK_12                           (0xC000U) /* CK3_PRE - PCLK/2^12 */
#define _TAUJ_CK3_PRE_PCLK_13                           (0xD000U) /* CK3_PRE - PCLK/2^13 */
#define _TAUJ_CK3_PRE_PCLK_14                           (0xE000U) /* CK3_PRE - PCLK/2^14 */
#define _TAUJ_CK3_PRE_PCLK_15                           (0xF000U) /* CK3_PRE - PCLK/2^15 */
#define _TAUJ_CK3_PRS_CLEAR                             (0x0FFFU) /* CK30_PRE - clear */
/* Operating mode selection (TAUJmPRS2[3-0]) */
#define _TAUJ_CK2_PRE_PCLK_0                            (0x0000U) /* CK2_PRE - PCLK/2^0 */
#define _TAUJ_CK2_PRE_PCLK_1                            (0x0100U) /* CK2_PRE - PCLK/2^1 */
#define _TAUJ_CK2_PRE_PCLK_2                            (0x0200U) /* CK2_PRE - PCLK/2^2 */
#define _TAUJ_CK2_PRE_PCLK_3                            (0x0300U) /* CK2_PRE - PCLK/2^3 */
#define _TAUJ_CK2_PRE_PCLK_4                            (0x0400U) /* CK2_PRE - PCLK/2^4 */
#define _TAUJ_CK2_PRE_PCLK_5                            (0x0500U) /* CK2_PRE - PCLK/2^5 */
#define _TAUJ_CK2_PRE_PCLK_6                            (0x0600U) /* CK2_PRE - PCLK/2^6 */
#define _TAUJ_CK2_PRE_PCLK_7                            (0x0700U) /* CK2_PRE - PCLK/2^7 */
#define _TAUJ_CK2_PRE_PCLK_8                            (0x0800U) /* CK2_PRE - PCLK/2^8 */
#define _TAUJ_CK2_PRE_PCLK_9                            (0x0900U) /* CK2_PRE - PCLK/2^9 */
#define _TAUJ_CK2_PRE_PCLK_10                           (0x0A00U) /* CK2_PRE - PCLK/2^10 */
#define _TAUJ_CK2_PRE_PCLK_11                           (0x0B00U) /* CK2_PRE - PCLK/2^11 */
#define _TAUJ_CK2_PRE_PCLK_12                           (0x0C00U) /* CK2_PRE - PCLK/2^12 */
#define _TAUJ_CK2_PRE_PCLK_13                           (0x0D00U) /* CK2_PRE - PCLK/2^13 */
#define _TAUJ_CK2_PRE_PCLK_14                           (0x0E00U) /* CK2_PRE - PCLK/2^14 */
#define _TAUJ_CK2_PRE_PCLK_15                           (0x0F00U) /* CK2_PRE - PCLK/2^15 */
#define _TAUJ_CK2_PRS_CLEAR                             (0xF0FFU) /* CK2_PRE - clear */
/* Operating mode selection (TAUJmPRS1[3-0]) */
#define _TAUJ_CK1_PRE_PCLK_0                            (0x0000U) /* CK1_PRE - PCLK/2^0 */
#define _TAUJ_CK1_PRE_PCLK_1                            (0x0010U) /* CK1_PRE - PCLK/2^1 */
#define _TAUJ_CK1_PRE_PCLK_2                            (0x0020U) /* CK1_PRE - PCLK/2^2 */
#define _TAUJ_CK1_PRE_PCLK_3                            (0x0030U) /* CK1_PRE - PCLK/2^3 */
#define _TAUJ_CK1_PRE_PCLK_4                            (0x0040U) /* CK1_PRE - PCLK/2^4 */
#define _TAUJ_CK1_PRE_PCLK_5                            (0x0050U) /* CK1_PRE - PCLK/2^5 */
#define _TAUJ_CK1_PRE_PCLK_6                            (0x0060U) /* CK1_PRE - PCLK/2^6 */
#define _TAUJ_CK1_PRE_PCLK_7                            (0x0070U) /* CK1_PRE - PCLK/2^7 */
#define _TAUJ_CK1_PRE_PCLK_8                            (0x0080U) /* CK1_PRE - PCLK/2^8 */
#define _TAUJ_CK1_PRE_PCLK_9                            (0x0090U) /* CK1_PRE - PCLK/2^9 */
#define _TAUJ_CK1_PRE_PCLK_10                           (0x00A0U) /* CK1_PRE - PCLK/2^10 */
#define _TAUJ_CK1_PRE_PCLK_11                           (0x00B0U) /* CK1_PRE - PCLK/2^11 */
#define _TAUJ_CK1_PRE_PCLK_12                           (0x00C0U) /* CK1_PRE - PCLK/2^12 */
#define _TAUJ_CK1_PRE_PCLK_13                           (0x00D0U) /* CK1_PRE - PCLK/2^13 */
#define _TAUJ_CK1_PRE_PCLK_14                           (0x00E0U) /* CK1_PRE - PCLK/2^14 */
#define _TAUJ_CK1_PRE_PCLK_15                           (0x00F0U) /* CK1_PRE - PCLK/2^15 */
#define _TAUJ_CK1_PRS_CLEAR                             (0xFF0FU) /* CK1_PRE - clear */
/* Operating mode selection (TAUJmPRS0[3-0]) */
#define _TAUJ_CK0_PRE_PCLK_0                            (0x0000U) /* CK0_PRE - PCLK/2^0 */
#define _TAUJ_CK0_PRE_PCLK_1                            (0x0001U) /* CK0_PRE - PCLK/2^1 */
#define _TAUJ_CK0_PRE_PCLK_2                            (0x0002U) /* CK0_PRE - PCLK/2^2 */
#define _TAUJ_CK0_PRE_PCLK_3                            (0x0003U) /* CK0_PRE - PCLK/2^3 */
#define _TAUJ_CK0_PRE_PCLK_4                            (0x0004U) /* CK0_PRE - PCLK/2^4 */
#define _TAUJ_CK0_PRE_PCLK_5                            (0x0005U) /* CK0_PRE - PCLK/2^5 */
#define _TAUJ_CK0_PRE_PCLK_6                            (0x0006U) /* CK0_PRE - PCLK/2^6 */
#define _TAUJ_CK0_PRE_PCLK_7                            (0x0007U) /* CK0_PRE - PCLK/2^7 */
#define _TAUJ_CK0_PRE_PCLK_8                            (0x0008U) /* CK0_PRE - PCLK/2^8 */
#define _TAUJ_CK0_PRE_PCLK_9                            (0x0009U) /* CK0_PRE - PCLK/2^9 */
#define _TAUJ_CK0_PRE_PCLK_10                           (0x000AU) /* CK0_PRE - PCLK/2^10 */
#define _TAUJ_CK0_PRE_PCLK_11                           (0x000BU) /* CK0_PRE - PCLK/2^11 */
#define _TAUJ_CK0_PRE_PCLK_12                           (0x000CU) /* CK0_PRE - PCLK/2^12 */
#define _TAUJ_CK0_PRE_PCLK_13                           (0x000DU) /* CK0_PRE - PCLK/2^13 */
#define _TAUJ_CK0_PRE_PCLK_14                           (0x000EU) /* CK0_PRE - PCLK/2^14 */
#define _TAUJ_CK0_PRE_PCLK_15                           (0x000FU) /* CK0_PRE - PCLK/2^15 */
#define _TAUJ_CK0_PRS_CLEAR                             (0xFFF0U) /* CK0_PRE - clear */

/*
    TAUJm Channel Mode OS Register (TAUJmCMORn)
*/
/* Selection of operation clock (TAUJmCKS[1-0]) */
#define _TAUJ_SELECTION_CK0                             (0x0000U) /* CK0 */
#define _TAUJ_SELECTION_CK1                             (0x4000U) /* CK1 */
#define _TAUJ_SELECTION_CK2                             (0x8000U) /* CK2 */
#define _TAUJ_SELECTION_CK3                             (0xC000U) /* CK3 */
/* Selects a count clock for TAUJmCNTn counter (TAUJmCCS[1-0]) */
#define _TAUJ_COUNT_CLOCK_PCLK                          (0x0000U) /* Operation clock as specified by TAUJmCMORn */
/* A mster channel or slave channel (TAUJmMAS) */
#define _TAUJ_INDEPENDENT_CHANNEL                       (0x0000U) /* Slave */
#define _TAUJ_SLAVE_CHANNEL                             (0x0000U) /* Slave */
#define _TAUJ_MASTER_CHANNEL                            (0x0800U) /* Master */
/* Selects an external start trigger (TAUJmSTS[2-0]) */
#define _TAUJ_START_TRIGGER_SOFTWARE                    (0x0000U) /* Software trigger */
#define _TAUJ_START_TRIGGER_VALID_EDGE                  (0x0100U) /* Valid edge of TAUJTTINn input signal */
#define _TAUJ_START_STOP_TRIGGER_VALID_EDGE             (0x0200U) /* Input signal is used as a start trigger */
#define _TAUJ_START_TRIGGER_MASTER_INT                  (0x0400U) /* Master channel is used as a start trigger */
/* Specifies the timing for updating capture register (TAUJmCOS[1-0]) */
#define _TAUJ_OVERFLOW_AUTO_CLEAR                       (0x0000U) /* TAUJTTINm and TAUJmOVF update */
#define _TAUJ_OVERFLOW_MANUAL_CLEAR                     (0x0040U) /* TAUJTTINm and TAUJmOVF is set */
#define _TAUJ_OVERFLOW_COUNT_STOP                       (0x0080U) /* Counter overflow, TAUJmOVF is not set */
#define _TAUJ_OVERFLOW_COUNT_STOP_MANUAL_CLEAR          (0x00C0U) /* Counter overflow, TAUDnOVF */
/* Specifies an operating mode (TAUJmMD[4-0]) */
#define _TAUJ_INTERVAL_TIMER_MODE                       (0x0000U) /* Interval timer mode */
#define _TAUJ_CAPTURE_MODE                              (0x0004U) /* Capture mode */
#define _TAUJ_ONE_COUNT_MODE                            (0x0008U) /* One-count mode */
#define _TAUJ_CAPTURE_ONE_COUNT_MODE                    (0x000CU) /* Capture and one-count mode */
#define _TAUJ_COUNT_CAPTURE_MODE                        (0x0016U) /* Count capture mode  */
#define _TAUJ_GATE_COUNT_MODE                           (0x0018U) /* Gate count mode */
#define _TAUJ_CAPTURE_AND_GATE_COUNT_MODE               (0x001AU) /* Capture and gate count mode */
/* Role of TAUJ0MD0 Bit (TAUJmMD0) */
#define _TAUJ_START_INT_NOT_GENERATED                   (0x0000U) /* INTTAUJ0Im is not generated */
#define _TAUJ_START_TRIGGER_DISABLE                     (0x0000U) /* Disables detection. */
#define _TAUJ_START_INT_GENERATED                       (0x0001U) /* INTTAUJ0Im is generated */
#define _TAUJ_START_TRIGGER_ENABLE                      (0x0001U) /* Enables detection. */

/*
    TAUJm Channel Mode User Register (TAUJmCMURn)
*/
/* Specifies a valid edge of TAUJTTINn input signal (TAUJmTIS[1-0]) */
#define _TAUJ_INPUT_EDGE_FALLING                        (0x00U) /* Falling edge */
#define _TAUJ_INPUT_EDGE_UNUSED                         (0x00U) /* Unused Falling edge */
#define _TAUJ_INPUT_EDGE_RISING                         (0x01U) /* Rising edge */
#define _TAUJ_INPUT_EDGE_BOTH_MEASURE_LOW               (0x02U) /* Selects low width measurement) */
#define _TAUJ_INPUT_EDGE_BOTH_MEASURE_HIGH              (0x03U) /* Selects high width measurement */

/*
    TAUJm Channel Start Trigger Register (TAUJmTS)
*/
/* Enables the counter operation of channel 3 (TAUJmTS3) */
#define _TAUJ_CHANNEL3_COUNTER_START                    (0x08U) /* Enables the counter operation */
/* Enables the counter operation of channel 2 (TAUJmTS2) */
#define _TAUJ_CHANNEL2_COUNTER_START                    (0x04U) /* Enables the counter operation */
/* Enables the counter operation of channel 1 (TAUJmTS1) */
#define _TAUJ_CHANNEL1_COUNTER_START                    (0x02U) /* Enables the counter operation */
/* Enables the counter operation of channel 0 (TAUJmTS0) */
#define _TAUJ_CHANNEL0_COUNTER_START                    (0x01U) /* Enables the counter operation */

/*
    TAUJm Channel Stop Trigger Register (TAUJmTT)
*/
/* Stops the counter operation of channel 3 (TAUJmTT3) */
#define _TAUJ_CHANNEL3_COUNTER_STOP                     (0x08U) /* Stops the counter operation */
/* Stops the counter operation of channel 2 (TAUJmTT2) */
#define _TAUJ_CHANNEL2_COUNTER_STOP                     (0x04U) /* Stops the counter operation */
/* Stops the counter operation of channel 1 (TAUJmTT1) */
#define _TAUJ_CHANNEL1_COUNTER_STOP                     (0x02U) /* Stops the counter operation */
/* Stops the counter operation of channel 0 (TAUJmTT0) */
#define _TAUJ_CHANNEL0_COUNTER_STOP                     (0x01U) /* Stops the counter operation */

/*
    TAUJm Channel Output Enable Register (TAUJmTOE)
*/
/* Enables/disables the independent channel output function (TAUJmTOE3) */
#define _TAUJ_CHANNEL3_DISABLES_OUTPUT_MODE             (0xF7U) /* Disables independent channel output mode */
#define _TAUJ_CHANNEL3_ENABLES_OUTPUT_MODE              (0x08U) /* Enables independent channel output mode */
/* Enables/disables the independent channel output function (TAUJmTOE2) */
#define _TAUJ_CHANNEL2_DISABLES_OUTPUT_MODE             (0xFBU) /* Disables independent channel output mode */
#define _TAUJ_CHANNEL2_ENABLES_OUTPUT_MODE              (0x04U) /* Enables independent channel output mode */
/* Enables/disables the independent channel output function (TAUJmTOE1) */
#define _TAUJ_CHANNEL1_DISABLES_OUTPUT_MODE             (0xFDU) /* Disables independent channel output mode */
#define _TAUJ_CHANNEL1_ENABLES_OUTPUT_MODE              (0x02U) /* Enables independent channel output mode */
/* Enables/disables the independent channel output function (TAUJmTOE0) */
#define _TAUJ_CHANNEL0_DISABLES_OUTPUT_MODE             (0xFEU) /* Disables independent channel output mode */
#define _TAUJ_CHANNEL0_ENABLES_OUTPUT_MODE              (0x01U) /* Enables independent channel output mode */

/*
    TAUJm Channel Output Mode Register (TAUJmTOM)
*/
/* Specifies an output mode (TAUJmTOM3) */
#define _TAUJ_CHANNEL3_INDEPENDENT_OPERATION            (0xF7U) /* Independent channel operation */
#define _TAUJ_CHANNEL3_SYNCHRONOUS_OPERATION            (0x08U) /* Synchronous channel operation */
/* Specifies an output mode (TAUJmTOM2) */
#define _TAUJ_CHANNEL2_INDEPENDENT_OPERATION            (0xFBU) /* Independent channel operation */
#define _TAUJ_CHANNEL2_SYNCHRONOUS_OPERATION            (0x04U) /* Synchronous channel operation */
/* Specifies an output mode (TAUJmTOM1) */
#define _TAUJ_CHANNEL1_INDEPENDENT_OPERATION            (0xFDU) /* Independent channel operation */
#define _TAUJ_CHANNEL1_SYNCHRONOUS_OPERATION            (0x02U) /* Synchronous channel operation */
/* Specifies an output mode (TAUJmTOM0) */
#define _TAUJ_CHANNEL0_INDEPENDENT_OPERATION            (0xFEU) /* Independent channel operation */
#define _TAUJ_CHANNEL0_SYNCHRONOUS_OPERATION            (0x01U) /* Synchronous channel operation */

/*
    TAUJm Channel Output Configuration Register (TAUJmTOC)
*/
/* Specifies the output mode (TAUJmTOC3) */
#define _TAUJ_CHANNEL3_OPERATION_MODE1                  (0xF7U) /* Operation mode 1 */
#define _TAUJ_CHANNEL3_OPERATION_MODE2                  (0x08U) /* Operation mode 2 */   
/* Specifies the output mode (TAUJmTOC2) */
#define _TAUJ_CHANNEL2_OPERATION_MODE1                  (0xFBU) /* Operation mode 1 */
#define _TAUJ_CHANNEL2_OPERATION_MODE2                  (0x04U) /* Operation mode 2 */   
/* Specifies the output mode (TAUJmTOC1) */
#define _TAUJ_CHANNEL1_OPERATION_MODE1                  (0xFDU) /* Operation mode 1 */
#define _TAUJ_CHANNEL1_OPERATION_MODE2                  (0x02U) /* Operation mode 2 */   
/* Specifies the output mode (TAUJmTOC0) */
#define _TAUJ_CHANNEL0_OPERATION_MODE1                  (0xFEU) /* Operation mode 1 */
#define _TAUJ_CHANNEL0_OPERATION_MODE2                  (0x01U) /* Operation mode 2 */   

/*
    TAUJm Channel Output Level Register (TAUJmTOL)
*/
/* Specifies the output logic of channel 3 output bit (TAUJmTOL3) */
#define _TAUJ_CHANNEL3_POSITIVE_LOGIC                   (0xF7U) /* Positive logic */
#define _TAUJ_CHANNEL3_NEGATIVE_LOGIC                   (0x08U) /* Negative logic */
/* Specifies the output logic of channel 2 output bit (TAUJmTOL2) */
#define _TAUJ_CHANNEL2_POSITIVE_LOGIC                   (0xFBU) /* Positive logic */
#define _TAUJ_CHANNEL2_NEGATIVE_LOGIC                   (0x04U) /* Negative logic */
/* Specifies the output logic of channel 1 output bit (TAUJmTOL1) */
#define _TAUJ_CHANNEL1_POSITIVE_LOGIC                   (0xFDU) /* Positive logic */
#define _TAUJ_CHANNEL1_NEGATIVE_LOGIC                   (0x02U) /* Negative logic */
/* Specifies the output logic of channel 0 output bit (TAUJmTOL0) */
#define _TAUJ_CHANNEL0_POSITIVE_LOGIC                   (0xFEU) /* Positive logic */
#define _TAUJ_CHANNEL0_NEGATIVE_LOGIC                   (0x01U) /* Negative logic */

/***********************************************************************************************************************
Macro definitions
***********************************************************************************************************************/
#define _TAUJ_OVERFLOW_OCCURS                           (0x01U)         /* Overflow occurs */
#define _TAUJ_OVERFLOW_VALUE                            (0x100000000ULL) /* Overflow value */
#define _TAUJ_FILTER_ENABLED                            (0x01U)         /* Digital Noise Elimination Enable Control */

#define Gpt_GptChannelConfiguration0 GptConf_GptChannelConfiguration_GptChannelConfiguration
#define Gpt_GptChannelConfiguration1 GptConf_GptChannelConfiguration_GptChannelConfiguration_001
#define Gpt_GptChannelConfiguration2 GptConf_GptChannelConfiguration_GptChannelConfiguration_002
#define Gpt_GptChannelConfiguration3 GptConf_GptChannelConfiguration_GptChannelConfiguration_003
#define Gpt_GptChannelConfiguration4 GptConf_GptChannelConfiguration_GptChannelConfiguration_004
#define Gpt_GptChannelConfiguration5 GptConf_GptChannelConfiguration_GptChannelConfiguration_005
/*******************************************************************************
**                      Global Data Types                                     **
*******************************************************************************/

/*******************************************************************************
**                      Global Function Prototypes                            **
*******************************************************************************/
void Mcu_EnableFOUTpin(void);
void Mcu_DisableFOUTpin(void);
void Port_Init(void);
void Wdg_Init(void);
void Reg_Init(void);

void Mcu_EcmNotification(uint16 EcmErrorNum);

#endif /* APP_MCU_DEVICE_SAMPLE_H */

/*******************************************************************************
**                      End of File                                           **
*******************************************************************************/
