

/*-----------------use for RH850_D1M1A_1441 --------------------*/
#include "r_typedefs.h"
// #include "dr7f701401.dvf.h"
// #include "r_dev_api.h"

#include "RSCAN.h"
#include "RSCAN_Table.h"
#include "Can.h"
#include "r_intc.h"
// #include "NM.h"

#define RSCAN_C_ISO_RSCAN_CLKC 40000000UL          /* PLLFIXCLK /12 (default)*/
#define RSCAN_C_ISO_RSCANXIN_CLK_XIN_CAN 8000000UL /*MainOSC*/
#define RSCAN_F_CAN RSCAN_C_ISO_RSCANXIN_CLK_XIN_CAN

#define RSCAN0_BASE_ADDRESS 0xFFD00000UL

/*--------------500K-----------------------------*/
#define RSCAN0_500K_BAUD_RATE 500U //波特率,单位kbps
#define RSCAN0_500K_T_SEG1 12U     //时间段1的Tq数
#define RSCAN0_500K_T_SEG2 3U      //时间段2的Tq数
#define RSCAN0_500K_SJW 3U         //同步跳转宽度

#define RSCAN_500K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_500K_BAUD_RATE) / (RSCAN0_500K_T_SEG1 + RSCAN0_500K_T_SEG2 + 1UL) / 1000UL)

/*-----------------250K---------------------------------*/
#define RSCAN0_250K_BAUD_RATE 250U //波特率,单位kbps
#define RSCAN0_250K_T_SEG1 13U     //11 //时间段1的Tq数
#define RSCAN0_250K_T_SEG2 2U      //4	 //时间段2的Tq数
#define RSCAN0_250K_SJW 1U         //2 //3

#define RSCAN_250K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_250K_BAUD_RATE) / (RSCAN0_250K_T_SEG1 + RSCAN0_250K_T_SEG2 + 1UL) / 1000UL)

/*-----------------125K---------------------------------*/
#define RSCAN0_125K_BAUD_RATE 125U //波特率,单位kbps
#define RSCAN0_125K_T_SEG1 13U     //11 //时间段1的Tq数
#define RSCAN0_125K_T_SEG2 2U      //4	 //时间段2的Tq数
#define RSCAN0_125K_SJW 1U         //2 //3

#define RSCAN_125K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_125K_BAUD_RATE) / (RSCAN0_125K_T_SEG1 + RSCAN0_125K_T_SEG2 + 1UL) / 1000UL)
/*------------------------------------------------*/

#if ((RSCAN0_500K_T_SEG2 < 2U) || (RSCAN0_250K_T_SEG2 < 2U) || (RSCAN0_125K_T_SEG2 < 2U) || (RSCAN0_500K_T_SEG2 > 8U) || (RSCAN0_250K_T_SEG2 > 8U) || (RSCAN0_125K_T_SEG2 > 8U))
#error RSCAN0 Time Segment 2 error!!!
#endif
#if ((RSCAN0_500K_T_SEG1 < 4U) || (RSCAN0_250K_T_SEG1 < 4U) || (RSCAN0_125K_T_SEG1 < 4U) || (RSCAN0_500K_T_SEG1 > 16U) || (RSCAN0_250K_T_SEG1 > 16U) || (RSCAN0_125K_T_SEG1 > 16U))
#error RSCAN0 Time Segment 1 error!!!
#endif
#if ((RSCAN0_500K_SJW < 1U) || (RSCAN0_250K_SJW < 1U) || (RSCAN0_125K_SJW < 1U) || (RSCAN0_500K_SJW > 4U) || (RSCAN0_250K_SJW > 4U) || (RSCAN0_125K_SJW > 4U))
#error RSCAN0 Resynchronization Jump Width error!!!
#endif
#if ((RSCAN_500K_BIT_RATE_DIV < 1U) || (RSCAN_250K_BIT_RATE_DIV < 1U) || (RSCAN_125K_BIT_RATE_DIV < 1U) || (RSCAN_500K_BIT_RATE_DIV > 1024U) || (RSCAN_250K_BIT_RATE_DIV > 1024U) || (RSCAN_125K_BIT_RATE_DIV > 1024U))
#error RSCAN0 Communication speed  error!!!
#endif

/*---------------------------------------*/

/*---------------------------------------*/

/***************************************************/
/**COMPLETE**/
#define RSCAN_ABORT_CPLT_AND 0X06U
#define RSCAN_ABORT_CPLT 0X02U
#define RSCAN_TX_CPLT_AND 0X04U
#define RSCAN_TX_CPLT 0X04U
/***************************************************/

/*RSCAN0GCFG*/
/*DCS*/
#define RSCAN_CLOCK_SOURCE_CLKC (0U << 4U)
#define RSCAN_CLOCK_SOURCE_CLK_XINCAN (1U << 4U)
/*DCE*/
#define RSCAN_DLC_CHECK_DISABLE (0U << 1U)
#define RSCAN_DLC_CHECK_ENABLE (1U << 1U)
/*TPRI*/
#define RSCAN_TX_PRIORITY_ID (0U)
#define RSCAN_TX_PRIORITY_BUFFER_NUM (1U)

/*RSCAN0C0CFG*/
#define RSCAN_500K_NTSEG2 ((RSCAN0_500K_T_SEG2 - 1U) << 20U)
#define RSCAN_500K_NTSEG1 ((RSCAN0_500K_T_SEG1 - 1U) << 16U)
#define RSCAN_500K_NSJW ((RSCAN0_500K_SJW - 1U) << 24U)
#define RSCAN_500K_NBRP (RSCAN_500K_BIT_RATE_DIV - 1U)

#define RSCAN_250K_NTSEG2 ((RSCAN0_250K_T_SEG2 - 1U) << 20U)
#define RSCAN_250K_NTSEG1 ((RSCAN0_250K_T_SEG1 - 1U) << 16U)
#define RSCAN_250K_NSJW ((RSCAN0_250K_SJW - 1U) << 24U)
#define RSCAN_250K_NBRP (RSCAN_250K_BIT_RATE_DIV - 1U)

#define RSCAN_125K_NTSEG2 ((RSCAN0_125K_T_SEG2 - 1U) << 20U)
#define RSCAN_125K_NTSEG1 ((RSCAN0_125K_T_SEG1 - 1U) << 16U)
#define RSCAN_125K_NSJW ((RSCAN0_125K_SJW - 1U) << 24U)
#define RSCAN_125K_NBRP (RSCAN_125K_BIT_RATE_DIV - 1U)

/*RSCANnCFCCk*/

/*Transmit/Receive FIFO Buffer Depth Configuration*/
#define RSCAN_TR_FIFO_DEPTH_0 (0UL << 8UL)
#define RSCAN_TR_FIFO_DEPTH_4 (1UL << 8UL)
#define RSCAN_TR_FIFO_DEPTH_8 (2UL << 8UL)
#define RSCAN_TR_FIFO_DEPTH_16 (3UL << 8UL)
#define RSCAN_TR_FIFO_DEPTH_32 (4UL << 8UL)
#define RSCAN_TR_FIFO_DEPTH_48 (5UL << 8UL)
#define RSCAN_TR_FIFO_DEPTH_64 (6UL << 8UL)
#define RSCAN_TR_FIFO_DEPTH_128 (7UL << 8UL)
/*Transmit/Receive FIFO Mode Select*/
#define RSCAN_TR_FIFO_MODE_RX (0UL << 16UL)
#define RSCAN_TR_FIFO_MODE_TX (1UL << 16UL)
/*Transmit/Receive FIFO Transmit Interrupt Enable*/
#define RSCAN_TR_FIFO_TX_INT_DIS (0UL << 2UL)
#define RSCAN_TR_FIFO_TX_INT_EN (1UL << 2UL)
/*Transmit/Receive FIFO Receive Interrupt Enable*/
#define RSCAN_TR_FIFO_RX_INT_DIS (0UL << 1UL)
#define RSCAN_TR_FIFO_RX_INT_EN (1UL << 1UL)
/*Transmit/Receive FIFO Buffer Enable*/
#define RSCAN_TR_FIFO_DIS (0UL)
#define RSCAN_TR_FIFO_EN (1UL)

/*RCFDCnCFDCmCTR*/
/*Transmit Abort Interrupt Enable*/
#define RSCAN_ABORT_INT_DIS (0UL << 16U)
#define RSCAN_ABORT_INT_EN (1UL << 16U)
/*Bus Off Recovery Mode Select*/
#define RSCAN_RECOVER_11898 (0UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_ENTRY (1UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END (1UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_BY_PROGRAM_REQUEST (1UL << 21U)

typedef struct
{

    /*具体接收内容*/
    CAN_Frame_st_t stReceiveContent;
    /*是否接收到新数据
    0：数据没有更新
    1：接收到新数据，已更新*/
    uint8_t u8CANReceiveStatus;

} CAN_Frame_Receive_st_t;

/*------------------------------------------------------------*/
RSCAN0_Config_st_t g_stRSCAN0Config;
/*------------------------------------------------------------*/

static uint32_t RSCAN0_CH_Baud_Rate_Cal(RSCAN_Channel_Config_st_t *pstRSCANChannelConfig)
{
    uint32_t u32RegisterBuf = 0UL;
    if (pstRSCANChannelConfig->u32RSCANChEn)
    {
        if (pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_500K)
        {
            u32RegisterBuf = (RSCAN_500K_NTSEG2 | RSCAN_500K_NTSEG1 | RSCAN_500K_NSJW | RSCAN_500K_NBRP);
        }
        else if (pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_250K)
        {
            u32RegisterBuf = (RSCAN_250K_NTSEG2 | RSCAN_250K_NTSEG1 | RSCAN_250K_NSJW | RSCAN_250K_NBRP);
        }
        else if (pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_125K)
        {
            u32RegisterBuf = (RSCAN_125K_NTSEG2 | RSCAN_125K_NTSEG1 | RSCAN_125K_NSJW | RSCAN_125K_NBRP);
        }
    }

    return u32RegisterBuf;
}
/*
返回值：
0：设置失败
1：设置成功
*/
uint8_t RSCAN0_CH_Init(const RSCANFD_Filter_st_t pstRSCANFilter[], RSCAN0_Config_st_t *pstRSCANConfig)
{
  //CAN 初始化
  uint8_t u8CanReturnValue;
      Can_Init(Can_Config);
  
    R_INTC_Init(297UL, INTC_EITB & INTC_EIMK | INTC_EIP(6UL)); /* table reference */
    R_INTC_Init(298UL, INTC_EITB & INTC_EIMK | INTC_EIP(6UL)); /* table reference */
    R_INTC_Init(308UL, INTC_EITB & INTC_EIMK | INTC_EIP(6UL)); /* table reference */
    R_INTC_Init(309UL, INTC_EITB & INTC_EIMK | INTC_EIP(6UL)); /* table reference */
    R_INTC_Init(307UL, INTC_EITB & INTC_EIMK | INTC_EIP(6UL)); /* table reference */
  
    // App_GenReturnValue = 
    u8CanReturnValue = Can_SetControllerMode(CanConf_CanController_Can2, CAN_CS_STARTED);

    g_stRSCAN0Config = *pstRSCANConfig;
    
    return 1;
}



void RSCAN0_CH0_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANReadMsgCallBack)
    {
        g_stRSCAN0Config.stRSCANCh0.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}
void RSCAN0_CH1_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANReadMsgCallBack)
    {
        g_stRSCAN0Config.stRSCANCh1.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}
void RSCAN0_CH2_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANReadMsgCallBack)
    {
        g_stRSCAN0Config.stRSCANCh2.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}

uint8 GaaByteArray00[] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};

// #if defined(CAN_LPDU_RECEIVE_CALLOUT_FUNCTION)
/* Callout function */
FUNC(boolean, CAN_APPL_CODE) UserCalloutFunction
(
  uint16 Hrh, Can_IdType CanId,
// #if (CAN_AR_VERSION == CAN_AR_422_VERSION)
//   uint8 CanDlc,
// #elif (CAN_AR_VERSION == CAN_AR_431_VERSION)
  uint8 CanDataLength,
// #endif
  P2CONST(uint8, CAN_APPL_DATA, AUTOMATIC) CanSduPtr)
{
  uint8 LucDlc;
  uint8 LucCnt;
  uint8 *LpData;
  uint8 arr[8];

// #if (CAN_AR_VERSION == CAN_AR_422_VERSION)
//   LucDlc = CanDlc;
// #elif (CAN_AR_VERSION == CAN_AR_431_VERSION)
  LucDlc = CanDataLength;
// #endif
//   if (0x068 == CanId)
//   {
    LpData = &GaaByteArray00[0];
//   }
//   else
//   {
//     LpData = &GaaByteArray1[0];
//   }
CAN_Frame_Receive_st_t stCANFrameReceive;
  for (LucCnt = 0; LucCnt < LucDlc; LucCnt++)
  {
    // if (LpData[LucCnt] != CanSduPtr[LucCnt])
    // {
    //   break;
    // }
    stCANFrameReceive.stReceiveContent.unCANData.u8CANData[LucCnt] = CanSduPtr[LucCnt];
  }

//   if (LucCnt == LucDlc)
//   {
//     GucReturnCount++;
//   }
//   /* return TRUE unconditionally */
//   return TRUE;
    
    stCANFrameReceive.stReceiveContent.u32CANID = CanId;
    stCANFrameReceive.stReceiveContent.u8CANLEN = CanDataLength;
    // stCANFrameReceive.stReceiveContent.unCANData.u8CANData = arr;
    RSCAN0_CH0_Receive(&stCANFrameReceive.stReceiveContent);

}
// #endif

/*********************************************************/

/*
0: Not in bus off state
1: In bus off state
*/
uint8_t RSCAN0_CH0_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;
    // if (RSCAN0C0ERFL & 0x08UL)
    // {
    //     u8BusoffStatus = 1U;
    // }

    return u8BusoffStatus;
}

uint8_t RSCAN0_CH1_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;

    // if (RSCAN0C1ERFL & 0x08UL)
    // {
    //     u8BusoffStatus = 1U;
    // }

    return u8BusoffStatus;
}
uint8_t RSCAN0_CH2_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;
    // if (RSCAN0C2ERFL & 0x08UL)
    // {
    //     u8BusoffStatus = 1U;
    // }

    return u8BusoffStatus;
}

void RSCAN0_CH0_Busoff_Recover(void)
{
    // if (RSCAN0_CH0_Get_Busoff_Status())
    // {
    //     RSCAN0C0ERFL &= 0xFFFFFFF7UL;
    //     RSCAN0C0CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
    //     while ((RSCAN0C0STS & 0x87UL) != 0x80UL)
    //     {
    //     }
    // }
}
void RSCAN0_CH1_Busoff_Recover(void)
{
    // if (RSCAN0_CH1_Get_Busoff_Status())
    // {
    //     RSCAN0C1ERFL &= 0xFFFFFFF7UL;
    //     RSCAN0C1CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
    //     while ((RSCAN0C1STS & 0x87UL) != 0x80UL)
    //     {
    //     }
    // }
}
void RSCAN0_CH2_Busoff_Recover(void)
{
    // if (RSCAN0_CH2_Get_Busoff_Status())
    // {
    //     RSCAN0C2ERFL &= 0xFFFFFFF7UL;
    //     RSCAN0C2CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
    //     while ((RSCAN0C2STS & 0x87UL) != 0x80UL)
    //     {
    //     }
    // }
}
/*****************************/
void RSCAN0_CH0_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 16UL * 0UL);
    uint32_t u32RSCANAddress = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    // if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
    // {
    //     enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    // }
    // if (enRSCANStatus == RSCAN_SET_COMPLETE)
    // {
    //     u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
    //     (*((uint8_t *)u32RSCANAddress)) |= 0X02U;
    //     //RCFDC0CFDTMC0 |= 0X02;
    // }
}
void RSCAN0_CH1_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 16UL * 1UL);
    uint32_t u32RSCANAddress = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    // if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
    // {
    //     enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    // }
    // if (enRSCANStatus == RSCAN_SET_COMPLETE)
    // {
    //     u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
    //     (*((uint8_t *)u32RSCANAddress)) |= 0X02U;
    //     //RCFDC0CFDTMC0 |= 0X02;
    // }
}
void RSCAN0_CH2_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 16UL * 2UL);
    uint32_t u32RSCANAddress = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    // if ((enBufIndex >= RSCAN_CHANNEL_BUF_MAX))
    // {
    //     enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    // }
    // if (enRSCANStatus == RSCAN_SET_COMPLETE)
    // {
    //     u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
    //     (*((uint8_t *)u32RSCANAddress)) |= 0X02U;
    //     //RCFDC0CFDTMC0 |= 0X02;
    // }
}

/*
如果CAN模块休眠了，但是芯片没休眠，CAN报文无法唤醒CAN模块。
*/
void RSCAN0_CH0_Sleep_Init(void)
{
    // RSCAN0C0CTR &= 0xfffffff9UL;
    // RSCAN0C0CTR |= 0x01UL;

    // while ((RSCAN0C0STS & 0x07UL) != 0X01UL)
    // {
    //     ;
    // }
    // RSCAN0C0CTR |= 0x04UL;
    // while ((RSCAN0C0STS & 0x07UL) != 0X04UL)
    // {
    //     ;
    // }
}
void RSCAN0_CH1_Sleep_Init(void)
{
    // RSCAN0C1CTR &= 0xfffffff9UL;
    // RSCAN0C1CTR |= 0x01UL;

    // while ((RSCAN0C1STS & 0x07UL) != 0X01UL)
    // {
    //     ;
    // }
    // RSCAN0C1CTR |= 0x04UL;
    // while ((RSCAN0C1STS & 0x07UL) != 0X04UL)
    // {
    //     ;
    // }
}
void RSCAN0_CH2_Sleep_Init(void)
{
    // RSCAN0C2CTR &= 0xfffffff9UL;
    // RSCAN0C2CTR |= 0x01UL;

    // while ((RSCAN0C2STS & 0x07UL) != 0X01UL)
    // {
    //     ;
    // }
    // RSCAN0C2CTR |= 0x04UL;
    // while ((RSCAN0C2STS & 0x07UL) != 0X04UL)
    // {
    //     ;
    // }
}

void RSCAN0_Sleep_Init(void)
{
    // RSCAN0GCTR &= 0xfffffff9UL;
    // RSCAN0GCTR |= 0x01UL;

    // while ((RSCAN0GSTS & 0x07UL) != 0X01UL)
    // {
    //     ;
    // }

    // RSCAN0GCTR |= 0x04UL;
    // // while ( (RSCAN0GSTS & 0x07UL) != 0X04UL )
    // while ((RSCAN0GSTS & 0x04UL) != 0X04UL)
    // {
    //     ;
    // }
}

uint8_t RSCAN0_CH0_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    // u8ErrorCount = (uint8_t)(RSCAN0C0STS >> 24U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH1_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    // u8ErrorCount = (uint8_t)(RSCAN0C1STS >> 24U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH2_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    // u8ErrorCount = (uint8_t)(RSCAN0C2STS >> 24U);
    return u8ErrorCount;
}

uint8_t RSCAN0_CH0_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    // u8ErrorCount = (uint8_t)(RSCAN0C0STS >> 16U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH1_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    // u8ErrorCount = (uint8_t)(RSCAN0C1STS >> 16U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH2_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    // u8ErrorCount = (uint8_t)(RSCAN0C2STS >> 16U);
    return u8ErrorCount;
}

/****************************************************/

/******************************************************************/

// void RSCAN0_CH0_RX_ISR(void)
// {
//     if (RSCAN0CFSTS2 & 0X08UL)
//     {
//         CAN_Frame_Receive_st_t stCANFrameReceive;
//         RSCAN0CFSTS2 &= 0xFFFFFFF7UL;

//         while ((RSCAN0CFSTS2 & 0x01UL) == 0U)
//         {
//             stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RSCAN0CFID2 & 0x1FFFFFFFUL);
//             stCANFrameReceive.stReceiveContent.u8CANLEN = (uint8_t)(RSCAN0CFPTR2 >> 28U);
//             stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RSCAN0CFID2 >> 31U));
//             stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RSCAN0CFDF02;
//             stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RSCAN0CFDF12;

//             RSCAN0CFPCTR2 = 0xFFU;

//             RSCAN0_CH0_Receive(&stCANFrameReceive.stReceiveContent);
//             NM_Infodiv_Indication(stCANFrameReceive.stReceiveContent.u32CANID,stCANFrameReceive.stReceiveContent.u8CANLEN,stCANFrameReceive.stReceiveContent.unCANData.u8CANData);
//         }
//     }
// }

// void RSCAN0_CH1_RX_ISR(void)
// {
//     if (RSCAN0CFSTS5 & 0X08UL)
//     {
//         CAN_Frame_Receive_st_t stCANFrameReceive;
//         RSCAN0CFSTS5 &= 0xFFFFFFF7UL;

//         while ((RSCAN0CFSTS5 & 0x01UL) == 0U)
//         {
//             stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RSCAN0CFID5 & 0x1FFFFFFFUL);
//             stCANFrameReceive.stReceiveContent.u8CANLEN = (uint8_t)(RSCAN0CFPTR5 >> 28U);
//             stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RSCAN0CFID5 >> 31U));
//             stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RSCAN0CFDF05;
//             stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RSCAN0CFDF15;

//             RSCAN0CFPCTR5 = 0xFFU;

//             RSCAN0_CH1_Receive(&stCANFrameReceive.stReceiveContent);
//         }
//     }
// }

// void RSCAN0_CH2_RX_ISR(void)
// {

//     if (RSCAN0CFSTS8 & 0X08UL)
//     {
//         CAN_Frame_Receive_st_t stCANFrameReceive;
//         RSCAN0CFSTS8 &= 0xFFFFFFF7UL;

//         while ((RSCAN0CFSTS8 & 0x01UL) == 0U)
//         {
//             stCANFrameReceive.stReceiveContent.u32CANID = (uint32_t)(RSCAN0CFID8 & 0x1FFFFFFFUL);
//             stCANFrameReceive.stReceiveContent.u8CANLEN = (uint8_t)(RSCAN0CFPTR8 >> 28U);
//             stCANFrameReceive.stReceiveContent.u8CANFrameIDE = (uint8_t)((RSCAN0CFID8 >> 31U));
//             stCANFrameReceive.stReceiveContent.unCANData.u32CANData[0U] = RSCAN0CFDF08;
//             stCANFrameReceive.stReceiveContent.unCANData.u32CANData[1U] = RSCAN0CFDF18;

//             RSCAN0CFPCTR8 = 0xFFU;

//             RSCAN0_CH2_Receive(&stCANFrameReceive.stReceiveContent);
//             NM_EVCAN_Indication(stCANFrameReceive.stReceiveContent.u32CANID,stCANFrameReceive.stReceiveContent.u8CANLEN,stCANFrameReceive.stReceiveContent.unCANData.u8CANData);
//         }
//     }
// }

/*
void RSCAN0_CH0_TX_ISR(void)
{

    if (RSCAN0CFSTS0 & 0X10UL)
    {
        RSCAN0CFSTS0 &= 0XFFFFFFEFUL;
    }
    if (RSCAN0CFSTS1 & 0X10UL)
    {
        RSCAN0CFSTS1 &= 0XFFFFFFEFUL;
    }

    if ((RSCAN0TMSTS0 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS0 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    else if ((RSCAN0TMSTS0 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS0 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(0U);
        }
    }
    if ((RSCAN0TMSTS1 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS1 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(1, 0);
        }
    }
    else if ((RSCAN0TMSTS1 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS1 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(1U);
        }
    }
    if ((RSCAN0TMSTS2 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS2 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(2, 0);
        }
    }
    else if ((RSCAN0TMSTS2 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS2 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(2U);
        }
    }
    if ((RSCAN0TMSTS3 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS3 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(3, 0);
        }
    }
    else if ((RSCAN0TMSTS3 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS3 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(3U);
        }
    }
    if ((RSCAN0TMSTS4 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS4 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(4, 0);
        }
    }
    else if ((RSCAN0TMSTS4 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS4 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(4U);
        }
    }
    if ((RSCAN0TMSTS5 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS5 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(5, 0);
        }
    }
    else if ((RSCAN0TMSTS5 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS5 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(5U);
        }
    }
    if ((RSCAN0TMSTS6 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS6 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(6, 0);
        }
    }
    else if ((RSCAN0TMSTS6 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS6 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(6U);
        }
    }
    if ((RSCAN0TMSTS7 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS7 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(7, 0);
        }
    }
    else if ((RSCAN0TMSTS7 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS7 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(7U);
        }
    }
    if ((RSCAN0TMSTS8 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS8 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(8, 0);
        }
    }
    else if ((RSCAN0TMSTS8 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS8 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(8U);
        }
    }
    if ((RSCAN0TMSTS9 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS9 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(9, 0);
        }
    }
    else if ((RSCAN0TMSTS9 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS9 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(9U);
        }
    }
    if ((RSCAN0TMSTS10 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS10 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(10, 0);
        }
    }
    else if ((RSCAN0TMSTS10 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS10 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(10U);
        }
    }
    if ((RSCAN0TMSTS11 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS11 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(11, 0);
        }
    }
    else if ((RSCAN0TMSTS11 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS11 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(11U);
        }
    }
    if ((RSCAN0TMSTS12 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS12 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(12, 0);
        }
    }
    else if ((RSCAN0TMSTS12 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS12 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(12U);
        }
    }
    if ((RSCAN0TMSTS13 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS13 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(13, 0);
        }
    }
    else if ((RSCAN0TMSTS13 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS13 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(13U);
        }
    }
    if ((RSCAN0TMSTS14 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS14 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(14, 0);
        }
    }
    else if ((RSCAN0TMSTS14 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS14 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(14U);
        }
    }
    if ((RSCAN0TMSTS15 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS15 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(15, 0);
        }
    }
    else if ((RSCAN0TMSTS15 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS15 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(15U);
        }
    }
}

void RSCAN0_CH1_TX_ISR(void)
{

    if (RSCAN0CFSTS3 & 0X10UL)
    {
        RSCAN0CFSTS3 &= 0XFFFFFFEFUL;
    }
    if (RSCAN0CFSTS4 & 0X10UL)
    {
        RSCAN0CFSTS4 &= 0XFFFFFFEFUL;
    }

    if ((RSCAN0TMSTS16 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS16 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    else if ((RSCAN0TMSTS16 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS16 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(0U);
        }
    }
    if ((RSCAN0TMSTS17 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS17 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(1, 0);
        }
    }
    else if ((RSCAN0TMSTS17 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS17 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(1U);
        }
    }
    if ((RSCAN0TMSTS18 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS18 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(2, 0);
        }
    }
    else if ((RSCAN0TMSTS18 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS18 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(2U);
        }
    }
    if ((RSCAN0TMSTS19 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS19 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(3, 0);
        }
    }
    else if ((RSCAN0TMSTS19 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS19 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(3U);
        }
    }
    if ((RSCAN0TMSTS20 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS20 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(4, 0);
        }
    }
    else if ((RSCAN0TMSTS20 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS20 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(4U);
        }
    }
    if ((RSCAN0TMSTS21 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS21 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(5, 0);
        }
    }
    else if ((RSCAN0TMSTS21 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS21 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(5U);
        }
    }
    if ((RSCAN0TMSTS22 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS22 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(6, 0);
        }
    }
    else if ((RSCAN0TMSTS22 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS22 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(6U);
        }
    }
    if ((RSCAN0TMSTS23 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS23 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(7, 0);
        }
    }
    else if ((RSCAN0TMSTS23 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS23 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(7U);
        }
    }
    if ((RSCAN0TMSTS24 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS24 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(8, 0);
        }
    }
    else if ((RSCAN0TMSTS24 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS24 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(8U);
        }
    }
    if ((RSCAN0TMSTS25 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS25 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(9, 0);
        }
    }
    else if ((RSCAN0TMSTS25 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS25 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(9U);
        }
    }
    if ((RSCAN0TMSTS26 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS26 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(10, 0);
        }
    }
    else if ((RSCAN0TMSTS26 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS26 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(10U);
        }
    }
    if ((RSCAN0TMSTS27 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS27 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(11, 0);
        }
    }
    else if ((RSCAN0TMSTS27 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS27 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(11U);
        }
    }
    if ((RSCAN0TMSTS28 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS28 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(12, 0);
        }
    }
    else if ((RSCAN0TMSTS28 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS28 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(12U);
        }
    }
    if ((RSCAN0TMSTS29 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS29 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(13, 0);
        }
    }
    else if ((RSCAN0TMSTS29 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS29 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(13U);
        }
    }
    if ((RSCAN0TMSTS30 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS30 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(14, 0);
        }
    }
    else if ((RSCAN0TMSTS30 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS30 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(14U);
        }
    }
    if ((RSCAN0TMSTS31 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS31 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANConfirmCallBack(15, 0);
        }
    }
    else if ((RSCAN0TMSTS31 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS31 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh1.pfnRSCANAbortConfirmCallBack(15U);
        }
    }
}

void RSCAN0_CH2_TX_ISR(void)
{
    if (RSCAN0CFSTS6 & 0X10UL)
    {
        RSCAN0CFSTS6 &= 0XFFFFFFEFUL;
    }
    if (RSCAN0CFSTS7 & 0X10UL)
    {
        RSCAN0CFSTS7 &= 0XFFFFFFEFUL;
    }

    if ((RSCAN0TMSTS32 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS32 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    else if ((RSCAN0TMSTS32 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS32 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(0U);
        }
    }

    if ((RSCAN0TMSTS33 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS33 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(1U, 0U);
        }
    }
    else if ((RSCAN0TMSTS33 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS33 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(1U);
        }
    }

    if ((RSCAN0TMSTS34 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS34 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(2U, 0U);
        }
    }
    else if ((RSCAN0TMSTS34 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS34 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(2U);
        }
    }

    if ((RSCAN0TMSTS35 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS35 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(3U, 0U);
        }
    }
    else if ((RSCAN0TMSTS35 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS35 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(3U);
        }
    }

    if ((RSCAN0TMSTS36 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS36 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(4U, 0U);
        }
    }
    else if ((RSCAN0TMSTS36 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS36 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(4U);
        }
    }
    if ((RSCAN0TMSTS37 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS37 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(5U, 0U);
        }
    }
    else if ((RSCAN0TMSTS37 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS37 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(5U);
        }
    }
    if ((RSCAN0TMSTS38 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS38 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(6U, 0U);
        }
    }
    else if ((RSCAN0TMSTS38 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS38 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(6U);
        }
    }
    if ((RSCAN0TMSTS39 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS39 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(7U, 0U);
        }
    }
    else if ((RSCAN0TMSTS39 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS39 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(7U);
        }
    }
    if ((RSCAN0TMSTS40 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS40 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(8U, 0U);
        }
    }
    else if ((RSCAN0TMSTS40 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS40 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(8U);
        }
    }
    if ((RSCAN0TMSTS41 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS41 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(9U, 0U);
        }
    }
    else if ((RSCAN0TMSTS41 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS41 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(9U);
        }
    }
    if ((RSCAN0TMSTS42 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS42 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(10U, 0U);
        }
    }
    else if ((RSCAN0TMSTS42 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS42 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(10U);
        }
    }
    if ((RSCAN0TMSTS43 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS43 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(11U, 0U);
        }
    }
    else if ((RSCAN0TMSTS43 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS43 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(11U);
        }
    }
    if ((RSCAN0TMSTS44 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS44 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(12U, 0U);
        }
    }
    else if ((RSCAN0TMSTS44 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS44 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(12U);
        }
    }
    if ((RSCAN0TMSTS45 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS45 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(13U, 0U);
        }
    }
    else if ((RSCAN0TMSTS45 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS45 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(13U);
        }
    }
    if ((RSCAN0TMSTS46 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS46 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(14U, 0U);
        }
    }
    else if ((RSCAN0TMSTS46 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS46 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(14U);
        }
    }
    if ((RSCAN0TMSTS47 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT)
    {
        RSCAN0TMSTS47 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(15U, 0U);
        }
    }
    else if ((RSCAN0TMSTS47 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT)
    {
        RSCAN0TMSTS47 = 0X0U;
        if (g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack)
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANAbortConfirmCallBack(15U);
        }
    }
}
*/
/*********************************************************************/
