/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_DIAG_Ram.h                                                                                      */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                              COPYRIGHT                                                             */
/*====================================================================================================================*/
/* (c) 2021 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Global variable definitions of PWM Driver                                                                          */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.0.0: 23/08/2021 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                              Include Section                                                       **
***********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_DIAG_RAM_H
            #define PWM_59_INST0_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_DIAG_RAM_H
            #define PWM_59_INST1_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_DIAG_RAM_H
            #define PWM_59_INST2_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_DIAG_RAM_H
            #define PWM_59_INST3_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_DIAG_RAM_H
            #define PWM_59_INST4_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_DIAG_RAM_H
            #define PWM_59_INST5_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_DIAG_RAM_H
            #define PWM_59_INST6_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_DIAG_RAM_H
            #define PWM_59_INST7_DIAG_RAM_H
            #define PWM_DIAG_RAM_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_DIAG_RAM_H
        #define PWM_DIAG_RAM_H
        #define PWM_DIAG_RAM_HEADER
    #endif
#endif


#ifdef PWM_DIAG_RAM_HEADER
#undef PWM_DIAG_RAM_HEADER                                                                                              /* PRQA S 0841 # JV-01 */

#include "Pwm_DIAG_PBTypes.h"
/***********************************************************************************************************************
**                                              Version Information                                                   **
***********************************************************************************************************************/
/* AUTOSAR release version information */
#define PWM_DIAG_RAM_AR_RELEASE_MAJOR_VERSION      PWM_AR_RELEASE_MAJOR_VERSION
#define PWM_DIAG_RAM_AR_RELEASE_MINOR_VERSION      PWM_AR_RELEASE_MINOR_VERSION
#define PWM_DIAG_RAM_AR_RELEASE_REVISION_VERSION   PWM_AR_RELEASE_REVISION_VERSION

/* Software module version information */
#define PWM_DIAG_RAM_SW_MAJOR_VERSION              PWM_SW_MAJOR_VERSION
#define PWM_DIAG_RAM_SW_MINOR_VERSION              PWM_SW_MINOR_VERSION
#define PWM_DIAG_RAM_SW_PATCH_VERSION              PWM_SW_PATCH_VERSION

/***********************************************************************************************************************
**                                              Global configuration constants                                        **
***********************************************************************************************************************/
#if (PWM_DIAG_UNIT_USED == STD_ON)

#define PWM_START_SEC_VAR_NO_INIT_PTR
#include "Pwm_Mapping.h"

extern P2CONST(Pwm_DiagUnitConfigType, PWM_VAR_NO_INIT, PWM_CONFIG_DATA) Pwm_GpDiagConfig;

#define PWM_STOP_SEC_VAR_NO_INIT_PTR
#include "Pwm_Mapping.h"

#define PWM_START_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"

extern VAR(Pwm_HwFuncTableType, PWM_VAR_INIT) Pwm_DiagFunc;

#define PWM_STOP_SEC_VAR_INIT_UNSPECIFIED
#include "Pwm_Mapping.h"

#endif /* End of PWM_DIAG_UNIT_USED == STD_ON */
#endif /* End of PWM_DIAG_RAM_H */
/***********************************************************************************************************************
**                                              End of File                                                           **
***********************************************************************************************************************/
