/*====================================================================================================================*/
/* Project      = RH850/X2x AR4 MCAL Development                                                                      */
/* Module       = Pwm_MultiInstance.h                                                                                 */
/* SW-VERSION   = 1.5.0                                                                                               */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                       COPYRIGHT                                                    */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of API information.                                                                                      */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*                                              Devices:        X2x                                                   */
/*====================================================================================================================*/
/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*                                                                                                                    **
 * 1.4.4: 13/07/2022 : Removed QAC message 0883                                                                       **
 * 1.4.3: 18/04/2022 : Removed un-used define                                                                         **
 *                     Pwm_GaaTimerUnitConfig, Pwm_GaaClockConfig, Pwm_GaaNotificationStatus, Pwm_GblSyncStartStatus  **
 * 1.4.1: 21/11/2021 : Update QAC message for U2Bx                                                                    **
 * 1.4.0: 20/10/2021 : Added Types for Pwm Diag                                                                       **
 * 1.3.2: 14/08/2021 : Added variable Pwm_GaaTAUDUnitConfig                                                           **
 * 1.3.1: 02/07/2021 : Format source code to 120 characters                                                           **
 *        15/05/2021 : Fixed Coding Rule and tailor space                                                             **
 * 1.2.0: 28/07/2020 : Release                                                                                        **
 * 1.1.0: 19/06/2020 : Release                                                                                        **
 * 1.0.2: 05/06/2020 : Removed "Pwm_GpClockConfig"                                                                    **
 * 1.0.1: 27/04/2020 : macro definition and compile switch                                                            **
 * 1.0.0: 24/03/2020 : Initial Version.                                                                               **
 *                                                                                                                    */
/**********************************************************************************************************************/

#ifdef PWM_INSTANCE_INDEX
    #if (PWM_INSTANCE_INDEX == 0)
        #ifndef PWM_59_INST0_MULTIINSTANCE_H
            #define PWM_59_INST0_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 1)
        #ifndef PWM_59_INST1_MULTIINSTANCE_H
            #define PWM_59_INST1_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 2)
        #ifndef PWM_59_INST2_MULTIINSTANCE_H
            #define PWM_59_INST2_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 3)
        #ifndef PWM_59_INST3_MULTIINSTANCE_H
            #define PWM_59_INST3_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 4)
        #ifndef PWM_59_INST4_MULTIINSTANCE_H
            #define PWM_59_INST4_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 5)
        #ifndef PWM_59_INST5_MULTIINSTANCE_H
            #define PWM_59_INST5_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 6)
        #ifndef PWM_59_INST6_MULTIINSTANCE_H
            #define PWM_59_INST6_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #elif (PWM_INSTANCE_INDEX == 7)
        #ifndef PWM_59_INST7_MULTIINSTANCE_H
            #define PWM_59_INST7_MULTIINSTANCE_H
            #define PWM_MULTIINSTANCE_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef PWM_MULTIINSTANCE_H
        #define PWM_MULTIINSTANCE_H
        #define PWM_MULTIINSTANCE_HEADER
    #endif
#endif

#ifdef PWM_MULTIINSTANCE_HEADER
#undef PWM_MULTIINSTANCE_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

#define PWM_INCLUDE_FROM_MCAL

/* PWM_INSTANCE_INDEX is passed by -D option */
#ifdef PWM_INSTANCE_INDEX

/* Add index to all global symbols. INSTANCE_INDEX is passed by -D option */
#define PWM_MULTIINC(pre_symbol, suf_symbol)             PWM_MULTIINC_(pre_symbol, suf_symbol, PWM_INSTANCE_INDEX)
/* To evaluate INSTANCE_INDEX before concatenation, nest the macro */
#define PWM_MULTIINC_(pre_symbol, suf_symbol, index)     PWM_MULTIINC__(pre_symbol, suf_symbol, index)
#define PWM_MULTIINC__(pre_symbol, suf_symbol, index)    pre_symbol##index##suf_symbol.h

/* String conversion macro */
#define TO_STRING(str)                                   TO_STRING_(str)
#define TO_STRING_(str)                                  #str

/* Add index to all global symbols. INSTANCE_INDEX is passed by -D option */
#define PWM_MULTI(pre_symbol, suf_symbol)                PWM_MULTI_(pre_symbol, suf_symbol, PWM_INSTANCE_INDEX)
/* To evaluate INSTANCE_INDEX before concatenation, nest the macro */
#define PWM_MULTI_(pre_symbol, suf_symbol, index)        PWM_MULTI__(pre_symbol, suf_symbol, index)
#define PWM_MULTI__(pre_symbol, suf_symbol, index)       pre_symbol##index##suf_symbol


/* Multi instance all APIs */

#define Pwm_GetVersionInfo                               PWM_MULTI(Pwm_59_Inst, _GetVersionInfo)
#define Pwm_Init                                         PWM_MULTI(Pwm_59_Inst, _Init)
#define Pwm_DeInit                                       PWM_MULTI(Pwm_59_Inst, _DeInit)
#define Pwm_SetDutyCycle                                 PWM_MULTI(Pwm_59_Inst, _SetDutyCycle)
#define Pwm_SetPeriodAndDuty                             PWM_MULTI(Pwm_59_Inst, _SetPeriodAndDuty)
#define Pwm_SetOutputToIdle                              PWM_MULTI(Pwm_59_Inst, _SetOutputToIdle)
#define Pwm_GetOutputState                               PWM_MULTI(Pwm_59_Inst, _GetOutputState)
#define Pwm_EnableNotification                           PWM_MULTI(Pwm_59_Inst, _EnableNotification)
#define Pwm_DisableNotification                          PWM_MULTI(Pwm_59_Inst, _DisableNotification)
#define Pwm_SelectChannelClk                             PWM_MULTI(Pwm_59_Inst, _SelectChannelClk)
#define Pwm_SynchronousInit                              PWM_MULTI(Pwm_59_Inst, _SynchronousInit)
#define Pwm_SynchronousStart                             PWM_MULTI(Pwm_59_Inst, _SynchronousStart)
#define Pwm_SynchronousStop                              PWM_MULTI(Pwm_59_Inst, _SynchronousStop)
#define Pwm_SetChannelOutput                             PWM_MULTI(Pwm_59_Inst, _SetChannelOutput)
#define Pwm_SetTriggerDelay                              PWM_MULTI(Pwm_59_Inst, _SetTriggerDelay)
#define Pwm_DiagReadAdConvResult                         PWM_MULTI(Pwm_59_Inst, _DiagReadAdConvResult)
#define Pwm_DiagDisableAdTrigger                         PWM_MULTI(Pwm_59_Inst, _DiagDisableAdTrigger)
#define Pwm_DiagEnableAdTrigger                          PWM_MULTI(Pwm_59_Inst, _DiagEnableAdTrigger)


/* Multi instance all internal functions */
/*ATU*/
#define Pwm_CheckDetErrors                               PWM_MULTI(Pwm_59_Inst, _CheckDetErrors)
#define Pwm_SetStatus                                    PWM_MULTI(Pwm_59_Inst, _SetStatus)
#define Pwm_HW_ATU_InitUnit                              PWM_MULTI(Pwm_59_Inst, _HW_ATU_InitUnit)
#define Pwm_HW_ATU_InitChannel                           PWM_MULTI(Pwm_59_Inst, _HW_ATU_InitChannel)
#define Pwm_HW_DeInitChannel                             PWM_MULTI(Pwm_59_Inst, _HW_DeInitChannel)
#define Pwm_HW_DeInitUnit                                PWM_MULTI(Pwm_59_Inst, _HW_DeInitUnit)
#define Pwm_HW_SetOutputToIdle                           PWM_MULTI(Pwm_59_Inst, _HW_SetOutputToIdle)
#define Pwm_HW_SetDutyCycle                              PWM_MULTI(Pwm_59_Inst, _HW_SetDutyCycle)
#define Pwm_HW_SetPeriodAndDuty                          PWM_MULTI(Pwm_59_Inst, _HW_SetPeriodAndDuty)
#define Pwm_HW_EnableNotification                        PWM_MULTI(Pwm_59_Inst, _HW_EnableNotification)
#define Pwm_HW_DisableNotification                       PWM_MULTI(Pwm_59_Inst, _HW_DisableNotification)
#define Pwm_HW_Callback                                  PWM_MULTI(Pwm_59_Inst, _HW_Callback)
#define Pwm_HW_SelectChannelClk                          PWM_MULTI(Pwm_59_Inst, _HW_SelectChannelClk)
#define Pwm_HW_SynchronousInit                           PWM_MULTI(Pwm_59_Inst, _HW_SynchronousInit)
#define Pwm_HW_SynchronousStart                          PWM_MULTI(Pwm_59_Inst, _HW_SynchronousStart)
#define Pwm_HW_SynchronousStop                           PWM_MULTI(Pwm_59_Inst, _HW_SynchronousStop)
#define Pwm_HW_CalculateDuty                             PWM_MULTI(Pwm_59_Inst, _HW_CalculateDuty)
#define Pwm_HW_InitChannelRegister                       PWM_MULTI(Pwm_59_Inst, _HW_InitChannelRegister)
#define Pwm_HW_InitUnitRegister                          PWM_MULTI(Pwm_59_Inst, _HW_InitUnitRegister)
#define Pwm_HW_SetDutyToIdleState                        PWM_MULTI(Pwm_59_Inst, _HW_SetDutyToIdleState)

/*TAUD*/
#define Pwm_HW_TAUD_InitUnit                             PWM_MULTI(Pwm_59_Inst, _HW_TAUD_InitUnit)
#define Pwm_HW_TAUD_StartOutput                          PWM_MULTI(Pwm_59_Inst, _HW_TAUD_StartOutput)
#define Pwm_HW_TAUD_CalculateDuty                        PWM_MULTI(Pwm_59_Inst, _HW_TAUD_CalculateDuty)
#define Pwm_HW_TAUD_InitChannel                          PWM_MULTI(Pwm_59_Inst, _HW_TAUD_InitChannel)
#define Pwm_HW_TAUD_DeInitUnit                           PWM_MULTI(Pwm_59_Inst, _HW_TAUD_DeInitUnit)
#define Pwm_HW_TAUD_DeInitChannel                        PWM_MULTI(Pwm_59_Inst, _HW_TAUD_DeInitChannel)
#define Pwm_HW_TAUD_SetDuty_FixedPeriodShifted           PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SetDuty_FixedPeriodShifted)
#define Pwm_HW_TAUD_SetDutyCycle                         PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SetDutyCycle)
#define Pwm_HW_TAUD_SetPeriodAndDuty                     PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SetPeriodAndDuty)
#define Pwm_HW_TAUD_SetOutputToIdle                      PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SetOutputToIdle)
#define Pwm_HW_TAUD_GetOutputState                       PWM_MULTI(Pwm_59_Inst, _HW_TAUD_GetOutputState)
#define Pwm_HW_TAUD_IntNotification                      PWM_MULTI(Pwm_59_Inst, _HW_TAUD_IntNotification)
#define Pwm_HW_TAUD_EnableNotification                   PWM_MULTI(Pwm_59_Inst, _HW_TAUD_EnableNotification)
#define Pwm_HW_TAUD_DisableNotification                  PWM_MULTI(Pwm_59_Inst, _HW_TAUD_DisableNotification)
#define Pwm_HW_TAUD_SetChannelOutput                     PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SetChannelOutput)
#define Pwm_HW_TAUD_SetOutputEnable                      PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SetOutputEnable)
#define Pwm_HW_TAUD_SynchronousInit                      PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SynchronousInit)
#define Pwm_HW_TAUD_SynchronousStart                     PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SynchronousStart)
#define Pwm_HW_TAUD_SynchronousStop                      PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SynchronousStop)
#define Pwm_HW_TAUD_Callback                             PWM_MULTI(Pwm_59_Inst, _HW_TAUD_Callback)
#define Pwm_HW_TAUD_SelectChannelClk                     PWM_MULTI(Pwm_59_Inst, _HW_TAUD_SelectChannelClk)

/*TAUJ*/
#define Pwm_HW_TAUJ_InitUnit                             PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_InitUnit)
#define Pwm_HW_TAUJ_StartOutput                          PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_StartOutput)
#define Pwm_HW_TAUJ_InitChannel                          PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_InitChannel)
#define Pwm_HW_TAUJ_DeInitUnit                           PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_DeInitUnit)
#define Pwm_HW_TAUJ_DeInitChannel                        PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_DeInitChannel)
#define Pwm_HW_TAUJ_SetDutyCycle                         PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SetDutyCycle)
#define Pwm_HW_TAUJ_SetPeriodAndDuty                     PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SetPeriodAndDuty)
#define Pwm_HW_TAUJ_SetOutputToIdle                      PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SetOutputToIdle)
#define Pwm_HW_TAUJ_GetOutputState                       PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_GetOutputState)
#define Pwm_HW_TAUJ_CalculateDuty                        PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_CalculateDuty)
#define Pwm_HW_TAUJ_Callback                             PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_Callback)
#define Pwm_HW_TAUJ_IntNotification                      PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_IntNotification)
#define Pwm_HW_TAUJ_EnableNotification                   PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_EnableNotification)
#define Pwm_HW_TAUJ_DisableNotification                  PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_DisableNotification)
#define Pwm_HW_TAUJ_SelectChannelClk                     PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SelectChannelClk)
#define Pwm_HW_TAUJ_SetChannelOutput                     PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SetChannelOutput)
#define Pwm_HW_TAUJ_SynchronousInit                      PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SynchronousInit)
#define Pwm_HW_TAUJ_SynchronousStart                     PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SynchronousStart)
#define Pwm_HW_TAUJ_SetOutputEnable                      PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SetOutputEnable)
#define Pwm_HW_TAUJ_SynchronousStop                      PWM_MULTI(Pwm_59_Inst, _HW_TAUJ_SynchronousStop)

/* DIAG */
#define Pwm_HW_DIAG_InitUnit                             PWM_MULTI(Pwm_59_Inst, _HW_DIAG_InitUnit)
#define Pwm_HW_DIAG_InitChannel                          PWM_MULTI(Pwm_59_Inst, _HW_DIAG_InitChannel)
#define Pwm_HW_DIAG_DeInitUnit                           PWM_MULTI(Pwm_59_Inst, _HW_DIAG_DeInitUnit)
#define Pwm_HW_DIAG_DeInitChannel                        PWM_MULTI(Pwm_59_Inst, _HW_DIAG_DeInitChannel)
#define Pwm_HW_DIAG_SetDutyCycle                         PWM_MULTI(Pwm_59_Inst, _HW_DIAG_SetDutyCycle)
#define Pwm_HW_DIAG_SetOutputToIdle                      PWM_MULTI(Pwm_59_Inst, _HW_DIAG_SetOutputToIdle)
#define Pwm_HW_DIAG_DisableNotification                  PWM_MULTI(Pwm_59_Inst, _HW_DIAG_DisableNotification)
#define Pwm_HW_DIAG_EnableNotification                   PWM_MULTI(Pwm_59_Inst, _HW_DIAG_EnableNotification)
#define Pwm_HW_DIAG_DisableAdTrigger                     PWM_MULTI(Pwm_59_Inst, _HW_DIAG_DisableAdTrigger)
#define Pwm_HW_DIAG_EnableAdTrigger                      PWM_MULTI(Pwm_59_Inst, _HW_DIAG_EnableAdTrigger)
#define Pwm_HW_DIAG_SetTriggerDelay                      PWM_MULTI(Pwm_59_Inst, _HW_DIAG_SetTriggerDelay)
#define Pwm_HW_DIAG_ReadAdConvResult                     PWM_MULTI(Pwm_59_Inst, _HW_DIAG_ReadAdConvResult)
#define Pwm_HW_DIAG_Callback                             PWM_MULTI(Pwm_59_Inst, _HW_DIAG_Callback)


/* PWM_MULTI instance export global variables */
#define Pwm_GaaTAUChannelConfig                          PWM_MULTI(Pwm_59_Inst, _GaaTAUChannelConfig)
#define Pwm_GaaConfiguration                             PWM_MULTI(Pwm_59_Inst, _GaaConfiguration)
#define Pwm_GaaChannelConfig                             PWM_MULTI(Pwm_59_Inst, _GaaChannelConfig)
#define Pwm_GaaATUChannelProp                            PWM_MULTI(Pwm_59_Inst, _GaaATUChannelProp)
#define Pwm_GaaFpsSupport_Flag                           PWM_MULTI(Pwm_59_Inst, _GaaFpsSupport_Flag)
#define Pwm_GaaNotifStatus                               PWM_MULTI(Pwm_59_Inst, _GaaNotifStatus)
#define Pwm_GaaATUClockConfig                            PWM_MULTI(Pwm_59_Inst, _GaaATUClockConfig)
#define Pwm_GaaATUConfiguration                          PWM_MULTI(Pwm_59_Inst, _GaaATUConfiguration)
#define Pwm_GpATUClockConfig                             PWM_MULTI(Pwm_59_Inst, _GpATUClockConfig)
#define Pwm_GaaATUUnitConfig                             PWM_MULTI(Pwm_59_Inst, _GaaATUUnitConfig)
#define Pwm_GaaATUChannelConfig                          PWM_MULTI(Pwm_59_Inst, _GaaATUChannelConfig)
#define Pwm_GpATUUnitConfig                              PWM_MULTI(Pwm_59_Inst, _GpATUUnitConfig)
#define Pwm_GaaChannelConstantStatus                     PWM_MULTI(Pwm_59_Inst, _GaaChannelConstantStatus)
#define Pwm_GaaChannelIdleStatus                         PWM_MULTI(Pwm_59_Inst, _GaaChannelIdleStatus)
#define Pwm_GaaTAUDUnitConfig                            PWM_MULTI(Pwm_59_Inst, _GaaTAUDUnitConfig)
#define Pwm_GaaTAUDChannelProp                           PWM_MULTI(Pwm_59_Inst, _GaaTAUDChannelProp)
#define Pwm_GaaTAUJUnitConfig                            PWM_MULTI(Pwm_59_Inst, _GaaTAUJUnitConfig)
#define Pwm_GaaTAUJChannelProp                           PWM_MULTI(Pwm_59_Inst, _GaaTAUJChannelProp)
#define Pwm_GpChannelConfig                              PWM_MULTI(Pwm_59_Inst, _GpChannelConfig)
#define Pwm_GpTimerUnitConfig                            PWM_MULTI(Pwm_59_Inst, _GpTimerUnitConfig)
#define Pwm_GblDriverStatus                              PWM_MULTI(Pwm_59_Inst, _GblDriverStatus)
#define Pwm_GblSyncInitStatus                            PWM_MULTI(Pwm_59_Inst, _GblSyncInitStatus)
#define Pwm_GblSyncOperationStatus                       PWM_MULTI(Pwm_59_Inst, _GblSyncOperationStatus)
#define Pwm_GblOutputState                               PWM_MULTI(Pwm_59_Inst, _GblOutputState)
#define Pwm_GpTAUDUnitConfig                             PWM_MULTI(Pwm_59_Inst, _GpTAUDUnitConfig)
#define Pwm_GpTAUJUnitConfig                             PWM_MULTI(Pwm_59_Inst, _GpTAUJUnitConfig)
#define Pwm_GaaDiagChConfig                              PWM_MULTI(Pwm_59_Inst, _GaaDiagChConfig)
#define Pwm_GaaPrescalerConfig                           PWM_MULTI(Pwm_59_Inst, _GaaPrescalerConfig)
#define Pwm_GaaPeriodConfig                              PWM_MULTI(Pwm_59_Inst, _GaaPeriodConfig)
#define Pwm_GaaDiagNotifyConfig                          PWM_MULTI(Pwm_59_Inst, _GaaDiagNotifyConfig)
#define Pwm_GaaDiagNotiGrConfig                          PWM_MULTI(Pwm_59_Inst, _GaaDiagNotiGrConfig)
#define Pwm_GaaPeriodSelectConfig                        PWM_MULTI(Pwm_59_Inst, _GaaPeriodSelectConfig)
#define Pwm_GaaDiagUnitConfig                            PWM_MULTI(Pwm_59_Inst, _GaaDiagUnitConfig)
#define Pwm_GpDiagConfig                                 PWM_MULTI(Pwm_59_Inst, _GpDiagConfig)

#define Pwm_GaaHWIP_Used                                 PWM_MULTI(Pwm_59_Inst, _GaaHWIP_Used)
#define Pwm_AtuFunc                                      PWM_MULTI(Pwm_59_Inst, _AtuFunc)
#define Pwm_TaudFunc                                     PWM_MULTI(Pwm_59_Inst, _TaudFunc)
#define Pwm_TaujFunc                                     PWM_MULTI(Pwm_59_Inst, _TaujFunc)
#define Pwm_DiagFunc                                     PWM_MULTI(Pwm_59_Inst, _DiagFunc)
#define Pwm_GaaHwFunc                                    PWM_MULTI(Pwm_59_Inst, _GaaHwFunc)

/* Define Pwm's Type*/
#define Pwm_ATUChannelPropType                           PWM_MULTI(Pwm_59_Inst, _ATUChannelPropType)
#define Pwm_ATUConfigType                                PWM_MULTI(Pwm_59_Inst, _ATUConfigType)
#define Pwm_ATUClockConfigType                           PWM_MULTI(Pwm_59_Inst, _ATUClockConfigType )
#define Pwm_ATUUnitConfigType                            PWM_MULTI(Pwm_59_Inst, _ATUUnitConfigType)
#define Pwm_ATUChannelConfigType                         PWM_MULTI(Pwm_59_Inst, _ATUChannelConfigType)
#define Pwm_HwFuncTableType                              PWM_MULTI(Pwm_59_Inst, _HwFuncTableType)
#define Pwm_TAUChannelConfigType                         PWM_MULTI(Pwm_59_Inst, _TAUChannelConfigType)
#define Pwm_TAUDConfigType                               PWM_MULTI(Pwm_59_Inst, _TAUDConfigType)
#define Pwm_TAUDUnitConfigType                           PWM_MULTI(Pwm_59_Inst, _TAUDUnitConfigType)
#define Pwm_TAUDChannelPropType                          PWM_MULTI(Pwm_59_Inst, _TAUDChannelPropType)
#define Pwm_TAUJConfigType                               PWM_MULTI(Pwm_59_Inst, _TAUJConfigType)
#define Pwm_TAUJUnitConfigType                           PWM_MULTI(Pwm_59_Inst, _TAUJUnitConfigType)
#define Pwm_TAUJChannelPropType                          PWM_MULTI(Pwm_59_Inst, _TAUJChannelPropType)
#define Pwm_ChannelConfigType                            PWM_MULTI(Pwm_59_Inst, _ChannelConfigType)
#define Pwm_ConfigType                                   PWM_MULTI(Pwm_59_Inst, _ConfigType)
#define Pwm_HWIP_ConfigType                              PWM_MULTI(Pwm_59_Inst, _HWIP_ConfigType)
#define Pwm_DiagChannelConfigType                        PWM_MULTI(Pwm_59_Inst, _DiagChannelConfigType)
#define Pwm_DiagPrescalerConfigType                      PWM_MULTI(Pwm_59_Inst, _DiagPrescalerConfigType)
#define Pwm_DiagPeriodConfigType                         PWM_MULTI(Pwm_59_Inst, _DiagPeriodConfigType)
#define Pwm_DiagNotiGrConfigType                         PWM_MULTI(Pwm_59_Inst, _DiagNotiGrConfigType)
#define Pwm_DiagPeriodSelectConfigType                   PWM_MULTI(Pwm_59_Inst, _DiagPeriodSelectConfigType)
#define Pwm_DiagUnitConfigType                           PWM_MULTI(Pwm_59_Inst, _DiagUnitConfigType)
#define Pwm_DiagNotifyConfigType                         PWM_MULTI(Pwm_59_Inst, _DiagNotifyConfigType)

/*Multi instance for macro ISR*/
#define PWM_ISR_CATEGORY_2                               PWM_MULTI(PWM_59_INST, _ISR_CATEGORY_2)

/*Multi instance for common published information */
#define PWM_AR_RELEASE_MAJOR_VERSION_VALUE               PWM_MULTI(PWM_59_INST, _AR_RELEASE_MAJOR_VERSION_VALUE)
#define PWM_AR_RELEASE_MINOR_VERSION_VALUE               PWM_MULTI(PWM_59_INST, _AR_RELEASE_MINOR_VERSION_VALUE)
#define PWM_AR_RELEASE_REVISION_VERSION_VALUE            PWM_MULTI(PWM_59_INST, _AR_RELEASE_REVISION_VERSION_VALUE)
#define PWM_SW_MAJOR_VERSION_VALUE                       PWM_MULTI(PWM_59_INST, _SW_MAJOR_VERSION_VALUE)
#define PWM_SW_MINOR_VERSION_VALUE                       PWM_MULTI(PWM_59_INST, _SW_MINOR_VERSION_VALUE)
#define PWM_SW_PATCH_VERSION_VALUE                       PWM_MULTI(PWM_59_INST, _SW_PATCH_VERSION_VALUE)
#define PWM_AR_VERSION                                   PWM_MULTI(PWM_59_INST, _AR_VERSION)
#define PWM_VENDOR_ID_VALUE                              PWM_MULTI(PWM_59_INST, _VENDOR_ID_VALUE)
#define PWM_MODULE_ID_VALUE                              PWM_MULTI(PWM_59_INST, _MODULE_ID_VALUE)

/* Multi instance for DEM/DET ERROR */
#define PWM_E_INT_INCONSISTENT                           PWM_MULTI(PWM_59_INST, _E_INT_INCONSISTENT)
#define PWM_E_REWRITE_FAILED                             PWM_MULTI(PWM_59_INST, _E_REWRITE_FAILED)

/*Multi instance for version information */
#define PWM_CBK_AR_RELEASE_MAJOR_VERSION                 PWM_MULTI(PWM_59_INST, _CBK_AR_RELEASE_MAJOR_VERSION)
#define PWM_CBK_AR_RELEASE_MINOR_VERSION                 PWM_MULTI(PWM_59_INST, _CBK_AR_RELEASE_MINOR_VERSION)
#define PWM_CBK_AR_RELEASE_REVISION_VERSION              PWM_MULTI(PWM_59_INST, _CBK_AR_RELEASE_REVISION_VERSION)
#define PWM_CBK_SW_MAJOR_VERSION                         PWM_MULTI(PWM_59_INST, _CBK_SW_MAJOR_VERSION)
#define PWM_CBK_SW_MINOR_VERSION                         PWM_MULTI(PWM_59_INST, _CBK_SW_MINOR_VERSION)
#define PWM_CFG_AR_RELEASE_MAJOR_VERSION                 PWM_MULTI(PWM_59_INST, _CFG_AR_RELEASE_MAJOR_VERSION)
#define PWM_CFG_AR_RELEASE_MINOR_VERSION                 PWM_MULTI(PWM_59_INST, _CFG_AR_RELEASE_MINOR_VERSION)
#define PWM_CFG_AR_RELEASE_REVISION_VERSION              PWM_MULTI(PWM_59_INST, _CFG_AR_RELEASE_REVISION_VERSION)
#define PWM_CFG_SW_MAJOR_VERSION                         PWM_MULTI(PWM_59_INST, _CFG_SW_MAJOR_VERSION)
#define PWM_CFG_SW_MINOR_VERSION                         PWM_MULTI(PWM_59_INST, _CFG_SW_MINOR_VERSION)
#define PWM_PBCFG_C_AR_RELEASE_MAJOR_VERSION             PWM_MULTI(PWM_59_INST, _PBCFG_C_AR_RELEASE_MAJOR_VERSION)
#define PWM_PBCFG_C_AR_RELEASE_MINOR_VERSION             PWM_MULTI(PWM_59_INST, _PBCFG_C_AR_RELEASE_MINOR_VERSION)
#define PWM_PBCFG_C_AR_RELEASE_REVISION_VERSION          PWM_MULTI(PWM_59_INST, _PBCFG_C_AR_RELEASE_REVISION_VERSION)
#define PWM_PBCFG_C_SW_MAJOR_VERSION                     PWM_MULTI(PWM_59_INST, _PBCFG_C_SW_MAJOR_VERSION)
#define PWM_PBCFG_C_SW_MINOR_VERSION                     PWM_MULTI(PWM_59_INST, _PBCFG_C_SW_MINOR_VERSION)

#define PWM_59_INST0_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST0_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST0_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST0_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST0_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

#define PWM_59_INST1_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST1_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST1_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST1_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST1_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

#define PWM_59_INST2_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST2_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST2_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST2_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST2_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

#define PWM_59_INST3_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST3_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST3_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST3_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST3_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

#define PWM_59_INST4_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST4_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST4_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST4_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST4_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

#define PWM_59_INST5_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST5_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST5_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST5_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST5_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

#define PWM_59_INST6_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST6_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST6_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST6_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST6_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

#define PWM_59_INST7_PBTYPES_AR_RELEASE_MAJOR_VERSION              PWM_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define PWM_59_INST7_PBTYPES_AR_RELEASE_MINOR_VERSION              PWM_PBTYPES_AR_RELEASE_MINOR_VERSION
#define PWM_59_INST7_PBTYPES_AR_RELEASE_REVISION_VERSION           PWM_PBTYPES_AR_RELEASE_REVISION_VERSION
#define PWM_59_INST7_PBTYPES_SW_MAJOR_VERSION                      PWM_PBTYPES_SW_MAJOR_VERSION
#define PWM_59_INST7_PBTYPES_SW_MINOR_VERSION                      PWM_PBTYPES_SW_MINOR_VERSION

/* Multi instance for memory class/pointer class */
#define PWM_PUBLIC_CODE                                  PWM_MULTI(PWM_59_INST, _PUBLIC_CODE)
#define PWM_PRIVATE_CODE                                 PWM_MULTI(PWM_59_INST, _PRIVATE_CODE)
#define PWM_APPL_CODE                                    PWM_MULTI(PWM_59_INST, _APPL_CODE)
#define PWM_APPL_CONST                                   PWM_MULTI(PWM_59_INST, _APPL_CONST)
#define PWM_APPL_DATA                                    PWM_MULTI(PWM_59_INST, _APPL_DATA)
#define PWM_CODE_FAST                                    PWM_MULTI(PWM_59_INST, _CODE_FAST)
#define PWM_CONFIG_CONST                                 PWM_MULTI(PWM_59_INST, _CONFIG_CONST)
#define PWM_CONFIG_DATA                                  PWM_MULTI(PWM_59_INST, _CONFIG_DATA)
#define PWM_CONST                                        PWM_MULTI(PWM_59_INST, _CONST)
#define PWM_VAR_INT                                      PWM_MULTI(PWM_59_INST, _VAR_INIT)
#define PWM_VAR_NO_INIT                                  PWM_MULTI(PWM_59_INST, _VAR_NO_INIT)
#define PWM_VAR_FAST_NO_INIT                             PWM_MULTI(PWM_59_INST, _VAR_FAST_NO_INIT)

/* Define header file name */
#define PWM_MEMMAP_HEADER                               TO_STRING(PWM_MULTIINC(Pwm_59_Inst, _MemMap))
#define SCHM_PWM_HEADER                                 TO_STRING(PWM_MULTIINC(SchM_Pwm_59_Inst, ))
#define PWM_CFG_HEADER                                  TO_STRING(PWM_MULTIINC(Pwm_59_Inst, _Cfg))

#else /* end of defined(PWM_INSTANCE_INDEX)*/

#define PWM_MEMMAP_HEADER "Pwm_MemMap.h"
#define SCHM_PWM_HEADER   "SchM_Pwm.h"
#define PWM_CFG_HEADER    "Pwm_Cfg.h"

#endif /* defined(PWM_INSTANCE_INDEX) */
#endif /* PWM_MULTIINSTANCE_HEADER */
/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
