/*============================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                         */
/* Module       = Det.c                                                       */
/* SW-VERSION   = 1.5.0                                                       */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) 2019-2021 Renesas Electronics Corporation. All rights reserved.        */
/*============================================================================*/
/* Purpose:                                                                   */
/* This file contains the test application to test the                        */
/* DET errors of WDG Component Driver.                                        */
/*                                                                            */
/*============================================================================*/
/*                                                                            */
/* Unless otherwise agreed upon in writing between your company and           */
/* Renesas Electronics Corporation the following shall apply!                 */
/*                                                                            */
/* Warranty Disclaimer                                                        */
/*                                                                            */
/* There is no warranty of any kind whatsoever granted by Renesas. Any        */
/* warranty is expressly disclaimed and excluded by Renesas, either expressed */
/* or implied, including but not limited to those for non-infringement of     */
/* intellectual property, merchantability and/or fitness for the particular   */
/* purpose.                                                                   */
/*                                                                            */
/* Renesas shall not have any obligation to maintain, service or provide bug  */
/* fixes for the supplied Product(s) and/or the Application.                  */
/*                                                                            */
/* Each User is solely responsible for determining the appropriateness of     */
/* using the Product(s) and assumes all risks associated with its exercise    */
/* of rights under this Agreement, including, but not limited to the risks    */
/* and costs of program errors, compliance with applicable laws, damage to    */
/* or loss of data, programs or equipment, and unavailability or              */
/* interruption of operations.                                                */
/*                                                                            */
/* Limitation of Liability                                                    */
/*                                                                            */
/* In no event shall Renesas be liable to the User for any incidental,        */
/* consequential, indirect, or punitive damage (including but not limited     */
/* to lost profits) regardless of whether such liability is based on breach   */
/* of contract, tort, strict liability, breach of warranties, failure of      */
/* essential purpose or otherwise and even if advised of the possibility of   */
/* such damages. Renesas shall not be liable for any services or products     */
/* provided by third party vendors, developers or consultants identified or   */
/* referred to the User by Renesas in connection with the Product(s) and/or   */
/* the Application.                                                           */
/*                                                                            */
/*============================================================================*/
/* Environment:                                                               */
/*              Devices:        X2x                                           */
/*============================================================================*/

/*******************************************************************************
**                      Revision Control History                              **
*******************************************************************************/
/*
 * 1.3.1:  19/05/2021  : Add Det_ReportTransientFault function
 * 1.2.0:  26/08/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  27/12/2019  : Initial Version
 */
/******************************************************************************/

/*******************************************************************************
**                      Include Section                                       **
*******************************************************************************/
#include "Std_Types.h"
#include "Det.h"

/*******************************************************************************
**                      Version Information                                   **
*******************************************************************************/


/*******************************************************************************
**                      Version Check                                         **
*******************************************************************************/


/*******************************************************************************
**                         Global Data                                        **
*******************************************************************************/
#define DET_ERROR_BUFFER_SIZE 60U

Det_Error GstDetErrBuffer[DET_ERROR_BUFFER_SIZE];
Det_Fault GstDetFaultBuffer[DET_ERROR_BUFFER_SIZE];
uint8 GstDetBuffIndex = 0x00;


/*******************************************************************************
**                      Function Definitions                                  **
*******************************************************************************/


/*****************************************************************************/
/*                   Det_ReportError                                         */
/*****************************************************************************/
Std_ReturnType Det_ReportError (uint16 ModuleId, uint8 InstanceId,
                                                     uint8 ApiId, uint8 ErrorId)
{
  Det_Error *Lp_DetBuffer;
  /* DET error is reported */
  if (GstDetBuffIndex < DET_ERROR_BUFFER_SIZE)
  {
    Lp_DetBuffer = &GstDetErrBuffer[GstDetBuffIndex++];
    Lp_DetBuffer->ModuleId = ModuleId;
    Lp_DetBuffer->InstanceId = InstanceId;
    Lp_DetBuffer->ApiId = ApiId;
    Lp_DetBuffer->ErrorId = ErrorId;
  }
  else
  {
    /* Do nothing */
  }
  return(0);
}

/*****************************************************************************/
/*                   Det_ReportRuntimeError                                  */
/*****************************************************************************/
Std_ReturnType Det_ReportRuntimeError (uint16 ModuleId, uint8 InstanceId,
                                                     uint8 ApiId, uint8 ErrorId)
{
  Det_Error *Lp_DetBuffer;
  /* DET error is reported */
  if (GstDetBuffIndex < DET_ERROR_BUFFER_SIZE)
  {
    Lp_DetBuffer = &GstDetErrBuffer[GstDetBuffIndex++];
    Lp_DetBuffer->ModuleId = ModuleId;
    Lp_DetBuffer->InstanceId = InstanceId;
    Lp_DetBuffer->ApiId = ApiId;
    Lp_DetBuffer->ErrorId = ErrorId;
  }
  else
  {
    /* Do nothing */
  }
  return(0);
}

/*****************************************************************************/
/*                   Det_ReportTransientFault                                */
/*****************************************************************************/
Std_ReturnType Det_ReportTransientFault (uint16 ModuleId, uint8 InstanceId,
                                                     uint8 ApiId, uint8 FaultId)
{
  Det_Fault *Lp_DetBuffer;
  /* DET error is reported */
  if (GstDetBuffIndex < DET_ERROR_BUFFER_SIZE)
  {
    Lp_DetBuffer = &GstDetFaultBuffer[GstDetBuffIndex++];
    Lp_DetBuffer->ModuleId = ModuleId;
    Lp_DetBuffer->InstanceId = InstanceId;
    Lp_DetBuffer->ApiId = ApiId;
    Lp_DetBuffer->FaultId = FaultId;
  }
  else
  {
    /* Do nothing */
  }
  return(0);
}
/*******************************************************************************
**                      End of File                                           **
*******************************************************************************/
