/*============================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                         */
/* Module       = EthIf.c                                                     */
/* SW-VERSION   = 1.6.0                                                       */
/*============================================================================*/
/*                                  COPYRIGHT                                 */
/*============================================================================*/
/* (c) 2020,2021 Renesas Electronics Corporation. All rights reserved.        */
/*============================================================================*/
/* Purpose:                                                                   */
/* This application file contains execution sequences to demonstrate the usage*/
/* of ETH Driver APIs.                                                        */
/*                                                                            */
/*============================================================================*/
/*                                                                            */
/* Unless otherwise agreed upon in writing between your company and           */
/* Renesas Electronics Corporation the following shall apply!                 */
/*                                                                            */
/* Warranty Disclaimer                                                        */
/*                                                                            */
/* There is no warranty of any kind whatsoever granted by Renesas. Any        */
/* warranty is expressly disclaimed and excluded by Renesas, either expressed */
/* or implied, including but not limited to those for non-infringement of     */
/* intellectual property, merchantability and/or fitness for the particular   */
/* purpose.                                                                   */
/*                                                                            */
/* Renesas shall not have any obligation to maintain, service or provide bug  */
/* fixes for the supplied Product(s) and/or the Application.                  */
/*                                                                            */
/* Each User is solely responsible for determining the appropriateness of     */
/* using the Product(s) and assumes all risks associated with its exercise    */
/* of rights under this Agreement, including, but not limited to the risks    */
/* and costs of program errors, compliance with applicable laws, damage to    */
/* or loss of data, programs or equipment, and unavailability or              */
/* interruption of operations.                                                */
/*                                                                            */
/* Limitation of Liability                                                    */
/*                                                                            */
/* In no event shall Renesas be liable to the User for any incidental,        */
/* consequential, indirect, or punitive damage (including but not limited     */
/* to lost profits) regardless of whether such liability is based on breach   */
/* of contract, tort, strict liability, breach of warranties, failure of      */
/* essential purpose or otherwise and even if advised of the possibility of   */
/* such damages. Renesas shall not be liable for any services or products     */
/* provided by third party vendors, developers or consultants identified or   */
/* referred to the User by Renesas in connection with the Product(s) and/or   */
/* the Application.                                                           */
/*                                                                            */
/*============================================================================*/
/* Environment:                                                               */
/*              Devices:        X2x                                           */
/*============================================================================*/

/*******************************************************************************
**                      Revision History                                      **
*******************************************************************************/
/*
 * 1.3.1: 01/04/2021    : Remove vendor ID from the file name, API names
 *                        and parameters according to BSW00347 requirement
 * 1.2.0: 13/07/2020    : Release
 * 1.1.0: 19/06/2020    : Release
 * 1.0.1: 04/06/2020    : Update adjust management infomation for EthSwt.
 * 1.0.0: 11/05/2020    : Initial Version.
 */
/******************************************************************************/

/*******************************************************************************
**                      Include Section                                       **
*******************************************************************************/

#include "EthIf_Cbk.h"
#include "Eth.h"
/*******************************************************************************
**                      Version Check                                         **
*******************************************************************************/
/* AUTOSAR release version information */
#define ETHIF_C_AR_RELEASE_MAJOR_VERSION   ETH_AR_RELEASE_MAJOR_VERSION_VALUE
#define ETHIF_C_AR_RELEASE_MINOR_VERSION   ETH_AR_RELEASE_MINOR_VERSION_VALUE
#define ETHIF_C_AR_RELEASE_REVISION_VERSION \
                                        ETH_AR_RELEASE_REVISION_VERSION_VALUE

/* File version information */
#define ETHIF_SW_MAJOR_VERSION    ETH_SW_MAJOR_VERSION
#define ETHIF_SW_MINOR_VERSION    ETH_SW_MINOR_VERSION

/*******************************************************************************
**                         Global Data                                        **
*******************************************************************************/

/*******************************************************************************
**                      Function Definitions                                  **
*******************************************************************************/
BufReq_ReturnType EthIf_ProvideTxBuffer(
  uint8 CtrlIdx, Eth_FrameType FrameType, uint8 Priority,
  Eth_BufIdxType* BufIdxPtr, uint8** BufPtr, uint16* LenBytePtr);

Std_ReturnType EthIf_Transmit(
  uint8 CtrlIdx, Eth_BufIdxType BufIdx, Eth_FrameType FrameType,
  boolean TxConfirmation, uint16 LenByte, const uint8* PhysAddrPtr);
/*******************************************************************************
**                             EthIf_ProvideTxBuffer                          **
*******************************************************************************/
BufReq_ReturnType EthIf_ProvideTxBuffer(
  uint8 CtrlIdx, Eth_FrameType FrameType, uint8 Priority,
  Eth_BufIdxType* BufIdxPtr, uint8** BufPtr, uint16* LenBytePtr)
{
  BufReq_ReturnType LenReturnValue;

  LenReturnValue = Eth_ProvideTxBuffer(CtrlIdx, Priority, BufIdxPtr, BufPtr, LenBytePtr);

  #if (ETH_ETHSWITCH_MANAGEMENT_SUPPORT == STD_ON)
  /* Adjust management infomation length */
  *LenBytePtr -= 2;
  #endif

  return LenReturnValue;
}


/*******************************************************************************
**                             EthIf_Transmit                                 **
*******************************************************************************/
Std_ReturnType EthIf_Transmit(
  uint8 CtrlIdx, Eth_BufIdxType BufIdx, Eth_FrameType FrameType,
  boolean TxConfirmation, uint16 LenByte, const uint8* PhysAddrPtr)
{
  Std_ReturnType LucReturnValue;

  #if (ETH_ETHSWITCH_MANAGEMENT_SUPPORT == STD_ON)
  /* Adjust management infomation */
  LenByte += 2;
  #endif

  LucReturnValue = Eth_Transmit(CtrlIdx, BufIdx, FrameType, TxConfirmation, LenByte, PhysAddrPtr);

  return LucReturnValue;
}

/*******************************************************************************
                          End of the file
*******************************************************************************/
