#include "Simulated_SPI_Master.h"
#include "Port_Cfg.h"
#include "Port.h"
#include "Dio.h"

SimSPIConfigStruct  SimSPIConfig;

/*时钟输出高*/
void MC33984EHFK_Clock_Output_High(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_12, STD_HIGH);
}
/*时钟输出低*/
void MC33984EHFK_Clock_Output_Low(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_12, STD_LOW);
}
/*时钟翻转*/
void MC33984EHFK_Clock_Output_Flip(void)
{
  Dio_FlipChannel(DioConf_DioChannel_P02_12);
}

/*MOSI输出高*/
void MC33984EHFK_MOSI_Output_High(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_13, STD_HIGH);
}
/*MOSI输出低*/
void MC33984EHFK_MOSI_Output_Low(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_13, STD_LOW);
}

/*CS1输出高*/
void MC33984EHFK_CS1_Output_High(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_14, STD_HIGH);
}
/*CS1输出低*/
void MC33984EHFK_CS1_Output_Low(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_14, STD_LOW);
}

/*CS2输出高*/
void MC33984EHFK_CS2_Output_High(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_03, STD_HIGH);
}
/*CS2输出低*/
void MC33984EHFK_CS2_Output_Low(void)
{
  Dio_WriteChannel(DioConf_DioChannel_P02_03, STD_LOW);  
}
/*MISO*/
/*Dio_ReadChannel(Port_Config_PortGroup22_PortPin11);*/

/******************************************************************************
��������SPI_Master_Start
��  �ܣ���ʼ��������SPI����ģʽ
��  ����Mode��SPI����ģʽ��         SIM_SPI_MODE_0
                                    SIM_SPI_MODE_1
                                    SIM_SPI_MODE_2
                                    SIM_SPI_MODE_3
                                    
        FirstBit�����ȷ��͵�����λ��SIM_SPI_MSB_FIRST
                                    SIM_SPI_LSB_FIRST
����ֵ����
******************************************************************************/
void Sim_SPI_Master_Start(uint8_t Mode, uint8_t FirstBit)
{
  switch (Mode)
  {
    case SIM_SPI_MODE_0 : SimSPIConfig.CPOL = 0;
                          SimSPIConfig.CPHA = 0;
                          break;
                          
    case SIM_SPI_MODE_1 : SimSPIConfig.CPOL = 0;
                          SimSPIConfig.CPHA = 1;
                          break;
                          
    case SIM_SPI_MODE_2 : SimSPIConfig.CPOL = 1;
                          SimSPIConfig.CPHA = 0;
                          break;
                          
    case SIM_SPI_MODE_3 : SimSPIConfig.CPOL = 1;
                          SimSPIConfig.CPHA = 1;
                          break;
                          
    default             : SimSPIConfig.CPOL = 0;
                          SimSPIConfig.CPHA = 0;
                          break;                          
  }
  SimSPIConfig.FirstBit = FirstBit;
    
  // SPI_SCLK = SimSPIConfig.CPOL;
  Dio_WriteChannel(DioConf_DioChannel_P02_12, SimSPIConfig.CPOL);
  
  MC33984EHFK_MOSI_Output_Low();
}

/******************************************************************************
��������Sim_SPI_Master_Byte_Write
��  �ܣ���SPI������дһ�ֽ�
��  ����Data:Ҫд�������
����ֵ����
******************************************************************************/
void Sim_SPI_Master_Byte_Write(uint8_t Data)
{
  uint8_t BitPos;
  
  if (SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST)
  {
    for (BitPos = 0x80; BitPos >= 0x01; BitPos >>= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
    }
  }
  else
  {
    for (BitPos = 0x01; BitPos <= 0x80; BitPos <<= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
    }
  }
}

  uint8_t BitPosfsfds;
/******************************************************************************
��������Sim_SPI_Master_Byte_Read
��  �ܣ���SPI�����϶�ȡһ�ֽ�����
��  ����TxData���ڶ�ȡ��ͬʱд�������
����ֵ������������
******************************************************************************/
uint8_t Sim_SPI_Master_Byte_Read(uint8_t TxData)
{
  uint8_t RxData;
  uint8_t BitPos;
  RxData = 0x00;
  // BitPosfsfds=Dio_ReadChannel(Port_Config_PortGroup2_PortPin11);

  if (SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST)
  {
    for (BitPos = 0x80; BitPos >= 0x01; BitPos >>= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      else
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
    }
  }
  else
  {
    for (BitPos = 0x01; BitPos <= 0x80; BitPos <<= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      else
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
    }
  }

  return RxData;
}

/******************************************************************************
��������Sim_SPI_Master_Word_Write
��  �ܣ���SPI������дһ����(16bit)������
��  ����Data:Ҫд�������
����ֵ����
******************************************************************************/
void Sim_SPI_Master_Word_Write(uint16_t Data)
{
  uint16_t BitPos;
  
  if (SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST)
  {
    for (BitPos = 0x8000; BitPos >= 0x0001; BitPos >>= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
    }
  }
  else
  {
    for (BitPos = 0x0001; BitPos <= 0x8000; BitPos <<= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (Data & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
    }
  }
}

/******************************************************************************
��������Sim_SPI_Master_Word_Read
��  �ܣ���SPI�����϶�ȡһ����(16bit)������
��  ����TxData���ڶ�ȡ��ͬʱд�������
����ֵ������������
******************************************************************************/
uint16_t Sim_SPI_Master_Word_Read(uint16_t TxData)
{
  uint16_t RxData;
  uint16_t BitPos;
  
  RxData = 0x00;

  if (SimSPIConfig.FirstBit == SIM_SPI_MSB_FIRST)
  {
    for (BitPos = 0x8000; BitPos >= 0x0001; BitPos >>= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      else
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
    }
  }
  else
  {
    for (BitPos = 0x0001; BitPos <= 0x8000; BitPos <<= 1)
    {
      if (SimSPIConfig.CPHA == 0)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        if (TxData & BitPos)
          MC33984EHFK_MOSI_Output_High();
        else
          MC33984EHFK_MOSI_Output_Low();
        
        NOP();
        NOP();
        NOP();
      }
      else
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
      
      NOP();
      MC33984EHFK_Clock_Output_Flip();
      
      if (SimSPIConfig.CPHA)
      {
        NOP();
        NOP();
        NOP();
        
        if (Dio_ReadChannel(Port_Config_PortGroup2_PortPin11))
          RxData |= BitPos;
      }
    }
  }

  return RxData;
}
