/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Icu_TAU_PBTypes.h                                                                                   */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains macros and structure data types for post build parameters of TAU Timer IP                       */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3:  14/05/2022  : Change type of pTAUD3INTNOSELxReg from uint16 to uint32
 *                       Change ICU_TAUD3_INTERRUPT_SELECTION_USED to ICU_TAUD3_UNIT_USED
 *         17/04/2022  : Merge QAC message from U2Ax, E2x and U2Bx
 *         13/04/2022  : Update struct Icu_TAUChannelConfigType, add pTAUJCNTAddress and update pCNTAddress pointer 
 *                       type from uint32 to uint16
 * 1.4.1:  15/09/2021  : Rename Icu_TAUTimerChannelConfigType to Icu_TAUChannelUserRegConfigType
 *                       Rename Icu_GaaTAUTimerChannelConfig to Icu_GaaTAUChannelUserRegConfig
 *                       Remove Icu_GaaTAUChannelRamData, Icu_GaaTAUSignalMeasureRamData, Icu_UserModeSettingType,
 *                          STag_Icu_TAUChannelRamDataType, STag_Icu_TAUSignalMeasurementModeRamDataType
 * 1.3.2:  30/08/2021  : Change from #include "Icu_MemMap.h" to #include "Icu_Mapping.h".
 *                       Update header file macro.
 * 1.3.1:  02/07/2021  : Add QAC message 9.5.0
 *                       Format source code to 120 characters
 *                       Improve Violation tag (remove START/END)
 * 1.2.0:  17/07/2020  : Release
 * 1.1.0:  19/06/2020  : Release
 * 1.0.0:  25/03/2020  : Initial Version
 */
/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/
/* Message (2:3684)    : Array declared with unknown size.                                                            */
/* Rule                : CERTCCM ARR02, MISRA C:2012 Rule-8.11                                                        */
/* JV-01 Justification : Arrays used are verified in the file which are only declarations and size is configuration   */
/*                       dependent.                                                                                   */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/

/**********************************************************************************************************************/
#ifdef ICU_INSTANCE_INDEX
    #if (ICU_INSTANCE_INDEX == 0)
        #ifndef ICU_59_INST0_TAU_PBTYPES_H
            #define ICU_59_INST0_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 1)
        #ifndef ICU_59_INST1_TAU_PBTYPES_H
            #define ICU_59_INST1_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 2)
        #ifndef ICU_59_INST2_TAU_PBTYPES_H
            #define ICU_59_INST2_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 3)
        #ifndef ICU_59_INST3_TAU_PBTYPES_H
            #define ICU_59_INST3_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 4)
        #ifndef ICU_59_INST4_TAU_PBTYPES_H
            #define ICU_59_INST4_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 5)
        #ifndef ICU_59_INST5_TAU_PBTYPES_H
            #define ICU_59_INST5_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 6)
        #ifndef ICU_59_INST6_TAU_PBTYPES_H
            #define ICU_59_INST6_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #elif (ICU_INSTANCE_INDEX == 7)
        #ifndef ICU_59_INST7_TAU_PBTYPES_H
            #define ICU_59_INST7_TAU_PBTYPES_H
            #define ICU_TAU_PBTYPES_HEADER
        #endif
    #else
        #error "Missing instance index"
    #endif
#else
    #ifndef ICU_TAU_PBTYPES_H
        #define ICU_TAU_PBTYPES_H
        #define ICU_TAU_PBTYPES_HEADER
    #endif
#endif

#ifdef ICU_TAU_PBTYPES_HEADER
#undef ICU_TAU_PBTYPES_HEADER                                                                                           /* PRQA S 0841 # JV-01 */

/***********************************************************************************************************************
**                                                  Include Section                                                   **
***********************************************************************************************************************/
/* Included for Macro definitions */
#include "Icu.h"
/* Included for data type declaration */
#include "rh850_Types.h"
/* To avoid QAC error */

/***********************************************************************************************************************
**                                                Version Information                                                 **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                                 Global Data Types                                                  **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                                     Structure for TAU Unit configuration type                                      **
***********************************************************************************************************************/
typedef struct STag_Icu_TAUUnitConfigType
{
  /* void pointer to base address of Timer Array Unit user control register */
  P2VAR(volatile uint8, TYPEDEF, REGSPACE) pTAUnitUserCntlRegs;
  /* void pointer to base address of Timer Array Unit os control register */
  P2VAR(volatile uint8, TYPEDEF, REGSPACE) pTAUnitOsCntlRegs;

  #if (ICU_PRESCALER_CONFIGURED == STD_ON)
  /* TAU Unit prescaler for clock sources CK0, CK1, CK2, CK3 */
  uint16 usPrescaler;
  #endif
  /* TAUnit type
   * ICU_HW_TAUD - 1
   * ICU_HW_TAUJ - 2
   */
  uint8 ucIcuUnitType;
  /* Mask value for all channels in a TAU */
  uint16 usTAUChannelMaskValue;
  #if (ICU_PRESCALER_CONFIGURED == STD_ON)
  #if ((ICU_TAUD_UNIT_CONFIG == STD_ON) || (ICU_TAUJ_UNIT_CONFIG == STD_ON))
  /* TAU Unit baudrate value for CK3 */
  uint8 ucBaudRate;
  #endif
  /* Prescaler shared between PWM/GPT/ICU modules
   * 1: Prescaler for CK0 - CK3 has to be set by ICU
   * 0: Prescaler for CK0 - CK3 need not be set by ICU
   */
  uint8 ucConfigurePrescaler;
  #endif
} Icu_TAUUnitConfigType;

/***********************************************************************************************************************
**                                Structure for ICU Channel User Register information                                 **
***********************************************************************************************************************/
typedef struct STag_Icu_TAUChannelUserRegConfigType
{
  /* pointer to base address of CMOR register */
  P2VAR(volatile uint16, TYPEDEF, REGSPACE) pCMORReg;
  /*
   * Bits 15-14: 00: Selects the operation clock CK0
   *             01: Selects the operation clock CK1
   *             10: Selects the operation clock CK2
   *             11: Selects the operation clock CK3
   *
   * Bits 13-12: 00: Selects the prescaler output signal (ICU_MODE_SIGNAL_MEASUREMENT) / (ICU_MODE_TIMESTAMP)
   *             01: Selects TINn input valid edge detection signal (ICU_MODE_EDGE_COUNTER)
   *
   * Bit 11    :  0: Independent Channel operation functions
   *
   * Bits 10-8 : 000: Selects software start trigger (ICU_MODE_EDGE_COUNTER)
   *             001: Selects the TINn input valid edge detection signal (ICU_MODE_SIGNAL_MEASUREMENT)(ICU_PERIOD_TIME)
   *                  / (ICU_MODE_TIMESTAMP)
   *
   *             010: Selects the TINn input valid edge detection signal as the start signal and the reverse edge 
   *                  detection signal as the stop signal. (ICU_MODE_SIGNAL_MEASUREMENT)(ICU_HIGH_TIME, ICU_LOW_TIME)
   *
   * Bits 7-6  :  00: Not used  (ICU_MODE_EDGE_COUNTER)
   *
   *              01: Sets OVF when the counter reaches FFFFH, clears OVF when CSCn:CLOV = 1
   *                  Captures the counter value upon detection of a TINn input valid edge.
   *                  (ICU_MODE_SIGNAL_MEASUREMENT) (ICU_PERIOD_TIME)
   *                  (ICU_HIGH_TIME, ICU_LOW_TIME), (ICU_MODE_TIMESTAMP)
   *
   * Bits 4-1  :0010: Sets the Capture mode.
   *                   (ICU_MODE_SIGNAL_MEASUREMENT) (ICU_PERIOD_TIME)
   *
   *            0011: Event Count Mode (ICU_MODE_EDGE_COUNTER)
   *
   *            0110: Sets the Capture & One Count mode (ICU_MODE_SIGNAL_MEASUREMENT)(ICU_HIGH_TIME, ICU_LOW_TIME)
   *
   *            1011: Sets the Count Capture mode (ICU_MODE_TIMESTAMP)
   *
   * Bit 0     :  0: Neither output INTn nor toggles TOUTn at operation startup
   *              1: Outputs INTn at operation startup
   */
  uint16 usChannelModeOSRegSettings;
  /* Individual channel mask value for channel mode user register */
  uint8 ucChannelModeUserRegSettings;
  /* Index of Timer Unit in the Array Icu_GaaTAUUnitConfig */
  uint8 ucTimerUnitIndex;
  /* TAUD3 interrupt selection */
  #if (ICU_TAUD3_UNIT_USED == STD_ON)
  /* Pointer to base address of TAUD3INTNOSELx register */
  P2VAR(volatile uint32, TYPEDEF, REGSPACE) pTAUD3INTNOSELxReg;
  /* Mask value for channel in TAUD3 configured to support selection interrupt number */
  uint32 ulTAUD3SelectInterruptMask;
  #endif
} Icu_TAUChannelUserRegConfigType;

/***********************************************************************************************************************
**                                       Structure for TAU Channel information                                        **
***********************************************************************************************************************/
typedef struct STag_Icu_TAUChannelConfigType
{
  #if (ICU_GET_TAU_COUNT_VALUE_API == STD_ON)
  /* Pointer to base address of channel Counter register "TAUJnCNTm" */
  P2VAR(volatile uint32, TYPEDEF, REGSPACE) pTAUJCNTAddress;
  /* Pointer to base address of channel Counter register "TAUDnCNTm" */
  P2VAR(volatile uint16, TYPEDEF, REGSPACE) pCNTAddress;
  #else
  uint8 ucDummy;
  #endif
} Icu_TAUChannelConfigType;

/***********************************************************************************************************************
**                                           Global configuration constants                                           **
***********************************************************************************************************************/
#define ICU_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_Mapping.h"
/* Declaration for ICU Channel Configuration */
extern CONST(Icu_TAUChannelUserRegConfigType, ICU_CONFIG_DATA) Icu_GaaTAUChannelUserRegConfig[];                        /* PRQA S 3684 # JV-01 */
/* Array of structures for Hardware Configuration */
extern CONST(Icu_TAUUnitConfigType, ICU_CONFIG_DATA) Icu_GaaTAUUnitConfig[];                                            /* PRQA S 3684 # JV-01 */
/* Declaration for Icu_TAUChannelConfigType */
#if (ICU_TAU_UNIT_USED == STD_ON)
extern CONST(Icu_TAUChannelConfigType, ICU_CONFIG_DATA) Icu_GaaTAUChannelConfig[];                                      /* PRQA S 3684 # JV-01 */
#endif

#define ICU_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Icu_Mapping.h"

/***********************************************************************************************************************
**                                                Function Prototypes                                                 **
***********************************************************************************************************************/

#endif /* ICU_TAU_PBTYPES_HEADER  */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
