/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Can_PBcfg.c                                                                                         */
/*====================================================================================================================*/
/*                                  COPYRIGHT                                                                         */
/*====================================================================================================================*/
/* (c) 2022 Renesas Electronics Corporation. All rights reserved.                                                     */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file contains post-build time parameters.                                                                     */
/* AUTOMATICALLY GENERATED FILE - DO NOT EDIT                                                                         */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s)        */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        R7F702301BFABG                                                                        */
/*====================================================================================================================*/


/***********************************************************************************************************************
**                      Revision Control History                                                                      **
***********************************************************************************************************************/



/***********************************************************************************************************************
**                      Generation Tool Version                                                                       **
***********************************************************************************************************************/
/*                                                                                                                    */
/* TOOL VERSION:  CanU2x.dll version: 1.5.0, MCALConfGen.exe version: 1.4.0                                           */
/*                                                                                                                    */


/***********************************************************************************************************************
**                      Input File                                                                                    **
***********************************************************************************************************************/
/*
 * INPUT FILE:    D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Can_Can_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Config\ECUC\test_Mcu_Mcu_ecuc.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\generator\BSWMDT\R431_CAN_U2A8_BSWMDT.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Dem\xml\Dem_Can.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\Os\xml\Os_Can.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\EcuM\xml\EcuM_Can.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\stubs\CanIf\xml\CanIf.arxml
 *                D:\sharedir\Test_MCAL_U2A8_292_43.03_240129_canfd\Test_MCAL_U2A8_292_43.03_240129\Config\Config292\Translation.trxml
 * GENERATED ON:  27 Apr 2025 - 14:14:03
 */


/***********************************************************************************************************************
**                      Instance Index                                                                                **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Include Section                                                                               **
***********************************************************************************************************************/
/* CAN Post Build configuration header */
#include "Can.h"
#include "Can_PBTypes.h"
#include "Can_LTTypes.h"


/***********************************************************************************************************************
**                      Coding Rule Violations                                                                        **
***********************************************************************************************************************/
/* Message (2:0315)    : Implicit conversion from a pointer to object type to a pointer to void.                      */
/*                       REFERENCE - ISO:C90-6.3.4 Cast Operators - Semantics                                         */
/* Rule                : MISRA C:2012 Dir1.1                                                                          */
/* JV-01 Justification : Void pointer is used in order to typecast to different channel structures later.             */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/
/* Message (4:5087)    : #include directives should only be preceded by preprocessor directives or comments           */
/* Rule                : MISRA C:2012 Rule 20.1                                                                       */
/* JV-01 Justification : This is done as per Memory Requirement, (MEMMAP003 - Specification of Memory Mapping).       */
/*       Verification  : However, part of the code is verified manually and it is not having any impact.              */
/**********************************************************************************************************************/


/***********************************************************************************************************************
**                      Version Information                                                                           **
***********************************************************************************************************************/
#define CAN_PBCFG_C_AR_RELEASE_MAJOR_VERSION                                    4U
#define CAN_PBCFG_C_AR_RELEASE_MINOR_VERSION                                    3U
#define CAN_PBCFG_C_AR_RELEASE_REVISION_VERSION                                 1U
#define CAN_PBCFG_C_SW_MAJOR_VERSION                                            1U
#define CAN_PBCFG_C_SW_MINOR_VERSION                                            5U

/***********************************************************************************************************************
**                      Version Check                                                                                 **
***********************************************************************************************************************/
#if (CAN_PBTYPES_AR_RELEASE_MAJOR_VERSION != CAN_PBCFG_C_AR_RELEASE_MAJOR_VERSION)
 #error "Can_PBcfg.c : Mismatch in Release Major Version"
#endif

#if (CAN_PBTYPES_AR_RELEASE_MINOR_VERSION != CAN_PBCFG_C_AR_RELEASE_MINOR_VERSION)
 #error "Can_PBcfg.c : Mismatch in Release Minor Version"
#endif

#if (CAN_PBTYPES_AR_RELEASE_REVISION_VERSION != CAN_PBCFG_C_AR_RELEASE_REVISION_VERSION)
 #error "Can_PBcfg.c : Mismatch in Release Revision Version"
#endif

#if (CAN_PBTYPES_SW_MAJOR_VERSION != CAN_PBCFG_C_SW_MAJOR_VERSION)
  #error "Can_PBcfg.c : Mismatch in Software Major Version"
#endif

#if (CAN_PBTYPES_SW_MINOR_VERSION != CAN_PBCFG_C_SW_MINOR_VERSION)
  #error "Can_PBcfg.c : Mismatch in Software Minor Version"
#endif


/***********************************************************************************************************************
**                      Global Data Types                                                                             **
***********************************************************************************************************************/
#define CAN_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Can_MemMap.h"



static CONST(uint32, CAN_CONFIG_DATA) Can_GaaGAFLCFGConfig00[] =
{
  /* Index 0 */
  0x00000000UL,

  /* Index 1 */
  0x00000001UL,

  /* Index 2 */
  0x00000000UL,

  /* Index 3 */
  0x00000000UL
};
static CONST(uint32, CAN_CONFIG_DATA) Can_GaaGAFLCFGConfig01[] =
{
  /* Index 0 */
  0x00010000UL,

  /* Index 1 */
  0x00000000UL,

  /* Index 2 */
  0x00000000UL,

  /* Index 3 */
  0x00000000UL
};
static CONST(uint32, CAN_CONFIG_DATA) Can_GaaTMIEConfig00[] =
{
  /* Index 0 */
  0x00000000UL,

  /* Index 1 */
  0x00000000UL,

  /* Index 2 */
  0x00000000UL,

  /* Index 3 */
  0x00000000UL,

  /* Index 4 */
  0x00000000UL,

  /* Index 5 */
  0x00000000UL,

  /* Index 6 */
  0x00000001UL,

  /* Index 7 */
  0x00000000UL,

  /* Index 8 */
  0x00000000UL,

  /* Index 9 */
  0x00000000UL,

  /* Index 10 */
  0x00000000UL,

  /* Index 11 */
  0x00000000UL,

  /* Index 12 */
  0x00000000UL,

  /* Index 13 */
  0x00000000UL,

  /* Index 14 */
  0x00000000UL,

  /* Index 15 */
  0x00000000UL
};
static CONST(uint32, CAN_CONFIG_DATA) Can_GaaTMIEConfig01[] =
{
  /* Index 0 */
  0x00000001UL,

  /* Index 1 */
  0x00000000UL,

  /* Index 2 */
  0x00000000UL,

  /* Index 3 */
  0x00000000UL,

  /* Index 4 */
  0x00000000UL,

  /* Index 5 */
  0x00000000UL,

  /* Index 6 */
  0x00000000UL,

  /* Index 7 */
  0x00000000UL,

  /* Index 8 */
  0x00000000UL,

  /* Index 9 */
  0x00000000UL,

  /* Index 10 */
  0x00000000UL,

  /* Index 11 */
  0x00000000UL,

  /* Index 12 */
  0x00000000UL,

  /* Index 13 */
  0x00000000UL,

  /* Index 14 */
  0x00000000UL,

  /* Index 15 */
  0x00000000UL
};
#define CAN_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Can_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */

#define CAN_START_SEC_DBTOC_DATA_UNSPECIFIED
#include "Can_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */


/* Array for Baudrate Configuration */
STATIC CONST(Can_BaudrateConfigType, CAN_CONFIG_DATA) Can_GaaBaudrateConfig00[] =
{
  /* Index: 0 - CanControllerBaudrateConfig */
  {
    /* usBaudrateConfigID */
    0x0000U,

    /* ulCFG */
    CAN_RSCAN_NSJW(8) | CAN_RSCAN_NTSEG1(31) | CAN_RSCAN_NTSEG2(8) | CAN_RSCAN_NBRP(3),

    /* ulDCFG */
    CAN_RSCAN_SJW(2) | CAN_RSCAN_TSEG1(7) | CAN_RSCAN_TSEG2(2) | CAN_RSCAN_BRP(3),

    /* ulFDCFG */
    0UL,

    /* blBRS */
    CAN_TRUE,

    /* blFdConfigured */
    CAN_TRUE
  }
};

STATIC CONST(Can_BaudrateConfigType, CAN_CONFIG_DATA) Can_GaaBaudrateConfig01[] =
{
  /* Index: 0 - CanControllerBaudrateConfig0 */
  {
    /* usBaudrateConfigID */
    0x0000U,

    /* ulCFG */
    CAN_RSCAN_NSJW(1) | CAN_RSCAN_NTSEG1(13) | CAN_RSCAN_NTSEG2(6) | CAN_RSCAN_NBRP(15),

    /* ulDCFG */
    CAN_RSCAN_SJW(1) | CAN_RSCAN_TSEG1(13) | CAN_RSCAN_TSEG2(6) | CAN_RSCAN_BRP(15),

    /* ulFDCFG */
    0UL,

    /* blBRS */
    CAN_FALSE,

    /* blFdConfigured */
    CAN_FALSE
  },
  /* Index: 1 - CanControllerBaudrateConfig1 */
  {
    /* usBaudrateConfigID */
    0x0001U,

    /* ulCFG */
    CAN_RSCAN_NSJW(1) | CAN_RSCAN_NTSEG1(13) | CAN_RSCAN_NTSEG2(6) | CAN_RSCAN_NBRP(7),

    /* ulDCFG */
    CAN_RSCAN_SJW(1) | CAN_RSCAN_TSEG1(13) | CAN_RSCAN_TSEG2(6) | CAN_RSCAN_BRP(7),

    /* ulFDCFG */
    0UL,

    /* blBRS */
    CAN_FALSE,

    /* blFdConfigured */
    CAN_FALSE
  }
};

STATIC CONST(Can_BaudrateConfigType, CAN_CONFIG_DATA) Can_GaaBaudrateConfig02[] =
{
  /* Index: 0 - CanControllerBaudrateConfig */
  {
    /* usBaudrateConfigID */
    0x0000U,

    /* ulCFG */
    CAN_RSCAN_NSJW(8) | CAN_RSCAN_NTSEG1(31) | CAN_RSCAN_NTSEG2(8) | CAN_RSCAN_NBRP(3),

    /* ulDCFG */
    CAN_RSCAN_SJW(2) | CAN_RSCAN_TSEG1(7) | CAN_RSCAN_TSEG2(2) | CAN_RSCAN_BRP(3),

    /* ulFDCFG */
    0UL,

    /* blBRS */
    CAN_TRUE,

    /* blFdConfigured */
    CAN_TRUE
  }
};

/* Array for Controller Configuration (Post-build time) */
STATIC CONST(Can_ControllerPBConfigType, CAN_CONFIG_DATA) Can_GaaControllerPBConfig0[] =
{
  /* Index: 0 - CanController0 */
  {
    /* ucMainFunctionWIndex */
    0U,

    /* usNoOfBaudrate */
    0x0001U,

    /* pBaudrateConfig */
    &Can_GaaBaudrateConfig00[0]
  },
  /* Index: 1 - CanController1 */
  {
    /* ucMainFunctionWIndex */
    0U,

    /* usNoOfBaudrate */
    0x0002U,

    /* pBaudrateConfig */
    &Can_GaaBaudrateConfig01[0]
  },
  /* Index: 2 - Can2 */
  {
    /* ucMainFunctionWIndex */
    0U,

    /* usNoOfBaudrate */
    0x0001U,

    /* pBaudrateConfig */
    &Can_GaaBaudrateConfig02[0]
  }
};

/* Array for Hardware Object Handle */
STATIC CONST(Can_HohConfigType, CAN_CONFIG_DATA) Can_GaaHohConfig0[] =
{
  /* Index: 0 - CanHardwareObject0 -> TXRXBUFFER(RX)[9] */
  {
    /* enHoh */
    CAN_HOH_HRH,

    /* ucMainFunctionRIndex */
    0U,

    /* ucController */
    0x00U,

    /* ucTMDLC */
    0x00U,

    /* usHohId */
    0x0000U,

    /* enBufferType */
    CAN_BUFFERTYPE_TXRXFIFO,

    /* usBufferIndex */
    0x0009U,

    /* ucPaddingValue */
    0x00U,

    /* ulXXCCRegValue */
    CAN_RSCAN_CFM_RX | CAN_RSCAN_CFIM | CAN_RSCAN_CFRXIE | CAN_RSCAN_CFDC_16 | CAN_RSCAN_CFPLS_8,

    /* ulXXCCERegValue */
    0UL,

    /* blObjectUsesPolling */
    CAN_FALSE
  },
  /* Index: 1 - CanHardwareObject1 -> TXRXBUFFER(RX)[0] */
  {
    /* enHoh */
    CAN_HOH_HRH,

    /* ucMainFunctionRIndex */
    0U,

    /* ucController */
    0x01U,

    /* ucTMDLC */
    0x00U,

    /* usHohId */
    0x0001U,

    /* enBufferType */
    CAN_BUFFERTYPE_TXRXFIFO,

    /* usBufferIndex */
    0x0000U,

    /* ucPaddingValue */
    0x00U,

    /* ulXXCCRegValue */
    CAN_RSCAN_CFM_RX | CAN_RSCAN_CFIM | CAN_RSCAN_CFRXIE | CAN_RSCAN_CFDC_4 | CAN_RSCAN_CFPLS_8,

    /* ulXXCCERegValue */
    0UL,

    /* blObjectUsesPolling */
    CAN_FALSE
  },
  /* Index: 2 - CanHardwareObject2 -> TXBUFFER[192] */
  {
    /* enHoh */
    CAN_HOH_HTH,

    /* ucMainFunctionRIndex */
    0U,

    /* ucController */
    0x00U,

    /* ucTMDLC */
    0x40U,

    /* usHohId */
    0x0002U,

    /* enBufferType */
    CAN_BUFFERTYPE_BUFFER,

    /* usBufferIndex */
    0x00C0U,

    /* ucPaddingValue */
    0x00U,

    /* ulXXCCRegValue */
    0UL,

    /* ulXXCCERegValue */
    0UL,

    /* blObjectUsesPolling */
    CAN_FALSE
  },
  /* Index: 3 - CanHardwareObject3 -> TXBUFFER[0] */
  {
    /* enHoh */
    CAN_HOH_HTH,

    /* ucMainFunctionRIndex */
    0U,

    /* ucController */
    0x01U,

    /* ucTMDLC */
    0x40U,

    /* usHohId */
    0x0003U,

    /* enBufferType */
    CAN_BUFFERTYPE_BUFFER,

    /* usBufferIndex */
    0x0000U,

    /* ucPaddingValue */
    0x00U,

    /* ulXXCCRegValue */
    0UL,

    /* ulXXCCERegValue */
    0UL,

    /* blObjectUsesPolling */
    CAN_FALSE
  }
};

/* Array for Acceptance Filter Receive Rule Configuration */
STATIC CONST(Can_FilterType, CAN_CONFIG_DATA) Can_GaaFilterConfig0[] =
{
  /* Index: 0 - CanHardwareObject0/CanHwFilter: RSCANFD03 -> TXRXFIFO[9] */
  {
    /* ulGAFLID */
    0x00000100UL,

    /* ulGAFLM */
    0xC0000000UL,

    /* aaGAFLP */
    { CAN_RSCAN_GAFLDLC_0, CAN_RSCAN_GAFLFDP_TXRXFIFO(9) }
  },
  /* Index: 1 - CanHardwareObject1/CanHwFilter: RSCANFD10 -> TXRXFIFO[0] */
  {
    /* ulGAFLID */
    0x00000065UL,

    /* ulGAFLM */
    0xC0000000UL,

    /* aaGAFLP */
    { CAN_RSCAN_GAFLDLC_0, CAN_RSCAN_GAFLFDP_TXRXFIFO(0) }
  }
};

/* Array for Can Hardware Configuration Table */
STATIC CONST(Can_HWUnitInfoType, CAN_CONFIG_DATA) Can_GaaHWUnitInfo0[] =
{
  /* Index: 0 - Registers for RSCAN unit 0 */
  {
    /* ucNoOfTMIEC */
    0x10U,

    /* ucNoOfGAFLCFG */
    0x04U,

    /* usNoOfFilters */
    0x0001U,

    /* ulRMNB */
    0x00000000UL,

    /* ulGCFG */
    CAN_RSCAN_ITRCP(8) | CAN_RSCAN_DCE,

    /* pGAFLCFG */
    &Can_GaaGAFLCFGConfig00[0],

    /* pTMIEC */
    &Can_GaaTMIEConfig00[0],

    /* pFilterConfig */
    &Can_GaaFilterConfig0[0]
  },
  /* Index: 1 - Registers for RSCAN unit 1 */
  {
    /* ucNoOfTMIEC */
    0x10U,

    /* ucNoOfGAFLCFG */
    0x04U,

    /* usNoOfFilters */
    0x0001U,

    /* ulRMNB */
    0x00000000UL,

    /* ulGCFG */
    CAN_RSCAN_ITRCP(8) | CAN_RSCAN_DCE,

    /* pGAFLCFG */
    &Can_GaaGAFLCFGConfig01[0],

    /* pTMIEC */
    &Can_GaaTMIEConfig01[0],

    /* pFilterConfig */
    &Can_GaaFilterConfig0[1]
  }
};

/* Global array for Config Structure */
CONST(Can_ConfigType, CAN_CONFIG_DATA) Can_GaaConfig[] =
{
  /* Index: 0 - CanConfigSet0 */
  {
    /* ulStartOfDbToc */
    0x0ED40128UL,

    /* ucNoOfUnits */
    0x02U,

    /* ucNoOfControllers */
    0x03U,

    /* usNoOfHohs */
    0x0004U,

    /* pHWUnitInfo */
    &Can_GaaHWUnitInfo0[0],                                                                                             /* PRQA S 0315 # JV-01 */

    /* pControllerPCConfig */
    &Can_GaaControllerPCConfig0[0],                                                                                     /* PRQA S 0315 # JV-01 */

    /* pControllerPBConfig */
    &Can_GaaControllerPBConfig0[0],                                                                                     /* PRQA S 0315 # JV-01 */

    /* pHohConfig */
    &Can_GaaHohConfig0[0],                                                                                              /* PRQA S 0315 # JV-01 */

    /* pPhysicalControllerToIndex */
    &Can_GaaPhysicalControllerToIndex0[0]
  }
};

#define CAN_STOP_SEC_DBTOC_DATA_UNSPECIFIED
#include "Can_MemMap.h"                                                                                                 /* PRQA S 5087 # JV-01 */



/***********************************************************************************************************************
**                      Global Data                                                                                   **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      Function Definitions                                                                          **
***********************************************************************************************************************/

/***********************************************************************************************************************
**                      End of File                                                                                   **
***********************************************************************************************************************/

