/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Adc_Mapping.h                                                                                       */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2021,2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* Provision of API and database declaration, Service Id and DET error Macros                                         */
/* and Module version information Macros.                                                                             */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.5: 12/09/2022 : Removed the memory section CONST_32.
 * 1.4.3: 15/04/2022 : Added the memory section CONFIG_DATA_PTR.
 *                     Remove the memory section VAR_NO_INIT_32.
 * 1.4.1: 24/11/2021 : Added support of instance 4.
 * 1.3.2: 06/09/2021 : Initial Version
 */
/**********************************************************************************************************************/

#ifdef ADC_INSTANCE_INDEX
  #if (ADC_INSTANCE_INDEX == 0)
    #if defined(ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST0_START_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_VAR_NO_INIT_PTR)
      #undef ADC_START_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST0_START_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_PTR)
      #undef ADC_STOP_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST0_STOP_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST0_STOP_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_DBTOC_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_DBTOC_DATA_UNSPECIFIED
      #define ADC_59_INST0_START_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED)
      #define ADC_59_INST0_STOP_SEC_DBTOC_DATA_UNSPECIFIED
      #undef ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_PUBLIC_CODE)
      #undef ADC_START_SEC_PUBLIC_CODE
      #define ADC_59_INST0_START_SEC_PUBLIC_CODE

    #elif defined(ADC_STOP_SEC_PUBLIC_CODE)
      #undef ADC_STOP_SEC_PUBLIC_CODE
      #define ADC_59_INST0_STOP_SEC_PUBLIC_CODE

    #elif defined(ADC_START_SEC_CODE_FAST)
      #undef ADC_START_SEC_CODE_FAST
      #define ADC_59_INST0_START_SEC_CODE_FAST

    #elif defined(ADC_STOP_SEC_CODE_FAST)
      #undef ADC_STOP_SEC_CODE_FAST
      #define ADC_59_INST0_STOP_SEC_CODE_FAST

    #elif defined(ADC_START_SEC_PRIVATE_CODE)
      #undef ADC_START_SEC_PRIVATE_CODE
      #define ADC_59_INST0_START_SEC_PRIVATE_CODE

    #elif defined(ADC_STOP_SEC_PRIVATE_CODE)
      #undef ADC_STOP_SEC_PRIVATE_CODE
      #define ADC_59_INST0_STOP_SEC_PRIVATE_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_32)
      #undef ADC_START_SEC_CONFIG_DATA_32
      #define ADC_59_INST0_START_SEC_CONFIG_DATA_32

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_32)
      #undef ADC_STOP_SEC_CONFIG_DATA_32
      #define ADC_59_INST0_STOP_SEC_CONFIG_DATA_32

    #elif defined(ADC_START_SEC_CONFIG_DATA_8)
      #undef ADC_START_SEC_CONFIG_DATA_8
      #define ADC_59_INST0_START_SEC_CONFIG_DATA_8

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_8)
      #undef ADC_STOP_SEC_CONFIG_DATA_8
      #define ADC_59_INST0_STOP_SEC_CONFIG_DATA_8

    #elif defined(ADC_START_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST0_START_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST0_STOP_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_CONFIG_DATA_PTR)
      #undef ADC_START_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST0_START_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_PTR)
      #undef ADC_STOP_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST0_STOP_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_START_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST0_START_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST0_STOP_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_VAR_NO_INIT_8)
      #undef ADC_START_SEC_VAR_NO_INIT_8
      #define ADC_59_INST0_START_SEC_VAR_NO_INIT_8

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_8)
      #undef ADC_STOP_SEC_VAR_NO_INIT_8
      #define ADC_59_INST0_STOP_SEC_VAR_NO_INIT_8

    #elif defined(ADC_START_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST0_START_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST0_STOP_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_APPL_CODE)
      #undef ADC_START_SEC_APPL_CODE
      #define ADC_59_INST0_START_SEC_APPL_CODE

    #elif defined(ADC_STOP_SEC_APPL_CODE)
      #undef ADC_STOP_SEC_APPL_CODE
      #define ADC_59_INST0_STOP_SEC_APPL_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_16)
      #undef ADC_START_SEC_CONFIG_DATA_16
      #define ADC_59_INST0_START_SEC_CONFIG_DATA_16

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_16)
      #undef ADC_STOP_SEC_CONFIG_DATA_16
      #define ADC_59_INST0_STOP_SEC_CONFIG_DATA_16

    #else
      #error "No valid section"
    #endif
  #elif (ADC_INSTANCE_INDEX == 1)
    #if defined(ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST1_START_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_VAR_NO_INIT_PTR)
      #undef ADC_START_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST1_START_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_PTR)
      #undef ADC_STOP_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST1_STOP_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST1_STOP_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_DBTOC_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_DBTOC_DATA_UNSPECIFIED
      #define ADC_59_INST1_START_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED)
      #define ADC_59_INST1_STOP_SEC_DBTOC_DATA_UNSPECIFIED
      #undef ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_PUBLIC_CODE)
      #undef ADC_START_SEC_PUBLIC_CODE
      #define ADC_59_INST1_START_SEC_PUBLIC_CODE

    #elif defined(ADC_STOP_SEC_PUBLIC_CODE)
      #undef ADC_STOP_SEC_PUBLIC_CODE
      #define ADC_59_INST1_STOP_SEC_PUBLIC_CODE

    #elif defined(ADC_START_SEC_CODE_FAST)
      #undef ADC_START_SEC_CODE_FAST
      #define ADC_59_INST1_START_SEC_CODE_FAST

    #elif defined(ADC_STOP_SEC_CODE_FAST)
      #undef ADC_STOP_SEC_CODE_FAST
      #define ADC_59_INST1_STOP_SEC_CODE_FAST

    #elif defined(ADC_START_SEC_PRIVATE_CODE)
      #undef ADC_START_SEC_PRIVATE_CODE
      #define ADC_59_INST1_START_SEC_PRIVATE_CODE

    #elif defined(ADC_STOP_SEC_PRIVATE_CODE)
      #undef ADC_STOP_SEC_PRIVATE_CODE
      #define ADC_59_INST1_STOP_SEC_PRIVATE_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_32)
      #undef ADC_START_SEC_CONFIG_DATA_32
      #define ADC_59_INST1_START_SEC_CONFIG_DATA_32

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_32)
      #undef ADC_STOP_SEC_CONFIG_DATA_32
      #define ADC_59_INST1_STOP_SEC_CONFIG_DATA_32

    #elif defined(ADC_START_SEC_CONFIG_DATA_8)
      #undef ADC_START_SEC_CONFIG_DATA_8
      #define ADC_59_INST1_START_SEC_CONFIG_DATA_8

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_8)
      #undef ADC_STOP_SEC_CONFIG_DATA_8
      #define ADC_59_INST1_STOP_SEC_CONFIG_DATA_8

    #elif defined(ADC_START_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST1_START_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST1_STOP_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_CONFIG_DATA_PTR)
      #undef ADC_START_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST1_START_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_PTR)
      #undef ADC_STOP_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST1_STOP_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_START_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST1_START_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST1_STOP_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_VAR_NO_INIT_8)
      #undef ADC_START_SEC_VAR_NO_INIT_8
      #define ADC_59_INST1_START_SEC_VAR_NO_INIT_8

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_8)
      #undef ADC_STOP_SEC_VAR_NO_INIT_8
      #define ADC_59_INST1_STOP_SEC_VAR_NO_INIT_8

    #elif defined(ADC_START_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST1_START_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST1_STOP_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_APPL_CODE)
      #undef ADC_START_SEC_APPL_CODE
      #define ADC_59_INST1_START_SEC_APPL_CODE

    #elif defined(ADC_STOP_SEC_APPL_CODE)
      #undef ADC_STOP_SEC_APPL_CODE
      #define ADC_59_INST1_STOP_SEC_APPL_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_16)
      #undef ADC_START_SEC_CONFIG_DATA_16
      #define ADC_59_INST1_START_SEC_CONFIG_DATA_16

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_16)
      #undef ADC_STOP_SEC_CONFIG_DATA_16
      #define ADC_59_INST1_STOP_SEC_CONFIG_DATA_16

    #else
      #error "No valid section"
    #endif
  #elif (ADC_INSTANCE_INDEX == 2)
    #if defined(ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST2_START_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_VAR_NO_INIT_PTR)
      #undef ADC_START_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST2_START_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_PTR)
      #undef ADC_STOP_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST2_STOP_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST2_STOP_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_DBTOC_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_DBTOC_DATA_UNSPECIFIED
      #define ADC_59_INST2_START_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED)
      #define ADC_59_INST2_STOP_SEC_DBTOC_DATA_UNSPECIFIED
      #undef ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_PUBLIC_CODE)
      #undef ADC_START_SEC_PUBLIC_CODE
      #define ADC_59_INST2_START_SEC_PUBLIC_CODE

    #elif defined(ADC_STOP_SEC_PUBLIC_CODE)
      #undef ADC_STOP_SEC_PUBLIC_CODE
      #define ADC_59_INST2_STOP_SEC_PUBLIC_CODE

    #elif defined(ADC_START_SEC_CODE_FAST)
      #undef ADC_START_SEC_CODE_FAST
      #define ADC_59_INST2_START_SEC_CODE_FAST

    #elif defined(ADC_STOP_SEC_CODE_FAST)
      #undef ADC_STOP_SEC_CODE_FAST
      #define ADC_59_INST2_STOP_SEC_CODE_FAST

    #elif defined(ADC_START_SEC_PRIVATE_CODE)
      #undef ADC_START_SEC_PRIVATE_CODE
      #define ADC_59_INST2_START_SEC_PRIVATE_CODE

    #elif defined(ADC_STOP_SEC_PRIVATE_CODE)
      #undef ADC_STOP_SEC_PRIVATE_CODE
      #define ADC_59_INST2_STOP_SEC_PRIVATE_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_32)
      #undef ADC_START_SEC_CONFIG_DATA_32
      #define ADC_59_INST2_START_SEC_CONFIG_DATA_32

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_32)
      #undef ADC_STOP_SEC_CONFIG_DATA_32
      #define ADC_59_INST2_STOP_SEC_CONFIG_DATA_32

    #elif defined(ADC_START_SEC_CONFIG_DATA_8)
      #undef ADC_START_SEC_CONFIG_DATA_8
      #define ADC_59_INST2_START_SEC_CONFIG_DATA_8

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_8)
      #undef ADC_STOP_SEC_CONFIG_DATA_8
      #define ADC_59_INST2_STOP_SEC_CONFIG_DATA_8

    #elif defined(ADC_START_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST2_START_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST2_STOP_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_CONFIG_DATA_PTR)
      #undef ADC_START_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST2_START_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_PTR)
      #undef ADC_STOP_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST2_STOP_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_START_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST2_START_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST2_STOP_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_VAR_NO_INIT_8)
      #undef ADC_START_SEC_VAR_NO_INIT_8
      #define ADC_59_INST2_START_SEC_VAR_NO_INIT_8

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_8)
      #undef ADC_STOP_SEC_VAR_NO_INIT_8
      #define ADC_59_INST2_STOP_SEC_VAR_NO_INIT_8

    #elif defined(ADC_START_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST2_START_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST2_STOP_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_APPL_CODE)
      #undef ADC_START_SEC_APPL_CODE
      #define ADC_59_INST2_START_SEC_APPL_CODE

    #elif defined(ADC_STOP_SEC_APPL_CODE)
      #undef ADC_STOP_SEC_APPL_CODE
      #define ADC_59_INST2_STOP_SEC_APPL_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_16)
      #undef ADC_START_SEC_CONFIG_DATA_16
      #define ADC_59_INST2_START_SEC_CONFIG_DATA_16

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_16)
      #undef ADC_STOP_SEC_CONFIG_DATA_16
      #define ADC_59_INST2_STOP_SEC_CONFIG_DATA_16

    #else
      #error "No valid section"
    #endif
  #elif (ADC_INSTANCE_INDEX == 3)
    #if defined(ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST3_START_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_VAR_NO_INIT_PTR)
      #undef ADC_START_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST3_START_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_PTR)
      #undef ADC_STOP_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST3_STOP_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST3_STOP_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_DBTOC_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_DBTOC_DATA_UNSPECIFIED
      #define ADC_59_INST3_START_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED)
      #define ADC_59_INST3_STOP_SEC_DBTOC_DATA_UNSPECIFIED
      #undef ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_PUBLIC_CODE)
      #undef ADC_START_SEC_PUBLIC_CODE
      #define ADC_59_INST3_START_SEC_PUBLIC_CODE

    #elif defined(ADC_STOP_SEC_PUBLIC_CODE)
      #undef ADC_STOP_SEC_PUBLIC_CODE
      #define ADC_59_INST3_STOP_SEC_PUBLIC_CODE

    #elif defined(ADC_START_SEC_CODE_FAST)
      #undef ADC_START_SEC_CODE_FAST
      #define ADC_59_INST3_START_SEC_CODE_FAST

    #elif defined(ADC_STOP_SEC_CODE_FAST)
      #undef ADC_STOP_SEC_CODE_FAST
      #define ADC_59_INST3_STOP_SEC_CODE_FAST

    #elif defined(ADC_START_SEC_PRIVATE_CODE)
      #undef ADC_START_SEC_PRIVATE_CODE
      #define ADC_59_INST3_START_SEC_PRIVATE_CODE

    #elif defined(ADC_STOP_SEC_PRIVATE_CODE)
      #undef ADC_STOP_SEC_PRIVATE_CODE
      #define ADC_59_INST3_STOP_SEC_PRIVATE_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_32)
      #undef ADC_START_SEC_CONFIG_DATA_32
      #define ADC_59_INST3_START_SEC_CONFIG_DATA_32

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_32)
      #undef ADC_STOP_SEC_CONFIG_DATA_32
      #define ADC_59_INST3_STOP_SEC_CONFIG_DATA_32

    #elif defined(ADC_START_SEC_CONFIG_DATA_8)
      #undef ADC_START_SEC_CONFIG_DATA_8
      #define ADC_59_INST3_START_SEC_CONFIG_DATA_8

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_8)
      #undef ADC_STOP_SEC_CONFIG_DATA_8
      #define ADC_59_INST3_STOP_SEC_CONFIG_DATA_8

    #elif defined(ADC_START_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST3_START_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST3_STOP_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_CONFIG_DATA_PTR)
      #undef ADC_START_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST3_START_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_PTR)
      #undef ADC_STOP_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST3_STOP_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_START_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST3_START_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST3_STOP_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_VAR_NO_INIT_8)
      #undef ADC_START_SEC_VAR_NO_INIT_8
      #define ADC_59_INST3_START_SEC_VAR_NO_INIT_8

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_8)
      #undef ADC_STOP_SEC_VAR_NO_INIT_8
      #define ADC_59_INST3_STOP_SEC_VAR_NO_INIT_8

    #elif defined(ADC_START_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST3_START_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST3_STOP_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_APPL_CODE)
      #undef ADC_START_SEC_APPL_CODE
      #define ADC_59_INST3_START_SEC_APPL_CODE

    #elif defined(ADC_STOP_SEC_APPL_CODE)
      #undef ADC_STOP_SEC_APPL_CODE
      #define ADC_59_INST3_STOP_SEC_APPL_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_16)
      #undef ADC_START_SEC_CONFIG_DATA_16
      #define ADC_59_INST3_START_SEC_CONFIG_DATA_16

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_16)
      #undef ADC_STOP_SEC_CONFIG_DATA_16
      #define ADC_59_INST3_STOP_SEC_CONFIG_DATA_16

    #else
      #error "No valid section"
    #endif

  #elif (ADC_INSTANCE_INDEX == 4)
    #if defined(ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_START_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST4_START_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_VAR_NO_INIT_PTR)
      #undef ADC_START_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST4_START_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_PTR)
      #undef ADC_STOP_SEC_VAR_NO_INIT_PTR
      #define ADC_59_INST4_STOP_SEC_VAR_NO_INIT_PTR

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED)
      #undef ADC_STOP_SEC_VAR_NO_INIT_UNSPECIFIED
      #define ADC_59_INST4_STOP_SEC_VAR_NO_INIT_UNSPECIFIED

    #elif defined(ADC_START_SEC_DBTOC_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_DBTOC_DATA_UNSPECIFIED
      #define ADC_59_INST4_START_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED)
      #define ADC_59_INST4_STOP_SEC_DBTOC_DATA_UNSPECIFIED
      #undef ADC_STOP_SEC_DBTOC_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_PUBLIC_CODE)
      #undef ADC_START_SEC_PUBLIC_CODE
      #define ADC_59_INST4_START_SEC_PUBLIC_CODE

    #elif defined(ADC_STOP_SEC_PUBLIC_CODE)
      #undef ADC_STOP_SEC_PUBLIC_CODE
      #define ADC_59_INST4_STOP_SEC_PUBLIC_CODE

    #elif defined(ADC_START_SEC_CODE_FAST)
      #undef ADC_START_SEC_CODE_FAST
      #define ADC_59_INST4_START_SEC_CODE_FAST

    #elif defined(ADC_STOP_SEC_CODE_FAST)
      #undef ADC_STOP_SEC_CODE_FAST
      #define ADC_59_INST4_STOP_SEC_CODE_FAST

    #elif defined(ADC_START_SEC_PRIVATE_CODE)
      #undef ADC_START_SEC_PRIVATE_CODE
      #define ADC_59_INST4_START_SEC_PRIVATE_CODE

    #elif defined(ADC_STOP_SEC_PRIVATE_CODE)
      #undef ADC_STOP_SEC_PRIVATE_CODE
      #define ADC_59_INST4_STOP_SEC_PRIVATE_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_32)
      #undef ADC_START_SEC_CONFIG_DATA_32
      #define ADC_59_INST4_START_SEC_CONFIG_DATA_32

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_32)
      #undef ADC_STOP_SEC_CONFIG_DATA_32
      #define ADC_59_INST4_STOP_SEC_CONFIG_DATA_32

    #elif defined(ADC_START_SEC_CONFIG_DATA_8)
      #undef ADC_START_SEC_CONFIG_DATA_8
      #define ADC_59_INST4_START_SEC_CONFIG_DATA_8

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_8)
      #undef ADC_STOP_SEC_CONFIG_DATA_8
      #define ADC_59_INST4_STOP_SEC_CONFIG_DATA_8

    #elif defined(ADC_START_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST4_START_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED)
      #undef ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
      #define ADC_59_INST4_STOP_SEC_CONFIG_DATA_UNSPECIFIED

    #elif defined(ADC_START_SEC_CONFIG_DATA_PTR)
      #undef ADC_START_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST4_START_SEC_CONFIG_DATA_PTR

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_PTR)
      #undef ADC_STOP_SEC_CONFIG_DATA_PTR
      #define ADC_59_INST4_STOP_SEC_CONFIG_DATA_PTR
\
    #elif defined(ADC_START_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST4_START_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_INIT_BOOLEAN
      #define ADC_59_INST4_STOP_SEC_VAR_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_VAR_NO_INIT_8)
      #undef ADC_START_SEC_VAR_NO_INIT_8
      #define ADC_59_INST4_START_SEC_VAR_NO_INIT_8

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_8)
      #undef ADC_STOP_SEC_VAR_NO_INIT_8
      #define ADC_59_INST4_STOP_SEC_VAR_NO_INIT_8

    #elif defined(ADC_START_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_START_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST4_START_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN)
      #undef ADC_STOP_SEC_VAR_NO_INIT_BOOLEAN
      #define ADC_59_INST4_STOP_SEC_VAR_NO_INIT_BOOLEAN

    #elif defined(ADC_START_SEC_APPL_CODE)
      #undef ADC_START_SEC_APPL_CODE
      #define ADC_59_INST4_START_SEC_APPL_CODE

    #elif defined(ADC_STOP_SEC_APPL_CODE)
      #undef ADC_STOP_SEC_APPL_CODE
      #define ADC_59_INST4_STOP_SEC_APPL_CODE

    #elif defined(ADC_START_SEC_CONFIG_DATA_16)
      #undef ADC_START_SEC_CONFIG_DATA_16
      #define ADC_59_INST4_START_SEC_CONFIG_DATA_16

    #elif defined(ADC_STOP_SEC_CONFIG_DATA_16)
      #undef ADC_STOP_SEC_CONFIG_DATA_16
      #define ADC_59_INST4_STOP_SEC_CONFIG_DATA_16

    #else
      #error "No valid section"
    #endif

  #else
     #error "Miss instance index"
  #endif
#endif

#include ADC_MEMMAP_HEADER

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
