/*====================================================================================================================*/
/* Project      = AUTOSAR Renesas X2x MCAL Components                                                                 */
/* Module       = Adc_MultiInstance.h                                                                                 */
/* SW-VERSION   = 1.5.0                                                                                               */
/*====================================================================================================================*/
/*                                                     COPYRIGHT                                                      */
/*====================================================================================================================*/
/* (c) 2020-2022 Renesas Electronics Corporation. All rights reserved.                                                */
/*====================================================================================================================*/
/* Purpose:                                                                                                           */
/* This file is used to add instance index to each global symbol for the multiple instance support.                   */
/*                                                                                                                    */
/*====================================================================================================================*/
/*                                                                                                                    */
/* Unless otherwise agreed upon in writing between your company and Renesas Electronics Corporation the following     */
/* shall apply!                                                                                                       */
/*                                                                                                                    */
/* Warranty Disclaimer                                                                                                */
/*                                                                                                                    */
/* There is no warranty of any kind whatsoever granted by Renesas. Any warranty is expressly disclaimed and excluded  */
/* by Renesas, either expressed or implied, including but not limited to those for non-infringement of intellectual   */
/* property, merchantability and/or fitness for the particular purpose.                                               */
/*                                                                                                                    */
/* Renesas shall not have any obligation to maintain, service or provide bug fixes for the supplied Product(s) and/or */
/* the Application.                                                                                                   */
/*                                                                                                                    */
/* Each User is solely responsible for determining the appropriateness of using the Product(s) and assumes all risks  */
/* associated with its exercise of rights under this Agreement, including, but not limited to the risks and costs of  */
/* program errors, compliance with applicable laws, damage to or loss of data, programs or equipment, and             */
/* unavailability or interruption of operations.                                                                      */
/*                                                                                                                    */
/* Limitation of Liability                                                                                            */
/*                                                                                                                    */
/* In no event shall Renesas be liable to the User for any incidental, consequential, indirect, or punitive damage    */
/* (including but not limited to lost profits) regardless of whether such liability is based on breach of contract,   */
/* tort, strict liability, breach of warranties, failure of essential purpose or otherwise and even if advised of the */
/* possibility of such damages. Renesas shall not be liable for any services or products provided by third party      */
/* vendors, developers or consultants identified or referred to the User by Renesas in connection with the Product(s) */
/* and/or the Application.                                                                                            */
/*                                                                                                                    */
/*====================================================================================================================*/
/* Environment:                                                                                                       */
/*              Devices:        X2x                                                                                   */
/*====================================================================================================================*/

/***********************************************************************************************************************
**                                              Revision Control History                                              **
***********************************************************************************************************************/
/*
 * 1.4.3: 17/05/2022 : Moved the extension from the header file definition into the multi-macro.
 *                     Added the prefix ADC_ to macro SCHM_ADC_HEADER.
 *                     Added new macro Adc_GpHwTriggConfig.
 *        15/04/2022 : Added new macro for ADCKA ISRs and instance 4.
 * 1.4.1: 24/11/2021 : Added new functions of ADCK.
 *                     Removed the compile switch of ADC_IP_ADCH.
 *                     Added instance 4 to the suppression of duplicate inclusion.
 * 1.3.2: 09/09/2021 : Add macro definitions of memory section required for multi-instances.
 *                     Remove unnecessary macro definitions for multi-instances.
 *        06/09/2021 : Add macro definitions required for multi-instances.
 *                     Update macro definitions for multi-instances.
 * 1.3.1: 12/07/2021 : Changed the name of the global variable Adc_GpWaitTimeConfig to conform to Camel.
 *                     Added the global variable Adc_GaaHwUnitData.
 *                     Removed the global variables Adc_GblDataAvailable, Adc_GblErrIntStatus.
 *        07/07/2021 : Changed comment format to 120 columns
 *        24/05/2021 : Removed internal functions from "Adc_MultiInstance.h".
 * 1.3.0: 10/12/2020 : Add new definition for function Adc_PicInit and
 *                     global variable Adc_GpTriggOutConfigRegister
 * 1.2.0: 14/07/2020 : Release
 *        27/07/2020 : Add QAC 9.3.1 comment.
 * 1.1.2: 06/07/2020 : Remove array Adc_GaaCurrentConvGroup
 * 1.1.1: 02/07/2020 : Add Multi instance define for function
 *                     Adc_GetLastSgConvGroup
 * 1.1.0: 19/06/2020 : Release
 * 1.0.1: 23/04/2020 : As per Redmine #263565, Remove Multi instance for macro
 *                     uses in pre-compiling time (STD_ON/STD_OFF).
 * 1.0.0: 09/01/2020 : Initial Version
 */
/**********************************************************************************************************************/
#ifdef ADC_INSTANCE_INDEX
  #if (ADC_INSTANCE_INDEX == 0)
    #ifndef ADC_59_INST0_MULTIINSTANCE_H
      #define ADC_59_INST0_MULTIINSTANCE_H
      #define ADC_MULTIINSTANCE_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 1)
    #ifndef ADC_59_INST1_MULTIINSTANCE_H
      #define ADC_59_INST1_MULTIINSTANCE_H
      #define ADC_MULTIINSTANCE_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 2)
    #ifndef ADC_59_INST2_MULTIINSTANCE_H
      #define ADC_59_INST2_MULTIINSTANCE_H
      #define ADC_MULTIINSTANCE_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 3)
    #ifndef ADC_59_INST3_MULTIINSTANCE_H
      #define ADC_59_INST3_MULTIINSTANCE_H
      #define ADC_MULTIINSTANCE_HEADER
    #endif
  #elif (ADC_INSTANCE_INDEX == 4)
    #ifndef ADC_59_INST4_MULTIINSTANCE_H
      #define ADC_59_INST4_MULTIINSTANCE_H
      #define ADC_MULTIINSTANCE_HEADER
    #endif
  #else
    #error "Miss instance index"
  #endif
#else
  #ifndef ADC_MULTIINSTANCE_H
    #define ADC_MULTIINSTANCE_H
    #define ADC_MULTIINSTANCE_HEADER
  #endif
#endif

#ifdef ADC_MULTIINSTANCE_HEADER
#undef ADC_MULTIINSTANCE_HEADER                                                                                         /* PRQA S 0841 # JV-01 */

#define ADC_INCLUDE_FROM_MCAL

/***********************************************************************************************************************
**                                               Coding Rule Violations                                               **
***********************************************************************************************************************/
/* Message (2:0841)    : Using '#undef'.                                                                              */
/* Rule                : MISRA C:2012 Rule-20.5                                                                       */
/* JV-01 Justification : This file compliant AUTOSAR format. So, there is need to use #undef.                         */
/*       Verification  : Incorrect declaration would result in compilation fails.                                     */
/**********************************************************************************************************************/

/***********************************************************************************************************************
**                                                   Global Symbols                                                   **
***********************************************************************************************************************/
/* ADC_INSTANCE_INDEX is passed by -D option */
#if defined(ADC_INSTANCE_INDEX)

/* Add index to all global symbols. INSTANCE_INDEX is passed by -D option */
#define ADC_MULTIINC(pre_symbol, suf_symbol)               ADC_MULTIINC_(pre_symbol, suf_symbol, ADC_INSTANCE_INDEX)
/* To evaluate INSTANCE_INDEX before concatenation, nest the macro */
#define ADC_MULTIINC_(pre_symbol, suf_symbol, index)       ADC_MULTIINC__(pre_symbol, suf_symbol, index)
#define ADC_MULTIINC__(pre_symbol, suf_symbol, index)      pre_symbol ## index ## suf_symbol.h

/* String conversion macro */
#define TO_STRING(str)                                     TO_STRING_(str)
#define TO_STRING_(str)                                    #str


/* Add index to all global symbols. ADC_INSTANCE_INDEX is passed by -D option */
#define ADC_MULTI(pre_symbol, suf_symbol)                  ADC_MULTI_(pre_symbol, suf_symbol, ADC_INSTANCE_INDEX)
/* To evaluate ADC_INSTANCE_INDEX before concatenation, nest the macro */
#define ADC_MULTI_(pre_symbol, suf_symbol, index)          ADC_MULTI__(pre_symbol, suf_symbol, index)
#define ADC_MULTI__(pre_symbol, suf_symbol, index)         pre_symbol ## index ## suf_symbol

/* Multi instance all symbolic constants */

/* API */
#define Adc_Init                                           ADC_MULTI(Adc_59_Inst, _Init)
#define Adc_DeInit                                         ADC_MULTI(Adc_59_Inst, _DeInit)
#define Adc_StartGroupConversion                           ADC_MULTI(Adc_59_Inst, _StartGroupConversion)
#define Adc_StopGroupConversion                            ADC_MULTI(Adc_59_Inst, _StopGroupConversion)
#define Adc_ReadGroup                                      ADC_MULTI(Adc_59_Inst, _ReadGroup)
#define Adc_EnableHardwareTrigger                          ADC_MULTI(Adc_59_Inst, _EnableHardwareTrigger)
#define Adc_DisableHardwareTrigger                         ADC_MULTI(Adc_59_Inst, _DisableHardwareTrigger)
#define Adc_EnableGroupNotification                        ADC_MULTI(Adc_59_Inst, _EnableGroupNotification)
#define Adc_DisableGroupNotification                       ADC_MULTI(Adc_59_Inst, _DisableGroupNotification)
#define Adc_GetGroupStatus                                 ADC_MULTI(Adc_59_Inst, _GetGroupStatus)
#define Adc_GetStreamLastPointer                           ADC_MULTI(Adc_59_Inst, _GetStreamLastPointer)
#define Adc_DisableChannel                                 ADC_MULTI(Adc_59_Inst, _DisableChannel)
#define Adc_EnableChannel                                  ADC_MULTI(Adc_59_Inst, _EnableChannel)
#define Adc_GetVersionInfo                                 ADC_MULTI(Adc_59_Inst, _GetVersionInfo)
#define Adc_SetupResultBuffer                              ADC_MULTI(Adc_59_Inst, _SetupResultBuffer)

/* Internal Function(Adc_LLDriver) */
#define Adc_HwInit                                         ADC_MULTI(Adc_59_Inst, _HwInit)
#define Adc_HwDeInit                                       ADC_MULTI(Adc_59_Inst, _HwDeInit)
#define Adc_StateTransition                                ADC_MULTI(Adc_59_Inst, _StateTransition)
#define Adc_SetStatus                                      ADC_MULTI(Adc_59_Inst, _SetStatus)
#define Adc_HwStartGroupConversion                         ADC_MULTI(Adc_59_Inst, _HwStartGroupConversion)
#define Adc_HwStopGroupConversion                          ADC_MULTI(Adc_59_Inst, _HwStopGroupConversion)
#define Adc_HwEnableHardwareTrigger                        ADC_MULTI(Adc_59_Inst, _HwEnableHardwareTrigger)
#define Adc_HwDisableHardwareTrigger                       ADC_MULTI(Adc_59_Inst, _HwDisableHardwareTrigger)
#define Adc_IntDisableEnableChannel                        ADC_MULTI(Adc_59_Inst, _IntDisableEnableChannel)
#define Adc_PollingReadGroup                               ADC_MULTI(Adc_59_Inst, _PollingReadGroup)
#define Adc_Isr                                            ADC_MULTI(Adc_59_Inst, _Isr)
#define Adc_ErrIsr                                         ADC_MULTI(Adc_59_Inst, _ErrIsr)
#define Adc_ParityErrIsr                                   ADC_MULTI(Adc_59_Inst, _ParityErrIsr)
#define Adc_DmaIsr                                         ADC_MULTI(Adc_59_Inst, _DmaIsr)

/* Internal Function(Adc_ADCX_LLDriver) */
#define Adc_AdcInit                                        ADC_MULTI(Adc_59_Inst, _AdcInit)
#define Adc_AdcDeInit                                      ADC_MULTI(Adc_59_Inst, _AdcDeInit)
#define Adc_EcmErrorInterrupt                              ADC_MULTI(Adc_59_Inst, _EcmErrorInterrupt)
#define Adc_SetWaitTime                                    ADC_MULTI(Adc_59_Inst, _SetWaitTime)
#define Adc_DeInitWaitTime                                 ADC_MULTI(Adc_59_Inst, _DeInitWaitTime)
#define Adc_TrackHoldEnable                                ADC_MULTI(Adc_59_Inst, _TrackHoldEnable)
#define Adc_TrackHoldDisable                               ADC_MULTI(Adc_59_Inst, _TrackHoldDisable)
#define Adc_TrackHoldDeInit                                ADC_MULTI(Adc_59_Inst, _TrackHoldDeInit)
#define Adc_TrackHoldInit                                  ADC_MULTI(Adc_59_Inst, _TrackHoldInit)
#define Adc_PwmDiagInit                                    ADC_MULTI(Adc_59_Inst, _PwmDiagInit)
#define Adc_PwmDiagDeInit                                  ADC_MULTI(Adc_59_Inst, _PwmDiagDeInit)
#define Adc_PwmDiagEnable                                  ADC_MULTI(Adc_59_Inst, _PwmDiagEnable)
#define Adc_PwmDiagDisable                                 ADC_MULTI(Adc_59_Inst, _PwmDiagDisable)
#define Adc_PwmDiagReadData                                ADC_MULTI(Adc_59_Inst, _PwmDiagReadData)

/* Internal Function(Adc_PIC_LLDriver) */
#define Adc_PicInit                                        ADC_MULTI(Adc_59_Inst, _PicInit)
#define Adc_PicDeInit                                      ADC_MULTI(Adc_59_Inst, _PicDeInit)
#define Adc_PicClearHwTrigger                              ADC_MULTI(Adc_59_Inst, _PicClearHwTrigger)
#define Adc_PicEnableHwTrigger                             ADC_MULTI(Adc_59_Inst, _PicEnableHwTrigger)
#define Adc_PicDisableHwTrigger                            ADC_MULTI(Adc_59_Inst, _PicDisableHwTrigger)

/* Internal Function(Adc_sDMAC_LLDriver) */
#define Adc_DmaInit                                        ADC_MULTI(Adc_59_Inst, _DmaInit)
#define Adc_DmaDeInit                                      ADC_MULTI(Adc_59_Inst, _DmaDeInit)
#define Adc_DmaEnable                                      ADC_MULTI(Adc_59_Inst, _DmaEnable)
#define Adc_DmaDisable                                     ADC_MULTI(Adc_59_Inst, _DmaDisable)
#define Adc_DmaGetTransferStatus                           ADC_MULTI(Adc_59_Inst, _DmaGetTransferStatus)
#define Adc_DmaClearInterruptFlag                          ADC_MULTI(Adc_59_Inst, _DmaClearInterruptFlag)

/* Interrupt handler(Adc_Irq) */
#define ADC0_SG0_ISR                                       ADC_MULTI(ADC0_59_INST, _SG0_ISR)
#define ADC0_SG1_ISR                                       ADC_MULTI(ADC0_59_INST, _SG1_ISR)
#define ADC0_SG2_ISR                                       ADC_MULTI(ADC0_59_INST, _SG2_ISR)
#define ADC0_SG3_ISR                                       ADC_MULTI(ADC0_59_INST, _SG3_ISR)
#define ADC0_SG4_ISR                                       ADC_MULTI(ADC0_59_INST, _SG4_ISR)
#define ADC0_ERR_ISR                                       ADC_MULTI(ADC0_59_INST, _ERR_ISR)
#define ADC1_SG0_ISR                                       ADC_MULTI(ADC1_59_INST, _SG0_ISR)
#define ADC1_SG1_ISR                                       ADC_MULTI(ADC1_59_INST, _SG1_ISR)
#define ADC1_SG2_ISR                                       ADC_MULTI(ADC1_59_INST, _SG2_ISR)
#define ADC1_SG3_ISR                                       ADC_MULTI(ADC1_59_INST, _SG3_ISR)
#define ADC1_SG4_ISR                                       ADC_MULTI(ADC1_59_INST, _SG4_ISR)
#define ADC1_ERR_ISR                                       ADC_MULTI(ADC1_59_INST, _ERR_ISR)
#define ADC2_SG0_ISR                                       ADC_MULTI(ADC2_59_INST, _SG0_ISR)
#define ADC2_SG1_ISR                                       ADC_MULTI(ADC2_59_INST, _SG1_ISR)
#define ADC2_SG2_ISR                                       ADC_MULTI(ADC2_59_INST, _SG2_ISR)
#define ADC2_SG3_ISR                                       ADC_MULTI(ADC2_59_INST, _SG3_ISR)
#define ADC2_SG4_ISR                                       ADC_MULTI(ADC2_59_INST, _SG4_ISR)
#define ADC2_ERR_ISR                                       ADC_MULTI(ADC2_59_INST, _ERR_ISR)
#define ADC3_SG0_ISR                                       ADC_MULTI(ADC3_59_INST, _SG0_ISR)
#define ADC3_SG1_ISR                                       ADC_MULTI(ADC3_59_INST, _SG1_ISR)
#define ADC3_SG2_ISR                                       ADC_MULTI(ADC3_59_INST, _SG2_ISR)
#define ADC3_SG3_ISR                                       ADC_MULTI(ADC3_59_INST, _SG3_ISR)
#define ADC3_SG4_ISR                                       ADC_MULTI(ADC3_59_INST, _SG4_ISR)
#define ADC3_ERR_ISR                                       ADC_MULTI(ADC3_59_INST, _ERR_ISR)
#define ADCA_SG0_ISR                                       ADC_MULTI(ADCS_59_INST, _SG0_ISR)
#define ADCA_SG1_ISR                                       ADC_MULTI(ADCS_59_INST, _SG1_ISR)
#define ADCA_SG2_ISR                                       ADC_MULTI(ADCS_59_INST, _SG2_ISR)
#define ADCA_SG3_ISR                                       ADC_MULTI(ADCS_59_INST, _SG3_ISR)
#define ADCA_SG4_ISR                                       ADC_MULTI(ADCS_59_INST, _SG4_ISR)
#define ADCA_ERR_ISR                                       ADC_MULTI(ADCA_59_INST, _ERR_ISR)
#define ADC_DMA0_CH00_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH00_ISR)
#define ADC_DMA0_CH01_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH01_ISR)
#define ADC_DMA0_CH02_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH02_ISR)
#define ADC_DMA0_CH03_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH03_ISR)
#define ADC_DMA0_CH04_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH04_ISR)
#define ADC_DMA0_CH05_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH05_ISR)
#define ADC_DMA0_CH06_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH06_ISR)
#define ADC_DMA0_CH07_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH07_ISR)
#define ADC_DMA0_CH08_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH08_ISR)
#define ADC_DMA0_CH09_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH09_ISR)
#define ADC_DMA0_CH10_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH10_ISR)
#define ADC_DMA0_CH11_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH11_ISR)
#define ADC_DMA0_CH12_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH12_ISR)
#define ADC_DMA0_CH13_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH13_ISR)
#define ADC_DMA0_CH14_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH14_ISR)
#define ADC_DMA0_CH15_ISR                                  ADC_MULTI(ADC_59_INST, _DMA0_CH15_ISR)
#define ADC_DMA1_CH00_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH00_ISR)
#define ADC_DMA1_CH01_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH01_ISR)
#define ADC_DMA1_CH02_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH02_ISR)
#define ADC_DMA1_CH03_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH03_ISR)
#define ADC_DMA1_CH04_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH04_ISR)
#define ADC_DMA1_CH05_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH05_ISR)
#define ADC_DMA1_CH06_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH06_ISR)
#define ADC_DMA1_CH07_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH07_ISR)
#define ADC_DMA1_CH08_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH08_ISR)
#define ADC_DMA1_CH09_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH09_ISR)
#define ADC_DMA1_CH10_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH10_ISR)
#define ADC_DMA1_CH11_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH11_ISR)
#define ADC_DMA1_CH12_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH12_ISR)
#define ADC_DMA1_CH13_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH13_ISR)
#define ADC_DMA1_CH14_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH14_ISR)
#define ADC_DMA1_CH15_ISR                                  ADC_MULTI(ADC_59_INST, _DMA1_CH15_ISR)
#define ADC_PARITY_ERR_ISR                                 ADC_MULTI(ADC_59_INST, _PARITY_ERR_ISR)

/* Global pointer */
#define Adc_GpHwUnitConfig                                 ADC_MULTI(Adc_59_Inst, _GpHwUnitConfig)
#define Adc_GpSgUnitConfig                                 ADC_MULTI(Adc_59_Inst, _GpSgUnitConfig)
#define Adc_GpGroupConfig                                  ADC_MULTI(Adc_59_Inst, _GpGroupConfig)
#define Adc_GpHWGroupTrigg                                 ADC_MULTI(Adc_59_Inst, _GpHWGroupTrigg)
#define Adc_GpSGGroupTrigg                                 ADC_MULTI(Adc_59_Inst, _GpSGGroupTrigg)
#define Adc_GpTriggOutConfigRegister                       ADC_MULTI(Adc_59_Inst, _GpTriggOutConfigRegister)
#define Adc_GpTriggOutConfigValue                          ADC_MULTI(Adc_59_Inst, _GpTriggOutConfigValue)
#define Adc_GpDmaUnitConfig                                ADC_MULTI(Adc_59_Inst, _GpDmaUnitConfig)
#define Adc_GpDmaHWUnitMapping                             ADC_MULTI(Adc_59_Inst, _GpDmaHWUnitMapping)
#define Adc_GpDmaSGUnitMapping                             ADC_MULTI(Adc_59_Inst, _GpDmaSGUnitMapping)
#define Adc_GpHwUnitIndex                                  ADC_MULTI(Adc_59_Inst, _GpHwUnitIndex)
#define Adc_GpSgUnitIndex                                  ADC_MULTI(Adc_59_Inst, _GpSgUnitIndex)
#define Adc_GpChannelToGroup                               ADC_MULTI(Adc_59_Inst, _GpChannelToGroup)
#define Adc_GpLimitCheckRange                              ADC_MULTI(Adc_59_Inst, _GpLimitCheckRange)
#define Adc_GpGroupRamData                                 ADC_MULTI(Adc_59_Inst, _GpGroupRamData)
#define Adc_GpChannelToDisableEnable                       ADC_MULTI(Adc_59_Inst, _GpChannelToDisableEnable)
#define Adc_GpSgUnitRamData                                ADC_MULTI(Adc_59_Inst, _GpSgUnitRamData)
#define Adc_GpWaitTimeConfig                               ADC_MULTI(Adc_59_Inst, _GpWaitTimeConfig)
#define Adc_GpHwTriggConfig                                ADC_MULTI(Adc_59_Inst, _GpHwTriggConfig)

/* Global variable */
#define Adc_GblDriverStatus                                ADC_MULTI(Adc_59_Inst, _GblDriverStatus)
#define Adc_GucMaxSwTriggGroups                            ADC_MULTI(Adc_59_Inst, _GucMaxSwTriggGroups)
#define Adc_GucNoOfGroups                                  ADC_MULTI(Adc_59_Inst, _GucNoOfGroups)
#define Adc_GucMaxDmaChannels                              ADC_MULTI(Adc_59_Inst, _GucMaxDmaChannels)

/* Generated global variable */
#define Adc_GaaConfiguration                               ADC_MULTI(Adc_59_Inst, _GaaConfiguration)
#define Adc_GaaHWUnitConfig                                ADC_MULTI(Adc_59_Inst, _GaaHWUnitConfig)
#define Adc_GaaSgUnitConfig                                ADC_MULTI(Adc_59_Inst, _GaaSgUnitConfig)
#define Adc_GaaGroupConfig                                 ADC_MULTI(Adc_59_Inst, _GaaGroupConfig)
#define Adc_GaaHWGroupTrigg                                ADC_MULTI(Adc_59_Inst, _GaaHWGroupTrigg)
#define Adc_GaaDmaUnitConfig                               ADC_MULTI(Adc_59_Inst, _GaaDmaUnitConfig)
#define Adc_GaaChannelToGroup                              ADC_MULTI(Adc_59_Inst, _GaaChannelToGroup)
#define Adc_GaaGroupRamData                                ADC_MULTI(Adc_59_Inst, _GaaGroupRamData)
#define Adc_GaaHwUnit                                      ADC_MULTI(Adc_59_Inst, _GaaHwUnit)
#define Adc_GaaSGUnit                                      ADC_MULTI(Adc_59_Inst, _GaaSGUnit)
#define Adc_GaaHwUnitIndex                                 ADC_MULTI(Adc_59_Inst, _GaaHwUnitIndex)
#define Adc_GaaSgUnitIndex                                 ADC_MULTI(Adc_59_Inst, _GaaSgUnitIndex)
#define Adc_GaaSgUnitRamData                               ADC_MULTI(Adc_59_Inst, _GaaSgUnitRamData)
#define Adc_GaaChannelToDisableEnable                      ADC_MULTI(Adc_59_Inst, _GaaChannelToDisableEnable)
#define Adc_GaaSgUnitPriorityQueue                         ADC_MULTI(Adc_59_Inst, _GaaSgUnitPriorityQueue)
#define Adc_GaaLimitCheckRange                             ADC_MULTI(Adc_59_Inst, _GaaLimitCheckRange)
#define Adc_GaaSgTriggType                                 ADC_MULTI(Adc_59_Inst, _GaaSgTriggType)
#define Adc_GaaTriggOutConfigType                          ADC_MULTI(Adc_59_Inst, _GaaTriggOutConfigType)
#define Adc_GaaTriggOutConfigRegister                      ADC_MULTI(Adc_59_Inst, _GaaTriggOutConfigRegister)
#define Adc_GaaPicTenRegisters                             ADC_MULTI(Adc_59_Inst, _GaaPicTenRegisters)
#define Adc_GaaWaitTimeConfig                              ADC_MULTI(Adc_59_Inst, _GaaWaitTimeConfig)
#define Adc_GaaHwUnitData                                  ADC_MULTI(Adc_59_Inst, _GaaHwUnitData)

/* Multi instance for DEM ERROR */
#define ADC_E_TIMEOUT                                      ADC_MULTI(ADC_59_INST, _E_TIMEOUT)
#define ADC_E_INT_INCONSISTENT                             ADC_MULTI(ADC_59_INST, _E_INT_INCONSISTENT)
#define ADC_E_ECM_INT_INCONSISTENT                         ADC_MULTI(ADC_59_INST, _E_ECM_INT_INCONSISTENT)
#define ADC_E_ID_FAILURE                                   ADC_MULTI(ADC_59_INST, _E_ID_FAILURE)
#define ADC_E_PARITY_FAILURE                               ADC_MULTI(ADC_59_INST, _E_PARITY_FAILURE)

/*Multi instance for version information */
#define ADC_CFG_AR_RELEASE_MAJOR_VERSION                   ADC_MULTI(ADC_59_INST, _CFG_AR_RELEASE_MAJOR_VERSION)
#define ADC_CFG_AR_RELEASE_MINOR_VERSION                   ADC_MULTI(ADC_59_INST, _CFG_AR_RELEASE_MINOR_VERSION)
#define ADC_CFG_AR_RELEASE_REVISION_VERSION                ADC_MULTI(ADC_59_INST, _CFG_AR_RELEASE_REVISION_VERSION)
#define ADC_CFG_SW_MAJOR_VERSION                           ADC_MULTI(ADC_59_INST, _CFG_SW_MAJOR_VERSION)
#define ADC_CFG_SW_MINOR_VERSION                           ADC_MULTI(ADC_59_INST, _CFG_SW_MINOR_VERSION)
#define ADC_AR_VERSION                                     ADC_MULTI(ADC_59_INST, _AR_VERSION)

/* Multi instance for version information for PBCFG file */
#define ADC_PBCFG_C_AR_RELEASE_MAJOR_VERSION               ADC_MULTI(ADC_59_INST, _PBCFG_C_AR_RELEASE_MAJOR_VERSION)
#define ADC_PBCFG_C_AR_RELEASE_MINOR_VERSION               ADC_MULTI(ADC_59_INST, _PBCFG_C_AR_RELEASE_MINOR_VERSION)
#define ADC_PBCFG_C_AR_RELEASE_REVISION_VERSION            ADC_MULTI(ADC_59_INST, _PBCFG_C_AR_RELEASE_REVISION_VERSION)
#define ADC_PBCFG_C_SW_MAJOR_VERSION                       ADC_MULTI(ADC_59_INST, _PBCFG_C_SW_MAJOR_VERSION)
#define ADC_PBCFG_C_SW_MINOR_VERSION                       ADC_MULTI(ADC_59_INST, _PBCFG_C_SW_MINOR_VERSION)

/*Multi instance for common published information */
#define ADC_AR_RELEASE_MAJOR_VERSION_VALUE                 ADC_MULTI(ADC_59_INST, _AR_RELEASE_MAJOR_VERSION_VALUE)
#define ADC_AR_RELEASE_MINOR_VERSION_VALUE                 ADC_MULTI(ADC_59_INST, _AR_RELEASE_MINOR_VERSION_VALUE)
#define ADC_AR_RELEASE_REVISION_VERSION_VALUE              ADC_MULTI(ADC_59_INST, _AR_RELEASE_REVISION_VERSION_VALUE)
#define ADC_SW_MAJOR_VERSION_VALUE                         ADC_MULTI(ADC_59_INST, _SW_MAJOR_VERSION_VALUE)
#define ADC_SW_MINOR_VERSION_VALUE                         ADC_MULTI(ADC_59_INST, _SW_MINOR_VERSION_VALUE)
#define ADC_SW_PATCH_VERSION_VALUE                         ADC_MULTI(ADC_59_INST, _SW_PATCH_VERSION_VALUE)
#define ADC_VENDOR_ID_VALUE                                ADC_MULTI(ADC_59_INST, _VENDOR_ID_VALUE)
#define ADC_MODULE_ID_VALUE                                ADC_MULTI(ADC_59_INST, _MODULE_ID_VALUE)

/* Multi instance for memory class/pointer class */
#define ADC_PUBLIC_CODE                                    ADC_MULTI(ADC_59_INST, _PUBLIC_CODE)
#define ADC_PRIVATE_CODE                                   ADC_MULTI(ADC_59_INST, _PRIVATE_CODE)
#define ADC_APPL_CODE                                      ADC_MULTI(ADC_59_INST, _APPL_CODE)
#define ADC_APPL_DATA                                      ADC_MULTI(ADC_59_INST, _APPL_DATA)
#define ADC_CODE_FAST                                      ADC_MULTI(ADC_59_INST, _CODE_FAST)
#define ADC_CONFIG_DATA                                    ADC_MULTI(ADC_59_INST, _CONFIG_DATA)
#define ADC_VAR_INIT                                       ADC_MULTI(ADC_59_INST, _VAR_INIT)
#define ADC_VAR_NO_INIT                                    ADC_MULTI(ADC_59_INST, _VAR_NO_INIT)
#define ADC_CONST                                          ADC_MULTI(ADC_59_INST, _CONST)

/* Multi instance for memory class/pointer class */
#define Adc_ConfigType                                     ADC_MULTI(Adc_59_Inst, _ConfigType)
#define STag_Adc_ConfigType                                ADC_MULTI(STag_Adc_59_Inst, _ConfigType)

/* Multi instance for memory section */
#define SchM_Enter_Adc_ADC_RAM_DATA_PROTECTION             ADC_MULTI(SchM_Enter_Adc_59_Inst, _ADC_RAM_DATA_PROTECTION)
#define SchM_Exit_Adc_ADC_RAM_DATA_PROTECTION              ADC_MULTI(SchM_Exit_Adc_59_Inst, _ADC_RAM_DATA_PROTECTION)
#define SchM_Enter_Adc_ADC_INTERRUPT_CONTROL_PROTECTION    \
                                                    ADC_MULTI(SchM_Enter_Adc_59_Inst, _ADC_INTERRUPT_CONTROL_PROTECTION)
#define SchM_Exit_Adc_ADC_INTERRUPT_CONTROL_PROTECTION     \
                                                     ADC_MULTI(SchM_Exit_Adc_59_Inst, _ADC_INTERRUPT_CONTROL_PROTECTION)

/* Define header file name */
#define ADC_MEMMAP_HEADER                                  TO_STRING(ADC_MULTIINC(Adc_59_Inst, _MemMap))
#define ADC_SCHM_ADC_HEADER                                TO_STRING(ADC_MULTIINC(SchM_Adc_59_Inst, ))
#define ADC_CFG_HEADER                                     TO_STRING(ADC_MULTIINC(Adc_59_Inst, _Cfg))

#define ADC_59_INST0_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ADC_59_INST0_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ADC_59_INST0_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION  ADC_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ADC_59_INST0_ADCX_PBTYPES_SW_MAJOR_VERSION             ADC_ADCX_PBTYPES_SW_MAJOR_VERSION
#define ADC_59_INST0_ADCX_PBTYPES_SW_MINOR_VERSION             ADC_ADCX_PBTYPES_SW_MINOR_VERSION

#define ADC_59_INST1_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ADC_59_INST1_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ADC_59_INST1_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION  ADC_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ADC_59_INST1_ADCX_PBTYPES_SW_MAJOR_VERSION             ADC_ADCX_PBTYPES_SW_MAJOR_VERSION
#define ADC_59_INST1_ADCX_PBTYPES_SW_MINOR_VERSION             ADC_ADCX_PBTYPES_SW_MINOR_VERSION

#define ADC_59_INST2_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ADC_59_INST2_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ADC_59_INST2_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION  ADC_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ADC_59_INST2_ADCX_PBTYPES_SW_MAJOR_VERSION             ADC_ADCX_PBTYPES_SW_MAJOR_VERSION
#define ADC_59_INST2_ADCX_PBTYPES_SW_MINOR_VERSION             ADC_ADCX_PBTYPES_SW_MINOR_VERSION

#define ADC_59_INST3_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ADC_59_INST3_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ADC_59_INST3_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION  ADC_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ADC_59_INST3_ADCX_PBTYPES_SW_MAJOR_VERSION             ADC_ADCX_PBTYPES_SW_MAJOR_VERSION
#define ADC_59_INST3_ADCX_PBTYPES_SW_MINOR_VERSION             ADC_ADCX_PBTYPES_SW_MINOR_VERSION

#define ADC_59_INST4_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MAJOR_VERSION
#define ADC_59_INST4_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION     ADC_ADCX_PBTYPES_AR_RELEASE_MINOR_VERSION
#define ADC_59_INST4_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION  ADC_ADCX_PBTYPES_AR_RELEASE_REVISION_VERSION
#define ADC_59_INST4_ADCX_PBTYPES_SW_MAJOR_VERSION             ADC_ADCX_PBTYPES_SW_MAJOR_VERSION
#define ADC_59_INST4_ADCX_PBTYPES_SW_MINOR_VERSION             ADC_ADCX_PBTYPES_SW_MINOR_VERSION

#else /* end of defined(ADC_INSTANCE_INDEX)*/
#define ADC_MEMMAP_HEADER    "Adc_MemMap.h"
#define ADC_SCHM_ADC_HEADER  "SchM_Adc.h"
#define ADC_CFG_HEADER       "Adc_Cfg.h"
#endif /* defined(ADC_INSTANCE_INDEX) */
#endif /* ADC_MULTIINSTANCE_HEADER */

/***********************************************************************************************************************
**                                                    End of File                                                     **
***********************************************************************************************************************/
